class
	--
	-- tclmidi syntax for key_pressure events
	--
	SYNTAX_KEY_PRESSURE

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "KeyPressure" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			key_pres: KEY_PRESSURE_EVENT
			pitch, pres: INTEGER
		do
			error := False
			if args.count /= 5 then
				error := True
				error_description := "wrong number of args: should be %
					%'time KeyPressure channel pitch pressure'";
			else
				precursor(e, args)
				if not error then
					key_pres ?= e

					-- fourth argument should be pitch
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							key_pres.set_pitch_wildcard
						else
							error := True
							!!error_description.copy("Invalid pitch '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						pitch := args.item(4).to_integer
						if pitch >= 0 and then pitch <= 128 then
							key_pres.set_pitch(pitch)
						else
							error := True
							!!error_description.copy("Invalid pitch value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end

				if not error then
					if not args.item(5).is_integer then
						if args.item(5).is_equal("*") then
							key_pres.set_pressure_wildcard
						else
							error := True
							!!error_description.copy("Invalid pressure '")
							error_description.append(args.item(5))
							error_description.append("'")
						end
					else
						pres := args.item(5).to_integer
						if pres >= 0 and then pres <= 128 then
							key_pres.set_pressure(pres)
						else
							error := True
							!!error_description.copy("Invalid pressure value '")
							error_description.append(args.item(5))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			key_pres: KEY_PRESSURE_EVENT
		do
			Result := precursor(e)

			key_pres ?= e
			Result.append(" ")
			if key_pres.pitch_wildcard then
				Result.append("*")
			else
				Result.append(key_pres.pitch.to_string)
			end

			Result.append(" ")
			if key_pres.pressure_wildcard then
				Result.append("*")
			else
				Result.append(key_pres.pressure.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a KEY_PRESSURE_EVENT?
		local
			key_pres: KEY_PRESSURE_EVENT
		do
			key_pres ?= e
			Result := key_pres /= Void
		end

end -- SYNTAX_KEY_PRESSURE
