class
	--
	-- tclmidi syntax for meta_channel_prefix events
	--
	SYNTAX_META_CHANNEL_PREFIX

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaChannelPrefix" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			prefix_event: META_CHANNEL_PREFIX_EVENT
			val: INTEGER
		do
			error := False
			if args.count /= 3 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaChannelPrefix prefix'";
			else
				prefix_event ?= e

				-- third argument should be prefix
				if not args.item(3).is_integer then
					if args.item(3).is_equal("*") then
						prefix_event.set_channel_prefix_wildcard
					else
						error := True
						!!error_description.copy("Invalid prefix '")
						error_description.append(args.item(3))
						error_description.append("'")
					end
				else
					val := args.item(3).to_integer
					if val >= 0 and then val <= 255 then
						prefix_event.set_channel_prefix(val)
					else
						error := True
						!!error_description.copy("Invalid prefix value '")
						error_description.append(args.item(3))
						error_description.append("': should be in range 0 %
							%to 255")
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			prefix_event: META_CHANNEL_PREFIX_EVENT
		do
			prefix_event ?= e
			if prefix_event.channel_prefix_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(prefix_event.channel_prefix.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_CHANNEL_PREFIX_EVENT?
		local
			prefix_event: META_CHANNEL_PREFIX_EVENT
		do
			prefix_event ?= e
			Result := prefix_event /= Void
		end

end -- SYNTAX_META_CHANNEL_PREFIX
