class
	--
	-- tclmidi syntax for meta_key events
	--
	SYNTAX_META_KEY

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaKey" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			key_event: META_KEY_EVENT
			mode: INTEGER
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaKey key mode'";
			else
				error := False
				key_event ?= e

				-- fourth argument should be mode
				if args.item(4).is_equal("*") then
					key_event.set_mode_wildcard
					mode := key_event.Mode_major
				elseif args.item(4).same_as("minor") then
					key_event.set_mode(key_event.Mode_minor)
					mode := key_event.Mode_minor
				elseif args.item(4).same_as("major") then
					key_event.set_mode(key_event.Mode_major)
					mode := key_event.Mode_major
				else
					error := True
					!!error_description.copy("Invalid mode '")
					error_description.append(args.item(4))
					error_description.append("'")
				end
			end

			if not error then
				-- Now check key and set accidentals based on mode
				if args.item(3).same_as("*") then
					key_event.set_accidentals_wildcard
				elseif args.item(3).same_as("C Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_7_flats)
					else
						error := True
						!!error_description.copy("Invalid key 'C Flat Minor'")
					end
				elseif args.item(3).same_as("G Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_6_flats)
					else
						error := True
						!!error_description.copy("Invalid key 'G Flat Minor'")
					end
				elseif args.item(3).same_as("D Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_5_flats)
					else
						error := True
						!!error_description.copy("Invalid key 'D Flat Minor'")
					end
				elseif args.item(3).same_as("A Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_4_flats)
					else
						key_event.set_accidentals(key_event.Key_7_flats)
					end
				elseif args.item(3).same_as("E Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_3_flats)
					else
						key_event.set_accidentals(key_event.Key_6_flats)
					end
				elseif args.item(3).same_as("B Flat") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_2_flats)
					else
						key_event.set_accidentals(key_event.Key_5_flats)
					end
				elseif args.item(3).same_as("F") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_1_flat)
					else
						key_event.set_accidentals(key_event.Key_4_flats)
					end
				elseif args.item(3).same_as("C") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_0_Accidentals)
					else
						key_event.set_accidentals(key_event.Key_3_flats)
					end
				elseif args.item(3).same_as("G") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_1_sharp)
					else
						key_event.set_accidentals(key_event.Key_2_flats)
					end
				elseif args.item(3).same_as("D") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_2_sharps)
					else
						key_event.set_accidentals(key_event.Key_1_flat)
					end
				elseif args.item(3).same_as("A") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_3_sharps)
					else
						key_event.set_accidentals(key_event.Key_0_Accidentals)
					end
				elseif args.item(3).same_as("E") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_4_sharps)
					else
						key_event.set_accidentals(key_event.Key_1_sharp)
					end
				elseif args.item(3).same_as("B") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_5_sharps)
					else
						key_event.set_accidentals(key_event.Key_2_sharps)
					end
				elseif args.item(3).same_as("F Sharp") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_6_sharps)
					else
						key_event.set_accidentals(key_event.Key_3_sharps)
					end
				elseif args.item(3).same_as("C Sharp") then
					if mode = key_event.Mode_major then
						key_event.set_accidentals(key_event.Key_7_sharps)
					else
						key_event.set_accidentals(key_event.Key_4_sharps)
					end
				elseif args.item(3).same_as("G Sharp") then
					if mode = key_event.Mode_major then
						error := True
						!!error_description.copy("Invalid key 'G Sharp Major'")
					else
						key_event.set_accidentals(key_event.Key_5_sharps)
					end
				elseif args.item(3).same_as("D Sharp") then
					if mode = key_event.Mode_major then
						error := True
						!!error_description.copy("Invalid key 'D Sharp Major'")
					else
						key_event.set_accidentals(key_event.Key_6_sharps)
					end
				elseif args.item(3).same_as("A Sharp") then
					if mode = key_event.Mode_major then
						error := True
						!!error_description.copy("Invalid key 'A Sharp Major'")
					else
						key_event.set_accidentals(key_event.Key_7_sharps)
					end
				else
					error := True
					!!error_description.copy("Invalid key '")
					error_description.append(args.item(3))
					error_description.append("'")
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			key_event: META_KEY_EVENT
			acc_str: STRING
			l: TCL_LIST
		do
			key_event ?= e
			if key_event.accidentals_wildcard then
				!!Result.copy("*")
			else
				acc_str := key_event.accidentals_to_string(
				    key_event.accidentals)
				if not acc_str.has(' ') then
					!!Result.copy(acc_str)
				else
					!!Result.copy("{")
					Result.append(acc_str)
					Result.append("}")
				end
			end

			Result.append(" ")
			if key_event.mode_wildcard then
				Result.append("*")
			else
				Result.append(key_event.mode_to_string(key_event.mode))
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_KEY_EVENT?
		local
			key_event: META_KEY_EVENT
		do
			key_event ?= e
			Result := key_event /= Void
		end

end -- SYNTAX_META_KEY_EVENT
