class
	--
	-- tclmidi syntax for meta_sequence_number events
	--
	SYNTAX_META_SEQUENCE_NUMBER

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaSequenceNumber" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta sequence number event from arguments
		local
			seq: META_SEQUENCE_NUMBER_EVENT
			val: INTEGER
		do
			error := False
			if args.count /= 3 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaSequenceNumber prefix'";
			else
				seq ?= e

				-- third argument should be sequence
				if not args.item(3).is_integer then
					if args.item(3).is_equal("*") then
						seq.set_sequence_wildcard
					else
						error := True
						!!error_description.copy("Invalid sequence '")
						error_description.append(args.item(3))
						error_description.append("'")
					end
				else
					val := args.item(3).to_integer
					if val >= 0 and then val <= 255 then
						seq.set_sequence(val)
					else
						error := True
						!!error_description.copy("Invalid sequence value '")
						error_description.append(args.item(3))
						error_description.append("': should be in range 0 %
							%to 255")
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			seq: META_SEQUENCE_NUMBER_EVENT
		do
			seq ?= e
			if seq.sequence_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(seq.sequence.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_SEQUENCE_NUMBER_EVENT?
		local
			seq: META_SEQUENCE_NUMBER_EVENT
		do
			seq ?= e
			Result := seq /= Void
		end

end -- SYNTAX_META_SEQUENCE_NUMBER
