class
	--
	-- tclmidi syntax for note_off events
	--
	SYNTAX_NOTE_OFF

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, is_printable, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "NoteOff" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			note_off: NOTE_OFF_EVENT
			pitch, vel: INTEGER
		do
			error := False
			if args.count /= 4 and then args.count /= 5 then
				error := True
				error_description := "wrong number of args: should be %
					%'time NoteOff channel pitch ?velocity?'";
			else
				precursor(e, args)
				if not error then
					note_off ?= e

					-- fourth argument should be pitch
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							note_off.set_pitch_wildcard
						else
							error := True
							!!error_description.copy("Invalid pitch '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						pitch := args.item(4).to_integer
						if pitch >= 0 and then pitch <= 128 then
							note_off.set_pitch(pitch)
						else
							error := True
							!!error_description.copy("Invalid pitch value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end

				if not error then
					if args.count = 5 then
						if not args.item(5).is_integer then
							if args.item(5).is_equal("*") then
								note_off.set_velocity_wildcard
							else
								error := True
								!!error_description.copy("Invalid velocity '")
								error_description.append(args.item(5))
								error_description.append("'")
							end
						else
							vel := args.item(5).to_integer
							if vel >= 0 and then vel <= 128 then
								note_off.set_velocity(vel)
							else
								error := True
								!!error_description.copy("Invalid velocity %
									%value '")
								error_description.append(args.item(5))
								error_description.append("': should be in %
									%range 0 to 128")
							end
						end
					end
				end

				note_off.set_sibling(Void)
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			note_off: NOTE_OFF_EVENT
		do
			-- If we have a sibling, the note off was coverd by
			-- printing a Note event when the NoteOn event was
			-- encountered.

			note_off ?= e
			if note_off.sibling = Void then
				Result := precursor(e)

				Result.append(" ")
				if note_off.pitch_wildcard then
					Result.append("*")
				else
					Result.append(note_off.pitch.to_string)
				end

				Result.append(" ")
				if note_off.velocity_wildcard then
					Result.append("*")
				else
					Result.append(note_off.velocity.to_string)
				end
			end
		end

	is_printable(e: EVENT): BOOLEAN is
			-- will event print anything?
		local
			note_off: NOTE_OFF_EVENT
		do
			note_off ?= e
			Result := note_off.sibling = Void
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a NOTE_OFF_EVENT?
		local
			note_off: NOTE_OFF_EVENT
		do
			note_off ?= e
			Result := note_off /= Void
		end

end -- SYNTAX_NOTE_OFF
