class
	--
	-- tclmidi syntax for note_on events
	--
	SYNTAX_NOTE_ON

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, is_printable, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is
		local
			note_on: NOTE_ON_EVENT
		do
			note_on ?= e
			if note_on.sibling_wildcard or else note_on.sibling /= Void then
				Result := "Note"
			else
				Result := "NoteOn"
			end
		end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			note_on: NOTE_ON_EVENT
			pitch, vel: INTEGER
		do
			error := False
			if args.item(2).same_as("NoteOn") and args.count /= 5 then
				error := True
				error_description := "wrong number of args: should be %
					%'time NoteOn channel pitch velocity'";
			elseif args.item(2).same_as("Note") and args.count /= 6 then
				error := True
				error_description := "wrong number of args: should be %
					%'time Note channel pitch velocity duration'";
			else
				precursor(e, args)
				if not error then
					note_on ?= e

					-- fourth argument should be pitch
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							note_on.set_pitch_wildcard
						else
							error := True
							!!error_description.copy("Invalid pitch '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						pitch := args.item(4).to_integer
						if pitch >= 0 and then pitch <= 128 then
							note_on.set_pitch(pitch)
						else
							error := True
							!!error_description.copy("Invalid pitch value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end

				if not error then
					if not args.item(5).is_integer then
						if args.item(5).is_equal("*") then
							note_on.set_velocity_wildcard
						else
							error := True
							!!error_description.copy("Invalid velocity '")
							error_description.append(args.item(5))
							error_description.append("'")
						end
					else
						vel := args.item(5).to_integer
						if vel >= 0 and then vel <= 128 then
							note_on.set_velocity(vel)
						else
							error := True
							!!error_description.copy("Invalid velocity value '")
							error_description.append(args.item(5))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end

				if not error then
					note_on.set_sibling(Void)
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			note_on: NOTE_ON_EVENT
		do
			note_on ?= e
			if not note_on.is_note_off or else note_on.sibling = Void then
				Result := precursor(e)

				Result.append(" ")
				if note_on.pitch_wildcard then
					Result.append("*")
				else
					Result.append(note_on.pitch.to_string)
				end

				Result.append(" ")
				if note_on.velocity_wildcard then
					Result.append("*")
				else
					Result.append(note_on.velocity.to_string)
				end

				if note_on.sibling_wildcard or else note_on.sibling /= Void then
					Result.append(" ")
					if note_on.sibling_wildcard then
						Result.append("*")
					else
						Result.append(note_on.duration.to_string)
					end
				end
			end
		end

	is_printable(e: EVENT): BOOLEAN is
			-- will event print anything?
		local
			note_on: NOTE_ON_EVENT
		do
			note_on ?= e
			Result := not note_on.is_note_off or else note_on.sibling = Void
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a NOTE_ON_EVENT?
		local
			note_on: NOTE_ON_EVENT
		do
			note_on ?= e
			Result := note_on /= Void
		end

end -- SYNTAX_NOTE_ON
