class
	--
	-- tclmidi syntax for parameter events
	--
	SYNTAX_PARAMETER

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "Parameter" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			parameter: PARAMETER_EVENT
			param, value: INTEGER
		do
			error := False
			if args.count /= 5 then
				error := True
				error_description := "wrong number of args: should be %
					%'time Parameter channel parmater value'";
			else
				precursor(e, args)
				if not error then
					parameter ?= e

					-- fourth argument should be param
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							parameter.set_parameter_wildcard
						else
							error := True
							!!error_description.copy("Invalid parameter '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						param := args.item(4).to_integer
						if param >= 0 and then param <= 128 then
							parameter.set_parameter(param)
						else
							error := True
							!!error_description.copy("Invalid parameter %
								%value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end

				if not error then
					if not args.item(5).is_integer then
						if args.item(5).is_equal("*") then
							parameter.set_value_wildcard
						else
							error := True
							!!error_description.copy("Invalid value '")
							error_description.append(args.item(5))
							error_description.append("'")
						end
					else
						value := args.item(5).to_integer
						if value >= 0 and then value <= 128 then
							parameter.set_value(value)
						else
							error := True
							!!error_description.copy("Invalid value value '")
							error_description.append(args.item(5))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			parameter: PARAMETER_EVENT
		do
			Result := precursor(e)

			parameter ?= e
			Result.append(" ")
			if parameter.parameter_wildcard then
				Result.append("*")
			else
				Result.append(parameter.parameter.to_string)
			end

			Result.append(" ")
			if parameter.value_wildcard then
				Result.append("*")
			else
				Result.append(parameter.value.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a PARAMETER_EVENT?
		local
			parameter: PARAMETER_EVENT
		do
			parameter ?= e
			Result := parameter /= Void
		end

end -- SYNTAX_PARAMETER
