class
	--
	-- tclmidi syntax for pitch_wheel events
	--
	SYNTAX_PITCH_WHEEL

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "PitchWheel" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			pw: PITCH_WHEEL_EVENT
			wheel: INTEGER
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time PitchWheel channel value'";
			else
				precursor(e, args)
				if not error then
					pw ?= e

					-- fourth argument should be value
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							pw.set_wheel_wildcard
						else
							error := True
							!!error_description.copy("Invalid wheel value '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						wheel := args.item(4).to_integer
						if wheel >= -8192 and then wheel <= 8191 then
							pw.set_wheel(wheel)
						else
							error := True
							!!error_description.copy("Invalid wheel value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%-8192 to 8191")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			pw: PITCH_WHEEL_EVENT
		do
			Result := precursor(e)

			pw ?= e
			Result.append(" ")
			if pw.wheel_wildcard then
				Result.append("*")
			else
				Result.append(pw.wheel.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a PITCH_WHEEL_EVENT?
		local
			pw: PITCH_WHEEL_EVENT
		do
			pw ?= e
			Result := pw /= Void
		end

end -- SYNTAX_PITCH_WHEEL
