class
	--
	-- An INPUT_STREAM that uses tcl functions for the i/o
	--
	TCL_INPUT_CHANNEL

inherit
	INPUT_STREAM

creation
	make

feature -- Initialization
	make(interp: like tcl_interp; name: like channel_name) is
			-- create an input stream based on channel
		require
			valid_interp: interp /= Void and then interp.is_not_void
			not_void: name /= Void
		do
			tcl_interp := interp
			channel_name := name

			!!tcl_channel
			tcl_channel.call_tcl_get_channel(tcl_interp, channel_name, "r",
				tcl_channel)
		ensure
			interp_set: tcl_interp = interp
			name_set: channel_name = name
		end

feature -- Access
	tcl_interp: POINTER
	channel_name: STRING

	is_connected: BOOLEAN is
			-- true when channel is a valid input channel
		do
			if tcl_channel.channel.is_not_null then
				Result := True
			end
		end

	end_of_input: BOOLEAN is
			-- has end-of-input been reached?
		local
			eof: INTEGER_REF
		do
			if not push_back_flag then
				!!eof
				tcl_channel.call_tcl_eof(tcl_channel.channel, eof)
				if eof.item = 0 then
					Result := False
				else
					Result := True
				end
			end
		end

feature -- Reading
	read_character is
			-- read a character from tcl tcl_channel
		do
			if push_back_flag then
				push_back_flag := False
			else
				memory := read_char
			end
		end

	unread_character is
		do
			push_back_flag := True
		end

	last_character: CHARACTER is
		do
			result := memory.to_character
		end

	read_line_in(str: STRING) is
		local
			mem: INTEGER
		do
			read_character
			if last_character /= '%N' then
				from
					str.extend(memory.to_character)
					mem := read_char
				until
					mem = eof_value or else mem = ('%N').code
				loop
					str.extend(mem.to_character)
					mem := read_char
				end
				memory := mem
			end
		end
		

feature {TCL_INPUT_CHANNEL} -- Implementation
	read_char: INTEGER is
		local
			small_array: ARRAY[CHARACTER]
		do
			!!small_array.make(1, 1)
			tcl_channel.call_tcl_read(tcl_channel.channel, small_array, 1)

			if small_array.count = 1 then
				Result := small_array.item(1).to_integer
			else
				Result := eof_value
			end
		end

	eof_value: INTEGER is -1

feature {NONE}
	memory: INTEGER
	tcl_channel: TCL_CHANNEL

end -- TCL_INPUT_CHANNEL
