class
	--
	-- Hooks to tcl commands that split or build lists
	--
	TCL_LIST

creation
	make_from_list, make_from_split

feature -- Initialization
	make_from_list(interp: like tcl_interp; l: like list) is
			-- create a list for splitting
		require
			not_void: l /= Void
		do
			tcl_interp := interp
			list := l
			!!split_list.make(1, 0)
		ensure
			tcl_interp_set: tcl_interp = interp
			list_set: list = l
		end

	make_from_split(interp: like tcl_interp; sl: like split_list) is
			-- create a split list for joining
		require
			not_void: sl /= Void and then sl.count > 0
		do
			tcl_interp := interp
			split_list := sl

			!!list.make(0)
		end

feature -- Access
	tcl_interp: POINTER
	list: STRING
	split_list: ARRAY[STRING]
	error: BOOLEAN is
			-- Did Tcl_SplitList fail?
		do
			Result := split_list.count = 0
		end

feature -- Action
	split is
			-- split list into split_list
		require
			valid_list: list.count > 0
		do
			call_tcl_split_list(tcl_interp, list, split_list)
		end

	merge is
			-- merge separate strings into single list
		require
			valid_split: split_list.count > 0
		do
			call_tcl_merge(split_list, list)
		end

feature -- C hooks
	call_tcl_split_list(interp: POINTER; l: STRING; sp: ARRAY[STRING]) is
			-- call Tcl_SplitList C function
		external "C_WithoutCurrent"
		alias "c_tcl_split_list"
		end

	call_tcl_merge(sp: ARRAY[STRING]; l: STRING) is
			-- call Tcl_Merge C function
		external "C_WithoutCurrent"
		alias "c_tcl_merge"
		end

end -- TCL_LIST
