class
	--
	-- An OUTPUT_STREAM implemented on top of the Tcl file operators
	--
	TCL_OUTPUT_CHANNEL

inherit
	OUTPUT_STREAM

creation
	make

feature -- Initialization
	make(interp: like tcl_interp; name: like channel_name) is
			-- create an input stream based on channel
		require
			valid_interp: interp /= Void and then interp.is_not_void
			not_void: name /= Void
		do
			tcl_interp := interp
			channel_name := name

			!!tcl_channel
			tcl_channel.call_tcl_get_channel(tcl_interp, channel_name, "w",
				tcl_channel)
			-- make sure we're in binary mode
			tcl_channel.call_tcl_set_channel_option(tcl_interp,
				tcl_channel.channel, "-translation", "binary")
		ensure
			interp_set: tcl_interp = interp
			name_set: channel_name = name
		end

feature -- Access
	tcl_interp: POINTER
	channel_name: STRING

	is_connected: BOOLEAN is
			-- true when channel is a valid input tcl_channel
		do
			if tcl_channel.channel.is_not_null then
				Result := True
			end
		end

feature -- Action
	put_character(c: CHARACTER) is
		local
			small_array: ARRAY[CHARACTER]
		do
			!!small_array.make(1, 1)
			small_array.put(c, 1)
			tcl_channel.call_tcl_write(tcl_channel.channel, small_array, 1)
		end

	flush is
		do
			tcl_channel.call_tcl_flush(tcl_channel.channel)
		end

feature {TCL_OUTPUT_CHANNEL} -- Implementation
	tcl_channel: TCL_CHANNEL

end -- TCL_OUTPUT_CHANNEL
