deferred class
	--
	-- A tclmidi extended tcl command
	--
	TCLMIDI_COMMAND

feature -- Initialization
	make is
			-- set up defaults
		do
			syntax_valid := True
			error := False
		ensure
			no_error: not error
		end

feature -- Access
	context: COMMAND_CONTEXT
	arguments: ARRAY[STRING]
	error: BOOLEAN
	command_result: STRING
	syntax_valid: BOOLEAN

feature -- Element Change
	set_context(c: like context) is
			-- set the command context
		require
			not_void: c /= Void
		do
			context := c
		ensure
			context_set: context = c
		end

	set_arguments(a: like arguments) is
			-- set the command arguments
		require
			not_void: a /= Void
		do
			arguments := a
		ensure
			args_set: arguments = a
		end

	reset is
			-- remove any context or arguments
		do
			context := Void
			arguments := Void
			syntax_valid := True
			error := False
			command_result := Void
		ensure
			no_context: context = Void
			no_arguments: arguments = Void
			good_syntax: syntax_valid = True
			no_error: error = False
		end

feature -- Actions
	check_syntax is
			-- Check args for valid syntax - result in syntax_valid
		require
			args_set: arguments /= Void
			has_context: context /= Void
		deferred
		end

	execute is
			-- Execute the command
		require
			valid_args: syntax_valid
			has_context: context /= Void
		deferred
		end

feature {TCLMIDI_COMMAND} -- Access
	command_name: STRING is
			-- Command name
		deferred
		end

	usage: STRING is
			-- Command usage message
		deferred
		end

invariant
	bad_syntax_means_error: not syntax_valid implies error

end -- TCLMIDI_COMMAND
