# Mpexpr - make ppc shared lib for mac

# define PROJECT, project_VERSION, and DLL_VERSION for use by install.tcl

MPEXPR_VERSION = 1.0
DLL_VERSION = 10
PROJECT = mpexpr{DLL_VERSION}

DriveName    =  dogbert
TclLibDir    = {DriveName}:System Folder:Extensions:Tool Command Language
TclLib       = {TclLibDir}:Tcl8.0.shlb
TclSourceDir = {DriveName}:Tcl/Tk Folder:tcl8.0


MAKEFILE     = mpexpr.make
MondoBuild = {MAKEFILE}
Includes     = 	-i "{TclSourceDir}:generic:" -i ""
SymPPC      = 
ObjDirPPC   =

PPCCOptions  = {Includes} {SymPPC} 
		-typecheck relaxed -d MAC_TCL 
		-shared_lib_export on -export_list syms.exp

ObjectsPPC  = 
		"{ObjDirPPC}mpexpr.c.x" 
		"{ObjDirPPC}mpformat.c.x" 
		"{ObjDirPPC}mpiface.c.x" 
		"{ObjDirPPC}mpparse.c.x" 
		"{ObjDirPPC}qfunc.c.x" 
		"{ObjDirPPC}qio.c.x" 
		"{ObjDirPPC}qmath.c.x" 
		"{ObjDirPPC}qmod.c.x" 
		"{ObjDirPPC}qtrans.c.x" 
		"{ObjDirPPC}zfunc.c.x" 
		"{ObjDirPPC}zio.c.x" 
		"{ObjDirPPC}zmath.c.x" 
		"{ObjDirPPC}zmod.c.x" 
		"{ObjDirPPC}zmul.c.x"
		


{PROJECT}.shlb  {MondoBuild} {ObjectsPPC}
	PPCLink 
		-o {Targ} {SymPPC} 
		{ObjectsPPC} 
		-t 'shlb' 
		-c '????' 
		-xm s 
		-export Mpexpr_Init 
		"{SharedLibraries}InterfaceLib" 
		"{SharedLibraries}StdCLib" 
		"{SharedLibraries}MathLib" 
		"{TclLib}" 
		"{PPCLibraries}StdCRuntime.o" 
		"{PPCLibraries}PPCCRuntime.o" 
		"{PPCLibraries}PPCToolLibs.o"


"{ObjDirPPC}mpexpr.c.x"  {MondoBuild} mpexpr.c
	{PPCC} mpexpr.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}mpformat.c.x"  {MondoBuild} mpformat.c
	{PPCC} mpformat.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}mpiface.c.x"  {MondoBuild} mpiface.c
	{PPCC} mpiface.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}mpparse.c.x"  {MondoBuild} mpparse.c
	{PPCC} mpparse.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}qfunc.c.x"  {MondoBuild} qfunc.c
	{PPCC} qfunc.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}qio.c.x"  {MondoBuild} qio.c
	{PPCC} qio.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}qmath.c.x"  {MondoBuild} qmath.c
	{PPCC} qmath.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}qmod.c.x"  {MondoBuild} qmod.c
	{PPCC} qmod.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}qtrans.c.x"  {MondoBuild} qtrans.c
	{PPCC} qtrans.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}zfunc.c.x"  {MondoBuild} zfunc.c
	{PPCC} zfunc.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}zio.c.x"  {MondoBuild} zio.c
	{PPCC} zio.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}zmath.c.x"  {MondoBuild} zmath.c
	{PPCC} zmath.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}zmod.c.x"  {MondoBuild} zmod.c
	{PPCC} zmod.c -o {Targ} {PPCCOptions}

"{ObjDirPPC}zmul.c.x"  {MondoBuild} zmul.c
	{PPCC} zmul.c -o {Targ} {PPCCOptions}


mpexpr  {PROJECT}.shlb

