'\" $Id: narray.man,v 1.7 1998/08/26 15:53:16 nickm Exp nickm $ 
'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.9 97/08/22 18:50:59
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH narray n "August 1998" Tcl "Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
narray \- create and manipulate multi-dimensional arrays
.SH SYNOPSIS
\fBnarray create \fIarrayName\fR \fIdim0 \fR?\fIdim1 ...\fR?

.BE

.SH DESCRIPTION
This command creates multi-dimensional floating-point arrays in Tcl.
In addition to setting and getting the value of array elements,
functions can be mapped over array elements.  These functions can use
variables local to the narray.  

This manual page documents version 0.81 of the narray extension.

.SH NARRAY LAYOUT AND INDEXES

An narray is stored in memory as a vector of \fBNArrayFloat\fR's
(usually \fBfloat\fR's -- see \fBnarray.h\fR). Storage is "C" style,
such that an index into an narray \fIindex0 \fR?\fIindex1 ...\fR?
references the ?\fIindexN\fR + \fIdimN\fR * ( \fIindexN-1\fR +
\fIdimN-1\fR (...\fIindex1\fR + \fIdim1\fR? * \fIindex0\fR)...)
element.  Each \fIindexN\fR can be greater than \fIdimN\fR or even
negative, as long as the sum ?\fIindexN\fR + \fIdimN\fR * (
\fIindexN-1\fR + \fIdimN-1\fR (...\fIindex1\fR + \fIdim1\fR? *
\fIindex0\fR)...)  is within the bounds of the vector.  In addition,
there may be fewer indexes than dimensions.

.SH NARRAY INVOCATION

The NArray package can be loaded into Tcl or Wish via the native package
facility:

.TP
\fBpackage require narray\fR

.SH NARRAY CREATION
Narray's can be created with the following command:
.TP
\fBnarray create \fIarrayName\fR \fIdim0 \fR?\fIdim1 ...\fR?
Creates a command \fIarrayName\fR that represent a multi-dimensional
array with dimensions of length \fIdim0 \fR?\fIdim1 ...\fR?.  Returns
\fIarrayName\fR.

.SH NARRAY COMMAND
The \fBnarray\fR command creates a new Tcl command whose name is the
same as the name of the narray.  This command may be used to invoke
various operations on the narray.  It has the following general form:
.DS C
\fIarrayName option \fR?\fIarg arg ...\fR?
.DE

The following commands are possible for narray's:
.TP
\fIarrayName\fR \fBaref \fIindex0 \fR?\fIindex1 ...\fR?
Return the element at \fIindex0 \fR?\fIindex1 ...\fR?.
.TP
\fIarrayName\fR \fBaset \fIindex0 \fR?\fIindex1 ...\fR? \fIvalue\fR
Set the element at \fIindex0 \fR?\fIindex1 ...\fR? to \fIvalue\fR.
.TP
\fIarrayName\fR \fBvref \fIvariable\fR
Return the value of the variable \fIvariable\fR.
.TP
\fIarrayName\fR \fBvset \fIvariable value\fR
Set the variable \fIvariable\fR to \fIvalue\fR.
.TP
\fIarrayName\fR \fBvars\fR
Return a list of variables in \fIarrayName\fR.
.TP
\fIarrayName\fR \fBmap \fIcode \fR?\fI{array_var0 array0} ...\fR?
Compile \fIcode\fR and apply it to each element of \fIarrayName\fR.
Make the narray \fIarray0\fR available to \fIcode\fR as
\fIarray_var0\fR.
.TP
\fIarrayName\fR \fBdimensions\fR
Return the dimensions of \fIarrayName\fR.
.TP
\fIarrayName\fR \fBcollapse\fR \fIdirection\fR \fR?\fImask\fR? \fIresult\fR
Sum over all elements in the indicated direction, saving the result to
the NArray \fBresult\fR. By applying a mask, it is possible to omit
summing over certain selected elements along the collapse direction.
.TP
\fIarrayName\fR \fBexport\fR \fIoffset\fR \fIsize\fR \fIresult\fR
Extract a subset of \fIarrayName\fR of the specified size and at
the specified offset indices into the NArray \fIresult\fR.
.TP
\fIarrayName\fR \fBimport\fR \fIoffset\fR \fIsource\fR
Import the contents of the NArray \fIsource\fR into \fIarrayName\fR
at the specified offset indices.
.TP
\fIarrayName\fR \fBstatus\fR
Return some status information about \fIarrayName\fR (currently, the
kilobytes used by the narray and its debug status.)
.TP
\fIarrayName\fR \fBdebug\fR \fIlevel\fR
Set the debug flags of \fIarrayName\fR to \fIlevel\fR.  The debug
flags are a bitwise OR of:
.DS C
1 Print parsing information
2 Trace stack machine execution 
4 Print compiled code before executing it
.DE


.SH NARRAY LANGUAGE
The \fIarrayName\fR \fBmap\fR command compiles and applies a sequence
of code to each element in a narray.  Statements in the language 
are seperated by semi-colons or by newlines.  The narray language
includes standard math (including \fB+=, -=, *=, /=\fR and \fB?:\fR).
\fB=\fR is used for assignment.  The following forms may appear on the
left hand side of an assigment:
.TP 20
\fIvar\fR
The variable \fIvar\fR.  Variables may contain numeric values only.
.TP 20
\fB[\fR?\fIindex0, index1, ...\fR?\fB]\fR
The current element, modified by \fIindex0, index1, ...\fR.
For example, \fB[]\fR is the current element,
\fB[-1]\fR is the previous element, and \fB[0,1]\fR is
the element in the same row but next column in a 2D matrix.
.TP 20
\fB\fIarray_var\fB[\fR?\fIindex0, index1, ...\fR?\fB]\fR
Accesses elements of the narray \fIarray_var\fR.
.LP
The value of variables and array elements may be referenced by
prefixing a \fB$\fR to them.  For example, \fB$foo\fR is the value of
the variable \fBfoo\fR.  In addtion \fB@\fIN\fR may be used to
reference the value of the \fIN\fR'th index of the current element.
For example, \fB@0\fR is the row number and \fB@1\fR is the column
number (for a 2D matrix.)
.LP
Funtions may be called as \fIfunc\fB(\fR?\fIarg0, ...\fR?\fB)\fR
Strings enclosed by "'s may be passed to functions.  The following
functions are availabe:
.TP
\fBsin(\fIx\fB)\fR
The sine of \fIx\fR.
.TP
\fBcos(\fIx\fB)\fR
The cosine of \fIx\fR.
.TP
\fBtan(\fIx\fB)\fR
The tangent of \fIx\fR.
.TP
\fBasin(\fIx\fB)\fR
The arc sine of \fIx\fR.
.TP
\fBacos(\fIx\fB)\fR
The arc cosine of \fIx\fR.
.TP
\fBatan(\fIx\fB)\fR
The arg tangent of \fIx\fR.
.TP
\fBsinh(\fIx\fB)\fR
The hyperbolic sine of \fIx\fR.
.TP
\fBcosh(\fIx\fB)\fR
The hyperbolic cosine of \fIx\fR.
.TP
\fBtanh(\fIx\fB)\fR
The hyperbolic tangent of \fIx\fR.
.TP
\fBexp(\fIx\fB)\fR
\fBe ^ \fIx\fR.
.TP
\fBlog(\fIx\fB)\fR
The natural log of \fIx\fR.
.TP
\fBlog10(\fIx\fB)\fR
The base 10 log of \fIx\fR.
.TP
\fBsqrt(\fIx\fB)\fR
The square root of \fIx\fR.
.TP
\fBceil(\fIx\fB)\fR
The smallest integral value not less than \fIx\fR.
.TP
\fBfloor(\fIx\fB)\fR
The largest integral value not greater than \fIx\fR.
.TP
\fBatan2(\fIx, y\fB)\fR
The arc tangent function of two variables.
.TP
\fBpow(\fIx, y\fB)\fR
\fIx\fR raised to the \fIy\fR power.
.TP
\fBfmod(\fIx, y\fB)\fR
The floating-point remainder of \fIx\fR / \fIy\fR.
.TP
\fBprintf(\fIformat_string, ?arg?, ...\fB)\fR
A limited form of printf that understands the d, f, g, and s formats.
.TP
\fBfprintf(\fIfile_number, format_string, ?arg?, ...\fB)\fR
Like \fBprintf\fR, but output goes to the file handle identified by
\fIfile_number\fR.  Tcl's file handles are of the form
\fBfile\fIfile_number\fR.
.TP
\fBtcl_eval(\fIstring, ?arg?, ...\fB)\fR
Concatenate \fIstring\fR and
any arguments (numeric arguments are converted to strings and preceded
by a space) and evaulate in Tcl in the current context.
.SH VARIABLES
The following variables are set by this extension:
.TP
\fBnarray_library\fR
The location of the Tcl library.  This can be overridden by the
environment variable \fBNARRAY_LIBRARY\fR.
.TP
\fBnarray_version\fR
The version number of the narray extension, in the form
\fImajor\fR.\fIminor\fR.
.SH LIBRARY COMMANDS
The file \fBnarray.tcl\fR contains these useful library routines:
.TP
\fBpnarray \fIarrayName\fR
Print the narray \fIarrayName\fR.
.TP
\fBnarray_delete \fIarrayName\fR
Delete the narray \fIarrayName\fR.  This is the same as \fBrename
\fIarrayName \fB{}\fR.
.SH BUGS AND QUIRKS
Simple expressions must end with a semi-colon or newline.  For
example, \fIarrayName\fR \fBmap { sum += $[]; }\fR will compile, but
\fIarrayName\fR \fBmap { sum += [] }\fR is a syntax error.

Strings are not first-class -- they can only appear as literals in
function calls.  If you want strings, use Tcl and \fBtcl_eval\fR.

The parser/code generator does not use a representation that makes for
easy optimizations.

The parser doesn't attempt to generate useful error messages.  Use
\fBdebug\fR level 1 to track down syntax errors.

The bytecode interpreter was developed in an ad hoc fashion and without
(much) regard to performance.

Most of the code was written for ease-of-implementation rather than doing
things the "right" way.

There are spotty run-time checks.  There is no stack underflow
checking, and only scattered type checking.
.SH AUTHOR
Nick Maliszewskyj <nickm@nist.gov> and Przemek Klosowski <przemek@nist.gov>
please contact us if you have questions, bug reports/fixes, or just better
ideas for how to implement this tool.

This package is based on, and includes code by Sam Shen <slshen@lbl.gov>.
.PP
