# La siguiente linea vuelve a arrancar usando wish \
exec wish8.1 -f $0

# Seoras, seores, estamos aqu reunidos para conseguir unir este ordenador
# con la computadora del quinto aunque los vientos y mareas de este mundo de 
# perdicin  llamado Internet se interpongan.

# Esta majaderia es Copyright (c) 1998 Andrs Garca Garca y se distribuye bajo
# licencia GNU. 

# Version 0.5.3

set dirGetleft [file dirname [info script]]

source [file join "$dirGetleft" scripts Ccombinado.tcl]
source [file join "$dirGetleft" scripts Ventana.tcl]
source [file join "$dirGetleft" scripts Dialogos.tcl]
source [file join "$dirGetleft" scripts Herramientas.tcl]
source [file join "$dirGetleft" scripts Ayuda.tcl]

proc ver_enlaces {} {
    global n_enlaces fichero_enlace direccion directorio_base descripcion_enlace
    for {set i 1} {$i<$n_enlaces} {incr i} {
        puts "$i: $fichero_enlace($i) $descripcion_enlace($i)"
    }
    return
}

#############################################################################
# fijar_coordenadas
#    Lee las coordenadas de la esquina superior izquierda de la ventana
#    que se pasa como parmetro y las coloca en coord.
#
# Parametro:
#    ventana cuya posicion se desea conocer.
#
# Variable global:
#    coord(x): x de las coordenadas.
#    coord(y): y.
#############################################################################
proc fijar_coordenadas {{cual .} } {
    global coord

    regexp {(?:\+)([0-9]+)(?:\+)([0-9]+)} [wm geometry $cual] \
            nada coord(x) coord(y)

    return
}

###############################################################################
# Adecentar_dir
#    Coge el path absoluto de un fichero y le quita cosas como '..' y '.'
#    Tambin le quita los parmetros si es una llamada a un cgi
#
# Parmetro:
#    Path del fichero
# Devuelve:
#    Path adecentado
###############################################################################
proc Adecentar_dir {path} {
    if {[regexp {\.$} $path]} {
        append path /
    }
    for {set a 1 ; set b 1} {($a>0)||($b>0)} {} {
        set a [regsub -all {/\./} $path {/} path]
        set b [regsub -all {([^./]+/\.\./)} $path {} path]
    }
    for {} {[regsub {^/\.\.} $path {} path]} {} {}

    return $path
}   

###############################################################################
# Inicializacion_bajada
#    Se encarga de tareas previas al comienzo de la bajada de la direccion 
#    pedida.
# Parametro:
#    pagina: la direccion de la pagina pedida
###############################################################################
proc Inicializacion_bajada {pagina} {
    global directorio_local directorio_base
    global direccion opciones fichero_a_bajar
    global labelTitles labelMessages

    if {[regexp -nocase {(?:http://)?([^/]+)((?:~[^/]*)?(?:[^\?]*))(?:/)(.*)} \
        $pagina nada direccion(www) direccion(dir) nombre_fichero]} {
    } else {
        tk_messageBox -type ok -title $labelTitles(initError) -icon error \
            -message $labelMessages(formatError)
        return
    }

    set directorio_base [Dialogos::SeleccionarDirectorio]
    if {![string compare $directorio_base ""]} {
        return
    }
    set directorio_local $directorio_base

    if {$nombre_fichero==""} {
        set nombre_fichero index.html
    }

    set nombre_fichero [file join $direccion(dir) $nombre_fichero]
    set direccion(base) $direccion(dir)

    set fichero [Abrir_fichero [Adecentar_nombres $nombre_fichero] 1]

    if {$fichero!=1} {
        set Ventana::Rizo::informe(parar) 0
        Ventana::Bajando_encabezamiento $pagina
        if {($Ventana::Rizo::curlError!=0)&&($Ventana::Rizo::curlError!="")} {
            tk_messageBox -icon error -type ok -title $labelTitles(error) \
                    -message "$Ventana::Rizo::mensaje_error"
            return
        }
        set Ventana::Rizo::informe(parar) 0
        Ventana::Bajando_archivo $fichero $pagina
    } else {
        tk_messageBox -type ok -title $labelTitles(initError) -icon error \
                -message [concat $labelMessages(notOpen) $nombre_fichero]
        return
    }
    tkwait variable Ventana::Rizo::informe(parar)
    if {$Ventana::Rizo::curlError==1} {
        tk_messageBox -icon error -type ok -title $labelTitles(error) \
                 -message "$Ventana::Rizo::mensaje_error"
        return
    }

    set nombre [file rootname $fichero]
    file rename -force $fichero $nombre
    if {([string match $Ventana::Rizo::meta(contenido) "text/html"])&&(![regexp -nocase {html?$} $nombre])} {
        file rename -force $nombre $nombre.html
        exec touch $nombre
        set nombre_fichero [Adecentar_nombres $nombre_fichero].html
    }
    return [string trimleft $nombre_fichero /]
}

###############################################################################
# Path_relativo
#    Esta funcin devuelve el path relativo desde el directorio actual, al
#    directorio raz.
# Parmetros:
#    El directorio en que se encuentra el fichero que va a ser preprocesado
# Devuelve:
#    El path relativo
###############################################################################
proc Path_relativo {path_absoluto} {
    global directorio_base

    set patron (?:$directorio_base/)(.*)
    regexp $patron $path_absoluto nada path
    if {![info exists path]} return

    set cuenta [regsub -all {/} $path {} ignorar]

    for {set i 0;set rel ""} {$i<$cuenta} {incr i} {
        append rel ../
    }
    return $rel
}

###############################################################################
# Preprocesado
#    Reads the Web page passed as a parameter and proccess it to extract
#    all links to local files and images it has
#
# Parameters:
#    file: file which contains the page to process
#
# Side efects:
#    'fichero_enlace' keeps the links
#    'descripcion_enlace' the descripcion of the link
###############################################################################
proc Preprocesado {file} {
    global n_enlaces fichero_enlace descripcion_enlace direccion directorio_local
    global opciones directorio_base vistos
    global labelTitles labelMessages

    if [string match $file ""] return
    set file [Adecentar_dir $file]
    set file [Adecentar_nombres $file]
puts "Fichero a preprocesar: $file"
    if [info exists vistos($file)] {
        set n_enlaces 0
        return
    }
    set vistos($file) 1
    set directorio_local [file dirname $file]
    if {[file exists $file.orig]} {
        set fichero $file.orig
    } else {
        set fichero $file
    }
    set n_enlaces  1
    set enlaces_absolutos 0
    set hay_url 0
    if [catch {open $fichero r} leer] {
        tk_messageBox -title $labelTitles(preError) -icon error\
            -message [concat $leer\n$labelMessages(notOpen)\n$fichero]
        set n_enlaces 0
        return
    }
    for {set cosa [gets $leer]} {(![eof $leer]) || ([string compare $cosa ""])} {if {![eof $leer]} {append cosa " " [gets $leer]} } {
        if {[regexp {<!} $cosa]} {
            while {![regexp {(?:>)(.*)} $cosa nada cosa]} {
                append cosa " " [gets $leer]
            }
        }
        if {![regexp -nocase {< *[laif]} $cosa]} {
            set cosa ""
            continue
        }
        if [regexp -nocase  \
            {((?:< *a[^>]+href *)|(?:< *img[^>]+src *)|(?:< *link[^>]+href *)|(?:< *frame[^>]+src *))((?:= *)(?:\")?([^#\">]+))(?:.*?>)(.*)} \
			    $cosa nada diff alt nombre_fichero cosa] {
            if [info exists repetidos($nombre_fichero)] continue
            if {[regexp -nocase {^mailto:|^news:} $nombre_fichero]} continue
            if {([regexp {\?} $nombre_fichero])&&($opciones(cgi)==0)} continue
            if {[regexp {<!} $diff]} continue
            if [info exists vistos([Adecentar_nombres [Adecentar_dir [file join $directorio_base$direccion(dir) $nombre_fichero]]])] {
                continue
            }
		if [regexp -nocase {javascript:} $nombre_fichero] continue
            if [regexp -nocase {(?:http:)(/[^/].*)} $nombre_fichero nada nombre_fichero] {
                set hay_url 1
            }
            if {([string first :// $nombre_fichero]!=-1 ) } {
                regexp {(?:://)([^/]+)(?:/)?(.*)} $nombre_fichero nada direccion_www nombre_fichero
                if ![info exists direccion_www] {
                    tk_messageBox -title $labelTitles(error) -icon error \
                        -message [concat $labelMessages(noWWW) $nombre_fichero]
                    continue
                }
                if {[string compare [string tolower [string trimright $direccion(www) {/}]] [string tolower $direccion_www]]} continue
                set nombre_fichero /$nombre_fichero
                set hay_url 1
                set enlaces_absolutos 1
            }
            if {[regexp -nocase {href} $diff]==1} {
                if {($opciones(dir)==0)&&($direccion(base)!="")} {
                    if {![regexp -nocase "^(/)([string trimleft "$direccion(base)" "/"])"  \
                        [Adecentar_dir [file join $direccion(dir) $nombre_fichero]]]} {
                        continue
                    }
                }
                if {![regexp -nocase {^< *?area} $diff]} {
                    while {![regexp -nocase {(.*?)(< */a *>)} $cosa nada descripcion]} {
                        append cosa " " [gets $leer]
                    }
                    set descripcion_enlace($n_enlaces) [Adecentar_descripcion $descripcion]
                } else {
                    set descripcion_enlace($n_enlaces) "Enlaces en un mapa"
                }
            } elseif [regexp -nocase {frame} $diff] {
                set descripcion_enlace($n_enlaces) "Marco: $nombre_fichero"
            } else {
                if {![regexp -nocase {(?:ALT *= *\")(.*?)(\")} $alt nada descrip]} {
                    if {![regexp -nocase {(?:src *= *\")(.*?)(\")} $alt nada descrip]} {
                        set descrip $nombre_fichero
                    }
	            }
                set descripcion_enlace($n_enlaces) "Image: $descrip"
            }
            set fichero_enlace($n_enlaces) [Adecentar_dir $nombre_fichero]
            set repetidos($nombre_fichero) 1

            if  [regexp {^/} $nombre_fichero] {
                set enlaces_absolutos 1
                set enlaces_completos($n_enlaces) $diff$nombre_fichero
            }
            incr n_enlaces
        } else {
            regexp -nocase {(?:.*?< *[^aif])(.*)} $cosa nada cosa
        }
    }
    close $leer
#ver_enlaces
    Cambiar_pagina $file $hay_url

    return
}

###############################################################################
# Adecentar_nombres
#    Quita del path y nombre de un fichero cosas como '?' '~' '+' '-'
# Devuelve
#    El nombre sin esas cosas
###############################################################################
proc Adecentar_nombres {nombre} {

    regsub -all {~}  $nombre {} nombre
    regsub -all {\*} $nombre {} nombre

    if {[regexp {([^\?]+)(?:\?)(.*)} $nombre nada uno dos]} {
        regsub -all {\?} $dos {} dos
        regsub -all {\+} $dos {} dos
        regsub -all {\?} $dos {} dos
        regsub -all {/}  $dos {} dos
        regsub -all {\\} $dos {} dos
        set nombre $uno$dos
    }
    return $nombre
}

###############################################################################
# Adecentar_descripcion
#    Coge la descripcion en HTML del enlace y lo traduce para ojos humanos
# Parametros:
#    La descripcion a traducir
###############################################################################
proc Adecentar_descripcion {descripcion} {

    if [regexp -nocase {^(< *img)} $descripcion] {
        if {![regexp -nocase {(?:ALT *= *\")([^\"]+)} $descripcion nada descrip]} {
            regexp -nocase {(?:src *= *\")([^\"]+)} $descripcion nada descrip
        }
        set descripcion "Link image: $descrip"
    }
    regsub -all {<.*?>}     $descripcion {}   descripcion
    regsub -all {&quot;}    $descripcion {\"} descripcion
    regsub -all {&#34;}     $descripcion {\"} descripcion
    regsub -all {&#39;}     $descripcion {'}  descripcion
    regsub -all {&lt;}      $descripcion {<}  descripcion
    regsub -all {&gt;}      $descripcion {>}  descripcion
    regsub -all {(&)(amp;)} $descripcion {\1} descripcion
    regsub -all {&ntilde;}  $descripcion {}  descripcion
    regsub -all {&aacute;}  $descripcion {}  descripcion
    regsub -all {&eacute;}  $descripcion {}  descripcion
    regsub -all {&iacute;}  $descripcion {}  descripcion
    regsub -all {&oacute;}  $descripcion {}  descripcion
    regsub -all {&uacute;}  $descripcion {}  descripcion

    return $descripcion
}

###############################################################################
# Elegidos
#    Seleccion automatica de los ficheros a bajar.
# Parametros:
#    patron: expresion regular que identifica el tipo de fichero.
#    cual: '1' para seleccionar, '0' para deseleccionar.
###############################################################################
proc Elegidos { patron cual} {

    global fichero_enlace n_enlaces enlacesok

    for {set i 1} {$i<$n_enlaces} {incr i} {
        if {[regexp -nocase $patron $fichero_enlace($i)]} {
            set enlacesok($i) $cual
        }
    }
    return
}

###############################################################################
# Elegir_bajadas
#    Muestra un cuadro de dialogo con los ficheros con los que enlaza la pagina
#    para escoger cuales bajar.
# Efectos secundarios:
#    En la matriz 'enlacesok' se guarda un '1' si ese fichero se ha de bajar y 
#    un '0' en caso contrario.
###############################################################################
proc Elegir_bajadas {} {

    global fichero_enlace n_enlaces enlacesok descripcion_enlace
    global leido dirGetleft labelButton labelTitles labelDialogs

    if {$n_enlaces==1} "return 0"
    set elegir   [toplevel .elegir]
    set marco    [frame $elegir.marco]
    set marco_in [frame $elegir.marco.marco_interno]
    set botones  [frame $elegir.botones]
    set checks   [frame $elegir.checks]

    wm title $elegir $labelTitles(choose)

    set texto [text $marco_in.texto -yscrollcommand [list $marco_in.yscroll set] \
            -xscrollcommand [list $marco.xscroll set] -wrap none]
    set aceptar [button $botones.aceptar   -text $labelButton(ok)     -width 9 \
            -command "set leido 1"]
    set cancelar [button $botones.cancelar -text $labelButton(cancel) -width 9 \
            -command "set leido 0" ]

    set mas   [image create bitmap  -file [file join $dirGetleft images mas]]
    set menos [image create bitmap  -file [file join $dirGetleft images menos]]
    set lhtml [label  $checks.lhtml -text "  $labelDialogs(html)"]
    set htmla [button $checks.htmla -image $mas   -width 8 -height 8 \
            -command "Elegidos {(html$)|(htm$)} 1"]
    set htmle [button $checks.htmle -image $menos -width 8 -height 8 \
            -command "Elegidos {(html$)|(htm$)} 0"]
    set lima  [label $checks.lima   -text "  $labelDialogs(images)"]
    set imaa  [button $checks.imaa  -image $mas   -width 8 -height 8 \
            -command "Elegidos {(gif$)|(jpg$)|(bmp$)|(xbm$)|(tiff$)} 1"]
    set imae  [button $checks.imae  -image $menos -width 8 -height 8 \
            -command "Elegidos {(gif$)|(jpg$)|(bmp$)|(xbm$)|(tiff$)} 0"]
    set lcom  [label $checks.lcom   -text "  $labelDialogs(archives)"]
    set coma  [button $checks.cona  -image $mas   -width 8 -height 8 \
            -command "Elegidos {(tar$)|(gz$)|(z$)|(zip$)} 1"]
    set come  [button $checks.cone  -image $menos -width 8 -height 8 \
            -command "Elegidos {(tar$)|(gz$)|(z$)|(zip$)} 0"]
    set ltodo [label $checks.ltodo  -text "  $labelDialogs(all)"]
    set todoa [button $checks.todoa -image $mas   -width 8 -height 8 \
            -command "Elegidos {.} 1"]
    set todoe [button $checks.todoe -image $menos -width 8 -height 8 \
            -command "Elegidos {.} 0"]

    set color [$texto cget -background]

    for {set i 1} {$i<$n_enlaces} {incr i} {
        checkbutton $texto.enlaces$i -variable enlacesok($i) -background $color
        set enlacesok($i) 1

        $texto window create $i.0 -window $texto.enlaces$i
        $texto insert insert $descripcion_enlace($i)\n
    }

    set barray [scrollbar $marco_in.yscroll -orient vertical \
        -command [list $texto yview]]
    set barrax [scrollbar $marco.xscroll -orient horizontal  \
        -command [list $texto xview]]

    pack $texto $barray -side left -fill y
    pack $barrax -side bottom -fill x
    pack $marco_in $marco
    pack $lhtml $htmla $htmle $lima $imaa $imae $lcom $coma $come \
        $ltodo $todoa $todoe -side left
    pack $aceptar $cancelar -side left
    pack $botones $checks -side bottom

    tkwait visibility $elegir

    grab $elegir
    tkwait variable leido
    grab release $elegir
    destroy $elegir

    return $leido
}

###############################################################################
# Abrir_fichero
#    Crea, si hace falta el directorio en el que se va a guardar el enlace 
#    que toque.
# Parametro:
#    fichero: nombre del fichero.
#    force: '0' si no hay que abrir si ya existe, '1' si hay que abrirlo
# Devuelve:
#    Nombre del fichero a bajar si todo va bien
#    1: Si el fichero ya existe y no se sobreescribe
###############################################################################
proc Abrir_fichero {fichero {force 0}} {
    global directorio_local directorio_base
    global labelTitles labelMessages

    if [regexp {(?:^/)(.*)} $fichero nada fichero] {
        set directorio_a_usar $directorio_base
    } else {
        set directorio_a_usar $directorio_local
    }
    if {([file exists [file join $directorio_a_usar [string trimright $fichero {/}]]])&&($force==0)} {
        return 1
    }

    set directorio [file dirname $fichero]
    if [file exists [file join $directorio_a_usar $directorio]] {
        if {![file isdirectory [file join $directorio_a_usar $directorio]]} {
            puts "La hemos fastidiado con los nombres: $fichero"
            return 1
        }
     } else {
        if [catch {file mkdir [file join $directorio_a_usar $directorio]} error] {
            tk_messageBox -title $labelTitles(error) -icon error \
                    -message $error
            return 1
        }
     }
     set fichero_a_bajar \
        [file join $directorio_a_usar ${fichero}.$labelMessages(downloading)]

     return $fichero_a_bajar
}

###############################################################################
# ErrorLog
#    Logs in the file 'Geterror.log' the error messages returned by 'curl'
#
# Parameters
#    file: file in which the error occured
#    link: link that we where trying to download
###############################################################################
proc ErrorLog {file link} {
    global dirGetleft env tcl_platform labelDialogs

    if [regexp {Windows} $tcl_platform(os)] {
        set errorLog [file join "$dirGetleft" Geterror.log]
    } else {
        set errorLog [file join $env(HOME) Geterror.log]
    }
    set handle [open $errorLog a+]
    puts $handle "$labelDialogs(errorLink) $link"
    puts $handle "$labelDialogs(errorFile) $file"
    puts $handle "$labelDialogs(errorCode) $::Ventana::Rizo::curlError"
    puts $handle "$labelDialogs(errorMess) $::Ventana::Rizo::mensaje_error"
    close $handle

    return
}

###############################################################################
# Bajar
#    Baja un enlace
# Parametro:
#    enlace:  enlace a bajar
#    fichero: handle al fichero en el que se va a guardar
#    sufijo:  '1' si es 'html' o 'htm' 0 en otro caso
# Devuelve:
#    - '1' si es una pagina HTML
#    - '0' si no
###############################################################################
proc Bajar {enlace fichero sufijo} {
    global direccion

    set fichero [Adecentar_dir $fichero]
    set enlace  [Adecentar_dir $enlace]

    Ventana::Bajando_encabezamiento $enlace
    if {$::Ventana::Rizo::curlError!=""} {
        ErrorLog $fichero $enlace
        return 0
    }
    set Ventana::Rizo::informe(parar) 0
    Ventana::Bajando_archivo $fichero $enlace

    catch {tkwait window .bajando}
    if {$::Ventana::Rizo::curlError!=""} {
        ErrorLog $fichero $enlace
        return 0
    }

    catch {file rename $fichero [file rootname $fichero]}
    if [string match $Ventana::Rizo::meta(contenido) "text/html"] {
       return 1
    }
    return 0
}

###############################################################################
# Cambiar_pagina
#    Altera el contenido de una pgina de Web para que haya consistencia con
#    los directorios
#
# Parmetros
#    pagina: fichero con la pgina a cambiar
#    hay_url: '1' si hay que poner las direcciones de Web, '0' en caso contrario
###############################################################################
proc Cambiar_pagina {pagina hay_url} {
    global direccion fichero_enlace n_enlaces
    global directorio_base

    set path_relativo [Path_relativo $pagina]
    set script [open "$directorio_base/script.sed" w+]
    if {$hay_url==1} {
        puts $script "s#http://$direccion(www)##g"
        puts $script "s#ftp://$direccion(www)##g"
        puts $script {s#\(http:/\)\([^/]\)#/\2#g}
    }

    if [string match $direccion(dir) "/"] {
        set dir ""
    } else {
        set dir $direccion(dir)
    }
    for {set i 1} {$i<$n_enlaces} {incr i} {
        if [regsub -all {~|\?|\*} $fichero_enlace($i) {} nuevo_enlace] {
            regsub {\*|\?} $fichero_enlace($i) {\\&} tmp
            regsub {&} $nuevo_enlace {\\\&} nuevo_enlace
            puts $script "s#=\"*$tmp\"*#=\"$nuevo_enlace\"#g"
        }
        if {![regexp {^/} $fichero_enlace($i)]} {
            set tmp [Adecentar_dir [Adecentar_dir $dir]/[Adecentar_dir $fichero_enlace($i)]]
            set conAmper $tmp
            if {![string match $tmp $fichero_enlace($i)]} {
                regsub {&} $tmp {\\\&} tmp
                if [regexp {^\./} $fichero_enlace($i)] {
                    puts $script "s#=\"*\\\$fichero_enlace($i)\"*#=\"[Adecentar_nombres $tmp]\"#g"
                } else {
                    puts $script "s#=\"*$fichero_enlace($i)\"*#=\"[Adecentar_nombres $tmp]\"#g"
                }
            }
            set fichero_enlace($i) $conAmper
        }
    }
    puts $script "s#=\"/#=\"$path_relativo#g"
    puts $script "s#=/#=$path_relativo#g"

    close $script

    if {![file exists $pagina.orig]} {
        file copy $pagina $pagina.orig
        Invocar_sed $pagina
    }
    file delete "$directorio_base/script.sed"

    return
}

###############################################################################
# Invocar_sed
#    LLama s 'sed' para que haga el trabajo sucio de modificar las pginas de
#    Web.
#
# Parmetros:
#    pagina: fichero en el que se encuentra la pgina a cambiar.
#    expr:   (opcional), si existe es la expressin regular que se pasar a
#            'sed'. Si no existe, se invocar usando el fichero 'script.sed'.
###############################################################################
proc Invocar_sed {pagina {expr {}}} {
    global directorio_base
    global labelTitles

    if {$expr!=""} {
        set file [open "$directorio_base/script.sed" w+]
        puts $file $expr
        close $file
    }
    if [catch {exec sed -f "$directorio_base/script.sed"  $pagina > "$directorio_base/sed_temp"} error] {
        tk_messageBox -title $labelTitles(error) -message $error -type ok -icon error
    } else {
        file rename -force "$directorio_base/sed_temp" $pagina
    }
    return
}

###############################################################################
# Controlar_bajar
#    Envia a 'Bajar' los ficheros escogidos uno a uno
#
# Parametros:
#    lista_enlaces: lista con los enlaces que hay que bajarse
#    nivel_actual: nivel maximo de recursin
#    pagina_madre: pagina de la que sali la lista de enlaces  
###############################################################################
proc Controlar_bajar {lista_enlaces nivel_actual pagina_madre} {
    global direccion directorio_local n_enlaces directorio_base
    global opciones

    set n_oks [llength $lista_enlaces]
    if {$n_oks==0} return

    set cosa ""

    set j 0
    foreach enlace  $lista_enlaces {
        update
        incr j

        if [regexp {/$} $enlace] {
            set fichero_a_abrir [file join [Adecentar_nombres $enlace] index.html]
            set es_html($j) 1
            set indice [lsearch -exact $lista_enlaces $enlace]
            set lista_enlaces [lreplace $lista_enlaces \
                    $indice $indice [file join $enlace index.html]]
        } else {
            set fichero_a_abrir [Adecentar_nombres $enlace]
        }
        set fichero [Abrir_fichero $fichero_a_abrir]
        if [regexp -nocase {(htm|html)$} $fichero_a_abrir] {
            set sufijo 1
        } else {
            set sufijo 0
        }
        if {$fichero==1} {
            set es_html($j) $sufijo
            if {$sufijo==0} {
                if [file exists $fichero_a_abrir.html] {
                    set es_html($j) 1
                    set indice [lsearch -exact $lista_enlaces $enlace]
                    set lista_enlaces [lreplace $lista_enlaces $indice $indice $enlace.html]
                } else continue
            }
        } else {
            if [regexp {/$} $enlace] {
                Bajar $direccion(www)$enlace $fichero $sufijo
            } else {
                set dir_a_bajar $direccion(www)$enlace
                set es_html($j) [Bajar $dir_a_bajar $fichero $sufijo]
                if {($es_html($j)==1)&&($sufijo==0)} {
                    set raiz_fichero [file rootname $fichero]
                    catch {file rename $raiz_fichero $raiz_fichero.html}
                    exec touch $raiz_fichero
                    set indice [lsearch -exact $lista_enlaces $enlace]
                    set lista_enlaces [lreplace $lista_enlaces \
                            $indice $indice $enlace.html]
                    set enlace [file tail $enlace]
                    Invocar_sed [Adecentar_nombres $pagina_madre] "s#\($enlace\)\(\ \|\"\)#$enlace.html\2#g"
                }
            }
        }
    }

    set j 1
    foreach enlace $lista_enlaces {
        if {$es_html($j)==1} {
            set tmp_url   $direccion(dir)
            set tmp_local $directorio_local
            set dir_enlace [Adecentar_dir [file dirname $enlace]]
            if {$dir_enlace != "."} {
                set direccion(dir) [Adecentar_dir $dir_enlace]
            }
            set pagina_a_tratar "$directorio_base$enlace"
            if {($nivel_actual<$opciones(niv))||($opciones(niv)==-1)} {
                Preprocesado $pagina_a_tratar
                if {$n_enlaces!=1} {
                    Elegidos {.} 1
                    Controlar_bajar [Preparar_bajar] [expr $nivel_actual+1] $pagina_a_tratar
                }
            }
            set direcion(dir)   $tmp_url
            set directorio_local $tmp_local
        }
        incr j
    }
    return
}

###############################################################################
# Preparar_bajar
#    Se encarga de crear la lista con los ficheros a bajar
###############################################################################
proc Preparar_bajar {} {
    global fichero_enlace n_enlaces enlacesok

    for {set i 1 ; set lista_enlaces ""} {$i<$n_enlaces} {incr i} {
        if {$enlacesok($i)==1} {
            if {[lsearch $lista_enlaces $fichero_enlace($i)] == -1} {
                lappend lista_enlaces $fichero_enlace($i)
            }
        }
    }
    return $lista_enlaces
}

###############################################################################
# Leer_sel
#    Saca del portapapeles la direccion a tratar
# Devuelve
#    La seleccion a sacar
###############################################################################
proc Leer_sel {} {
    if {[catch {selection get -selection CLIPBOARD} cosa]} {
        if {[catch {selection get} cosa]} return
    }
    return $cosa
}

###############################################################################
# Introducir_url
#    Crea un cuadro de dialogo donde introducir la direccion deseada
###############################################################################
proc IntroducirUrl {} {
    global intro vistos n_enlaces opciones historial elementos ok
    global directorio_local index_his coord
    global labelButton labelTitles labelMessages

    fijar_coordenadas

    set intro [toplevel .introducir]
    wm title $intro $labelTitles(enterUrl)
    wm resizable $intro 0 0
    wm geometry $intro +[expr $coord(x)+100]+[expr $coord(y)+50]

    set ok 0

    set marcoEx [frame $intro.marcoEx]
    set marco   [frame $marcoEx.marco -bd 2 -relief groove]
    set elementos ""
    foreach {indice dir} [array get historial] {
        lappend elementos $dir
    }
    cuadro_combinado $marco.pagina [Leer_sel]

    set pagina $marco.pagina
    set botones  [frame $marcoEx.botones]
    set empezar  [button $intro.empezar  -text $labelButton(start) \
            -width 8 -command {set ok 1}]
    set cancelar [button $intro.cancelar -text $labelButton(cancel) \
            -width 8 -command {set ok 0}]

    bind $pagina.e <Return> "$empezar invoke"
    bind $pagina.e <Button-3> {
        Leer_sel %W
    }
    bind $empezar <Return> "$empezar invoke"

    pack $pagina -padx 20 -pady 20
    pack $marcoEx -ipadx 10 -ipady 5
    pack $marco -side bottom
    pack $cancelar -side right -padx 9 -pady 5
    pack $empezar -side right  -pady 5
    pack $botones -side right

    focus $pagina.e
    tkwait variable ok

    if {$ok==0} {
        destroy $intro
        return
    }

    set pagina_objetivo [$pagina.e get]
    destroy $intro
    if {$index_his==9} {
        set index_his 0
    } else {
        incr index_his
    }
    if {![EnHistorial $pagina_objetivo]} {
        set historial($index_his) $pagina_objetivo
        GuardarConfig
    }
    if [info exists vistos] {
        unset vistos
    }
    set nombre_fichero [Inicializacion_bajada $pagina_objetivo]
    if {![string compare $nombre_fichero ""]} return
    if {($opciones(niv)==0)||(![regexp -nocase "text/html" $Ventana::Rizo::meta(contenido)])} {
        tk_messageBox -icon info -title $labelTitles(theEnd) -type ok \
                -message $labelMessages(theEnd)
        return
    }
    set pagina_a_tratar [file join $directorio_local [Adecentar_nombres $nombre_fichero]]
    Preprocesado $pagina_a_tratar
    if {$n_enlaces==1} {
        tk_messageBox -icon info -title $labelTitles(noLinks) -type ok \
                -message $labelMessages(noLinks)
        return
    }
    set leido [Elegir_bajadas]
    if {$leido==1} {
        Controlar_bajar [Preparar_bajar] 1 $pagina_a_tratar
        tk_messageBox -icon info -title $labelTitles(theEnd) -type ok \
                -message $labelMessages(theEnd)
    }
    return
}

###############################################################################
# LeerConfig
#    Reads the configuration file
###############################################################################
proc LeerConfig {} {
    global historial dirGetleft opciones
    global env tcl_platform

    if [regexp {Windows} $tcl_platform(os)] {
        set ficherorc [file join "$dirGetleft" getleft.ini]
    } else {
        set ficherorc [file join $env(HOME) .Getleft]
    }

    if [catch {open $ficherorc r} fichero] {
        exec touch $ficherorc
        set opciones(lang) en
        return 0
    }

    for {set enHistorial 0} {![eof $fichero]} {} {
        set linea [gets $fichero]
        if [regexp {\[historial\]} $linea] {
            gets $fichero
            for {set i 0} {$i<10} {incr i} {
                set historial($i) [gets $fichero]
                if [string match $historial($i) ""] {
                unset historial($i)
                break
                }
            }
            set enHistorial [incr i -1]
        }

        if [regexp {\[proxy\]} $linea] {
            gets $fichero
            set opciones(dirProxy) [gets $fichero]
            set opciones(proxy) 1
        }

        if [regexp {\[language\]} $linea] {
            gets $fichero
            set opciones(lang) [gets $fichero]
        }
    }
    close $fichero

    if {![info exists opciones(lang)]} {
        set opciones(lang) en
    }

    return $enHistorial
}

###############################################################################
# GuardarConfig
#   Save the configuration
###############################################################################
proc GuardarConfig {} {
    global historial index_his dirGetleft opciones
    global env tcl_platform
    global labelMessages labelTitles

    if [regexp {Windows} $tcl_platform(os)] {
        set ficherorc [file join $dirGetleft getleft.ini]
    } else {
        set ficherorc [file join $env(HOME) .Getleft]
    }

    if [catch {open  $ficherorc w+} fichero] {
        tk_messageBox -title $labelTitles(error) -icon Error \
            -message $labelMessages(saveConfig)
        return
    }

    puts $fichero "\[historial\]\n"
    for {set i 0} {$i<10} {incr i} {
        if {![catch {set historial($i)} ]} {
            puts $fichero $historial($i)
        }
    }

    if [info exists opciones(dirProxy)] {
        puts $fichero "\n\[proxy\]\n"
        puts $fichero "$opciones(dirProxy)"
    }

    puts $fichero "\n\[language\]\n"
    puts $fichero "$opciones(lang)"

    close $fichero

    return
}

###############################################################################
# Mostrar_historial
#    Muestra el contenido del historial
###############################################################################
proc Mostrar_historial {} {
    global historial index_his

    for {set i 0} {$i<10} {incr i} {
        if {![catch {set historial($i)} ]} {
            puts "$i: $historial($i)"
        }
    }
    return
}

###############################################################################
# EnHistorial
#    Averigua si la pgina a meter ya est en el historial
#
# Parmetro:
#    Pgina a meter.
#
# Devuelve:
#    1 si est, 0 si no
###############################################################################
proc EnHistorial {pagina} {
    global historial

    for {set i 0} {$i<10} {incr i} {
        if [catch {regsub {(http://)||(ftp://)} $historial($i) {} una}] {
            return 0
        }
        regsub {(http://)||(ftp://)} $pagina {} dos

        if [string match $una $dos] {
            return 1
        }
    }
    return 0
}

###############################################################################
# ChangeLanguage
#    Changes the default language for the program
#
# Parameters:
#    lang: language to be used
###############################################################################
proc ChangeLanguage {lang} {
    global opciones

    set opciones(lang) $lang
    MenusEtiquetas $lang

    GuardarConfig

    return
}

###############################################################################
# MenusEtiquetas
#    Puts the labels into the menus.
#
# Parameters:
#    labFile: file with the labels in the, hopefully, desired language
###############################################################################
proc MenusEtiquetas {{labFile ""}} {
    global menus dirGetleft
    global labelButton labelTitles labelMessages labelDialogs

    if {$labFile==""} {
        set labFile en
    }

    source [file join $dirGetleft Languages menus.$labFile]

    .menus      entryconfigure 1 -label $labelMenus(1)      ;    # File
    $menus(1)   entryconfigure 0 -label $labelMenus(1,0)    ;    # Intro Url
    $menus(1)   entryconfigure 2 -label $labelMenus(1,2)    ;    # Exit

    .menus      entryconfigure 2 -label $labelMenus(2)      ;    # Options
    $menus(2)   entryconfigure 0 -label $labelMenus(2,0)    ;    # Up links
    $menus(2,0) entryconfigure 0 -label $labelMenus(2,0,0)  ;    # Follow
    $menus(2,0) entryconfigure 1 -label $labelMenus(2,0,1)  ;    # Ignore
    $menus(2)   entryconfigure 1 -label $labelMenus(2,1)    ;    # Levels
    $menus(2,1) entryconfigure 0 -label $labelMenus(2,1,0)  ;    # No limit
    $menus(2)   entryconfigure 2 -label $labelMenus(2,2)    ;    # CGI
    $menus(2)   entryconfigure 3 -label $labelMenus(2,3)    ;    # Use proxy

    .menus      entryconfigure 3 -label $labelMenus(3)      ;    # Tools
    $menus(3)   entryconfigure 0 -label $labelMenus(3,0)    ;    # Purge  files
    $menus(3)   entryconfigure 1 -label $labelMenus(3,1)    ;    # Restore orig
    $menus(3)   entryconfigure 2 -label $labelMenus(3,2)    ;    # Config proxy
    $menus(3)   entryconfigure 3 -label $labelMenus(3,3)    ;    # Language
    $menus(3,0) entryconfigure 0 -label $labelMenus(3,3,0)  ;    # Espaol
    $menus(3,0) entryconfigure 1 -label $labelMenus(3,3,1)  ;    # English
#    $menus(3)   entryconfigure 4 -label $labelMenus(3,4)    ;    # Resource
#    $menus(3)   entryconfigure 5 -label $labelMenus(3,5)    ;    # Resource2

    .menus      entryconfigure 4 -label $labelMenus(4)      ;    # Help
    $menus(4)   entryconfigure 0 -label $labelMenus(4,0)    ;    # Manual
    $menus(4)   entryconfigure 2 -label $labelMenus(4,2)    ;    # License
    $menus(4)   entryconfigure 4 -label $labelMenus(4,4)    ;    # About

    return
}

###############################################################################
# CrearMenus
#   Creates the menus, without putting the labels
###############################################################################
proc CrearMenus {} {
    global opciones dirGetleft menus

    menu .menus -relief flat

    set menus(1) [menu .menus.fichero      -tearoff 0]
    .menus add cascade -menu $menus(1) -underline 0
    set menus(2) [menu .menus.editar       -tearoff 0]
    .menus add cascade -label Options  -menu $menus(2) -underline 0
    set menus(3) [menu .menus.herramientas -tearoff 0]
    .menus add cascade -label Tools -menu $menus(3) -underline 0
    set menus(4) [menu .menus.help         -tearoff 0]
    .menus add cascade -label Help  -menu $menus(4) -underline 0

    $menus(1) add command -command "IntroducirUrl"
    $menus(1) add separator
    $menus(1) add command -command exit

    $menus(2) add cascade -menu $menus(2).directorios
    $menus(2) add cascade -menu $menus(2).niveles
    $menus(2) add check   -variable opciones(cgi)   -onvalue 1 -offvalue 0
    $menus(2) add check   -variable opciones(proxy) -onvalue 1 -offvalue 0

    set opciones(cgi)  0

    set menus(2,0) [menu $menus(2).directorios -tearoff 0]
    $menus(2,0) add radio -label Follow -variable opciones(dir) -value 1
    $menus(2,0) add radio -label Ignore -variable opciones(dir) -value 0
    set opciones(dir) 1

    set menus(2,1) [menu $menus(2).niveles -tearoff 0]
    $menus(2,1) add radio -label "No limit" -variable opciones(niv) -value -1
    for {set i 0} {$i<6} {incr i} {
        $menus(2,1) add radio -label $i -variable opciones(niv) -value $i
    }
    set opciones(niv) -1

    $menus(3) add command -command Herramientas::PurgarFicheros
    $menus(3) add command -command Herramientas::RestaurarOriginales
    $menus(3) add command -command Herramientas::ConfProxy
    $menus(3) add cascade -menu $menus(3).idiomas
#    $menus(3) add command -command \
#            "catch {source [file join $dirGetleft Getleft.tcl]}"
#    $menus(3) add command -command "source [file join $dirGetleft Getleft.tcl]"

    set menus(3,0) [menu $menus(3).idiomas -tearoff 0]
    $menus(3,0) add command -command "ChangeLanguage es"
    $menus(3,0) add command -command "ChangeLanguage en"

    $menus(4) add command -label "Manual"  -command Ayuda::Manual
    $menus(4) add separator
    $menus(4) add command -label "Licence" -command Ayuda::Licencia
    $menus(4) add separator
    $menus(4) add command -label "About"   -command Ayuda::AcercaDe

    MenusEtiquetas $opciones(lang)

    return
}

###############################################################################
#				PROGRAMA PRINCIPAL
############################################################################### 
wm title . "Getleft v 0.5.3"
wm geometry . 300x0
. config -menu .menus

set index_his [LeerConfig]

CrearMenus
