###############################################################################
###############################################################################
##                          ayuda.tcl
##
## Incluye los procedimientos necesarios para los comandos que se encuentran
## en el men de ayuda
##
## (c) 1999 Andrs Garca Garca.
## Distribuible segn los trminos de la licencia GNU
###############################################################################
###############################################################################

namespace eval Ayuda {

###############################################################################
# CrearVentana
#    Crea una ventana donde mostrar el contenido de un fichero de texto
#
# Parmetros:
#    titulo: ttulo que se le pondr a la ventana
#    fichero: fichero de texto a mostrar
###############################################################################
proc CrearVentana {titulo fichero} {
    global coord
    global labelButton labelTitles labelMessages

    if [catch {open $fichero r} handle] {
        tk_messageBox -title $labelTitles(error) -icon error \
            -message [concat $labelMessages(notFound) \n $fichero]
        return
    }

    fijar_coordenadas

    set ventana [toplevel .ventana$titulo]
    wm title $ventana $titulo
    wm resizable $ventana 0 0
    wm geometry $ventana +[expr $coord(x)+100]+[expr $coord(y)+50]

    set marcoExt [frame $ventana.marcoext]
    set marcoTex [frame $marcoExt.marcotex -bd 2 -relief sunken]

    set texto [text $marcoTex.texto -yscrollcommand [list $marcoTex.yscroll set] \
            -wrap none -bg white]

    set barra [scrollbar $marcoTex.yscroll -orient vertical \
            -command [list $texto yview] ]

    set aceptar [button $ventana.aceptar -text $labelButton(ok) -width 8 \
            -command "destroy \"$ventana\""]

    pack $marcoExt -ipadx 10 -ipady 5
    pack $marcoTex -side bottom
    pack $barra $texto -side right -fill y
    pack $aceptar -pady 5

    for {} {![eof $handle]} {} {
       set linea [gets $handle]
       $texto insert insert $linea\n
    }
    close $handle
    $texto configure -state disabled

    bind $aceptar <Return> "\"$aceptar\" invoke"
    return
}

###############################################################################
# Manual
#   Muestra el manual de la aplicacin
###############################################################################
proc Manual {} {
    global dirGetleft labelTitles

    CrearVentana $labelTitles(manual) [file join $dirGetleft doc Readme.txt]

    return
}

###############################################################################
# Licencia
#   Muestra la licencia GPL, no tengo una versin en Espaol, as la tendr
#   que poner en Ingls
###############################################################################
proc Licencia {} {
    global dirGetleft labelTitles

    CrearVentana  $labelTitles(license) [file join $dirGetleft doc license]

    return
}

###############################################################################
# AcercaDe
#    Muestra algo de informacin sobre el programa
###############################################################################
proc AcercaDe {} {
   global dirGetleft coord
   global labelButton labelTitles

   set ven [toplevel .acercade]
   wm title $ven $labelTitles(about)
   wm resizable $ven 0 0

   fijar_coordenadas
   wm geometry $ven +[expr $coord(x)+180]+[expr $coord(y)+110]

   set ima [image create photo -file $dirGetleft/doc/about.gif]
   set foto [frame $ven.foto -bd 2 -relief sunken]
   set lienzo [canvas $foto.lienzo -width 388 -height 234]
   $lienzo create image 0 0 -image $ima -anchor nw
   button $ven.aceptar -text $labelButton(ok) -command "destroy $ven"

   pack $lienzo -expand true
   pack $foto -side top -expand true -padx 2 -pady 2
   pack $ven.aceptar -pady 2

   grab $ven

   return
}

}