###############################################################################
###############################################################################
#####                          Ccombinado.tcl
###############################################################################
# This file contains a combobox type widget
###############################################################################
# Copyright 1999 Jess, Andrs Garca. Distributed under the terms of the
# GNU license
###############################################################################

###############################################################################
# CuadroTexto
#    Sets in the text widget the selected value, after deleting the former
#    one.
###############################################################################
proc CuadroTexto { v t } {
    if { [set idx [$v curselection ]]!="" } {
        $t delete 0 end
        $t insert 0 [$v get $idx]
    }
    return
}

###############################################################################
# RetiraLista
#    Erases the window used by the list.
###############################################################################
proc RetiraLista { w } {
    grab release $w
    wm withdraw [winfo toplevel $w]

    return
}

###############################################################################
# SacaLista
#    Maps the window with the list
#
# Parameter
#    Window name
###############################################################################
proc SacaLista {w} {
    global elementos

    set d ${w}_desplegable
    set l $d.listado

    if {[winfo ismapped $d]} {
        grab release $d
        wm withdraw $d
    } else {
        set x1 [expr [winfo rootx ${w}.fondo.boton]-\
                [winfo reqwidth $l.cuadro]]
        set y1 [expr [winfo rooty ${w}.fondo.boton]+\
                [winfo height ${w}.fondo.boton]]
        wm geometry $d +$x1+$y1
        wm deiconify $d
        raise $d
        focus $l.cuadro
        wm geometry $d +$x1+$y1
        update
        grab -global $d
    }
    return
}

###############################################################################
# Seleccionado
#    If you click on a list element, this procedures puts the selected
#    value in the text widget, and closes the window list
###############################################################################
proc Seleccionado { w y } {

    set d ${w}_desplegable
    set l $d.listado

    grab release $d

    ${w}.e delete 0 end
    ${w}.e insert 0 [$l.cuadro get [$l.cuadro nearest $y]]

    focus ${w}.e

    RetiraLista $l

    return
}

###############################################################################
# PulsadaTecla
#    Invoked if you use return to select an element, it writes it in the
#    text widget and then closes the list window.
###############################################################################
proc PulsadaTecla { w tipo } {

    set d ${w}_desplegable
    set l $d.listado

# Si 'tipo' es uno indica que la tecla pulsada es 'Return' y por lo
# tanto se debe poner el valor seleccionado en el cuadro de texto sino
# se considera que es 'Escape' y por lo tanto no se modifica el cuadro
# de texto

    if { $tipo==1 } {
        CuadroTexto $l.cuadro ${w}.e
    }

    focus ${w}.e
    RetiraLista $d

    return
}

###############################################################################
# BarraDesplazamiento
#    Erases the scroll bar in the window list in case it is not needed.
###############################################################################
proc BarraDesplazamiento { listbox scrollbar } {
    set items [$listbox index end]
    set size [$listbox cget -height]
    if {$items <= $size} {
        pack forget $scrollbar
        $listbox configure -height $items
    } else {
        pack $scrollbar -side right -fill y
    }
    return
}

###############################################################################
# cuadroCombinado
#    This procedure creates the combobox.
#
# Parameters:
#    w: full path to name the combobox.
#    elementos: list of items to be displayed in the list
#    nombre: value that will be preselected
###############################################################################
proc cuadroCombinado { w elementos {nombre ""}} {
    global datos_lista

    set datos_lista(relief) raised
    set resultado [frame $w -relief sunken -bd 1]
    rename $w _$w

# The variable 'ancho' contains the witdh if the entry box
   #====================
   # ANCHO DE LA LISTBOX
   #====================
    set ancho 50
    if { $resultado != {} } {
        if {[info comm flecha] == {}} {
            set flecha {
                #define flecha_width 15
                #define flecha_height 15
                static char flecha_text_bits[] = {
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0xf8, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0x40, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00
                }
            }
            image create bitmap flecha -data [set flecha]
            unset flecha
        }

# Entry box
        entry $w.e -bd 1 -relief flat -width $ancho -bg white
        frame $w.fondo -bg gray
        $w.e  insert 0 $nombre
        $w.e  selection range 0 end	

# Button
        button $w.fondo.boton -image flecha -relief raised \
            -command "SacaLista $w" -width 8 -height 10
        pack $w.e -side left -pady 1 -padx 1 -fill x
        pack $w.fondo -side right
        pack $w.fondo.boton -side bottom -pady 1 

# List
        set d ${w}_desplegable
        toplevel $d -relief raised -bd 1 -bg White
        wm overrideredirect $d 1
        wm transient $d
        wm withdraw $d

# En 'l' se guarda el nombre donde van a ir los elementos del listado
# de la barra de desplazamiento dentro de la ventana 'd'

        set l $d.listado
        frame $l 
        pack $l -expand yes -fill y

#Ahora se crea el cuadro de lista propiamente dicho es decir donde van
#a ir los elementos que podemos seleccionar as como la barra de 
#desplazamiento vertical

        scrollbar $l.barra -bd 1 -command "$l.cuadro yview"

#En este se define el ancho que queremos para la lista si se quiere
#el estandard no se pone el width con el ancho

        listbox $l.cuadro -yscroll "$l.barra set" -setgrid 1 -bg White \
            -relief sunken -width $ancho
        pack $l.barra -side right -fill y
        pack $l.cuadro -side left -expand 1 -fill both

#Pone una etiqueta a la ventana que se usa como cuadro de lista 
#desplegable, a la parte usada para poner los elementos y a la
#barra de desplazamiento

        set etiqueta [winfo name $w]_listado
        foreach q "$d $l $l.cuadro $l.barra" {
             bindtags $q [concat ${etiqueta} [bindtags $q]]
        }
        set numero [llength $elementos]
        if {$elementos != ""} {
            $l.cuadro delete 0 end
            foreach q $elementos {
                $l.cuadro insert end $q
                if { $q==$nombre } {
                    set i [lsearch $elementos $q]
                    $l.cuadro yview moveto [expr (double($i))/$numero]
                    tkListboxMotion $l.cuadro \ $i
                }
            }
        }
        bind $l.cuadro <Motion> "
            set datos_lista(y) %y
            tkListboxMotion %W \[%W index @%x,%y]
        "
        bind $l.cuadro <Enter> {
            tkCancelRepeat
        }
        bind $etiqueta <ButtonPress>  {
            foreach q {rootx rooty width height} {
                set $q [winfo $q %W]
            }
            if {(%X < $rootx) || (%X > ($rootx+$width)) || \
                     (%Y < $rooty) || (($rooty+$height) < %Y)} {
                RetiraLista %W
            }
        }
        bind $etiqueta <Return> "PulsadaTecla [list $w] 1"
        bind $etiqueta <Escape> "PulsadaTecla [list $w] 0"
        bind $l.cuadro <1> "Seleccionado [list $w] %y"
        bind ${w}.e <Down> "SacaLista ${w}"
        bind $l.cuadro <Configure> "
            BarraDesplazamiento $l.cuadro $l.barra
        "
    }
    return
}
