##############################################################################
##############################################################################
#                               Rizo.tcl
# In this file are implemented the procedures to actually do the downloading
# by executing 'curl'.
##############################################################################
# Copyright 1999 Andrs Garca Garca  -- ornalux@redestb.es
# Distributed under the terms of the GPL license
##############################################################################
##############################################################################
namespace eval Rizo {
variable errorMessage ""
variable meta
variable curlReport

##############################################################################
# RefererPage
#    It takes the path of the page from which the link was taken, as composes
#    its url. As filenames sometimes get changed, removing '~' for example,
#    the composed url may not be exactly the same, but if there is an
#    'file not found' error, it will be enough to clue the publisher, so
#    he can fix the error, that's the idea anyway.
#
# Parameter:
#    mother: full path to the referer page
#
# Returns
#    The url (or something like it)
##############################################################################
proc RefererPage {mother} {
    global siteUrl directories
puts "ReferePage: $mother"
    if {![regexp {(?:.:)(.*)} $directories(base) nada base]} {
        set base $directories(base)
    }
    regexp -nocase {(.*?\..*?)(\.html)} $mother nada mother
    regexp "(?:$base)(.*)" $mother nada remotePath
    set url http://$siteUrl(www)$remotePath

    return $url
}

##############################################################################
# Common
#    This procedure takes care of initializing the state variables an invoke
#    'curl' for all the connection types.
#
# Parameters:
#    args: args that will be passed to curl
#    type: type of connection:
#           - cab: Headers
#           - dat: The link itself
##############################################################################
proc Common {args type} {
    variable curlReport
    variable meta
    variable pipe
    variable curlError
    global options errorCode

    set curlReport(long)     0
    set curlReport(pause)    0
    set curlReport(speed)    0
    set curlReport(stop)     0
    set curlReport(gotBytes) 0
    set curlError            0
    set errorCode           ""

    if {$options(proxy)==1} {
        set curlCmd [concat curl -x $options(dirProxy) $args]
    } else {
        set curlCmd [concat curl $args]
    }
#puts $curlCmd
    eval {set pipe [open "| $curlCmd |& cat" r]}

    fileevent $pipe readable [list [namespace code Lector] $pipe $type]
    fconfigure $pipe -blocking 0

    return
}

###############################################################################
# HeadRequest
#    Asks the server for the Headers of the link
#
# Parameters:
#    link: url to download
#    mother: referer page of the link
###############################################################################
proc HeadRequest {link mother} {
    variable meta
# It seems some servers return the body on a HEAD request
    variable workaround

    set meta(content) ""
    set meta(relocate)  ""
    set workaround 0

    if [info exists meta(totalBytes)] {
        unset meta(totalBytes)
    }

    if {$mother!="-"} {
        set refererUrl [RefererPage $mother]
        set args [list -e $refererUrl -I $link]
    } else {
        set args [list -I $link]
    }
    Common $args cab

    return
}

###############################################################################
# DataRequest
#   Downloads a given url
#
# Parameters:
#   file:  file in which the url will be saved
#   linke: url to download
#   mother: referer url of the link
###############################################################################
proc DataRequest {file link mother} {
    variable curlReport
    variable meta
    global options

    set curlReport(percentage) 0
    if {![info exists meta(totalBytes)]} {
        set meta(totalBytes) 0
    }

    if {$mother!="-"} {
        set refererUrl [RefererPage $mother]
        set args [list -e $refererUrl -o $file $link]
    } else {
        set args [list -o $file $link]
    }

    Common $args dat

    return
}

###############################################################################
# ResumeRequest
#    Resumes, server allowing, a download
#
# Parameters:
#    file: full path of the file where the url will be downloaded
#    link: url to download
#    mother: referer page of the url
###############################################################################
proc ResumeRequest {file link mother} {
    variable curlReport
    variable meta

    set curlReport(percentage) 0
    if {![info exists meta(totalBytes)]} {
        set meta(totalBytes) 0
    }

    if {$mother!="-"} {
        set refererUrl [RefererPage $mother]
        set args [list -e $refererUrl -c -o $file $link]
    } else {
        set args [list -c -o $file $link]
    }
    Common $args dat

    return
}

###############################################################################
# Lector
#   This procedure controls the downloading, it is invoked anytime there is
#   something to proccess
#
# Parameters:
#   pipe: pipe used to invoke 'curl'
#   tipo: type of request (HEAD, GET, ...) or stopNow, to stop
###############################################################################
proc Lector {pipe tipo} {
    variable meta
    variable curlReport
    variable curlError
    variable workaround
    global errorCode getleftState

    if {($tipo=="stopNow")||($getleftState(downloading)==0)} {
        catch {close $pipe}
        return
    }
    if {[catch "eof $pipe" endOfFile]} {
        tk_messageBox -title "Error" -messageBox "Could you please e-mail me\n \
                saying you saw this?" -type ok
        return
    }
    if {($endOfFile) || ($curlReport(stop)==1) || ($curlReport(pause)==1)} {
        if {($endOfFile)} {
            set curlReport(end) 1
        }
        catch {close $pipe}
        if {$errorCode!=""} {
            set curlError [lindex $errorCode 2]
	        if {$curlError==18} {
                if {$tipo!="cab"} {
                    puts "Error 18 en el cuerpo"
                }
                set curlError 0
                set errorCode ""
            }
#            if {$curlError!=""} {
#                puts "Cdigo de error: $curlError - $errorCode"
#            }
        }
        return
    }
    if {[gets $pipe line]>=0} {
        if {[string first curl $line]!=-1} {
            set Ventana::Rizo::errorMessage $line
            return
        }
        if [string match $line ""] return
        if {$tipo=="cab"} {
            if {([regexp {^<} $line])||($workaround==1)} {
                set workaround 1
                return
            }
#puts $line
            if [regexp -nocase {^(?:HTTP/)([0-9].[0-9])(?:\ )([0-9]*)(?:\ )(.*)} \
                    $line nada meta(versionServer) meta(code) meta(error)] {
                if {$meta(code)>=400} {
                    set Ventana::Rizo::errorMessage $meta(error)
                    catch {error "Server Error" SERVER \
                            "Server \"$meta(error)\" $meta(code)"}
                    return
                }
            }
            regexp -nocase {^(?:Location: )(.*)}      $line nada meta(relocate)
            regexp -nocase {^(?:Content-Type: )(.*)}  $line nada meta(content)
            regexp -nocase {^(?:Last-Modified: )(.*)} $line nada meta(lastModified)
            regexp -nocase {^(?:Content-Length: )(.*)} \
                    $line nada meta(totalBytes)
        } else {
            set curlReport(speed) 0
            set curlReport(gotBytes)  0

            if {[string first % $line]!=-1} {
                set curlReport(long) 1
                return
            }
            if {$curlReport(long)==1} {
                set curlReport(percentage) [lindex $line 0]
                set curlReport(speed)  [lindex $line 6]
            } else {
                regexp {(^.*?)(?: )(?:.*\()(.*)( )} $line \
                        nada curlReport(gotBytes) curlReport(speed)
                if [catch {expr $curlReport(gotBytes)*100.0/$meta(totalBytes)} \
                        curlReport(percentage)] {
                    set errorCode ""
                    set curlReport(percentage) 0
                } else {
                    set curlReport(percentage) [expr round($curlReport(percentage))]
                }
                if {$curlReport(gotBytes)<512} {
                    set curlReport(gotBytes) \
                        "[format "%.0f" $curlReport(gotBytes)] bytes"
                } elseif {$curlReport(gotBytes)<1048576} {
                    set curlReport(gotBytes) \
                        "[format "%.2f" [expr $curlReport(gotBytes)/1024.0]] k"
                } else {
                    set curlReport(gotBytes) \
                        "[format "%.2f" [expr $curlReport(gotBytes)/1048576.0]] M"
                }
            }
            if {![regexp {/} $curlReport(speed)]} {
                if {($curlReport(speed)>512)} {
                    set curlReport(speed) \
                        "[format "%.2f" [expr $curlReport(speed)/1024.0]] k/s"
                } else {
                    set curlReport(speed) \
                        "[format "%.2f" $curlReport(speed)] bytes/s"
                }
            }
            if {$curlReport(long)==1} {
                set curlReport(left) "[lindex $line 4] ( $curlReport(speed) )"
            } else {
                set curlReport(left) "$curlReport(gotBytes) ( $curlReport(speed) )"
            }
        }
    }
    return
}

}
