# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please refer to the BSD type license enclosed in this package

set rcsId {$Id: cpustats.tcl,v 1.9 1998/04/21 17:01:09 jfontain Exp $}

package provide cpustats 1.1

namespace eval cpustats {
    array set data {
        updates 0
        0,label {} 0,type ascii 0,message {}
        1,label user 1,type real 1,message {percentage spent in user mode}
        2,label system 2,type real 2,message {percentage spent in system mode}
        3,label nice 3,type real 3,message {percentage spent in nice mode}
        4,label idle 4,type real 4,message {percentage spent in idle mode}
        pollTimes {10 5 20 30 60 120 300}
        columns 5
        sort {0 increasing}
        helpText {
This is a view of processor activity for the system as a whole.
        }
    }

    array set data {0,0 percent}           ;# initialize single row index column with data unit so that viewer labels are meaningful

    array set last {user 0 nice 0 system 0 idle 0}                                                    ;# stored values for last poll
    set file [open /proc/stat]                                               ;# keep the statistics file open for better performance

    proc update {} {                                               ;# gather cpu statistics (based on the proc man page information)
        variable file
        variable last
        variable data

        seek $file 0                                                                         ;# always rewind before retrieving data
        scan [gets $file] {cpu %d %d %d %d} user nice system idle                                       ;# in hundredths of a second
        foreach item {user nice system idle} {         ;# calculate statistics during the last poll period except for the first pass
            set current [set $item]
            set $item [expr {$current-$last($item)}]
            set last($item) $current
        }
        set multiplier [expr {100.0/($user+$nice+$system+$idle)}]
        array set data "
            0,1 [format %.1f [expr {$multiplier*$user}]] 0,2 [format %.1f [expr {$multiplier*$system}]]
            0,3 [format %.1f [expr {$multiplier*$nice}]] 0,4 [format %.1f [expr {$multiplier*$idle}]]
        "
        incr data(updates)
    }
}
