# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please refer to the BSD type license enclosed in this package

set rcsId {$Id: html.tcl,v 1.5 1998/04/21 16:33:50 jfontain Exp $}

# use a font nicer than the HTML library default one
array set HMtag_map {
    code {family Helvetica}
    kbd {family Helvetica weight bold}
    pre {fill 0 family Helvetica Tnowrap nowrap}
    samp {family Helvetica}
    tt {family Helvetica}
}

proc helpWindow {} {
    global htmlHelpDataText

    if {[winfo exists .topHelp]} {
        wm deiconify .topHelp
        raise .topHelp
        return
    }
    toplevel .topHelp
    wm title .topHelp {moodss: global help}
    frame .topHelp.bound                      ;# create a frame for bindings that otherwise would propagate to all toplevel children

    set panes [new panner .topHelp -panes 2]                                         ;# split window in 2 for contents and help data
    pack $widget::($panes,path) -fill both -expand 1

    set contents [new scroll text $panner::($panes,frame1)]
    pack $widget::($contents,path) -fill both -expand 1

    set widget [new scroll text $panner::($panes,frame2)]
    pack $widget::($widget,path) -fill both -expand 1

    bind .topHelp.bound <Destroy> "delete $widget $contents $panes"

    set contentsText $composite::($contents,scrolled,path)                                       ;# first setup and display contents
    $contentsText configure -cursor watch                                                 ;# show that we are busy for user feedback
    update idletasks
    HMinit_win $contentsText
    $contentsText configure -state normal
    HMparse_html $::htmlHelpContents "HMrender $contentsText"
    $contentsText configure -state disabled
    HMset_state $contentsText -stop 1                                                        ;# stop rendering previous page if busy

    set htmlHelpDataText $composite::($widget,scrolled,path)                                      ;# now setup and display help text
    $htmlHelpDataText configure -cursor watch                                             ;# show that we are busy for user feedback
    update idletasks
    HMinit_win $htmlHelpDataText
    $htmlHelpDataText configure -state normal
    HMparse_html $::htmlHelpData "HMrender $htmlHelpDataText"
    $htmlHelpDataText configure -state disabled
    HMset_state $htmlHelpDataText -stop 1                                                    ;# stop rendering previous page if busy
    focus $htmlHelpDataText                                         ;# force focus on text widget so that page up and down keys work

    $htmlHelpDataText configure -cursor {}                                      ;# show that we are no longer busy for user feedback
    $contentsText configure -cursor {}
    update idletasks
}

proc HMlink_callback {widget reference} {                                                          ;# supply link callback procedure
    global htmlHelpDataText

    if {![string match #* $reference]} return                                                 ;# can only handle internal references
    HMgoto $htmlHelpDataText [string trimleft $reference #]                                   ;# always update help data text widget
}

proc HMset_image {widget label source} {                                                          ;# supply image handling procedure
    pack propagate [winfo parent $label] 1                    ;# do not display image, display alternate text in the smallest window
}
