set htmlHelpContents {
<UL>
<LI>
<A HREF="#about">About this document</A></LI>

<LI>
<A HREF="#introduction">Introduction</A></LI>

<LI>
<A HREF="#required">Required software</A></LI>

<LI>
<A HREF="#architecture">Architecture</A></LI>

<LI>
<A HREF="#core">Core</A></LI>

<UL>
<LI>
<A HREF="#userinterface">User interface</A></LI>

<UL>
<LI>
<A HREF="#draganddrop">drag and drop</A></LI>

<UL>
<LI>
<A HREF="#dropsites">drop sites</A></LI>

<LI>
<A HREF="#dragsites">drag sites</A></LI>
</UL>
</UL>

<LI>
<A HREF="#commandline">Command line</A></LI>
</UL>

<LI>
<A HREF="#modules">Modules</A></LI>

<UL>
<LI>
<A HREF="#source">source</A></LI>

<UL>
<LI>
<A HREF="#namespace">namespace</A></LI>

<LI>
<A HREF="#configuration">configuration</A></LI>

<LI>
<A HREF="#variabledata">variable data</A></LI>
</UL>

<LI>
<A HREF="#installation">installation</A></LI>
</UL>

<LI>
<A HREF="#future">Future developments</A></LI>

<LI>
<A HREF="#misc">Miscellaneous information</A></LI>
</UL>
</BODY>
</HTML>
}
set htmlHelpData {
<BODY>
<HTML>
<H3>
<A NAME="about"></A>About this document</H3>
This document contains general information, reference information and examples
designed to help the user understand the moodss application and the programmer
write modules for it.
<H3>
<A NAME="introduction"></A>Introduction</H3>
Quite often, one needs to monitor changing data, whether it might come
from a system, such as the different processes running on a Unix server,
or from a network, such as the kind and volume of traffic that runs through
it.

<P>Most often, such data can be organized in a table with rows of information,
each column representing a different type of data. For example, in the
case of processes running on a system, rows might be sorted according to
their unique process identifier, and columns might represent such values
as CPU usage, memory usage, owner's name, time of creation, ...

<P>The software used to view this type of information comes in different
forms and shapes. Unix users might be familiar with the "top" application
which presents rows of process data as lines of text, whereas RMON (Remote
MONitoring) SNMP software usually uses multiple windows with graphical
displays, curves, pie charts, multiple configuration dialog boxes, even
3D visualization modules to present network traffic, connection matrices,
...

<P>In most cases, data comes from one or several tables. A common interface,
graphical with menus, drag'n'drop capability, table widgets and graphical
data viewers such as multiple line graphs, bar and pie charts, could be
used. The user could then sort table rows, select one or more cells, rows,
columns, to launch viewers such as other tables, charts, ... best suited
to the way data should be presented. In effect, what is needed is a spreadsheet
that is capable of dealing with dynamically changing data.

<P>Moodss (Modular Object Oriented Dynamic SpreadSheet) is an attempt at
answering these needs. It is composed of a main part (the core) and an
unlimited number of modules, each module interfacing to a specific type
of data. The core is written in the great Tcl language (<A HREF="http://sunscript.sun.com/">http://sunscript.sun.com/</A>
or <A HREF="http://www.scriptics.com/">http://www.scriptics.com/</A> )
using object oriented techniques thanks to the stooop and scwoop packages
(<A HREF="http://www.mygale.org/~jfontain/">http://www.mygale.org/~jfontain/</A>).
The module function is to describe the type of data that it is also in
charge of retrieving and formatting when asked by the core. Modules can
be written in plain Tcl and optionally use dynamically linked libraries
written in the C language (modules are packages in the Tcl sense).

<P>Modules are loaded when moodss is started. One or more modules can be
handled concurrently (new feature of version 3.0). Module names are specified
in the command line and cannot be unloaded.

<P>As features are added to moodss, different ways of viewing data will
be made available while the modules will stay the same. The goal of moodss
is to become a nice feature packed generic way of viewing data. Moodss
can be used to monitor any type of data, since the simplest cases can fit
in a table with a single row.

<P>As moodss is written in Tcl and uses well supported extensions (Tktable
and BLT), it will run on most Tcl/Tk supported platforms: UNIX and Windows
(I do not know if Tktable and BLT are available for the MacIntosh). Some
modules may be specific to a platform, but the core is guaranteed to run
on them all.

<P>After reading and understanding this document, you should be able to
write your own modules in order to monitor the data that you are interested
in.

<P>Moodss is free software. You can redistribute it and/or modify it under
the terms of a BSD type license: please see the COPYRIGHT file or use the
main window About help menu for more information.
<H3>
<A NAME="required"></A>Required software</H3>
For the current version (3.0), the following packages must be installed
before attempting to install moodss (make sure to check the INSTALL file
for the latest information):
<UL>
<LI>
Tcl/Tk version 8.0 or above (at <A HREF="http://sunscript.sun.com/">http://sunscript.sun.com/</A>)</LI>

<LI>
tkTable version 1.8 or above (at <A HREF="http://www.cs.uoregon.edu/research/tcl/">http://www.cs.uoregon.edu/research/tcl/</A>)<B>*</B></LI>

<LI>
the BLT library for Tcl/Tk 8.0 (<A HREF="ftp://ftp.neosoft.com/pub/tcl/sorted/devel/blt8.0p2-unoff">ftp://ftp.neosoft.com/pub/tcl/sorted/devel/blt8.0p2-unoff.tgz</A>)<B>*</B></LI>
</UL>

<DIV ALIGN=right><B>*</B><I> many thanks to the authors for these great
packages</I></DIV>
&nbsp;
<BR>The stooop library and required scwoop and pie widgets are included
in the self-contained <I>moodss</I> file. Therefore, it is not required
to install the stooop, scwoop and tkpiechart packages, unless you want
to work on the moodss source code itself. However, should you want to get
more information on those extensions, you could find the latest versions
at:
<UL>
<LI>
stooop version 3.5.1 or above (at <A HREF="http://www.mygale.org/~jfontain/">http://www.mygale.org/~jfontain/</A>)</LI>

<LI>
scwoop version 2.2 or above (at <A HREF="http://www.mygale.org/~jfontain/">http://www.mygale.org/~jfontain/</A>)</LI>

<LI>
tkpiechart version 4.2 or above (at <A HREF="http://www.mygale.org/~jfontain/">http://www.mygale.org/~jfontain/</A>)</LI>
</UL>

<H3>
<A NAME="architecture"></A>Architecture</H3>
The moodss application is composed of the core software and one or several
modules. Modules are implemented as Tcl packages and thus usually comprise
a Tcl source file and a pkgIndex.tcl file required by the Tcl package implementation.

<P>The core will load one or more modules, whose names were passed as command
line parameters and will start displaying module data in one or more tables.
The tables are then updated at the frequency defined by the poll time,
which the user may change. For example, to launch moodss with the random
module, just type:
<PRE>$ wish moodss random</PRE>
All the module code and data are kept in a separate namespace. The module
data is stored is a single array including some configuration data used
when the module is loaded by the core, and variable data (displayed in
the application table and eventual graphical viewers) which the module
must update when requested by the core.

<P>The initial data tables represent the first data views, from which cells
can be selected and when dropped through a drag'n'drop operation into a
graph, bar chart or pie chart iconic site, result in the creation of graphical
data viewers. In turn, these viewers can display more table cells, which
when dropped into the graphical viewer, result in the creation of corresponding
data graph lines, bars, or slices.

<P>Any draggable data can be dropped in valid drop sites at any time. It
is thus possible to drag several data cells from any viewer into other
ones, the trash, ... even if the data comes from different modules.

<P>All data viewers can be moved and resized at will through a simple internal
window manager.
<H3>
<A NAME="core"></A>Core</H3>

<H4>
<A NAME="userinterface"></A>User interface</H4>
Soon after the application launch, tabular data is displayed in one or
more tkTable widgets with automatic scroll bars, between the menu bar,
the drop sites with graphical viewers and trash icons and a message area,
as one can see below:
<BR>&nbsp;
<CENTER><IMG SRC="moodss1.jpg" ALT="moodss initial main window view" HEIGHT=506 WIDTH=620></CENTER>


<P>The message area is used to display status information, such as when
the data is being updated, and help information, as the user moves the
mouse pointer over sensitive areas, such as table column headers. Further
help is provided through widget tips (also known as balloons) when appropriate,
and of course the Help menu.

<P>The window title shows the name of the current module along with the
poll time.

<P>The <I>File</I> menu only contains the <I>Exit</I> menu entry, used
to gracefully quit the moodss application.

<P>The <I>Options</I> menu contains the <I>Poll time</I> entry which when
selected launches the corresponding dialog box, as shown below:
<BR>&nbsp;
<CENTER><IMG SRC="moodss2.jpg" ALT="poll time dialog box" HEIGHT=225 WIDTH=228></CENTER>


<P>The user can select a new poll time among the module choices from a
spin entry widget, or directly type in a new value, as long as it is not
smaller than the module minimum poll time, in which case a message dialog
box warns the user.

<P>Table data can be sorted at any time by simply clicking on a column
title. Clicking on the same column title again sorts the data in opposite
order, thus toggling between increasing and decreasing orders.
<BR>When sorting, the selected column is used as a reference, meaning that
all rows will be rearranged so that the selected column appears sorted,
with values either increasing or decreasing.
<BR>The reference column for sorting always appear in a darker shade of
gray.

<P>Aside from the main tables, graphical viewers can be created for viewing
table cell data behavior over time. Viewers can also be deleted, data views
(such as pie slices, curves, ...) can be added or removed from existing
viewers, ... These functions are all implemented using the drag and drop
functionality described below.

<P>Graphical viewers available at this time are BLT graph viewers (such
as can be seen below), side-by-side bars charts, stacked bars charts, 2D
pie charts and 3D pie charts*.

<P>*<I>note: if you know of any other nice viewers (like 3D graphs) that
work with Tcl, please let me know so I can integrate them. Many thanks
in advance...</I>
<CENTER>
<H5>
<IMG SRC="moodss3.jpg" ALT="moodss window with graph data viewers" HEIGHT=656 WIDTH=682></H5></CENTER>
All data viewers can be moved and resized thanks to handling areas in the
data viewer borders. When moving the mouse pointer over these areas, the
mouse cursor changes to indicate the available action. Corner handles allow
resizing in both x and y axis. Handles in the middle of the sides allow
resizing in either the x or y axis direction. All other areas can be used
for moving the data viewer. Clicking on any part of the border changes
the stacking order: the viewer being clicked on either goes below (eventually
becomes hidden) the other viewers, or becomes fully visible (on top, eventually
hiding other viewers). Further description of this small window manager
functionality is useless, as it behaves like a standard window manager
(let me know if it does not).

<P>The <I>Help</I> menu contains <I>Global</I> help (actually launches
an embedded HTML viewer with this very document), <I>Modules</I> help,
and <I>About</I> general information entries.
<H5>
<A NAME="draganddrop"></A>Drag and drop</H5>
Drag and drop in moodss tries to behave as the familiar Windows functionality
(no, it doesn't mean I am a Bill Gates fan :). For example, to create a
cell graphical plot, one must place the mouse pointer over a data cell
in the main table, hold down the first mouse button (the left one for a
right handed user) while dragging over to the left-most icon below the
menu bar (when dragging an object, as the mouse pointer passes over possible
drop sites, they are highlighted with a thin black surrounding border for
user feedback). Releasing the mouse button at this time results in the
creation of a BLT graph viewer.

<P>Only valid drop sites for the data being dragged are highlighted when
the mouse cursor passes over them, thus guaranteeing error free operations.

<P>In summary, data cells can be dragged from any data table or any viewer
into any viewer icon, any viewer or the trash can.
<H6>
<A NAME="dropsites"></A>Drop sites</H6>
All icons right below the menu bar are valid drop sites for data cells
(several may be dropped at the same time). From left to right:
<UL>
<LI>
graph viewer with one or more data curves created at once</LI>

<LI>
side by side bar chart with one or more data bars created at once</LI>

<LI>
stacked bar chart with one or more data bars created at once</LI>

<LI>
2D pie chart with one or more data slices created at once</LI>

<LI>
3D pie chart with one or more data slices created at once</LI>

<LI>
object trash with one or more data viewers deleted at once</LI>
</UL>
For example, a graph viewer with 1 curve is created by dropping a data
cell into the graph viewer icon.

<P>Once a viewer exists, it also acts as a drop site for data cells, which
may be dragged from any data table or other viewers. Dropping one or more
cells directly in the viewer results in corresponding lines, bars or slices
being created and automatically updated. Each new graphical element is
assigned a new and different color.

<P>You may delete one or more graphical viewer elements (graph lines, bar
chart bars or pie charts slices) from a graphical viewer by selecting them
(using the first mouse button) through their labels. Several elements can
be selected by depressing the control key as the first mouse button is
pressed. The selection can also be extended by depressing the shift key
along with the first mouse button. The pie slices can also be directly
selected by clicking on the slices themselves.
<BR>Then dragging from the viewer to the trash drop site (the bullet hole)
on the upper right side of the main window and releasing the first mouse
button result in the corresponding viewer elements to be destroyed. If
there are no remaining lines, the graphical viewer itself (graph, bar chart
or pie) is destroyed.
<H6>
<A NAME="dragsites"></A>Drag sites</H6>
A data table is obviously a drag site. At the moment, only one cell can
be dragged at once.

<P>Any graphical viewer is also a drag site. It requires selecting one
or more graphical viewer elements before initiating the drag operation
from any point in the viewer. If there are no selected elements, dragging
is impossible: the mouse cursor is not changed into the drag circular cursor.
<H4>
<A NAME="commandline"></A>Command line</H4>
Launching moodss is very simple: just pass one or more data module names
as parameters, as in:
<PRE>$ wish moodss random</PRE>
or, for 2 modules at once:
<PRE>$ wish moodss ps cpustats</PRE>
You may eventually specify a poll time in seconds using:
<PRE>$ wish moodss -update 25 random</PRE>

<H3>
<A NAME="modules"></A>Modules</H3>
All examples are drawn from the <I>random</I> sample module.
<H4>
<A NAME="source"></A>source</H4>
Since a module is a package, it must have a name in the Tcl sense. For
example, at the beginning of the <I>random.tcl</I> file, one can find the
following statement:
<PRE>package provide random 1.1</PRE>
This line simply states that this is the <I>1.1</I> version of the <I>random</I>
package. Please note that the package name must also be used as the module
namespace name (see below).
<H5>
<A NAME="namespace"></A>namespace</H5>
All module procedures and data are kept in a specific namespace bearing
the module name. For example (from the <I>random.tcl</I> source file):
<PRE>namespace eval random {
&nbsp;&nbsp;&nbsp; array set data {
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ...
&nbsp;&nbsp;&nbsp; }
&nbsp;&nbsp;&nbsp; proc update {} {
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ...
&nbsp;&nbsp;&nbsp; }
}</PRE>

<H5>
<A NAME="configuration"></A>configuration</H5>
The module configuration defines the data table column headers, help information,
... This data never changes during the lifetime of the application.

<P>All the module configuration data is stored as array members of the
array named <I>data</I> within the module namespace. For example:
<PRE>namespace eval random {
&nbsp;&nbsp;&nbsp; array set data {
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; updates 0
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 0,label name 0,type ascii 0,message {user name}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 1,label cpu 1,type real 1,message {cpu usage in percent}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2,label disk 2,type integer 2,message {disk usage in megabytes}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 3,label command 3,type dictionary 3,message {most time consuming command}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; pollTimes {10 5 20 30 60 120 300}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; columns 4
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; sort {1 decreasing}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; indexColumns {0 3}
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; helpText {
This is a simple demonstration module ...
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; }
&nbsp;&nbsp;&nbsp; }
&nbsp;&nbsp;&nbsp; ...
}</PRE>
The <I>updates</I> member is a counter used to keep track of the number
of times that the module data was updated, and is also used by the core
to detect when module data display should be updated (see <A HREF="#variabledata">variable
data</A> for more information).

<P>The <I>columns</I> member defines the number of columns in the table
to be displayed by the core.

<P>The <I>n,label</I> members define the text to be displayed as column
titles. There must be as many <I>n,label</I> members as they are columns.
<BR>The <I>n,type</I> members define the type of the corresponding column
data. Valid types are simply those that the Tcl <I>lsort</I> command can
handle: <I>ascii</I>, <I>dictionary</I>, <I>integer</I> and <I>real</I>.
There must be as many <I>n,type</I> members as they are columns.
<BR>The <I>n,message</I> members define the text of the help message to
be displayed in the message area (see <A HREF="#architecture">User Interface</A>)
as the user moves the mouse pointer over column titles. It should be composed
of only a few words, just enough to actually help the user understand what
the column data means. There must be as many <I>n,message</I> members as
they are columns.
<BR>Note that column numbers start at 0.

<P>The <I>pollTimes</I> member is a list of valid poll times (in seconds)
for the module. The list need not be ordered, as its first element represents
the default poll time value to be used when the moodss application starts.
This value may be overridden by a command line argument. The smallest value
in the list is used by the core as the lowest possible poll time and checked
against when the user enters a new value through the poll time dialog box.
The list must not be empty.
<BR>Note that the list is also used by moodss as a set of possible choices
in the dialog box used to set the new poll time. The user may still directly
input any value as long as it is greater than or equal to the minimum value.

<P>The <I>sort</I> list defines the index of the column which should be
initially used as a reference for sorting the data table rows, and in which
order (<I>increasing</I> or <I>decreasing</I>) the rows should be sorted.
The column index for sorting works like the <I>-index</I> Tcl <I>lsort</I>
command option, that is rows are sorted so that that specific column appears
sorted in the specified order.

<P>The <I>indexColumns</I> list specifies the columns required to uniquely
identify a row in the table. In database talk, it represents the table
key. To maintain backward compatibility, it is optional and defaults to
0, the leftmost column. The index columns are used when creating data viewer
elements: their label is built by concatenating the key value for the cell
row with the cell column title. The key value is the concatenation of the
index column values for the cell.

<P>The <I>helpText</I> member specifies a text of any length, to be displayed
when the user requests help information on the current module from within
the help menu.
<H5>
<A NAME="variabledata"></A>variable data</H5>
The tabular data (variable data) that the module code must update is stored
in the same <I>data</I> array as the module configuration data.

<P>The core invokes the module <I>update</I> procedure (which obviously
must exist) when it is time to refresh the data display (tables and eventually
graphical viewers). At this time, the update procedure may update the tabular
data straight away (synchronous operation) or launch a request for later
data update (asynchronous operation).

<P>It actually does not matter when the data is updated. The core will
know that fresh data is available when the <I>updates</I> array member
is set (actually incremented as it also serves as a counter for the number
of updates so far).
<BR>It is the module programmer's responsibility to increment this counter
right after all tabular data has been updated.

<P>For example, retrieving information for the processes running on a machine
is a local operation that can be achieved in a reasonably small amount
of time. In such a case, data would be updated immediately and the <I>updates</I>
variable incremented at the same time.
<BR>But if the data has to be retrieved from across a network, waiting
for it to come back would cause a delay that the user would certainly notice,
as the application would not respond to mouse or keyboard input during
the whole time that it would take to fetch the whole data. In such cases,
it is easier to let the update procedure return immediately without setting
the <I>updates</I> variable, which would be incremented at a later time,
only when the data would become available. For example, when waiting for
data to come across a network connection, the Tcl <I>fileevent</I> command
could be used on a non blocking channel, where the script to be evaluated
when the channel becomes readable would increment the <I>updates</I> array
member.
<BR>Thus, data update can occur synchronously or asynchronously.

<P>For example:
<PRE>namespace eval random {
&nbsp;&nbsp;&nbsp; ...
&nbsp;&nbsp;&nbsp; proc update {} {
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; variable data
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; array set data "
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 0,0 john&nbsp;&nbsp;&nbsp; 0,1 1234 0,2 4567 0,3 cc
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 1,0 william 1,1 8901 1,2 2345 1,3 xedit
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2,0 anny&nbsp;&nbsp;&nbsp; 2,1 6789 2,2 0123 2,3 ps
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 4,0 peter&nbsp;&nbsp; 4,1 4567 4,2 8901 4,3 ls
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 6,0 laura&nbsp;&nbsp; 6,1 2345 6,2 6789 6,3 emacs
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 3,0 robert&nbsp; 3,1 1234 3,2 5678 3,3 top
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; "
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; incr data(updates)
&nbsp;&nbsp;&nbsp; }
}</PRE>
The tabular data array index is the <I>row</I> number followed by the <I>column</I>
number separated by a <I>comma</I>. The column number must start from 0
up to the total number of columns minus 1 (no holes are allowed in the
column sequence).
<BR>The row number can take any integer value and be defined in any order,
as long as it is unique during the lifetime of the module data. If a new
row is created, it must take a value that was never used: the index of
a row that has disappeared cannot be reused. Row numbers need not be consecutive.

<P>When all rows (or only those table cells that have changed) have been
updated, the <I>updates</I> member array must be incremented so that the
core knows that it can update the table data display.
<H4>
<A NAME="installation"></A>installation</H4>
A module is a package in the Tcl sense. When writing a module, you must
then provide a <I>pkgIndex.tcl</I> file along with the module code file.
The <I>pkgIndex.tcl</I> file is very simple, as the following example shows:
<PRE>package ifneeded random 1.0 "source [file join $dir random.tcl]"</PRE>
The line above says that if the <I>random</I> package is needed, the Tcl
core should source the <I>random.tcl</I> module source code from the directory
where it was installed. <I>1.0</I> is the version number for the package.

<P>Modules can be installed at any valid place that the Tcl core allows
(look at the <I>pkg_mkIndex</I> manual page for more information).

<P>When you unpack moodss, you will find the sample modules in sub-directories.
The current directory (.) is appended to the <I>auto_load</I> global list
variable so that sample modules can be found when moodss is run from the
unpacking directory.

<P>For example, if you unpacked moodss in <I>/home/joe/moodss-3.0/</I>,
you will find the random module package in <I>/home/joe/moodss-3.0/random/</I>
so that the following will work:
<PRE>$ cd /home/joe/moodss-3.0/
$ wish moodss random</PRE>
You can install your new modules in the default location: <I>/usr/local/lib/</I>
on Unix. For example, if you move the files in <I>/home/joe/moodss-3.0/random/</I>
to <I>/usr/local/lib/random/</I>, moodss (actually Tcl :) will still be
able to find the <I>random</I> module (again, look at the <I>pkg_mkIndex</I>
manual page for more information).

<P>Please take a look at the INSTALL file for the latest information on
how to install the moodss application itself.
<H3>
<A NAME="future"></A>Future developments</H3>
The following features will eventually be added to the core:
<UL>
<LI>
resizable pies</LI>

<LI>
more Linux modules</LI>

<LI>
more data viewers: summary tables, ...</LI>

<LI>
table multiple cell selection (as well as rows, columns)</LI>

<LI>
writable table cells?</LI>
</UL>
I welcome any suggestion for new features that you may need in your specific
use of moodss.
<H3>
<A NAME="misc"></A>Miscellaneous information</H3>
For downloading Tcl software (such as stooop, scwoop, ...), visit my <A HREF="http://www.mygale.org/~jfontain/">web
page</A>.

<P>Send your comments, complaints, ... to <A HREF="mailto:jfontain@mygale.org">Jean-Luc
Fontaine</A>.
</BODY>
</HTML>
}
