# copyright (C) 1997-98 Jean-Luc Fontaine (mailto:jfontain@mygale.org)
# this program is free software: please refer to the BSD type license enclosed in this package

set rcsId {$Id: random.tcl,v 1.11 1998/04/19 18:16:31 jfontain Exp $}

# module sample file with random data

# corresponding pkgIndex.tcl file content:
# package ifneeded random 1.0 "source [file join $dir random.tcl]"

package provide random 1.1

namespace eval random {                                                                    ;# namespace name must match package name
    # Module data is arranged in a single array that can be used by many views, such as tables, graphs, pies,...
    # It contains configuration values as well as dynamic data (see update procedure).

    # Number of updates counter which may also serve as a variable to be traced on write to detect updates
    # Label is the title displayed on the top cell of the data column.
    # Valid types are those that the lsort command can handle.
    # Message is a short help string that appears in the message area at the bottom of the data window when the mouse cursor passes
    # over the column title cell.
    # Poll times in seconds are placed in a list with the default poll time in first position. The other times can be in any order,
    # as the core will sort them and use the lowest value as the minimum poll time value.
    # The minimum poll seconds must be a reasonable value depending on the processing time of the moduleData procedure.
    # The columns array member is the total number of data columns to be displayed.
    # The sort list defines the initial column to be used for sorting the table data and in which direction
    # The indexColumns list speficies the columns required to uniquely identify a row in the table (optional, default: 0)
    # The help text will be displayed when the module help is launched from the main window help menu

    array set data {
        updates 0
        0,label name 0,type ascii 0,message {user name}
        1,label cpu 1,type real 1,message {cpu usage in percent}
        2,label disk 2,type integer 2,message {disk usage in megabytes}
        3,label command 3,type dictionary 3,message {command name}
        pollTimes {10 5 20 30 60 120 300}
        columns 4
        sort {1 decreasing}
        indexColumns {0 3}
        helpText {
This is a simple demonstration module for the moodss (Modular Object Oriented Dynamic SpreadSheet) utility. Most of the data is randomly generated.
        }
    }

    # the dynamic data array index is the row number followed by the column number separated by a comma
    # the column number must start from 0 up to the total number of columns minus 1 (no holes are allowed in the column sequence)
    # the row number can take any integer value and be defined in any order, as long as it is unique during the lifetime of the
    # module data. if a new row is created, it must take a value that was never used: thus, the number of a row that has disappeared
    # is not allowed. Row numbers need not be consecutive.

    proc update {} {                                                                      ;# mandatory procedure: update module data
        variable data

        array set data "
            0,0 john 0,1 [format %.1f [expr {rand()*30}]] 0,2 [expr {100+int(rand()*50)}] 0,3 cc
            1,0 william 1,1 [format %.1f [expr {rand()*3}]] 1,2 [expr {300+int(rand()*100)}] 1,3 xedit
            2,0 anny 2,1 [format %.1f [expr {rand()*5}]] 2,2 [expr {200+int(rand()*30)}] 2,3 ps
            4,0 peter 4,1 [format %.1f [expr {rand()*8}]] 4,2 [expr {50+int(rand()*10)}] 4,3 ls
            6,0 laura 6,1 [format %.1f [expr {rand()*20}]] 6,2 [expr {90+int(rand()*20)}] 6,3 emacs
            3,0 robert 3,1 [format %.1f [expr {rand()*10}]] 3,2 [expr {500+int(rand()*150)}] 3,3 top
            9,0 laura 9,1 [format %.1f [expr {rand()*30}]] 9,2 [expr {100+int(rand()*50)}] 9,3 cc
        "
        incr data(updates)                         ;# write variable so that update can be detected with an eventual tcl write trace
#       after 3000 [namespace code {incr data(updates)}]                                          ;# simulate asynchronous operation
    }
}
