set rcsId {$Id: scroll.tcl,v 1.2 1997/07/13 12:44:15 jfontain Exp $}

# generic scroll widget with automatic scrollbars for scrolling widgets with the common tk scroll interface

class scroll {}

proc scroll::scroll {this scrollableClass parentPath args} composite {[new frame $parentPath] $args} {
    # scrollable class widget must accept the -[xy]scrollcommand options and [xy]view commands, such as canvas, text, table, ...
    set path $widget::($this,path)
    composite::manage $this [new $scrollableClass $path] scrolled\
        [new scrollbar $path -orient horizontal] horizontal [new scrollbar $path] vertical

    widget::configure $composite::($this,scrolled)\
        -xscrollcommand "scroll::horizontalScroll $this" -yscrollcommand "scroll::verticalScroll $this"
    widget::configure $composite::($this,horizontal) -command "$composite::($this,scrolled,path) xview"
    widget::configure $composite::($this,vertical) -command "$composite::($this,scrolled,path) yview"

    grid $composite::($this,scrolled,path) -sticky nsew
    grid rowconfigure $path 0 -weight 1
    grid columnconfigure $path 0 -weight 1

    composite::complete $this
}

proc scroll::~scroll {this} {}

proc scroll::options {this} {
    return [list\
        [list -automatic automatic Automatic 1 1]\
    ]
}

proc scroll::set-automatic {this value} {                      ;# update both dimensions so scrollbars get updated according to mode
    eval horizontalScroll $this [$composite::($this,scrolled,path) xview]
    eval verticalScroll $this [$composite::($this,scrolled,path) yview]
}

proc scroll::update {path column row first last} {                                ;# eventually make scrollbar visible and update it
    if {[llength [grid info $path]]==0} {                                                                   ;# scrollbar not visible
        grid $path -column $column -row $row -sticky nsew                                                               ;# so map it
    }
    $path set $first $last
}

proc scroll::horizontalScroll {this first last} {
    if {!$composite::($this,-automatic)||(($last-$first)<1)} {
        # in automatic mode, scrollbar is required when only part of scrolled widget is visible
        update $composite::($this,horizontal,path) 0 1 $first $last
    } else {                                         ;# in automatic mode, no need for a scrollbar since whole dimension can be seen
        grid forget $composite::($this,horizontal,path)
    }
}

proc scroll::verticalScroll {this first last} {
    if {!$composite::($this,-automatic)||(($last-$first)<1)} {
        update $composite::($this,vertical,path) 1 0 $first $last
    } elseif {$composite::($this,-automatic)} {
        grid forget $composite::($this,vertical,path)
    }
}
