/*
 * fapolicyd-backend.h - Header file for database backend interface
 * Copyright (c) 2020-23 Red Hat Inc.
 * All Rights Reserved.
 *
 * This software may be freely redistributed and/or modified under the
 * terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
 * Boston, MA 02110-1335, USA.
 *
 * Authors:
 *   Radovan Sroka <rsroka@redhat.com>
 */

#ifndef FAPOLICYD_BACKEND_HEADER
#define FAPOLICYD_BACKEND_HEADER

#include "conf.h"
#include "file.h"

// If this gets extended, please put the new items at the end.
typedef enum { SRC_UNKNOWN, SRC_RPM, SRC_FILE_DB, SRC_DEB } trust_src_t;

// source, size, sha
// Do not pad the hash value so SHA1 and SHA256 digests parse correctly
// The reason for in and out is they mean different things for printf
// and scanf. For scanf, it limits the buffer. For printf, its the minimum
// bytes to write.  helper: stringify macro value
#define STR_IMPL(x) #x
#define STR(x) STR_IMPL(x)
#define DATA_FORMAT "%u %zu %s"
#define DATA_FORMAT_IN "%u %zu %" STR(FILE_DIGEST_STRING_WIDTH) "s"

typedef struct _backend
{
	const char * name;
	int (*init)(void);
	int (*load)(const conf_t *);
	int (*close)(void);
	int memfd;
	long entries;
} backend;

#endif
