import { IJacobian2, IVec2 } from "../point/interface";
import { Jacobian2 } from "../point/jacobian";
import { Shape, ShapeTransform } from "./interface";
export declare class LinearTransform implements ShapeTransform {
    readonly xx: number;
    readonly yx: number;
    readonly xy: number;
    readonly yy: number;
    readonly tx: number;
    readonly ty: number;
    readonly j: Jacobian2;
    constructor(xx: number, xy: number, yx: number, yy: number, x: number, y: number);
    eval(t: IVec2): IVec2;
    derivative(_t: IVec2): IJacobian2;
    inverse(): LinearTransform;
    static neutral: LinearTransform;
}
export declare class CompositeTransform implements ShapeTransform {
    private b;
    private a;
    private constructor();
    eval(z: IVec2): IVec2;
    derivative(z: IVec2): IJacobian2;
    static from(a: ShapeTransform, b: ShapeTransform): ShapeTransform;
}
export declare function transformShape(sh: Shape, tfm: ShapeTransform): Shape;
