commit c7c51ea1940ccb558ac52b08d294f33d17088842
Author: Samuel Thibault <samuel.thibault@ens-lyon.org>
Date:   Tue Dec 1 00:33:43 2020 +0100

    x86: Keep fp_regs.h standalone
    
    We cannot include stdint.h in fp_regs.h since this is included by
    mach_types.h for bootstrapping, before we have stdint.h from glibc.
    
    * i386/include/mach/i386/fp_reg.h: Do not include <stdint.h>
    (XSAVE_XCOMP_BV_COMPACT, struct i386_xfp_xstate_header): Use unsigned
    long long instead of uint64_t.

commit 55797acc7748c15cd25891f1b84b1123aee50b3d
Author: Samuel Thibault <samuel.thibault@ens-lyon.org>
Date:   Tue Dec 1 01:08:00 2020 +0100

    x86: Move fp_reg.h static assertions to .c file
    
    Since fp_reg.h is installed on the system, and compilers may not even
    support _Static_assert.
    
    * i386/include/mach/i386/fp_reg.h: Move _Static_assert to...
    * i386/i386/fpu.c: ... c file.

---
 i386/i386/fpu.c                 |    3 +++
 i386/include/mach/i386/fp_reg.h |   12 ++++--------
 2 files changed, 7 insertions(+), 8 deletions(-)

--- a/i386/include/mach/i386/fp_reg.h
+++ b/i386/include/mach/i386/fp_reg.h
@@ -27,8 +27,6 @@
 #ifndef	_MACH_I386_FP_REG_H_
 #define	_MACH_I386_FP_REG_H_
 
-#include <stdint.h>
-
 /*
  *	Floating point registers and status, as saved
  *	and restored by FP save/restore instructions.
@@ -53,13 +51,12 @@ struct i386_fp_regs {
 					/* space for 8 80-bit FP registers */
 };
 
-#define XSAVE_XCOMP_BV_COMPACT (((uint64_t)1) << 63)
+#define XSAVE_XCOMP_BV_COMPACT (((unsigned long long)1) << 63)
 struct i386_xfp_xstate_header {
-	uint64_t	xfp_features;
-	uint64_t	xcomp_bv;
-	uint64_t	reserved[6];
+	unsigned long long	xfp_features;
+	unsigned long long	xcomp_bv;
+	unsigned long long	reserved[6];
 } __attribute__((packed, aligned(64)));
-_Static_assert(sizeof(struct i386_xfp_xstate_header) == 8*8);
 
 struct i386_xfp_save {
 	unsigned short	fp_control;	/* control */
@@ -82,7 +79,6 @@ struct i386_xfp_save {
 	struct i386_xfp_xstate_header header;
 	unsigned char	extended[0];	/* Extended region */
 } __attribute__((packed, aligned(64)));
-_Static_assert(sizeof(struct i386_xfp_save) == 512 + 8*8);
 
 /*
  * Control register
--- a/i386/i386/fpu.c
+++ b/i386/i386/fpu.c
@@ -69,6 +69,9 @@
 #define ASSERT_IPL(L)
 #endif
 
+_Static_assert(sizeof(struct i386_xfp_xstate_header) == 8*8);
+_Static_assert(sizeof(struct i386_xfp_save) == 512 + 8*8);
+
 int			fp_kind = FP_387;	/* 80387 present */
 enum fp_save_kind	fp_save_kind = FP_FNSAVE;	/* Which instruction we use to save/restore FPU state */
 uint64_t		fp_xsave_support;	/* Bitmap of supported XSAVE save areas */
