// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package main

import (
	"fmt"
	"os"

	"code.forgejo.org/f3/gof3/v3/cmd"
	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/util"
)

func main() {
	run(os.Args)
}

func run(args []string) {
	ctx, cancel := cmd.InstallSignals()
	defer cancel()
	log := logger.NewLogger()
	ctx = logger.ContextSetLogger(ctx, log)

	app := cmd.NewApp()
	if err := app.Run(ctx, args); err != nil {
		fmt.Printf("Failed to run F3 with %s\n%v\n", os.Args, err)

		if panicErr, ok := err.(util.PanicError); log.GetLevel() < logger.Info && ok {
			fmt.Printf("Stack trace\n%s", panicErr.Stack())
		}
	}
}
