// Code generated by smithy-go-codegen DO NOT EDIT.

package amplifyuibuilder

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCreateComponent struct {
}

func (*awsRestjson1_serializeOpCreateComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.ComponentToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateComponentData(input.ComponentToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateComponentInput(v *CreateComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateForm struct {
}

func (*awsRestjson1_serializeOpCreateForm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateForm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFormInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/forms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFormInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.FormToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateFormData(input.FormToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFormInput(v *CreateFormInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTheme struct {
}

func (*awsRestjson1_serializeOpCreateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.ThemeToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateThemeData(input.ThemeToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeInput(v *CreateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteComponent struct {
}

func (*awsRestjson1_serializeOpDeleteComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(v *DeleteComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteForm struct {
}

func (*awsRestjson1_serializeOpDeleteForm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteForm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFormInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/forms/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFormInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFormInput(v *DeleteFormInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTheme struct {
}

func (*awsRestjson1_serializeOpDeleteTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(v *DeleteThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExchangeCodeForToken struct {
}

func (*awsRestjson1_serializeOpExchangeCodeForToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExchangeCodeForToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExchangeCodeForTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tokens/{provider}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExchangeCodeForTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.Request != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentExchangeCodeForTokenRequestBody(input.Request, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExchangeCodeForTokenInput(v *ExchangeCodeForTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.Provider) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provider must not be empty")}
	}
	if len(v.Provider) > 0 {
		if err := encoder.SetURI("provider").String(string(v.Provider)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportComponents struct {
}

func (*awsRestjson1_serializeOpExportComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportComponentsInput(v *ExportComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpExportForms struct {
}

func (*awsRestjson1_serializeOpExportForms) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportForms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportFormsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export/app/{appId}/environment/{environmentName}/forms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportFormsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportFormsInput(v *ExportFormsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpExportThemes struct {
}

func (*awsRestjson1_serializeOpExportThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportThemesInput(v *ExportThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetCodegenJob struct {
}

func (*awsRestjson1_serializeOpGetCodegenJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCodegenJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCodegenJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/codegen-jobs/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCodegenJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCodegenJobInput(v *GetCodegenJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetComponent struct {
}

func (*awsRestjson1_serializeOpGetComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetComponentInput(v *GetComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetForm struct {
}

func (*awsRestjson1_serializeOpGetForm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetForm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFormInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/forms/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFormInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFormInput(v *GetFormInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMetadata struct {
}

func (*awsRestjson1_serializeOpGetMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMetadataInput(v *GetMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTheme struct {
}

func (*awsRestjson1_serializeOpGetTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetThemeInput(v *GetThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListCodegenJobs struct {
}

func (*awsRestjson1_serializeOpListCodegenJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCodegenJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCodegenJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/codegen-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCodegenJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCodegenJobsInput(v *ListCodegenJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListComponents struct {
}

func (*awsRestjson1_serializeOpListComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListComponentsInput(v *ListComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListForms struct {
}

func (*awsRestjson1_serializeOpListForms) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListForms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFormsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/forms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFormsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFormsInput(v *ListFormsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListThemes struct {
}

func (*awsRestjson1_serializeOpListThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemesInput(v *ListThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutMetadataFlag struct {
}

func (*awsRestjson1_serializeOpPutMetadataFlag) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutMetadataFlag) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMetadataFlagInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/metadata/features/{featureName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutMetadataFlagInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.Body != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentPutMetadataFlagBody(input.Body, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutMetadataFlagInput(v *PutMetadataFlagInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.FeatureName == nil || len(*v.FeatureName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member featureName must not be empty")}
	}
	if v.FeatureName != nil {
		if err := encoder.SetURI("featureName").String(*v.FeatureName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRefreshToken struct {
}

func (*awsRestjson1_serializeOpRefreshToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRefreshToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RefreshTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tokens/{provider}/refresh")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRefreshTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.RefreshTokenBody != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentRefreshTokenRequestBody(input.RefreshTokenBody, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRefreshTokenInput(v *RefreshTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.Provider) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provider must not be empty")}
	}
	if len(v.Provider) > 0 {
		if err := encoder.SetURI("provider").String(string(v.Provider)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartCodegenJob struct {
}

func (*awsRestjson1_serializeOpStartCodegenJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartCodegenJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCodegenJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/codegen-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartCodegenJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.CodegenJobToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentStartCodegenJobData(input.CodegenJobToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartCodegenJobInput(v *StartCodegenJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateComponent struct {
}

func (*awsRestjson1_serializeOpUpdateComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.UpdatedComponent != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateComponentData(input.UpdatedComponent, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateComponentInput(v *UpdateComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateForm struct {
}

func (*awsRestjson1_serializeOpUpdateForm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateForm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFormInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/forms/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFormInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.UpdatedForm != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateFormData(input.UpdatedForm, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFormInput(v *UpdateFormInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTheme struct {
}

func (*awsRestjson1_serializeOpUpdateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.UpdatedTheme != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateThemeData(input.UpdatedTheme, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(v *UpdateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionParameters(v *types.ActionParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Anchor != nil {
		ok := object.Key("anchor")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Anchor, ok); err != nil {
			return err
		}
	}

	if v.Fields != nil {
		ok := object.Key("fields")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Fields, ok); err != nil {
			return err
		}
	}

	if v.Global != nil {
		ok := object.Key("global")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Global, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Id, ok); err != nil {
			return err
		}
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.State != nil {
		ok := object.Key("state")
		if err := awsRestjson1_serializeDocumentMutationActionSetStateParameter(v.State, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Target, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Type, ok); err != nil {
			return err
		}
	}

	if v.Url != nil {
		ok := object.Key("url")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Url, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentApiConfiguration(v types.ApiConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ApiConfigurationMemberDataStoreConfig:
		av := object.Key("dataStoreConfig")
		if err := awsRestjson1_serializeDocumentDataStoreRenderConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ApiConfigurationMemberGraphQLConfig:
		av := object.Key("graphQLConfig")
		if err := awsRestjson1_serializeDocumentGraphQLRenderConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.ApiConfigurationMemberNoApiConfig:
		av := object.Key("noApiConfig")
		if err := awsRestjson1_serializeDocumentNoApiRenderConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAssociatedFieldsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenFeatureFlags(v *types.CodegenFeatureFlags, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsNonModelSupported != nil {
		ok := object.Key("isNonModelSupported")
		ok.Boolean(*v.IsNonModelSupported)
	}

	if v.IsRelationshipSupported != nil {
		ok := object.Key("isRelationshipSupported")
		ok.Boolean(*v.IsRelationshipSupported)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataEnum(v *types.CodegenGenericDataEnum, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataEnumValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataEnums(v map[string]types.CodegenGenericDataEnum, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCodegenGenericDataEnum(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataEnumValuesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataField(v *types.CodegenGenericDataField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataType) > 0 {
		ok := object.Key("dataType")
		ok.String(string(v.DataType))
	}

	if v.DataTypeValue != nil {
		ok := object.Key("dataTypeValue")
		ok.String(*v.DataTypeValue)
	}

	if v.IsArray != nil {
		ok := object.Key("isArray")
		ok.Boolean(*v.IsArray)
	}

	if v.ReadOnly != nil {
		ok := object.Key("readOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.Relationship != nil {
		ok := object.Key("relationship")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataRelationshipType(v.Relationship, ok); err != nil {
			return err
		}
	}

	if v.Required != nil {
		ok := object.Key("required")
		ok.Boolean(*v.Required)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataFields(v map[string]types.CodegenGenericDataField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCodegenGenericDataField(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataModel(v *types.CodegenGenericDataModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Fields != nil {
		ok := object.Key("fields")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataFields(v.Fields, ok); err != nil {
			return err
		}
	}

	if v.IsJoinTable != nil {
		ok := object.Key("isJoinTable")
		ok.Boolean(*v.IsJoinTable)
	}

	if v.PrimaryKeys != nil {
		ok := object.Key("primaryKeys")
		if err := awsRestjson1_serializeDocumentCodegenPrimaryKeysList(v.PrimaryKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataModels(v map[string]types.CodegenGenericDataModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCodegenGenericDataModel(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataNonModel(v *types.CodegenGenericDataNonModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Fields != nil {
		ok := object.Key("fields")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataNonModelFields(v.Fields, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataNonModelFields(v map[string]types.CodegenGenericDataField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCodegenGenericDataField(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataNonModels(v map[string]types.CodegenGenericDataNonModel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCodegenGenericDataNonModel(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenGenericDataRelationshipType(v *types.CodegenGenericDataRelationshipType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociatedFields != nil {
		ok := object.Key("associatedFields")
		if err := awsRestjson1_serializeDocumentAssociatedFieldsList(v.AssociatedFields, ok); err != nil {
			return err
		}
	}

	if v.BelongsToFieldOnRelatedModel != nil {
		ok := object.Key("belongsToFieldOnRelatedModel")
		ok.String(*v.BelongsToFieldOnRelatedModel)
	}

	if v.CanUnlinkAssociatedModel != nil {
		ok := object.Key("canUnlinkAssociatedModel")
		ok.Boolean(*v.CanUnlinkAssociatedModel)
	}

	if v.IsHasManyIndex != nil {
		ok := object.Key("isHasManyIndex")
		ok.Boolean(*v.IsHasManyIndex)
	}

	if v.RelatedJoinFieldName != nil {
		ok := object.Key("relatedJoinFieldName")
		ok.String(*v.RelatedJoinFieldName)
	}

	if v.RelatedJoinTableName != nil {
		ok := object.Key("relatedJoinTableName")
		ok.String(*v.RelatedJoinTableName)
	}

	if v.RelatedModelFields != nil {
		ok := object.Key("relatedModelFields")
		if err := awsRestjson1_serializeDocumentRelatedModelFieldsList(v.RelatedModelFields, ok); err != nil {
			return err
		}
	}

	if v.RelatedModelName != nil {
		ok := object.Key("relatedModelName")
		ok.String(*v.RelatedModelName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenJobGenericDataSchema(v *types.CodegenJobGenericDataSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataSourceType) > 0 {
		ok := object.Key("dataSourceType")
		ok.String(string(v.DataSourceType))
	}

	if v.Enums != nil {
		ok := object.Key("enums")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataEnums(v.Enums, ok); err != nil {
			return err
		}
	}

	if v.Models != nil {
		ok := object.Key("models")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataModels(v.Models, ok); err != nil {
			return err
		}
	}

	if v.NonModels != nil {
		ok := object.Key("nonModels")
		if err := awsRestjson1_serializeDocumentCodegenGenericDataNonModels(v.NonModels, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCodegenJobRenderConfig(v types.CodegenJobRenderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CodegenJobRenderConfigMemberReact:
		av := object.Key("react")
		if err := awsRestjson1_serializeDocumentReactStartCodegenJobData(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentCodegenPrimaryKeysList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentBindingProperties(v map[string]types.ComponentBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentBindingPropertiesValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentBindingPropertiesValue(v *types.ComponentBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingPropertiesValueProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentBindingPropertiesValueProperties(v *types.ComponentBindingPropertiesValueProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Predicates != nil {
		ok := object.Key("predicates")
		if err := awsRestjson1_serializeDocumentPredicateList(v.Predicates, ok); err != nil {
			return err
		}
	}

	if v.SlotName != nil {
		ok := object.Key("slotName")
		ok.String(*v.SlotName)
	}

	if v.UserAttribute != nil {
		ok := object.Key("userAttribute")
		ok.String(*v.UserAttribute)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentChild(v *types.ComponentChild, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentComponentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.String(*v.SourceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentChildList(v []types.ComponentChild, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentChild(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentCollectionProperties(v map[string]types.ComponentDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentDataConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentConditionProperty(v *types.ComponentConditionProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Else != nil {
		ok := object.Key("else")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Else, ok); err != nil {
			return err
		}
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Operand != nil {
		ok := object.Key("operand")
		ok.String(*v.Operand)
	}

	if v.OperandType != nil {
		ok := object.Key("operandType")
		ok.String(*v.OperandType)
	}

	if v.Operator != nil {
		ok := object.Key("operator")
		ok.String(*v.Operator)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	if v.Then != nil {
		ok := object.Key("then")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Then, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentDataConfiguration(v *types.ComponentDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifiers != nil {
		ok := object.Key("identifiers")
		if err := awsRestjson1_serializeDocumentIdentifierList(v.Identifiers, ok); err != nil {
			return err
		}
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Predicate != nil {
		ok := object.Key("predicate")
		if err := awsRestjson1_serializeDocumentPredicate(v.Predicate, ok); err != nil {
			return err
		}
	}

	if v.Sort != nil {
		ok := object.Key("sort")
		if err := awsRestjson1_serializeDocumentSortPropertyList(v.Sort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentEvent(v *types.ComponentEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		ok.String(*v.Action)
	}

	if v.BindingEvent != nil {
		ok := object.Key("bindingEvent")
		ok.String(*v.BindingEvent)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentActionParameters(v.Parameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentEvents(v map[string]types.ComponentEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentEvent(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentOverrides(v map[string]map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentComponentOverridesValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentOverridesValue(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentProperties(v map[string]types.ComponentProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentProperty(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentProperty(v *types.ComponentProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Bindings != nil {
		ok := object.Key("bindings")
		if err := awsRestjson1_serializeDocumentFormBindings(v.Bindings, ok); err != nil {
			return err
		}
	}

	if v.CollectionBindingProperties != nil {
		ok := object.Key("collectionBindingProperties")
		if err := awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v.CollectionBindingProperties, ok); err != nil {
			return err
		}
	}

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.Concat != nil {
		ok := object.Key("concat")
		if err := awsRestjson1_serializeDocumentComponentPropertyList(v.Concat, ok); err != nil {
			return err
		}
	}

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentComponentConditionProperty(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.Configured != nil {
		ok := object.Key("configured")
		ok.Boolean(*v.Configured)
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Event != nil {
		ok := object.Key("event")
		ok.String(*v.Event)
	}

	if v.ImportedValue != nil {
		ok := object.Key("importedValue")
		ok.String(*v.ImportedValue)
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	if v.UserAttribute != nil {
		ok := object.Key("userAttribute")
		ok.String(*v.UserAttribute)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v *types.ComponentPropertyBindingProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentPropertyList(v []types.ComponentProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentVariant(v *types.ComponentVariant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.VariantValues != nil {
		ok := object.Key("variantValues")
		if err := awsRestjson1_serializeDocumentComponentVariantValues(v.VariantValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentVariants(v []types.ComponentVariant, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentVariant(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentVariantValues(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateComponentData(v *types.CreateComponentData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.CollectionProperties != nil {
		ok := object.Key("collectionProperties")
		if err := awsRestjson1_serializeDocumentComponentCollectionProperties(v.CollectionProperties, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentComponentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersion != nil {
		ok := object.Key("schemaVersion")
		ok.String(*v.SchemaVersion)
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.String(*v.SourceId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Variants != nil {
		ok := object.Key("variants")
		if err := awsRestjson1_serializeDocumentComponentVariants(v.Variants, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateFormData(v *types.CreateFormData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cta != nil {
		ok := object.Key("cta")
		if err := awsRestjson1_serializeDocumentFormCTA(v.Cta, ok); err != nil {
			return err
		}
	}

	if v.DataType != nil {
		ok := object.Key("dataType")
		if err := awsRestjson1_serializeDocumentFormDataTypeConfig(v.DataType, ok); err != nil {
			return err
		}
	}

	if v.Fields != nil {
		ok := object.Key("fields")
		if err := awsRestjson1_serializeDocumentFieldsMap(v.Fields, ok); err != nil {
			return err
		}
	}

	if len(v.FormActionType) > 0 {
		ok := object.Key("formActionType")
		ok.String(string(v.FormActionType))
	}

	if len(v.LabelDecorator) > 0 {
		ok := object.Key("labelDecorator")
		ok.String(string(v.LabelDecorator))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SchemaVersion != nil {
		ok := object.Key("schemaVersion")
		ok.String(*v.SchemaVersion)
	}

	if v.SectionalElements != nil {
		ok := object.Key("sectionalElements")
		if err := awsRestjson1_serializeDocumentSectionalElementMap(v.SectionalElements, ok); err != nil {
			return err
		}
	}

	if v.Style != nil {
		ok := object.Key("style")
		if err := awsRestjson1_serializeDocumentFormStyle(v.Style, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateThemeData(v *types.CreateThemeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataStoreRenderConfig(v *types.DataStoreRenderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentExchangeCodeForTokenRequestBody(v *types.ExchangeCodeForTokenRequestBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.RedirectUri != nil {
		ok := object.Key("redirectUri")
		ok.String(*v.RedirectUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldConfig(v *types.FieldConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Excluded != nil {
		ok := object.Key("excluded")
		ok.Boolean(*v.Excluded)
	}

	if v.InputType != nil {
		ok := object.Key("inputType")
		if err := awsRestjson1_serializeDocumentFieldInputConfig(v.InputType, ok); err != nil {
			return err
		}
	}

	if v.Label != nil {
		ok := object.Key("label")
		ok.String(*v.Label)
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentFieldPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.Validations != nil {
		ok := object.Key("validations")
		if err := awsRestjson1_serializeDocumentValidationsList(v.Validations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldInputConfig(v *types.FieldInputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultChecked != nil {
		ok := object.Key("defaultChecked")
		ok.Boolean(*v.DefaultChecked)
	}

	if v.DefaultCountryCode != nil {
		ok := object.Key("defaultCountryCode")
		ok.String(*v.DefaultCountryCode)
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.DescriptiveText != nil {
		ok := object.Key("descriptiveText")
		ok.String(*v.DescriptiveText)
	}

	if v.FileUploaderConfig != nil {
		ok := object.Key("fileUploaderConfig")
		if err := awsRestjson1_serializeDocumentFileUploaderFieldConfig(v.FileUploaderConfig, ok); err != nil {
			return err
		}
	}

	if v.IsArray != nil {
		ok := object.Key("isArray")
		ok.Boolean(*v.IsArray)
	}

	if v.MaxValue != nil {
		ok := object.Key("maxValue")
		switch {
		case math.IsNaN(float64(*v.MaxValue)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MaxValue), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MaxValue), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MaxValue)

		}
	}

	if v.MinValue != nil {
		ok := object.Key("minValue")
		switch {
		case math.IsNaN(float64(*v.MinValue)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinValue), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinValue), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinValue)

		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Placeholder != nil {
		ok := object.Key("placeholder")
		ok.String(*v.Placeholder)
	}

	if v.ReadOnly != nil {
		ok := object.Key("readOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.Required != nil {
		ok := object.Key("required")
		ok.Boolean(*v.Required)
	}

	if v.Step != nil {
		ok := object.Key("step")
		switch {
		case math.IsNaN(float64(*v.Step)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Step), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Step), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Step)

		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	if v.ValueMappings != nil {
		ok := object.Key("valueMappings")
		if err := awsRestjson1_serializeDocumentValueMappings(v.ValueMappings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldPosition(v types.FieldPosition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FieldPositionMemberBelow:
		av := object.Key("below")
		av.String(uv.Value)

	case *types.FieldPositionMemberFixed:
		av := object.Key("fixed")
		av.String(string(uv.Value))

	case *types.FieldPositionMemberRightOf:
		av := object.Key("rightOf")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentFieldsMap(v map[string]types.FieldConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFieldConfig(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldValidationConfiguration(v *types.FieldValidationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NumValues != nil {
		ok := object.Key("numValues")
		if err := awsRestjson1_serializeDocumentNumValues(v.NumValues, ok); err != nil {
			return err
		}
	}

	if v.StrValues != nil {
		ok := object.Key("strValues")
		if err := awsRestjson1_serializeDocumentStrValues(v.StrValues, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	if v.ValidationMessage != nil {
		ok := object.Key("validationMessage")
		ok.String(*v.ValidationMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentFileUploaderFieldConfig(v *types.FileUploaderFieldConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcceptedFileTypes != nil {
		ok := object.Key("acceptedFileTypes")
		if err := awsRestjson1_serializeDocumentStrValues(v.AcceptedFileTypes, ok); err != nil {
			return err
		}
	}

	if len(v.AccessLevel) > 0 {
		ok := object.Key("accessLevel")
		ok.String(string(v.AccessLevel))
	}

	if v.IsResumable != nil {
		ok := object.Key("isResumable")
		ok.Boolean(*v.IsResumable)
	}

	if v.MaxFileCount != nil {
		ok := object.Key("maxFileCount")
		ok.Integer(*v.MaxFileCount)
	}

	if v.MaxSize != nil {
		ok := object.Key("maxSize")
		ok.Integer(*v.MaxSize)
	}

	if v.ShowThumbnails != nil {
		ok := object.Key("showThumbnails")
		ok.Boolean(*v.ShowThumbnails)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormBindingElement(v *types.FormBindingElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Element != nil {
		ok := object.Key("element")
		ok.String(*v.Element)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormBindings(v map[string]types.FormBindingElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFormBindingElement(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFormButton(v *types.FormButton, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("children")
		ok.String(*v.Children)
	}

	if v.Excluded != nil {
		ok := object.Key("excluded")
		ok.Boolean(*v.Excluded)
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentFieldPosition(v.Position, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFormCTA(v *types.FormCTA, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cancel != nil {
		ok := object.Key("cancel")
		if err := awsRestjson1_serializeDocumentFormButton(v.Cancel, ok); err != nil {
			return err
		}
	}

	if v.Clear != nil {
		ok := object.Key("clear")
		if err := awsRestjson1_serializeDocumentFormButton(v.Clear, ok); err != nil {
			return err
		}
	}

	if len(v.Position) > 0 {
		ok := object.Key("position")
		ok.String(string(v.Position))
	}

	if v.Submit != nil {
		ok := object.Key("submit")
		if err := awsRestjson1_serializeDocumentFormButton(v.Submit, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFormDataTypeConfig(v *types.FormDataTypeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataSourceType) > 0 {
		ok := object.Key("dataSourceType")
		ok.String(string(v.DataSourceType))
	}

	if v.DataTypeName != nil {
		ok := object.Key("dataTypeName")
		ok.String(*v.DataTypeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormInputBindingProperties(v map[string]types.FormInputBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFormInputBindingPropertiesValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFormInputBindingPropertiesValue(v *types.FormInputBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentFormInputBindingPropertiesValueProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormInputBindingPropertiesValueProperties(v *types.FormInputBindingPropertiesValueProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormInputValueProperty(v *types.FormInputValueProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentFormInputValuePropertyBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Concat != nil {
		ok := object.Key("concat")
		if err := awsRestjson1_serializeDocumentFormInputValuePropertyList(v.Concat, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormInputValuePropertyBindingProperties(v *types.FormInputValuePropertyBindingProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormInputValuePropertyList(v []types.FormInputValueProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFormInputValueProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFormStyle(v *types.FormStyle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HorizontalGap != nil {
		ok := object.Key("horizontalGap")
		if err := awsRestjson1_serializeDocumentFormStyleConfig(v.HorizontalGap, ok); err != nil {
			return err
		}
	}

	if v.OuterPadding != nil {
		ok := object.Key("outerPadding")
		if err := awsRestjson1_serializeDocumentFormStyleConfig(v.OuterPadding, ok); err != nil {
			return err
		}
	}

	if v.VerticalGap != nil {
		ok := object.Key("verticalGap")
		if err := awsRestjson1_serializeDocumentFormStyleConfig(v.VerticalGap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFormStyleConfig(v types.FormStyleConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FormStyleConfigMemberTokenReference:
		av := object.Key("tokenReference")
		av.String(uv.Value)

	case *types.FormStyleConfigMemberValue:
		av := object.Key("value")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentGraphQLRenderConfig(v *types.GraphQLRenderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FragmentsFilePath != nil {
		ok := object.Key("fragmentsFilePath")
		ok.String(*v.FragmentsFilePath)
	}

	if v.MutationsFilePath != nil {
		ok := object.Key("mutationsFilePath")
		ok.String(*v.MutationsFilePath)
	}

	if v.QueriesFilePath != nil {
		ok := object.Key("queriesFilePath")
		ok.String(*v.QueriesFilePath)
	}

	if v.SubscriptionsFilePath != nil {
		ok := object.Key("subscriptionsFilePath")
		ok.String(*v.SubscriptionsFilePath)
	}

	if v.TypesFilePath != nil {
		ok := object.Key("typesFilePath")
		ok.String(*v.TypesFilePath)
	}

	return nil
}

func awsRestjson1_serializeDocumentIdentifierList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMutationActionSetStateParameter(v *types.MutationActionSetStateParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	if v.Set != nil {
		ok := object.Key("set")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Set, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNoApiRenderConfig(v *types.NoApiRenderConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentNumValues(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPredicate(v *types.Predicate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.And != nil {
		ok := object.Key("and")
		if err := awsRestjson1_serializeDocumentPredicateList(v.And, ok); err != nil {
			return err
		}
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Operand != nil {
		ok := object.Key("operand")
		ok.String(*v.Operand)
	}

	if v.OperandType != nil {
		ok := object.Key("operandType")
		ok.String(*v.OperandType)
	}

	if v.Operator != nil {
		ok := object.Key("operator")
		ok.String(*v.Operator)
	}

	if v.Or != nil {
		ok := object.Key("or")
		if err := awsRestjson1_serializeDocumentPredicateList(v.Or, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPredicateList(v []types.Predicate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPredicate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPutMetadataFlagBody(v *types.PutMetadataFlagBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NewValue != nil {
		ok := object.Key("newValue")
		ok.String(*v.NewValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentReactCodegenDependencies(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentReactStartCodegenJobData(v *types.ReactStartCodegenJobData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiConfiguration != nil {
		ok := object.Key("apiConfiguration")
		if err := awsRestjson1_serializeDocumentApiConfiguration(v.ApiConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Dependencies != nil {
		ok := object.Key("dependencies")
		if err := awsRestjson1_serializeDocumentReactCodegenDependencies(v.Dependencies, ok); err != nil {
			return err
		}
	}

	if v.InlineSourceMap {
		ok := object.Key("inlineSourceMap")
		ok.Boolean(v.InlineSourceMap)
	}

	if len(v.Module) > 0 {
		ok := object.Key("module")
		ok.String(string(v.Module))
	}

	if v.RenderTypeDeclarations {
		ok := object.Key("renderTypeDeclarations")
		ok.Boolean(v.RenderTypeDeclarations)
	}

	if len(v.Script) > 0 {
		ok := object.Key("script")
		ok.String(string(v.Script))
	}

	if len(v.Target) > 0 {
		ok := object.Key("target")
		ok.String(string(v.Target))
	}

	return nil
}

func awsRestjson1_serializeDocumentRefreshTokenRequestBody(v *types.RefreshTokenRequestBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelatedModelFieldsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSectionalElement(v *types.SectionalElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Excluded != nil {
		ok := object.Key("excluded")
		ok.Boolean(*v.Excluded)
	}

	if v.Level != nil {
		ok := object.Key("level")
		ok.Integer(*v.Level)
	}

	if v.Orientation != nil {
		ok := object.Key("orientation")
		ok.String(*v.Orientation)
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentFieldPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentSectionalElementMap(v map[string]types.SectionalElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSectionalElement(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSortProperty(v *types.SortProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Direction) > 0 {
		ok := object.Key("direction")
		ok.String(string(v.Direction))
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	return nil
}

func awsRestjson1_serializeDocumentSortPropertyList(v []types.SortProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSortProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStartCodegenJobData(v *types.StartCodegenJobData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoGenerateForms != nil {
		ok := object.Key("autoGenerateForms")
		ok.Boolean(*v.AutoGenerateForms)
	}

	if v.Features != nil {
		ok := object.Key("features")
		if err := awsRestjson1_serializeDocumentCodegenFeatureFlags(v.Features, ok); err != nil {
			return err
		}
	}

	if v.GenericDataSchema != nil {
		ok := object.Key("genericDataSchema")
		if err := awsRestjson1_serializeDocumentCodegenJobGenericDataSchema(v.GenericDataSchema, ok); err != nil {
			return err
		}
	}

	if v.RenderConfig != nil {
		ok := object.Key("renderConfig")
		if err := awsRestjson1_serializeDocumentCodegenJobRenderConfig(v.RenderConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStrValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentThemeValue(v *types.ThemeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentThemeValues(v *types.ThemeValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentThemeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentThemeValuesList(v []types.ThemeValues, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentThemeValues(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateComponentData(v *types.UpdateComponentData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.CollectionProperties != nil {
		ok := object.Key("collectionProperties")
		if err := awsRestjson1_serializeDocumentComponentCollectionProperties(v.CollectionProperties, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentComponentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.SchemaVersion != nil {
		ok := object.Key("schemaVersion")
		ok.String(*v.SchemaVersion)
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.String(*v.SourceId)
	}

	if v.Variants != nil {
		ok := object.Key("variants")
		if err := awsRestjson1_serializeDocumentComponentVariants(v.Variants, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateFormData(v *types.UpdateFormData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Cta != nil {
		ok := object.Key("cta")
		if err := awsRestjson1_serializeDocumentFormCTA(v.Cta, ok); err != nil {
			return err
		}
	}

	if v.DataType != nil {
		ok := object.Key("dataType")
		if err := awsRestjson1_serializeDocumentFormDataTypeConfig(v.DataType, ok); err != nil {
			return err
		}
	}

	if v.Fields != nil {
		ok := object.Key("fields")
		if err := awsRestjson1_serializeDocumentFieldsMap(v.Fields, ok); err != nil {
			return err
		}
	}

	if len(v.FormActionType) > 0 {
		ok := object.Key("formActionType")
		ok.String(string(v.FormActionType))
	}

	if len(v.LabelDecorator) > 0 {
		ok := object.Key("labelDecorator")
		ok.String(string(v.LabelDecorator))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SchemaVersion != nil {
		ok := object.Key("schemaVersion")
		ok.String(*v.SchemaVersion)
	}

	if v.SectionalElements != nil {
		ok := object.Key("sectionalElements")
		if err := awsRestjson1_serializeDocumentSectionalElementMap(v.SectionalElements, ok); err != nil {
			return err
		}
	}

	if v.Style != nil {
		ok := object.Key("style")
		if err := awsRestjson1_serializeDocumentFormStyle(v.Style, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateThemeData(v *types.UpdateThemeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValidationsList(v []types.FieldValidationConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFieldValidationConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentValueMapping(v *types.ValueMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayValue != nil {
		ok := object.Key("displayValue")
		if err := awsRestjson1_serializeDocumentFormInputValueProperty(v.DisplayValue, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentFormInputValueProperty(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValueMappingList(v []types.ValueMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentValueMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentValueMappings(v *types.ValueMappings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentFormInputBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentValueMappingList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}
