Google I/O Android App
======================

Google I/O is a developer conference held each year with two days of deep
technical content featuring technical sessions and hundreds of demonstrations
from developers showcasing their technologies.

This project is the Android app for the conference. The app supports devices
running Android 5.0+, and is optimized for phones and tablets of all shapes
and sizes.

<h2>Source</h2>

The source code in this repository reflects the app as of I/O 2017.

<h2>Features</h2>

With the app, you can:

- View the conference agenda and edit your personal schedule
- Sync your schedule between all of your devices and the I/O website
- View detailed session, code lab, office hours, and speaker information,
  including speaker bios, photos, and Google+ profiles
- Participate in public #io15 conversations on Google+
- Guide yourself using the vector-based conference map
- Get a reminder a few minutes before sessions in your schedule are due to
  start
- Play "I/O Live" session video streams
- Send feedback on sessions, from your phone/tablet.

<h2>How to Work with the Source</h2>

We hope the source code for this app is useful for you as a reference or starting point for creating your own apps. Here is some additional reading to help you better understand and reuse this code.

  * [Build instructions](doc/BUILDING.md): instructions on how to build and run the code.
  * [Sync protocol and data format](doc/SYNC.md)
  * [Image loading](doc/IMAGES.md)
  * [Use of FCM](doc/FCM.md)
  * [Customization guide](doc/CUSTOM.md)

<h2>Copyright</h2>

    Copyright 2014 Google Inc. All rights reserved.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
