//go:build jwx_goccy

package json

import (
	"io"

	"github.com/goccy/go-json"
)

type Decoder = json.Decoder
type Delim = json.Delim
type Encoder = json.Encoder
type Marshaler = json.Marshaler
type Number = json.Number
type RawMessage = json.RawMessage
type Unmarshaler = json.Unmarshaler

func Engine() string {
	return "github.com/goccy/go-json"
}

// NewDecoder respects the values specified in DecoderSettings,
// and creates a Decoder that has certain features turned on/off
func NewDecoder(r io.Reader) *json.Decoder {
	dec := json.NewDecoder(r)

	if UseNumber() {
		dec.UseNumber()
	}

	return dec
}

// NewEncoder is just a proxy for "encoding/json".NewEncoder
func NewEncoder(w io.Writer) *json.Encoder {
	return json.NewEncoder(w)
}

// Marshal is just a proxy for "encoding/json".Marshal
func Marshal(v any) ([]byte, error) {
	return json.Marshal(v)
}

// MarshalIndent is just a proxy for "encoding/json".MarshalIndent
func MarshalIndent(v any, prefix, indent string) ([]byte, error) {
	return json.MarshalIndent(v, prefix, indent)
}
