// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package apigeeconnect

import (
	"context"
	"math"

	apigeeconnectpb "cloud.google.com/go/apigeeconnect/apiv1/apigeeconnectpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
)

var newTetherClientHook clientHook

// TetherCallOptions contains the retry settings for each method of TetherClient.
type TetherCallOptions struct {
	Egress []gax.CallOption
}

func defaultTetherGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("apigeeconnect.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("apigeeconnect.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("apigeeconnect.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://apigeeconnect.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultTetherCallOptions() *TetherCallOptions {
	return &TetherCallOptions{
		Egress: []gax.CallOption{},
	}
}

// internalTetherClient is an interface that defines the methods available from Apigee Connect API.
type internalTetherClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	Egress(context.Context, ...gax.CallOption) (apigeeconnectpb.Tether_EgressClient, error)
}

// TetherClient is a client for interacting with Apigee Connect API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Tether provides a way for the control plane to send HTTP API requests to
// services in data planes that runs in a remote datacenter without
// requiring customers to open firewalls on their runtime plane.
type TetherClient struct {
	// The internal transport-dependent client.
	internalClient internalTetherClient

	// The call options for this service.
	CallOptions *TetherCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *TetherClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *TetherClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *TetherClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// Egress egress streams egress requests and responses. Logically, this is not
// actually a streaming request, but uses streaming as a mechanism to flip
// the client-server relationship of gRPC so that the server can act as a
// client.
// The listener, the RPC server, accepts connections from the dialer,
// the RPC client.
// The listener streams http requests and the dialer streams http responses.
func (c *TetherClient) Egress(ctx context.Context, opts ...gax.CallOption) (apigeeconnectpb.Tether_EgressClient, error) {
	return c.internalClient.Egress(ctx, opts...)
}

// tetherGRPCClient is a client for interacting with Apigee Connect API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type tetherGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing TetherClient
	CallOptions **TetherCallOptions

	// The gRPC API client.
	tetherClient apigeeconnectpb.TetherClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewTetherClient creates a new tether client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Tether provides a way for the control plane to send HTTP API requests to
// services in data planes that runs in a remote datacenter without
// requiring customers to open firewalls on their runtime plane.
func NewTetherClient(ctx context.Context, opts ...option.ClientOption) (*TetherClient, error) {
	clientOpts := defaultTetherGRPCClientOptions()
	if newTetherClientHook != nil {
		hookOpts, err := newTetherClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := TetherClient{CallOptions: defaultTetherCallOptions()}

	c := &tetherGRPCClient{
		connPool:     connPool,
		tetherClient: apigeeconnectpb.NewTetherClient(connPool),
		CallOptions:  &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *tetherGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *tetherGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *tetherGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *tetherGRPCClient) Egress(ctx context.Context, opts ...gax.CallOption) (apigeeconnectpb.Tether_EgressClient, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	var resp apigeeconnectpb.Tether_EgressClient
	opts = append((*c.CallOptions).Egress[0:len((*c.CallOptions).Egress):len((*c.CallOptions).Egress)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.tetherClient.Egress(ctx, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
