// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/chat/v1/space.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Deprecated: Use `SpaceType` instead.
type Space_Type int32

const (
	// Reserved.
	Space_TYPE_UNSPECIFIED Space_Type = 0
	// Conversations between two or more humans.
	Space_ROOM Space_Type = 1
	// 1:1 Direct Message between a human and a Chat app, where all messages are
	// flat. Note that this doesn't include direct messages between two humans.
	Space_DM Space_Type = 2
)

// Enum value maps for Space_Type.
var (
	Space_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ROOM",
		2: "DM",
	}
	Space_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ROOM":             1,
		"DM":               2,
	}
)

func (x Space_Type) Enum() *Space_Type {
	p := new(Space_Type)
	*p = x
	return p
}

func (x Space_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[0].Descriptor()
}

func (Space_Type) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[0]
}

func (x Space_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_Type.Descriptor instead.
func (Space_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 0}
}

// The type of space. Required when creating or updating a space. Output only
// for other usage.
type Space_SpaceType int32

const (
	// Reserved.
	Space_SPACE_TYPE_UNSPECIFIED Space_SpaceType = 0
	// A place where people send messages, share files, and collaborate.
	// A `SPACE` can include Chat apps.
	Space_SPACE Space_SpaceType = 1
	// Group conversations between 3 or more people.
	// A `GROUP_CHAT` can include Chat apps.
	Space_GROUP_CHAT Space_SpaceType = 2
	// 1:1 messages between two humans or a human and a Chat app.
	Space_DIRECT_MESSAGE Space_SpaceType = 3
)

// Enum value maps for Space_SpaceType.
var (
	Space_SpaceType_name = map[int32]string{
		0: "SPACE_TYPE_UNSPECIFIED",
		1: "SPACE",
		2: "GROUP_CHAT",
		3: "DIRECT_MESSAGE",
	}
	Space_SpaceType_value = map[string]int32{
		"SPACE_TYPE_UNSPECIFIED": 0,
		"SPACE":                  1,
		"GROUP_CHAT":             2,
		"DIRECT_MESSAGE":         3,
	}
)

func (x Space_SpaceType) Enum() *Space_SpaceType {
	p := new(Space_SpaceType)
	*p = x
	return p
}

func (x Space_SpaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_SpaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[1].Descriptor()
}

func (Space_SpaceType) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[1]
}

func (x Space_SpaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_SpaceType.Descriptor instead.
func (Space_SpaceType) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 1}
}

// Specifies the type of threading state in the Chat space.
type Space_SpaceThreadingState int32

const (
	// Reserved.
	Space_SPACE_THREADING_STATE_UNSPECIFIED Space_SpaceThreadingState = 0
	// Named spaces that support message threads. When users respond to a
	// message, they can reply in-thread, which keeps their response in the
	// context of the original message.
	Space_THREADED_MESSAGES Space_SpaceThreadingState = 2
	// Named spaces where the conversation is organized by topic. Topics and
	// their replies are grouped together.
	Space_GROUPED_MESSAGES Space_SpaceThreadingState = 3
	// Direct messages (DMs) between two people and group conversations between
	// 3 or more people.
	Space_UNTHREADED_MESSAGES Space_SpaceThreadingState = 4
)

// Enum value maps for Space_SpaceThreadingState.
var (
	Space_SpaceThreadingState_name = map[int32]string{
		0: "SPACE_THREADING_STATE_UNSPECIFIED",
		2: "THREADED_MESSAGES",
		3: "GROUPED_MESSAGES",
		4: "UNTHREADED_MESSAGES",
	}
	Space_SpaceThreadingState_value = map[string]int32{
		"SPACE_THREADING_STATE_UNSPECIFIED": 0,
		"THREADED_MESSAGES":                 2,
		"GROUPED_MESSAGES":                  3,
		"UNTHREADED_MESSAGES":               4,
	}
)

func (x Space_SpaceThreadingState) Enum() *Space_SpaceThreadingState {
	p := new(Space_SpaceThreadingState)
	*p = x
	return p
}

func (x Space_SpaceThreadingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_SpaceThreadingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[2].Descriptor()
}

func (Space_SpaceThreadingState) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[2]
}

func (x Space_SpaceThreadingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_SpaceThreadingState.Descriptor instead.
func (Space_SpaceThreadingState) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 2}
}

// A space in Google Chat. Spaces are conversations between two or more users
// or 1:1 messages between a user and a Chat app.
type Space struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the space.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Deprecated: Use `space_type` instead.
	// The type of a space.
	//
	// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
	Type Space_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.chat.v1.Space_Type" json:"type,omitempty"`
	// The type of space. Required when creating a space or updating the space
	// type of a space. Output only for other usage.
	SpaceType Space_SpaceType `protobuf:"varint,10,opt,name=space_type,json=spaceType,proto3,enum=google.chat.v1.Space_SpaceType" json:"space_type,omitempty"`
	// Optional. Whether the space is a DM between a Chat app and a single
	// human.
	SingleUserBotDm bool `protobuf:"varint,4,opt,name=single_user_bot_dm,json=singleUserBotDm,proto3" json:"single_user_bot_dm,omitempty"`
	// Output only. Deprecated: Use `spaceThreadingState` instead.
	// Whether messages are threaded in this space.
	//
	// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
	Threaded bool `protobuf:"varint,5,opt,name=threaded,proto3" json:"threaded,omitempty"`
	// The space's display name. Required when [creating a
	// space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create).
	// If you receive the error message `ALREADY_EXISTS` when creating a space or
	// updating the `displayName`, try a different `displayName`. An
	// existing space within the Google Workspace organization might already use
	// this display name.
	//
	// For direct messages, this field might be empty.
	//
	// Supports up to 128 characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Immutable. Whether this space permits any Google Chat user as a member.
	// Input when creating a space in a Google Workspace organization. Omit this
	// field when creating spaces in the following conditions:
	//
	//   - The authenticated user uses a consumer account (unmanaged user
	//     account). By default, a space created by a consumer account permits any
	//     Google Chat user.
	//
	//   - The space is used to [import data to Google Chat]
	//     (https://developers.google.com/chat/api/guides/import-data-overview)
	//     because import mode spaces must only permit members from the same
	//     Google Workspace organization. However, as part of the [Google
	//     Workspace Developer Preview
	//     Program](https://developers.google.com/workspace/preview), import mode
	//     spaces can permit any Google Chat user so this field can then be set
	//     for import mode spaces.
	//
	// For existing spaces, this field is output only.
	ExternalUserAllowed bool `protobuf:"varint,8,opt,name=external_user_allowed,json=externalUserAllowed,proto3" json:"external_user_allowed,omitempty"`
	// Output only. The threading state in the Chat space.
	SpaceThreadingState Space_SpaceThreadingState `protobuf:"varint,9,opt,name=space_threading_state,json=spaceThreadingState,proto3,enum=google.chat.v1.Space_SpaceThreadingState" json:"space_threading_state,omitempty"`
	// Details about the space including description and rules.
	SpaceDetails *Space_SpaceDetails `protobuf:"bytes,11,opt,name=space_details,json=spaceDetails,proto3" json:"space_details,omitempty"`
	// The message history state for messages and threads in this space.
	SpaceHistoryState HistoryState `protobuf:"varint,13,opt,name=space_history_state,json=spaceHistoryState,proto3,enum=google.chat.v1.HistoryState" json:"space_history_state,omitempty"`
	// Optional. Whether this space is created in `Import Mode` as part of a data
	// migration into Google Workspace. While spaces are being imported, they
	// aren't visible to users until the import is complete.
	ImportMode bool `protobuf:"varint,16,opt,name=import_mode,json=importMode,proto3" json:"import_mode,omitempty"`
	// Optional. Immutable. For spaces created in Chat, the time the space was
	// created. This field is output only, except when used in import mode spaces.
	//
	// For import mode spaces, set this field to the historical timestamp at which
	// the space was created in the source in order to preserve the original
	// creation time.
	//
	// Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. For direct message (DM) spaces with a Chat app, whether the
	// space was created by a Google Workspace administrator. Administrators can
	// install and set up a direct message with a Chat app on behalf of users in
	// their organization.
	//
	// To support admin install, your Chat app must feature direct messaging.
	AdminInstalled bool `protobuf:"varint,19,opt,name=admin_installed,json=adminInstalled,proto3" json:"admin_installed,omitempty"`
}

func (x *Space) Reset() {
	*x = Space{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Space) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space) ProtoMessage() {}

func (x *Space) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space.ProtoReflect.Descriptor instead.
func (*Space) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0}
}

func (x *Space) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
func (x *Space) GetType() Space_Type {
	if x != nil {
		return x.Type
	}
	return Space_TYPE_UNSPECIFIED
}

func (x *Space) GetSpaceType() Space_SpaceType {
	if x != nil {
		return x.SpaceType
	}
	return Space_SPACE_TYPE_UNSPECIFIED
}

func (x *Space) GetSingleUserBotDm() bool {
	if x != nil {
		return x.SingleUserBotDm
	}
	return false
}

// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
func (x *Space) GetThreaded() bool {
	if x != nil {
		return x.Threaded
	}
	return false
}

func (x *Space) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Space) GetExternalUserAllowed() bool {
	if x != nil {
		return x.ExternalUserAllowed
	}
	return false
}

func (x *Space) GetSpaceThreadingState() Space_SpaceThreadingState {
	if x != nil {
		return x.SpaceThreadingState
	}
	return Space_SPACE_THREADING_STATE_UNSPECIFIED
}

func (x *Space) GetSpaceDetails() *Space_SpaceDetails {
	if x != nil {
		return x.SpaceDetails
	}
	return nil
}

func (x *Space) GetSpaceHistoryState() HistoryState {
	if x != nil {
		return x.SpaceHistoryState
	}
	return HistoryState_HISTORY_STATE_UNSPECIFIED
}

func (x *Space) GetImportMode() bool {
	if x != nil {
		return x.ImportMode
	}
	return false
}

func (x *Space) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Space) GetAdminInstalled() bool {
	if x != nil {
		return x.AdminInstalled
	}
	return false
}

// A request to create a named space.
type CreateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `displayName` and `spaceType` fields must be populated.  Only
	// `SpaceType.SPACE` is supported.
	//
	// If you receive the error message `ALREADY_EXISTS` when creating a space,
	// try a different `displayName`. An existing space within the Google
	// Workspace organization might already use this display name.
	//
	// The space `name` is assigned on the server so anything specified in this
	// field will be ignored.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Optional. A unique identifier for this request.
	// A random UUID is recommended.
	// Specifying an existing request ID returns the space created with that ID
	// instead of creating a new space.
	// Specifying an existing request ID from the same Chat app with a different
	// authenticated user returns an error.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSpaceRequest) Reset() {
	*x = CreateSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpaceRequest) ProtoMessage() {}

func (x *CreateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpaceRequest.ProtoReflect.Descriptor instead.
func (*CreateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{1}
}

func (x *CreateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *CreateSpaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to list the spaces the caller is a member of.
type ListSpacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of spaces to return. The service might return
	// fewer than this value.
	//
	// If unspecified, at most 100 spaces are returned.
	//
	// The maximum value is 1000. If you use a value more than 1000, it's
	// automatically changed to 1000.
	//
	// Negative values return an `INVALID_ARGUMENT` error.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous list spaces call.
	// Provide this parameter to retrieve the subsequent page.
	//
	// When paginating, the filter value should match the call that provided the
	// page token. Passing a different value may lead to unexpected results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A query filter.
	//
	// You can filter spaces by the space type
	// ([`space_type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#spacetype)).
	//
	// To filter by space type, you must specify valid enum value, such as
	// `SPACE` or `GROUP_CHAT` (the `space_type` can't be
	// `SPACE_TYPE_UNSPECIFIED`). To query for multiple space types, use the `OR`
	// operator.
	//
	// For example, the following queries are valid:
	//
	// ```
	// space_type = "SPACE"
	// spaceType = "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE"
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSpacesRequest) Reset() {
	*x = ListSpacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpacesRequest) ProtoMessage() {}

func (x *ListSpacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpacesRequest.ProtoReflect.Descriptor instead.
func (*ListSpacesRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{2}
}

func (x *ListSpacesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpacesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpacesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for a list spaces request.
type ListSpacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of spaces in the requested (or first) page.
	Spaces []*Space `protobuf:"bytes,1,rep,name=spaces,proto3" json:"spaces,omitempty"`
	// You can send a token as `pageToken` to retrieve the next page of
	// results. If empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpacesResponse) Reset() {
	*x = ListSpacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpacesResponse) ProtoMessage() {}

func (x *ListSpacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpacesResponse.ProtoReflect.Descriptor instead.
func (*ListSpacesResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{3}
}

func (x *ListSpacesResponse) GetSpaces() []*Space {
	if x != nil {
		return x.Spaces
	}
	return nil
}

func (x *ListSpacesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to return a single space.
type GetSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space, in the form "spaces/*".
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpaceRequest) Reset() {
	*x = GetSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpaceRequest) ProtoMessage() {}

func (x *GetSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpaceRequest.ProtoReflect.Descriptor instead.
func (*GetSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{4}
}

func (x *GetSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to get direct message space based on the user resource.
type FindDirectMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the user to find direct message with.
	//
	// Format: `users/{user}`, where `{user}` is either the `id` for the
	// [person](https://developers.google.com/people/api/rest/v1/people) from the
	// People API, or the `id` for the
	// [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
	// in the Directory API. For example, if the People API profile ID is
	// `123456789`, you can find a direct message with that person by using
	// `users/123456789` as the `name`. When [authenticated as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// you can use the email as an alias for `{user}`. For example,
	// `users/example@gmail.com` where `example@gmail.com` is the email of the
	// Google Chat user.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FindDirectMessageRequest) Reset() {
	*x = FindDirectMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FindDirectMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindDirectMessageRequest) ProtoMessage() {}

func (x *FindDirectMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindDirectMessageRequest.ProtoReflect.Descriptor instead.
func (*FindDirectMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{5}
}

func (x *FindDirectMessageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update a single space.
type UpdateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Space with fields to be updated. `Space.name` must be
	// populated in the form of `spaces/{space}`. Only fields
	// specified by `update_mask` are updated.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Required. The updated field paths, comma separated if there are
	// multiple.
	//
	// Currently supported field paths:
	//
	// - `display_name` (Only supports changing the display name of a space with
	// the `SPACE` type, or when also including the `space_type` mask to change a
	// `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
	// `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
	// error. If you receive the error message `ALREADY_EXISTS` when updating the
	// `displayName`, try a different `displayName`. An existing space within the
	// Google Workspace organization might already use this display name.)
	//
	// - `space_type` (Only supports changing a `GROUP_CHAT` space type to
	// `SPACE`. Include `display_name` together
	// with `space_type` in the update mask and ensure that the specified space
	// has a non-empty display name and the `SPACE` space type. Including the
	// `space_type` mask and the `SPACE` type in the specified space when updating
	// the display name is optional if the existing space already has the `SPACE`
	// type. Trying to update the space type in other ways results in an invalid
	// argument error).
	//
	// - `space_details`
	//
	// - `space_history_state` (Supports [turning history on or off for the
	// space](https://support.google.com/chat/answer/7664687) if [the organization
	// allows users to change their history
	// setting](https://support.google.com/a/answer/7664184).
	// Warning: mutually exclusive with all other field paths.)
	//
	// - Developer Preview: `access_settings.audience` (Supports changing the
	// [access setting](https://support.google.com/chat/answer/11971020) of a
	// space. If no audience is specified in the access setting, the space's
	// access setting is updated to restricted. Warning: mutually exclusive with
	// all other field paths.)
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpaceRequest) Reset() {
	*x = UpdateSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpaceRequest) ProtoMessage() {}

func (x *UpdateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpaceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *UpdateSpaceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for deleting a space.
type DeleteSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space to delete.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSpaceRequest) Reset() {
	*x = DeleteSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpaceRequest) ProtoMessage() {}

func (x *DeleteSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpaceRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for completing the import process for a space.
type CompleteImportSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the import mode space.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteImportSpaceRequest) Reset() {
	*x = CompleteImportSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteImportSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteImportSpaceRequest) ProtoMessage() {}

func (x *CompleteImportSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteImportSpaceRequest.ProtoReflect.Descriptor instead.
func (*CompleteImportSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{8}
}

func (x *CompleteImportSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for completing the import process for a space.
type CompleteImportSpaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The import mode space.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
}

func (x *CompleteImportSpaceResponse) Reset() {
	*x = CompleteImportSpaceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteImportSpaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteImportSpaceResponse) ProtoMessage() {}

func (x *CompleteImportSpaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteImportSpaceResponse.ProtoReflect.Descriptor instead.
func (*CompleteImportSpaceResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{9}
}

func (x *CompleteImportSpaceResponse) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

// Details about the space including description and rules.
type Space_SpaceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A description of the space. For example, describe the space's
	// discussion topic, functional purpose, or participants.
	//
	// Supports up to 150 characters.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The space's rules, expectations, and etiquette.
	//
	// Supports up to 5,000 characters.
	Guidelines string `protobuf:"bytes,2,opt,name=guidelines,proto3" json:"guidelines,omitempty"`
}

func (x *Space_SpaceDetails) Reset() {
	*x = Space_SpaceDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_space_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Space_SpaceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_SpaceDetails) ProtoMessage() {}

func (x *Space_SpaceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_SpaceDetails.ProtoReflect.Descriptor instead.
func (*Space_SpaceDetails) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Space_SpaceDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Space_SpaceDetails) GetGuidelines() string {
	if x != nil {
		return x.Guidelines
	}
	return ""
}

var File_google_chat_v1_space_proto protoreflect.FileDescriptor

var file_google_chat_v1_space_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe6, 0x08, 0x0a, 0x05, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x12, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x74, 0x5f, 0x64, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x42, 0x6f, 0x74, 0x44, 0x6d, 0x12, 0x21, 0x0a, 0x08, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52,
	0x08, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x15,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x15, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x73, 0x70, 0x61, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x0d, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x0c, 0x73, 0x70, 0x61, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x13, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x11, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x1a, 0x50, 0x0a, 0x0c, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x67,
	0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x22, 0x2e, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x4f, 0x4f,
	0x4d, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x44, 0x4d, 0x10, 0x02, 0x22, 0x56, 0x0a, 0x09, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x43, 0x48, 0x41, 0x54, 0x10, 0x02, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47,
	0x45, 0x10, 0x03, 0x22, 0x82, 0x01, 0x0a, 0x13, 0x53, 0x70, 0x61, 0x63, 0x65, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x53,
	0x50, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x48, 0x52, 0x45, 0x41, 0x44, 0x45, 0x44, 0x5f, 0x4d,
	0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x53, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x53, 0x10, 0x03, 0x12,
	0x17, 0x0a, 0x13, 0x55, 0x4e, 0x54, 0x48, 0x52, 0x45, 0x41, 0x44, 0x45, 0x44, 0x5f, 0x4d, 0x45,
	0x53, 0x53, 0x41, 0x47, 0x45, 0x53, 0x10, 0x04, 0x3a, 0x2e, 0xea, 0x41, 0x2b, 0x0a, 0x19, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x0e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x22, 0x6a, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30,
	0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0x76, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x6b, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x06, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x48, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1b, 0x0a, 0x19, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x33, 0x0a, 0x18, 0x46, 0x69, 0x6e, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x30, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4b,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x1a, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a,
	0x19, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x4a, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2b, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42, 0xa3, 0x01, 0x0a,
	0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x42, 0x0a, 0x53, 0x70, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2,
	0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70,
	0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_space_proto_rawDescOnce sync.Once
	file_google_chat_v1_space_proto_rawDescData = file_google_chat_v1_space_proto_rawDesc
)

func file_google_chat_v1_space_proto_rawDescGZIP() []byte {
	file_google_chat_v1_space_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_space_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_space_proto_rawDescData)
	})
	return file_google_chat_v1_space_proto_rawDescData
}

var file_google_chat_v1_space_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_chat_v1_space_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_chat_v1_space_proto_goTypes = []interface{}{
	(Space_Type)(0),                     // 0: google.chat.v1.Space.Type
	(Space_SpaceType)(0),                // 1: google.chat.v1.Space.SpaceType
	(Space_SpaceThreadingState)(0),      // 2: google.chat.v1.Space.SpaceThreadingState
	(*Space)(nil),                       // 3: google.chat.v1.Space
	(*CreateSpaceRequest)(nil),          // 4: google.chat.v1.CreateSpaceRequest
	(*ListSpacesRequest)(nil),           // 5: google.chat.v1.ListSpacesRequest
	(*ListSpacesResponse)(nil),          // 6: google.chat.v1.ListSpacesResponse
	(*GetSpaceRequest)(nil),             // 7: google.chat.v1.GetSpaceRequest
	(*FindDirectMessageRequest)(nil),    // 8: google.chat.v1.FindDirectMessageRequest
	(*UpdateSpaceRequest)(nil),          // 9: google.chat.v1.UpdateSpaceRequest
	(*DeleteSpaceRequest)(nil),          // 10: google.chat.v1.DeleteSpaceRequest
	(*CompleteImportSpaceRequest)(nil),  // 11: google.chat.v1.CompleteImportSpaceRequest
	(*CompleteImportSpaceResponse)(nil), // 12: google.chat.v1.CompleteImportSpaceResponse
	(*Space_SpaceDetails)(nil),          // 13: google.chat.v1.Space.SpaceDetails
	(HistoryState)(0),                   // 14: google.chat.v1.HistoryState
	(*timestamppb.Timestamp)(nil),       // 15: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),       // 16: google.protobuf.FieldMask
}
var file_google_chat_v1_space_proto_depIdxs = []int32{
	0,  // 0: google.chat.v1.Space.type:type_name -> google.chat.v1.Space.Type
	1,  // 1: google.chat.v1.Space.space_type:type_name -> google.chat.v1.Space.SpaceType
	2,  // 2: google.chat.v1.Space.space_threading_state:type_name -> google.chat.v1.Space.SpaceThreadingState
	13, // 3: google.chat.v1.Space.space_details:type_name -> google.chat.v1.Space.SpaceDetails
	14, // 4: google.chat.v1.Space.space_history_state:type_name -> google.chat.v1.HistoryState
	15, // 5: google.chat.v1.Space.create_time:type_name -> google.protobuf.Timestamp
	3,  // 6: google.chat.v1.CreateSpaceRequest.space:type_name -> google.chat.v1.Space
	3,  // 7: google.chat.v1.ListSpacesResponse.spaces:type_name -> google.chat.v1.Space
	3,  // 8: google.chat.v1.UpdateSpaceRequest.space:type_name -> google.chat.v1.Space
	16, // 9: google.chat.v1.UpdateSpaceRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 10: google.chat.v1.CompleteImportSpaceResponse.space:type_name -> google.chat.v1.Space
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_chat_v1_space_proto_init() }
func file_google_chat_v1_space_proto_init() {
	if File_google_chat_v1_space_proto != nil {
		return
	}
	file_google_chat_v1_history_state_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_chat_v1_space_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Space); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FindDirectMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteImportSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteImportSpaceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_space_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Space_SpaceDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_space_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_space_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_space_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_space_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_space_proto_msgTypes,
	}.Build()
	File_google_chat_v1_space_proto = out.File
	file_google_chat_v1_space_proto_rawDesc = nil
	file_google_chat_v1_space_proto_goTypes = nil
	file_google_chat_v1_space_proto_depIdxs = nil
}
