// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/page.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A Dialogflow CX conversation (session) can be described and visualized as a
// state machine. The states of a CX session are represented by pages.
//
// For each flow, you define many pages, where your combined pages can handle a
// complete conversation on the topics the flow is designed for. At any given
// moment, exactly one page is the current page, the current page is considered
// active, and the flow associated with that page is considered active. Every
// flow has a special start page. When a flow initially becomes active, the
// start page page becomes the current page. For each conversational turn, the
// current page will either stay the same or transition to another page.
//
// You configure each page to collect information from the end-user that is
// relevant for the conversational state represented by the page.
//
// For more information, see the
// [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
type Page struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the page.
	// Required for the
	// [Pages.UpdatePage][google.cloud.dialogflow.cx.v3beta1.Pages.UpdatePage]
	// method.
	// [Pages.CreatePage][google.cloud.dialogflow.cx.v3beta1.Pages.CreatePage]
	// populates the name automatically.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the page, unique within the flow.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the page. The maximum length is 500 characters.
	Description string `protobuf:"bytes,19,opt,name=description,proto3" json:"description,omitempty"`
	// The fulfillment to call when the session is entering the page.
	EntryFulfillment *Fulfillment `protobuf:"bytes,7,opt,name=entry_fulfillment,json=entryFulfillment,proto3" json:"entry_fulfillment,omitempty"`
	// The form associated with the page, used for collecting parameters
	// relevant to the page.
	Form *Form `protobuf:"bytes,4,opt,name=form,proto3" json:"form,omitempty"`
	// Ordered list of
	// [`TransitionRouteGroups`][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup]
	// added to the page. Transition route groups must be unique within a page. If
	// the page links both flow-level transition route groups and agent-level
	// transition route groups, the flow-level ones will have higher priority and
	// will be put before the agent-level ones.
	//
	//   - If multiple transition routes within a page scope refer to the same
	//     intent, then the precedence order is: page's transition route -> page's
	//     transition route group -> flow's transition routes.
	//
	//   - If multiple transition route groups within a page contain the same
	//     intent, then the first group in the ordered list takes precedence.
	//
	// Format:`projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>`
	// or `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/transitionRouteGroups/<TransitionRouteGroup ID>` for agent-level
	// groups.
	TransitionRouteGroups []string `protobuf:"bytes,11,rep,name=transition_route_groups,json=transitionRouteGroups,proto3" json:"transition_route_groups,omitempty"`
	// A list of transitions for the transition rules of this page.
	// They route the conversation to another page in the same flow, or another
	// flow.
	//
	// When we are in a certain page, the TransitionRoutes are evalauted in the
	// following order:
	//
	//   - TransitionRoutes defined in the page with intent specified.
	//   - TransitionRoutes defined in the
	//     [transition route
	//     groups][google.cloud.dialogflow.cx.v3beta1.Page.transition_route_groups]
	//     with intent specified.
	//   - TransitionRoutes defined in flow with intent specified.
	//   - TransitionRoutes defined in the
	//     [transition route
	//     groups][google.cloud.dialogflow.cx.v3beta1.Flow.transition_route_groups]
	//     with intent specified.
	//   - TransitionRoutes defined in the page with only condition specified.
	//   - TransitionRoutes defined in the
	//     [transition route
	//     groups][google.cloud.dialogflow.cx.v3beta1.Page.transition_route_groups]
	//     with only condition specified.
	TransitionRoutes []*TransitionRoute `protobuf:"bytes,9,rep,name=transition_routes,json=transitionRoutes,proto3" json:"transition_routes,omitempty"`
	// Handlers associated with the page to handle events such as webhook errors,
	// no match or no input.
	EventHandlers []*EventHandler `protobuf:"bytes,10,rep,name=event_handlers,json=eventHandlers,proto3" json:"event_handlers,omitempty"`
	// Hierarchical advanced settings for this page. The settings exposed at the
	// lower level overrides the settings exposed at the higher level.
	AdvancedSettings *AdvancedSettings `protobuf:"bytes,13,opt,name=advanced_settings,json=advancedSettings,proto3" json:"advanced_settings,omitempty"`
	// Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *KnowledgeConnectorSettings `protobuf:"bytes,18,opt,name=knowledge_connector_settings,json=knowledgeConnectorSettings,proto3" json:"knowledge_connector_settings,omitempty"`
}

func (x *Page) Reset() {
	*x = Page{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Page) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Page) ProtoMessage() {}

func (x *Page) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Page.ProtoReflect.Descriptor instead.
func (*Page) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{0}
}

func (x *Page) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Page) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Page) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Page) GetEntryFulfillment() *Fulfillment {
	if x != nil {
		return x.EntryFulfillment
	}
	return nil
}

func (x *Page) GetForm() *Form {
	if x != nil {
		return x.Form
	}
	return nil
}

func (x *Page) GetTransitionRouteGroups() []string {
	if x != nil {
		return x.TransitionRouteGroups
	}
	return nil
}

func (x *Page) GetTransitionRoutes() []*TransitionRoute {
	if x != nil {
		return x.TransitionRoutes
	}
	return nil
}

func (x *Page) GetEventHandlers() []*EventHandler {
	if x != nil {
		return x.EventHandlers
	}
	return nil
}

func (x *Page) GetAdvancedSettings() *AdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

func (x *Page) GetKnowledgeConnectorSettings() *KnowledgeConnectorSettings {
	if x != nil {
		return x.KnowledgeConnectorSettings
	}
	return nil
}

// A form is a data model that groups related parameters that can be collected
// from the user. The process in which the agent prompts the user and collects
// parameter values from the user is called form filling. A form can be added to
// a [page][google.cloud.dialogflow.cx.v3beta1.Page]. When form filling is done,
// the filled parameters will be written to the
// [session][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
type Form struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters to collect from the user.
	Parameters []*Form_Parameter `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *Form) Reset() {
	*x = Form{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Form) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Form) ProtoMessage() {}

func (x *Form) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Form.ProtoReflect.Descriptor instead.
func (*Form) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{1}
}

func (x *Form) GetParameters() []*Form_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// An event handler specifies an
// [event][google.cloud.dialogflow.cx.v3beta1.EventHandler.event] that can be
// handled during a session. When the specified event happens, the following
// actions are taken in order:
//
// *   If there is a
// [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3beta1.EventHandler.trigger_fulfillment]
// associated with the event, it will be called.
// *   If there is a
// [`target_page`][google.cloud.dialogflow.cx.v3beta1.EventHandler.target_page]
// associated with the event, the session will transition into the specified
// page.
// *   If there is a
// [`target_flow`][google.cloud.dialogflow.cx.v3beta1.EventHandler.target_flow]
// associated with the event, the session will transition into the specified
// flow.
type EventHandler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of this event handler.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the event to handle.
	Event string `protobuf:"bytes,4,opt,name=event,proto3" json:"event,omitempty"`
	// The fulfillment to call when the event occurs.
	// Handling webhook errors with a fulfillment enabled with webhook could
	// cause infinite loop. It is invalid to specify such fulfillment for a
	// handler handling webhooks.
	TriggerFulfillment *Fulfillment `protobuf:"bytes,5,opt,name=trigger_fulfillment,json=triggerFulfillment,proto3" json:"trigger_fulfillment,omitempty"`
	// The target to transition to, either a page in the same host flow (the flow
	// that owns this
	// [TransitionRoute][google.cloud.dialogflow.cx.v3beta1.TransitionRoute]), or
	// another flow in the same agent.
	//
	// Types that are assignable to Target:
	//
	//	*EventHandler_TargetPage
	//	*EventHandler_TargetFlow
	Target isEventHandler_Target `protobuf_oneof:"target"`
}

func (x *EventHandler) Reset() {
	*x = EventHandler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventHandler) ProtoMessage() {}

func (x *EventHandler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventHandler.ProtoReflect.Descriptor instead.
func (*EventHandler) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{2}
}

func (x *EventHandler) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EventHandler) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (x *EventHandler) GetTriggerFulfillment() *Fulfillment {
	if x != nil {
		return x.TriggerFulfillment
	}
	return nil
}

func (m *EventHandler) GetTarget() isEventHandler_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *EventHandler) GetTargetPage() string {
	if x, ok := x.GetTarget().(*EventHandler_TargetPage); ok {
		return x.TargetPage
	}
	return ""
}

func (x *EventHandler) GetTargetFlow() string {
	if x, ok := x.GetTarget().(*EventHandler_TargetFlow); ok {
		return x.TargetFlow
	}
	return ""
}

type isEventHandler_Target interface {
	isEventHandler_Target()
}

type EventHandler_TargetPage struct {
	// The target page to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	TargetPage string `protobuf:"bytes,2,opt,name=target_page,json=targetPage,proto3,oneof"`
}

type EventHandler_TargetFlow struct {
	// The target flow to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	TargetFlow string `protobuf:"bytes,3,opt,name=target_flow,json=targetFlow,proto3,oneof"`
}

func (*EventHandler_TargetPage) isEventHandler_Target() {}

func (*EventHandler_TargetFlow) isEventHandler_Target() {}

// A transition route specifies a
// [intent][google.cloud.dialogflow.cx.v3beta1.Intent] that can be matched
// and/or a data condition that can be evaluated during a session. When a
// specified transition is matched, the following actions are taken in order:
//
// *   If there is a
// [`trigger_fulfillment`][google.cloud.dialogflow.cx.v3beta1.TransitionRoute.trigger_fulfillment]
// associated with the transition, it will be called.
// *   If there is a
// [`target_page`][google.cloud.dialogflow.cx.v3beta1.TransitionRoute.target_page]
// associated with the transition, the session will transition into the
// specified page.
// *   If there is a
// [`target_flow`][google.cloud.dialogflow.cx.v3beta1.TransitionRoute.target_flow]
// associated with the transition, the session will transition into the
// specified flow.
type TransitionRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of this transition route.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the transition route. The maximum length is
	// 500 characters.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// The unique identifier of an
	// [Intent][google.cloud.dialogflow.cx.v3beta1.Intent]. Format:
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	// Indicates that the transition can only happen when the given intent is
	// matched.
	// At least one of `intent` or `condition` must be specified. When both
	// `intent` and `condition` are specified, the transition can only happen
	// when both are fulfilled.
	Intent string `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// The condition to evaluate against [form
	// parameters][google.cloud.dialogflow.cx.v3beta1.Form.parameters] or [session
	// parameters][google.cloud.dialogflow.cx.v3beta1.SessionInfo.parameters].
	//
	// See the [conditions
	// reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	// At least one of `intent` or `condition` must be specified. When both
	// `intent` and `condition` are specified, the transition can only happen
	// when both are fulfilled.
	Condition string `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
	// The fulfillment to call when the condition is satisfied. At least one of
	// `trigger_fulfillment` and `target` must be specified. When both are
	// defined, `trigger_fulfillment` is executed first.
	TriggerFulfillment *Fulfillment `protobuf:"bytes,3,opt,name=trigger_fulfillment,json=triggerFulfillment,proto3" json:"trigger_fulfillment,omitempty"`
	// The target to transition to, either a page in the same host flow (the flow
	// that owns this
	// [TransitionRoute][google.cloud.dialogflow.cx.v3beta1.TransitionRoute]), or
	// another flow in the same agent.
	//
	// Types that are assignable to Target:
	//
	//	*TransitionRoute_TargetPage
	//	*TransitionRoute_TargetFlow
	Target isTransitionRoute_Target `protobuf_oneof:"target"`
}

func (x *TransitionRoute) Reset() {
	*x = TransitionRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionRoute) ProtoMessage() {}

func (x *TransitionRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionRoute.ProtoReflect.Descriptor instead.
func (*TransitionRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{3}
}

func (x *TransitionRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransitionRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransitionRoute) GetIntent() string {
	if x != nil {
		return x.Intent
	}
	return ""
}

func (x *TransitionRoute) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *TransitionRoute) GetTriggerFulfillment() *Fulfillment {
	if x != nil {
		return x.TriggerFulfillment
	}
	return nil
}

func (m *TransitionRoute) GetTarget() isTransitionRoute_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *TransitionRoute) GetTargetPage() string {
	if x, ok := x.GetTarget().(*TransitionRoute_TargetPage); ok {
		return x.TargetPage
	}
	return ""
}

func (x *TransitionRoute) GetTargetFlow() string {
	if x, ok := x.GetTarget().(*TransitionRoute_TargetFlow); ok {
		return x.TargetFlow
	}
	return ""
}

type isTransitionRoute_Target interface {
	isTransitionRoute_Target()
}

type TransitionRoute_TargetPage struct {
	// The target page to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	TargetPage string `protobuf:"bytes,4,opt,name=target_page,json=targetPage,proto3,oneof"`
}

type TransitionRoute_TargetFlow struct {
	// The target flow to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	TargetFlow string `protobuf:"bytes,5,opt,name=target_flow,json=targetFlow,proto3,oneof"`
}

func (*TransitionRoute_TargetPage) isTransitionRoute_Target() {}

func (*TransitionRoute_TargetFlow) isTransitionRoute_Target() {}

// The request message for
// [Pages.ListPages][google.cloud.dialogflow.cx.v3beta1.Pages.ListPages].
type ListPagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow to list all pages for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The language to list pages for. The following fields are language
	// dependent:
	//
	// *  `Page.entry_fulfillment.messages`
	// *  `Page.entry_fulfillment.conditional_cases`
	// *  `Page.event_handlers.trigger_fulfillment.messages`
	// *  `Page.event_handlers.trigger_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages`
	// *
	// `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.reprompt_event_handlers.messages`
	// *
	// `Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases`
	// *  `Page.transition_routes.trigger_fulfillment.messages`
	// *  `Page.transition_routes.trigger_fulfillment.conditional_cases`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPagesRequest) Reset() {
	*x = ListPagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPagesRequest) ProtoMessage() {}

func (x *ListPagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPagesRequest.ProtoReflect.Descriptor instead.
func (*ListPagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{4}
}

func (x *ListPagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPagesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListPagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Pages.ListPages][google.cloud.dialogflow.cx.v3beta1.Pages.ListPages].
type ListPagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of pages. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Pages []*Page `protobuf:"bytes,1,rep,name=pages,proto3" json:"pages,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPagesResponse) Reset() {
	*x = ListPagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPagesResponse) ProtoMessage() {}

func (x *ListPagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPagesResponse.ProtoReflect.Descriptor instead.
func (*ListPagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{5}
}

func (x *ListPagesResponse) GetPages() []*Page {
	if x != nil {
		return x.Pages
	}
	return nil
}

func (x *ListPagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Pages.GetPage][google.cloud.dialogflow.cx.v3beta1.Pages.GetPage].
type GetPageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the page.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The language to retrieve the page for. The following fields are language
	// dependent:
	//
	// *  `Page.entry_fulfillment.messages`
	// *  `Page.entry_fulfillment.conditional_cases`
	// *  `Page.event_handlers.trigger_fulfillment.messages`
	// *  `Page.event_handlers.trigger_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages`
	// *
	// `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.reprompt_event_handlers.messages`
	// *
	// `Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases`
	// *  `Page.transition_routes.trigger_fulfillment.messages`
	// *  `Page.transition_routes.trigger_fulfillment.conditional_cases`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetPageRequest) Reset() {
	*x = GetPageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPageRequest) ProtoMessage() {}

func (x *GetPageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPageRequest.ProtoReflect.Descriptor instead.
func (*GetPageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{6}
}

func (x *GetPageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPageRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Pages.CreatePage][google.cloud.dialogflow.cx.v3beta1.Pages.CreatePage].
type CreatePageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The flow to create a page for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The page to create.
	Page *Page `protobuf:"bytes,2,opt,name=page,proto3" json:"page,omitempty"`
	// The language of the following fields in `page`:
	//
	// *  `Page.entry_fulfillment.messages`
	// *  `Page.entry_fulfillment.conditional_cases`
	// *  `Page.event_handlers.trigger_fulfillment.messages`
	// *  `Page.event_handlers.trigger_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages`
	// *
	// `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.reprompt_event_handlers.messages`
	// *
	// `Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases`
	// *  `Page.transition_routes.trigger_fulfillment.messages`
	// *  `Page.transition_routes.trigger_fulfillment.conditional_cases`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreatePageRequest) Reset() {
	*x = CreatePageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePageRequest) ProtoMessage() {}

func (x *CreatePageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePageRequest.ProtoReflect.Descriptor instead.
func (*CreatePageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{7}
}

func (x *CreatePageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePageRequest) GetPage() *Page {
	if x != nil {
		return x.Page
	}
	return nil
}

func (x *CreatePageRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Pages.UpdatePage][google.cloud.dialogflow.cx.v3beta1.Pages.UpdatePage].
type UpdatePageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The page to update.
	Page *Page `protobuf:"bytes,1,opt,name=page,proto3" json:"page,omitempty"`
	// The language of the following fields in `page`:
	//
	// *  `Page.entry_fulfillment.messages`
	// *  `Page.entry_fulfillment.conditional_cases`
	// *  `Page.event_handlers.trigger_fulfillment.messages`
	// *  `Page.event_handlers.trigger_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages`
	// *
	// `Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases`
	// *  `Page.form.parameters.fill_behavior.reprompt_event_handlers.messages`
	// *
	// `Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases`
	// *  `Page.transition_routes.trigger_fulfillment.messages`
	// *  `Page.transition_routes.trigger_fulfillment.conditional_cases`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePageRequest) Reset() {
	*x = UpdatePageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePageRequest) ProtoMessage() {}

func (x *UpdatePageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePageRequest.ProtoReflect.Descriptor instead.
func (*UpdatePageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{8}
}

func (x *UpdatePageRequest) GetPage() *Page {
	if x != nil {
		return x.Page
	}
	return nil
}

func (x *UpdatePageRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdatePageRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Pages.DeletePage][google.cloud.dialogflow.cx.v3beta1.Pages.DeletePage].
type DeletePageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the page to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/Flows/<flow ID>/pages/<Page ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for pages with no incoming transitions.
	// For pages with incoming transitions:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the incoming transitions.
	//   - If `force` is set to true, Dialogflow will remove the page, as well as
	//     any transitions to the page (i.e. [Target
	//     page][EventHandler.target_page] in event handlers or [Target
	//     page][TransitionRoute.target_page] in transition routes that point to
	//     this page will be cleared).
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeletePageRequest) Reset() {
	*x = DeletePageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePageRequest) ProtoMessage() {}

func (x *DeletePageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePageRequest.ProtoReflect.Descriptor instead.
func (*DeletePageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{9}
}

func (x *DeletePageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePageRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The Knowledge Connector settings for this page or flow.
// This includes information such as the attached Knowledge Bases, and the way
// to execute fulfillment.
type KnowledgeConnectorSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Knowledge Connector is enabled or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The fulfillment to be triggered.
	//
	// When the answers from the Knowledge Connector are selected by Dialogflow,
	// you can utitlize the request scoped parameter `$request.knowledge.answers`
	// (contains up to the 5 highest confidence answers) and
	// `$request.knowledge.questions` (contains the corresponding questions) to
	// construct the fulfillment.
	TriggerFulfillment *Fulfillment `protobuf:"bytes,3,opt,name=trigger_fulfillment,json=triggerFulfillment,proto3" json:"trigger_fulfillment,omitempty"`
	// The target to transition to, either a page in the same host flow (the flow
	// that owns this
	// [KnowledgeConnectorSettings][google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings]),
	// or another flow in the same agent.
	//
	// Types that are assignable to Target:
	//
	//	*KnowledgeConnectorSettings_TargetPage
	//	*KnowledgeConnectorSettings_TargetFlow
	Target isKnowledgeConnectorSettings_Target `protobuf_oneof:"target"`
	// Optional. List of related data store connections.
	DataStoreConnections []*DataStoreConnection `protobuf:"bytes,6,rep,name=data_store_connections,json=dataStoreConnections,proto3" json:"data_store_connections,omitempty"`
}

func (x *KnowledgeConnectorSettings) Reset() {
	*x = KnowledgeConnectorSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KnowledgeConnectorSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeConnectorSettings) ProtoMessage() {}

func (x *KnowledgeConnectorSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeConnectorSettings.ProtoReflect.Descriptor instead.
func (*KnowledgeConnectorSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{10}
}

func (x *KnowledgeConnectorSettings) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *KnowledgeConnectorSettings) GetTriggerFulfillment() *Fulfillment {
	if x != nil {
		return x.TriggerFulfillment
	}
	return nil
}

func (m *KnowledgeConnectorSettings) GetTarget() isKnowledgeConnectorSettings_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *KnowledgeConnectorSettings) GetTargetPage() string {
	if x, ok := x.GetTarget().(*KnowledgeConnectorSettings_TargetPage); ok {
		return x.TargetPage
	}
	return ""
}

func (x *KnowledgeConnectorSettings) GetTargetFlow() string {
	if x, ok := x.GetTarget().(*KnowledgeConnectorSettings_TargetFlow); ok {
		return x.TargetFlow
	}
	return ""
}

func (x *KnowledgeConnectorSettings) GetDataStoreConnections() []*DataStoreConnection {
	if x != nil {
		return x.DataStoreConnections
	}
	return nil
}

type isKnowledgeConnectorSettings_Target interface {
	isKnowledgeConnectorSettings_Target()
}

type KnowledgeConnectorSettings_TargetPage struct {
	// The target page to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	TargetPage string `protobuf:"bytes,4,opt,name=target_page,json=targetPage,proto3,oneof"`
}

type KnowledgeConnectorSettings_TargetFlow struct {
	// The target flow to transition to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	TargetFlow string `protobuf:"bytes,5,opt,name=target_flow,json=targetFlow,proto3,oneof"`
}

func (*KnowledgeConnectorSettings_TargetPage) isKnowledgeConnectorSettings_Target() {}

func (*KnowledgeConnectorSettings_TargetFlow) isKnowledgeConnectorSettings_Target() {}

// Represents a form parameter.
type Form_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The human-readable name of the parameter, unique within the
	// form.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Indicates whether the parameter is required. Optional parameters will not
	// trigger prompts; however, they are filled if the user specifies them.
	// Required parameters must be filled before form filling concludes.
	Required bool `protobuf:"varint,2,opt,name=required,proto3" json:"required,omitempty"`
	// Required. The entity type of the parameter.
	// Format: `projects/-/locations/-/agents/-/entityTypes/<System Entity Type
	// ID>` for system entity types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/entityTypes/<Entity Type ID>` for developer entity types.
	EntityType string `protobuf:"bytes,3,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Indicates whether the parameter represents a list of values.
	IsList bool `protobuf:"varint,4,opt,name=is_list,json=isList,proto3" json:"is_list,omitempty"`
	// Required. Defines fill behavior for the parameter.
	FillBehavior *Form_Parameter_FillBehavior `protobuf:"bytes,7,opt,name=fill_behavior,json=fillBehavior,proto3" json:"fill_behavior,omitempty"`
	// The default value of an optional parameter. If the parameter is required,
	// the default value will be ignored.
	DefaultValue *structpb.Value `protobuf:"bytes,9,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Indicates whether the parameter content should be redacted in log.  If
	// redaction is enabled, the parameter content will be replaced by parameter
	// name during logging.
	// Note: the parameter content is subject to redaction if either parameter
	// level redaction or [entity type level
	// redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
	// enabled.
	Redact bool `protobuf:"varint,11,opt,name=redact,proto3" json:"redact,omitempty"`
	// Hierarchical advanced settings for this parameter. The settings exposed
	// at the lower level overrides the settings exposed at the higher level.
	AdvancedSettings *AdvancedSettings `protobuf:"bytes,12,opt,name=advanced_settings,json=advancedSettings,proto3" json:"advanced_settings,omitempty"`
}

func (x *Form_Parameter) Reset() {
	*x = Form_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Form_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Form_Parameter) ProtoMessage() {}

func (x *Form_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Form_Parameter.ProtoReflect.Descriptor instead.
func (*Form_Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Form_Parameter) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Form_Parameter) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Form_Parameter) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *Form_Parameter) GetIsList() bool {
	if x != nil {
		return x.IsList
	}
	return false
}

func (x *Form_Parameter) GetFillBehavior() *Form_Parameter_FillBehavior {
	if x != nil {
		return x.FillBehavior
	}
	return nil
}

func (x *Form_Parameter) GetDefaultValue() *structpb.Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

func (x *Form_Parameter) GetRedact() bool {
	if x != nil {
		return x.Redact
	}
	return false
}

func (x *Form_Parameter) GetAdvancedSettings() *AdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

// Configuration for how the filling of a parameter should be handled.
type Form_Parameter_FillBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fulfillment to provide the initial prompt that the agent
	// can present to the user in order to fill the parameter.
	InitialPromptFulfillment *Fulfillment `protobuf:"bytes,3,opt,name=initial_prompt_fulfillment,json=initialPromptFulfillment,proto3" json:"initial_prompt_fulfillment,omitempty"`
	// The handlers for parameter-level events, used to provide reprompt for
	// the parameter or transition to a different page/flow. The supported
	// events are:
	// *   `sys.no-match-<N>`, where N can be from 1 to 6
	// *   `sys.no-match-default`
	// *   `sys.no-input-<N>`, where N can be from 1 to 6
	// *   `sys.no-input-default`
	// *   `sys.invalid-parameter`
	//
	// `initial_prompt_fulfillment` provides the first prompt for the
	// parameter.
	//
	// If the user's response does not fill the parameter, a
	// no-match/no-input event will be triggered, and the fulfillment
	// associated with the `sys.no-match-1`/`sys.no-input-1` handler (if
	// defined) will be called to provide a prompt. The
	// `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to
	// the next no-match/no-input event, and so on.
	//
	// A `sys.no-match-default` or `sys.no-input-default` handler will be used
	// to handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed.
	//
	// A `sys.invalid-parameter` handler can be defined to handle the case
	// where the parameter values have been `invalidated` by webhook. For
	// example, if the user's response fill the parameter, however the
	// parameter was invalidated by webhook, the fulfillment associated with
	// the `sys.invalid-parameter` handler (if defined) will be called to
	// provide a prompt.
	//
	// If the event handler for the corresponding event can't be found on the
	// parameter, `initial_prompt_fulfillment` will be re-prompted.
	RepromptEventHandlers []*EventHandler `protobuf:"bytes,5,rep,name=reprompt_event_handlers,json=repromptEventHandlers,proto3" json:"reprompt_event_handlers,omitempty"`
}

func (x *Form_Parameter_FillBehavior) Reset() {
	*x = Form_Parameter_FillBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Form_Parameter_FillBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Form_Parameter_FillBehavior) ProtoMessage() {}

func (x *Form_Parameter_FillBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Form_Parameter_FillBehavior.ProtoReflect.Descriptor instead.
func (*Form_Parameter_FillBehavior) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *Form_Parameter_FillBehavior) GetInitialPromptFulfillment() *Fulfillment {
	if x != nil {
		return x.InitialPromptFulfillment
	}
	return nil
}

func (x *Form_Parameter_FillBehavior) GetRepromptEventHandlers() []*EventHandler {
	if x != nil {
		return x.RepromptEventHandlers
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3beta1_page_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x07, 0x0a, 0x04, 0x50, 0x61, 0x67, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x11,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c,
	0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x46,
	0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x66, 0x6f,
	0x72, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6f,
	0x72, 0x6d, 0x52, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x6b, 0x0a, 0x17, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x33, 0xfa, 0x41, 0x30, 0x0a, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x15,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x60, 0x0a, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x0e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x52, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73,
	0x12, 0x61, 0x0a, 0x11, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x1c, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1a, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x75, 0xea, 0x41, 0x72,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65,
	0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x7b,
	0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x67,
	0x65, 0x7d, 0x22, 0xa6, 0x06, 0x0a, 0x04, 0x46, 0x6f, 0x72, 0x6d, 0x12, 0x52, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a,
	0xc9, 0x05, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x69, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x0d, 0x66, 0x69, 0x6c,
	0x6c, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x6c, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x6c, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x12, 0x3b, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x12, 0x61, 0x0a, 0x11, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10, 0x61, 0x64, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xec, 0x01, 0x0a,
	0x0c, 0x46, 0x69, 0x6c, 0x6c, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x72, 0x0a,
	0x1a, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f,
	0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x68, 0x0a, 0x17, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x72, 0x52, 0x15, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x73, 0x22, 0xbe, 0x02, 0x0a, 0x0c,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x60, 0x0a, 0x13, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x66, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c,
	0x6f, 0x77, 0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xaa, 0x03, 0x0a,
	0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3d, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x60, 0x0a,
	0x13, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x46, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f,
	0x77, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x42,
	0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xb3, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x7b, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x05, 0x70,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x61, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22,
	0xbb, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xb8, 0x01,
	0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x61, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0xa6, 0x03, 0x0a, 0x1a, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x13, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x46,
	0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6c, 0x6f,
	0x77, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0a,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x77, 0x12, 0x72, 0x0a, 0x16, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x32, 0xda, 0x08, 0x0a, 0x05, 0x50, 0x61, 0x67,
	0x65, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f,
	0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x12,
	0xb7, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xca, 0x01, 0x0a, 0x0a, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x22, 0x5b, 0xda, 0x41, 0x0b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x61, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x22, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x12, 0xd4, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x67, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x22, 0x65, 0xda, 0x41, 0x10, 0x70, 0x61, 0x67, 0x65, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x3a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x32, 0x44, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x67, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f,
	0x77, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xab, 0x01,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xc3, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x42, 0x09, 0x50, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62,
	0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a,
	0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_dialogflow_cx_v3beta1_page_proto_goTypes = []interface{}{
	(*Page)(nil),                        // 0: google.cloud.dialogflow.cx.v3beta1.Page
	(*Form)(nil),                        // 1: google.cloud.dialogflow.cx.v3beta1.Form
	(*EventHandler)(nil),                // 2: google.cloud.dialogflow.cx.v3beta1.EventHandler
	(*TransitionRoute)(nil),             // 3: google.cloud.dialogflow.cx.v3beta1.TransitionRoute
	(*ListPagesRequest)(nil),            // 4: google.cloud.dialogflow.cx.v3beta1.ListPagesRequest
	(*ListPagesResponse)(nil),           // 5: google.cloud.dialogflow.cx.v3beta1.ListPagesResponse
	(*GetPageRequest)(nil),              // 6: google.cloud.dialogflow.cx.v3beta1.GetPageRequest
	(*CreatePageRequest)(nil),           // 7: google.cloud.dialogflow.cx.v3beta1.CreatePageRequest
	(*UpdatePageRequest)(nil),           // 8: google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest
	(*DeletePageRequest)(nil),           // 9: google.cloud.dialogflow.cx.v3beta1.DeletePageRequest
	(*KnowledgeConnectorSettings)(nil),  // 10: google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
	(*Form_Parameter)(nil),              // 11: google.cloud.dialogflow.cx.v3beta1.Form.Parameter
	(*Form_Parameter_FillBehavior)(nil), // 12: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
	(*Fulfillment)(nil),                 // 13: google.cloud.dialogflow.cx.v3beta1.Fulfillment
	(*AdvancedSettings)(nil),            // 14: google.cloud.dialogflow.cx.v3beta1.AdvancedSettings
	(*fieldmaskpb.FieldMask)(nil),       // 15: google.protobuf.FieldMask
	(*DataStoreConnection)(nil),         // 16: google.cloud.dialogflow.cx.v3beta1.DataStoreConnection
	(*structpb.Value)(nil),              // 17: google.protobuf.Value
	(*emptypb.Empty)(nil),               // 18: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3beta1_page_proto_depIdxs = []int32{
	13, // 0: google.cloud.dialogflow.cx.v3beta1.Page.entry_fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	1,  // 1: google.cloud.dialogflow.cx.v3beta1.Page.form:type_name -> google.cloud.dialogflow.cx.v3beta1.Form
	3,  // 2: google.cloud.dialogflow.cx.v3beta1.Page.transition_routes:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRoute
	2,  // 3: google.cloud.dialogflow.cx.v3beta1.Page.event_handlers:type_name -> google.cloud.dialogflow.cx.v3beta1.EventHandler
	14, // 4: google.cloud.dialogflow.cx.v3beta1.Page.advanced_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.AdvancedSettings
	10, // 5: google.cloud.dialogflow.cx.v3beta1.Page.knowledge_connector_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings
	11, // 6: google.cloud.dialogflow.cx.v3beta1.Form.parameters:type_name -> google.cloud.dialogflow.cx.v3beta1.Form.Parameter
	13, // 7: google.cloud.dialogflow.cx.v3beta1.EventHandler.trigger_fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	13, // 8: google.cloud.dialogflow.cx.v3beta1.TransitionRoute.trigger_fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	0,  // 9: google.cloud.dialogflow.cx.v3beta1.ListPagesResponse.pages:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	0,  // 10: google.cloud.dialogflow.cx.v3beta1.CreatePageRequest.page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	0,  // 11: google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest.page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	15, // 12: google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 13: google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.trigger_fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	16, // 14: google.cloud.dialogflow.cx.v3beta1.KnowledgeConnectorSettings.data_store_connections:type_name -> google.cloud.dialogflow.cx.v3beta1.DataStoreConnection
	12, // 15: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.fill_behavior:type_name -> google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior
	17, // 16: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.default_value:type_name -> google.protobuf.Value
	14, // 17: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.advanced_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.AdvancedSettings
	13, // 18: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.initial_prompt_fulfillment:type_name -> google.cloud.dialogflow.cx.v3beta1.Fulfillment
	2,  // 19: google.cloud.dialogflow.cx.v3beta1.Form.Parameter.FillBehavior.reprompt_event_handlers:type_name -> google.cloud.dialogflow.cx.v3beta1.EventHandler
	4,  // 20: google.cloud.dialogflow.cx.v3beta1.Pages.ListPages:input_type -> google.cloud.dialogflow.cx.v3beta1.ListPagesRequest
	6,  // 21: google.cloud.dialogflow.cx.v3beta1.Pages.GetPage:input_type -> google.cloud.dialogflow.cx.v3beta1.GetPageRequest
	7,  // 22: google.cloud.dialogflow.cx.v3beta1.Pages.CreatePage:input_type -> google.cloud.dialogflow.cx.v3beta1.CreatePageRequest
	8,  // 23: google.cloud.dialogflow.cx.v3beta1.Pages.UpdatePage:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest
	9,  // 24: google.cloud.dialogflow.cx.v3beta1.Pages.DeletePage:input_type -> google.cloud.dialogflow.cx.v3beta1.DeletePageRequest
	5,  // 25: google.cloud.dialogflow.cx.v3beta1.Pages.ListPages:output_type -> google.cloud.dialogflow.cx.v3beta1.ListPagesResponse
	0,  // 26: google.cloud.dialogflow.cx.v3beta1.Pages.GetPage:output_type -> google.cloud.dialogflow.cx.v3beta1.Page
	0,  // 27: google.cloud.dialogflow.cx.v3beta1.Pages.CreatePage:output_type -> google.cloud.dialogflow.cx.v3beta1.Page
	0,  // 28: google.cloud.dialogflow.cx.v3beta1.Pages.UpdatePage:output_type -> google.cloud.dialogflow.cx.v3beta1.Page
	18, // 29: google.cloud.dialogflow.cx.v3beta1.Pages.DeletePage:output_type -> google.protobuf.Empty
	25, // [25:30] is the sub-list for method output_type
	20, // [20:25] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_page_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_page_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_page_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_advanced_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_data_store_connection_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_fulfillment_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Page); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Form); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventHandler); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KnowledgeConnectorSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Form_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Form_Parameter_FillBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*EventHandler_TargetPage)(nil),
		(*EventHandler_TargetFlow)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*TransitionRoute_TargetPage)(nil),
		(*TransitionRoute_TargetFlow)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*KnowledgeConnectorSettings_TargetPage)(nil),
		(*KnowledgeConnectorSettings_TargetFlow)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_page_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_page_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_page_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_page_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PagesClient is the client API for Pages service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PagesClient interface {
	// Returns the list of all pages in the specified flow.
	ListPages(ctx context.Context, in *ListPagesRequest, opts ...grpc.CallOption) (*ListPagesResponse, error)
	// Retrieves the specified page.
	GetPage(ctx context.Context, in *GetPageRequest, opts ...grpc.CallOption) (*Page, error)
	// Creates a page in the specified flow.
	CreatePage(ctx context.Context, in *CreatePageRequest, opts ...grpc.CallOption) (*Page, error)
	// Updates the specified page.
	UpdatePage(ctx context.Context, in *UpdatePageRequest, opts ...grpc.CallOption) (*Page, error)
	// Deletes the specified page.
	DeletePage(ctx context.Context, in *DeletePageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type pagesClient struct {
	cc grpc.ClientConnInterface
}

func NewPagesClient(cc grpc.ClientConnInterface) PagesClient {
	return &pagesClient{cc}
}

func (c *pagesClient) ListPages(ctx context.Context, in *ListPagesRequest, opts ...grpc.CallOption) (*ListPagesResponse, error) {
	out := new(ListPagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Pages/ListPages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) GetPage(ctx context.Context, in *GetPageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Pages/GetPage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) CreatePage(ctx context.Context, in *CreatePageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Pages/CreatePage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) UpdatePage(ctx context.Context, in *UpdatePageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Pages/UpdatePage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) DeletePage(ctx context.Context, in *DeletePageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Pages/DeletePage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PagesServer is the server API for Pages service.
type PagesServer interface {
	// Returns the list of all pages in the specified flow.
	ListPages(context.Context, *ListPagesRequest) (*ListPagesResponse, error)
	// Retrieves the specified page.
	GetPage(context.Context, *GetPageRequest) (*Page, error)
	// Creates a page in the specified flow.
	CreatePage(context.Context, *CreatePageRequest) (*Page, error)
	// Updates the specified page.
	UpdatePage(context.Context, *UpdatePageRequest) (*Page, error)
	// Deletes the specified page.
	DeletePage(context.Context, *DeletePageRequest) (*emptypb.Empty, error)
}

// UnimplementedPagesServer can be embedded to have forward compatible implementations.
type UnimplementedPagesServer struct {
}

func (*UnimplementedPagesServer) ListPages(context.Context, *ListPagesRequest) (*ListPagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPages not implemented")
}
func (*UnimplementedPagesServer) GetPage(context.Context, *GetPageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPage not implemented")
}
func (*UnimplementedPagesServer) CreatePage(context.Context, *CreatePageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePage not implemented")
}
func (*UnimplementedPagesServer) UpdatePage(context.Context, *UpdatePageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePage not implemented")
}
func (*UnimplementedPagesServer) DeletePage(context.Context, *DeletePageRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePage not implemented")
}

func RegisterPagesServer(s *grpc.Server, srv PagesServer) {
	s.RegisterService(&_Pages_serviceDesc, srv)
}

func _Pages_ListPages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).ListPages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Pages/ListPages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).ListPages(ctx, req.(*ListPagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_GetPage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).GetPage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Pages/GetPage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).GetPage(ctx, req.(*GetPageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_CreatePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).CreatePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Pages/CreatePage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).CreatePage(ctx, req.(*CreatePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_UpdatePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).UpdatePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Pages/UpdatePage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).UpdatePage(ctx, req.(*UpdatePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_DeletePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).DeletePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Pages/DeletePage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).DeletePage(ctx, req.(*DeletePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Pages_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Pages",
	HandlerType: (*PagesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPages",
			Handler:    _Pages_ListPages_Handler,
		},
		{
			MethodName: "GetPage",
			Handler:    _Pages_GetPage_Handler,
		},
		{
			MethodName: "CreatePage",
			Handler:    _Pages_CreatePage_Handler,
		},
		{
			MethodName: "UpdatePage",
			Handler:    _Pages_UpdatePage_Handler,
		},
		{
			MethodName: "DeletePage",
			Handler:    _Pages_DeletePage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/page.proto",
}
