// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package migrationcenterpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the types of asset views that provide complete or partial details
// of an asset.
type AssetView int32

const (
	// The asset view is not specified. The API displays the basic view by
	// default.
	AssetView_ASSET_VIEW_UNSPECIFIED AssetView = 0
	// The asset view includes only basic metadata of the asset.
	AssetView_ASSET_VIEW_BASIC AssetView = 1
	// The asset view includes all the metadata of an asset and performance data.
	AssetView_ASSET_VIEW_FULL AssetView = 2
)

// Enum value maps for AssetView.
var (
	AssetView_name = map[int32]string{
		0: "ASSET_VIEW_UNSPECIFIED",
		1: "ASSET_VIEW_BASIC",
		2: "ASSET_VIEW_FULL",
	}
	AssetView_value = map[string]int32{
		"ASSET_VIEW_UNSPECIFIED": 0,
		"ASSET_VIEW_BASIC":       1,
		"ASSET_VIEW_FULL":        2,
	}
)

func (x AssetView) Enum() *AssetView {
	p := new(AssetView)
	*p = x
	return p
}

func (x AssetView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AssetView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[0].Descriptor()
}

func (AssetView) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[0]
}

func (x AssetView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AssetView.Descriptor instead.
func (AssetView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{0}
}

// Known categories of operating systems.
type OperatingSystemFamily int32

const (
	OperatingSystemFamily_OS_FAMILY_UNKNOWN OperatingSystemFamily = 0
	// Microsoft Windows Server and Desktop.
	OperatingSystemFamily_OS_FAMILY_WINDOWS OperatingSystemFamily = 1
	// Various Linux flavors.
	OperatingSystemFamily_OS_FAMILY_LINUX OperatingSystemFamily = 2
	// Non-Linux Unix flavors.
	OperatingSystemFamily_OS_FAMILY_UNIX OperatingSystemFamily = 3
)

// Enum value maps for OperatingSystemFamily.
var (
	OperatingSystemFamily_name = map[int32]string{
		0: "OS_FAMILY_UNKNOWN",
		1: "OS_FAMILY_WINDOWS",
		2: "OS_FAMILY_LINUX",
		3: "OS_FAMILY_UNIX",
	}
	OperatingSystemFamily_value = map[string]int32{
		"OS_FAMILY_UNKNOWN": 0,
		"OS_FAMILY_WINDOWS": 1,
		"OS_FAMILY_LINUX":   2,
		"OS_FAMILY_UNIX":    3,
	}
)

func (x OperatingSystemFamily) Enum() *OperatingSystemFamily {
	p := new(OperatingSystemFamily)
	*p = x
	return p
}

func (x OperatingSystemFamily) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperatingSystemFamily) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[1].Descriptor()
}

func (OperatingSystemFamily) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[1]
}

func (x OperatingSystemFamily) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperatingSystemFamily.Descriptor instead.
func (OperatingSystemFamily) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{1}
}

// Specifies the data formats supported by Migration Center.
type ImportJobFormat int32

const (
	// Default value.
	ImportJobFormat_IMPORT_JOB_FORMAT_UNSPECIFIED ImportJobFormat = 0
	// RVTools format (XLSX).
	ImportJobFormat_IMPORT_JOB_FORMAT_RVTOOLS_XLSX ImportJobFormat = 1
	// RVTools format (CSV).
	ImportJobFormat_IMPORT_JOB_FORMAT_RVTOOLS_CSV ImportJobFormat = 2
	// CSV format exported from AWS using the
	// [AWS collection
	// script][https://github.com/GoogleCloudPlatform/aws-to-stratozone-export].
	ImportJobFormat_IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV ImportJobFormat = 4
	// CSV format exported from Azure using the
	// [Azure collection
	// script][https://github.com/GoogleCloudPlatform/azure-to-stratozone-export].
	ImportJobFormat_IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV ImportJobFormat = 5
	// CSV format created manually and following the StratoZone format. For more
	// information, see [Manually create and upload data
	// tables][https://cloud.google.com/migrate/stratozone/docs/import-data-portal].
	ImportJobFormat_IMPORT_JOB_FORMAT_STRATOZONE_CSV ImportJobFormat = 6
)

// Enum value maps for ImportJobFormat.
var (
	ImportJobFormat_name = map[int32]string{
		0: "IMPORT_JOB_FORMAT_UNSPECIFIED",
		1: "IMPORT_JOB_FORMAT_RVTOOLS_XLSX",
		2: "IMPORT_JOB_FORMAT_RVTOOLS_CSV",
		4: "IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV",
		5: "IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV",
		6: "IMPORT_JOB_FORMAT_STRATOZONE_CSV",
	}
	ImportJobFormat_value = map[string]int32{
		"IMPORT_JOB_FORMAT_UNSPECIFIED":        0,
		"IMPORT_JOB_FORMAT_RVTOOLS_XLSX":       1,
		"IMPORT_JOB_FORMAT_RVTOOLS_CSV":        2,
		"IMPORT_JOB_FORMAT_EXPORTED_AWS_CSV":   4,
		"IMPORT_JOB_FORMAT_EXPORTED_AZURE_CSV": 5,
		"IMPORT_JOB_FORMAT_STRATOZONE_CSV":     6,
	}
)

func (x ImportJobFormat) Enum() *ImportJobFormat {
	p := new(ImportJobFormat)
	*p = x
	return p
}

func (x ImportJobFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportJobFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[2].Descriptor()
}

func (ImportJobFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[2]
}

func (x ImportJobFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportJobFormat.Descriptor instead.
func (ImportJobFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{2}
}

// Specifies the types of import job views that provide complete or partial
// details of an import job.
type ImportJobView int32

const (
	// The import job view is not specified. The API displays the basic view by
	// default.
	ImportJobView_IMPORT_JOB_VIEW_UNSPECIFIED ImportJobView = 0
	// The import job view includes basic metadata of an import job.
	// This view does not include payload information.
	ImportJobView_IMPORT_JOB_VIEW_BASIC ImportJobView = 1
	// The import job view includes all metadata of an import job.
	ImportJobView_IMPORT_JOB_VIEW_FULL ImportJobView = 2
)

// Enum value maps for ImportJobView.
var (
	ImportJobView_name = map[int32]string{
		0: "IMPORT_JOB_VIEW_UNSPECIFIED",
		1: "IMPORT_JOB_VIEW_BASIC",
		2: "IMPORT_JOB_VIEW_FULL",
	}
	ImportJobView_value = map[string]int32{
		"IMPORT_JOB_VIEW_UNSPECIFIED": 0,
		"IMPORT_JOB_VIEW_BASIC":       1,
		"IMPORT_JOB_VIEW_FULL":        2,
	}
)

func (x ImportJobView) Enum() *ImportJobView {
	p := new(ImportJobView)
	*p = x
	return p
}

func (x ImportJobView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportJobView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[3].Descriptor()
}

func (ImportJobView) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[3]
}

func (x ImportJobView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportJobView.Descriptor instead.
func (ImportJobView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{3}
}

// ErrorFrameView can be specified in ErrorFrames List and Get requests to
// control the level of details that is returned for the original frame.
type ErrorFrameView int32

const (
	// Value is unset. The system will fallback to the default value.
	ErrorFrameView_ERROR_FRAME_VIEW_UNSPECIFIED ErrorFrameView = 0
	// Include basic frame data, but not the full contents.
	ErrorFrameView_ERROR_FRAME_VIEW_BASIC ErrorFrameView = 1
	// Include everything.
	ErrorFrameView_ERROR_FRAME_VIEW_FULL ErrorFrameView = 2
)

// Enum value maps for ErrorFrameView.
var (
	ErrorFrameView_name = map[int32]string{
		0: "ERROR_FRAME_VIEW_UNSPECIFIED",
		1: "ERROR_FRAME_VIEW_BASIC",
		2: "ERROR_FRAME_VIEW_FULL",
	}
	ErrorFrameView_value = map[string]int32{
		"ERROR_FRAME_VIEW_UNSPECIFIED": 0,
		"ERROR_FRAME_VIEW_BASIC":       1,
		"ERROR_FRAME_VIEW_FULL":        2,
	}
)

func (x ErrorFrameView) Enum() *ErrorFrameView {
	p := new(ErrorFrameView)
	*p = x
	return p
}

func (x ErrorFrameView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorFrameView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[4].Descriptor()
}

func (ErrorFrameView) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[4]
}

func (x ErrorFrameView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorFrameView.Descriptor instead.
func (ErrorFrameView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{4}
}

// The persistent disk (PD) types of Compute Engine virtual machines.
type PersistentDiskType int32

const (
	// Unspecified (default value).
	// Selecting this value allows the system to use any disk type according
	// to reported usage. This a good value to start with.
	PersistentDiskType_PERSISTENT_DISK_TYPE_UNSPECIFIED PersistentDiskType = 0
	// Standard HDD Persistent Disk.
	PersistentDiskType_PERSISTENT_DISK_TYPE_STANDARD PersistentDiskType = 1
	// Balanced Persistent Disk.
	PersistentDiskType_PERSISTENT_DISK_TYPE_BALANCED PersistentDiskType = 2
	// SSD Persistent Disk.
	PersistentDiskType_PERSISTENT_DISK_TYPE_SSD PersistentDiskType = 3
)

// Enum value maps for PersistentDiskType.
var (
	PersistentDiskType_name = map[int32]string{
		0: "PERSISTENT_DISK_TYPE_UNSPECIFIED",
		1: "PERSISTENT_DISK_TYPE_STANDARD",
		2: "PERSISTENT_DISK_TYPE_BALANCED",
		3: "PERSISTENT_DISK_TYPE_SSD",
	}
	PersistentDiskType_value = map[string]int32{
		"PERSISTENT_DISK_TYPE_UNSPECIFIED": 0,
		"PERSISTENT_DISK_TYPE_STANDARD":    1,
		"PERSISTENT_DISK_TYPE_BALANCED":    2,
		"PERSISTENT_DISK_TYPE_SSD":         3,
	}
)

func (x PersistentDiskType) Enum() *PersistentDiskType {
	p := new(PersistentDiskType)
	*p = x
	return p
}

func (x PersistentDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersistentDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[5].Descriptor()
}

func (PersistentDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[5]
}

func (x PersistentDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersistentDiskType.Descriptor instead.
func (PersistentDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{5}
}

// The License type for premium images (RHEL, RHEL for SAP, SLES, SLES for SAP,
// Windows Server).
type LicenseType int32

const (
	// Unspecified (default value).
	LicenseType_LICENSE_TYPE_UNSPECIFIED LicenseType = 0
	// Default Google Cloud licensing plan. Licensing is charged per usage.
	// This a good value to start with.
	LicenseType_LICENSE_TYPE_DEFAULT LicenseType = 1
	// Bring-your-own-license (BYOL) plan. User provides the OS license.
	LicenseType_LICENSE_TYPE_BRING_YOUR_OWN_LICENSE LicenseType = 2
)

// Enum value maps for LicenseType.
var (
	LicenseType_name = map[int32]string{
		0: "LICENSE_TYPE_UNSPECIFIED",
		1: "LICENSE_TYPE_DEFAULT",
		2: "LICENSE_TYPE_BRING_YOUR_OWN_LICENSE",
	}
	LicenseType_value = map[string]int32{
		"LICENSE_TYPE_UNSPECIFIED":            0,
		"LICENSE_TYPE_DEFAULT":                1,
		"LICENSE_TYPE_BRING_YOUR_OWN_LICENSE": 2,
	}
)

func (x LicenseType) Enum() *LicenseType {
	p := new(LicenseType)
	*p = x
	return p
}

func (x LicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[6].Descriptor()
}

func (LicenseType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[6]
}

func (x LicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LicenseType.Descriptor instead.
func (LicenseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{6}
}

// The sizing optimization strategy preferences of a virtual machine. This
// strategy, in addition to actual usage data of the virtual machine, can help
// determine the recommended shape on the target platform.
type SizingOptimizationStrategy int32

const (
	// Unspecified (default value).
	SizingOptimizationStrategy_SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED SizingOptimizationStrategy = 0
	// No optimization applied. Virtual machine sizing matches as closely as
	// possible the machine shape on the source site, not considering any actual
	// performance data.
	SizingOptimizationStrategy_SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE SizingOptimizationStrategy = 1
	// Virtual machine sizing will match the reported usage and shape, with some
	// slack. This a good value to start with.
	SizingOptimizationStrategy_SIZING_OPTIMIZATION_STRATEGY_MODERATE SizingOptimizationStrategy = 2
	// Virtual machine sizing will match the reported usage, with little slack.
	// Using this option can help reduce costs.
	SizingOptimizationStrategy_SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE SizingOptimizationStrategy = 3
)

// Enum value maps for SizingOptimizationStrategy.
var (
	SizingOptimizationStrategy_name = map[int32]string{
		0: "SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED",
		1: "SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE",
		2: "SIZING_OPTIMIZATION_STRATEGY_MODERATE",
		3: "SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE",
	}
	SizingOptimizationStrategy_value = map[string]int32{
		"SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED":    0,
		"SIZING_OPTIMIZATION_STRATEGY_SAME_AS_SOURCE": 1,
		"SIZING_OPTIMIZATION_STRATEGY_MODERATE":       2,
		"SIZING_OPTIMIZATION_STRATEGY_AGGRESSIVE":     3,
	}
)

func (x SizingOptimizationStrategy) Enum() *SizingOptimizationStrategy {
	p := new(SizingOptimizationStrategy)
	*p = x
	return p
}

func (x SizingOptimizationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SizingOptimizationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[7].Descriptor()
}

func (SizingOptimizationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[7]
}

func (x SizingOptimizationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SizingOptimizationStrategy.Descriptor instead.
func (SizingOptimizationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{7}
}

// The plan of commitments for VM resource-based committed use discount (CUD).
type CommitmentPlan int32

const (
	// Unspecified commitment plan.
	CommitmentPlan_COMMITMENT_PLAN_UNSPECIFIED CommitmentPlan = 0
	// No commitment plan.
	CommitmentPlan_COMMITMENT_PLAN_NONE CommitmentPlan = 1
	// 1 year commitment.
	CommitmentPlan_COMMITMENT_PLAN_ONE_YEAR CommitmentPlan = 2
	// 3 years commitment.
	CommitmentPlan_COMMITMENT_PLAN_THREE_YEARS CommitmentPlan = 3
)

// Enum value maps for CommitmentPlan.
var (
	CommitmentPlan_name = map[int32]string{
		0: "COMMITMENT_PLAN_UNSPECIFIED",
		1: "COMMITMENT_PLAN_NONE",
		2: "COMMITMENT_PLAN_ONE_YEAR",
		3: "COMMITMENT_PLAN_THREE_YEARS",
	}
	CommitmentPlan_value = map[string]int32{
		"COMMITMENT_PLAN_UNSPECIFIED": 0,
		"COMMITMENT_PLAN_NONE":        1,
		"COMMITMENT_PLAN_ONE_YEAR":    2,
		"COMMITMENT_PLAN_THREE_YEARS": 3,
	}
)

func (x CommitmentPlan) Enum() *CommitmentPlan {
	p := new(CommitmentPlan)
	*p = x
	return p
}

func (x CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[8].Descriptor()
}

func (CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[8]
}

func (x CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommitmentPlan.Descriptor instead.
func (CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{8}
}

// The preference for a specific Google Cloud product platform.
type ComputeMigrationTargetProduct int32

const (
	// Unspecified (default value).
	ComputeMigrationTargetProduct_COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED ComputeMigrationTargetProduct = 0
	// Prefer to migrate to Google Cloud Compute Engine.
	ComputeMigrationTargetProduct_COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE ComputeMigrationTargetProduct = 1
	// Prefer to migrate to Google Cloud VMware Engine.
	ComputeMigrationTargetProduct_COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE ComputeMigrationTargetProduct = 2
	// Prefer to migrate to Google Cloud Sole Tenant Nodes.
	ComputeMigrationTargetProduct_COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY ComputeMigrationTargetProduct = 3
)

// Enum value maps for ComputeMigrationTargetProduct.
var (
	ComputeMigrationTargetProduct_name = map[int32]string{
		0: "COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED",
		1: "COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE",
		2: "COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE",
		3: "COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY",
	}
	ComputeMigrationTargetProduct_value = map[string]int32{
		"COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED":    0,
		"COMPUTE_MIGRATION_TARGET_PRODUCT_COMPUTE_ENGINE": 1,
		"COMPUTE_MIGRATION_TARGET_PRODUCT_VMWARE_ENGINE":  2,
		"COMPUTE_MIGRATION_TARGET_PRODUCT_SOLE_TENANCY":   3,
	}
)

func (x ComputeMigrationTargetProduct) Enum() *ComputeMigrationTargetProduct {
	p := new(ComputeMigrationTargetProduct)
	*p = x
	return p
}

func (x ComputeMigrationTargetProduct) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeMigrationTargetProduct) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[9].Descriptor()
}

func (ComputeMigrationTargetProduct) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[9]
}

func (x ComputeMigrationTargetProduct) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeMigrationTargetProduct.Descriptor instead.
func (ComputeMigrationTargetProduct) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{9}
}

// Specifies the types of views that provide complete or partial details
// of a Report.
type ReportView int32

const (
	// The report view is not specified. The API displays the basic view by
	// default.
	ReportView_REPORT_VIEW_UNSPECIFIED ReportView = 0
	// The report view includes only basic metadata of the Report. Useful for
	// list views.
	ReportView_REPORT_VIEW_BASIC ReportView = 1
	// The report view includes all the metadata of the Report. Useful for
	// preview.
	ReportView_REPORT_VIEW_FULL ReportView = 2
	// The report view includes the standard metadata of an report. Useful for
	// detail view.
	ReportView_REPORT_VIEW_STANDARD ReportView = 3
)

// Enum value maps for ReportView.
var (
	ReportView_name = map[int32]string{
		0: "REPORT_VIEW_UNSPECIFIED",
		1: "REPORT_VIEW_BASIC",
		2: "REPORT_VIEW_FULL",
		3: "REPORT_VIEW_STANDARD",
	}
	ReportView_value = map[string]int32{
		"REPORT_VIEW_UNSPECIFIED": 0,
		"REPORT_VIEW_BASIC":       1,
		"REPORT_VIEW_FULL":        2,
		"REPORT_VIEW_STANDARD":    3,
	}
)

func (x ReportView) Enum() *ReportView {
	p := new(ReportView)
	*p = x
	return p
}

func (x ReportView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[10].Descriptor()
}

func (ReportView) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[10]
}

func (x ReportView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportView.Descriptor instead.
func (ReportView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{10}
}

// Enumerates possible states of an import job.
type ImportJob_ImportJobState int32

const (
	// Default value.
	ImportJob_IMPORT_JOB_STATE_UNSPECIFIED ImportJob_ImportJobState = 0
	// The import job is pending.
	ImportJob_IMPORT_JOB_STATE_PENDING ImportJob_ImportJobState = 1
	// The processing of the import job is ongoing.
	ImportJob_IMPORT_JOB_STATE_RUNNING ImportJob_ImportJobState = 2
	// The import job processing has completed.
	ImportJob_IMPORT_JOB_STATE_COMPLETED ImportJob_ImportJobState = 3
	// The import job failed to be processed.
	ImportJob_IMPORT_JOB_STATE_FAILED ImportJob_ImportJobState = 4
	// The import job is being validated.
	ImportJob_IMPORT_JOB_STATE_VALIDATING ImportJob_ImportJobState = 5
	// The import job contains blocking errors.
	ImportJob_IMPORT_JOB_STATE_FAILED_VALIDATION ImportJob_ImportJobState = 6
	// The validation of the job completed with no blocking errors.
	ImportJob_IMPORT_JOB_STATE_READY ImportJob_ImportJobState = 7
)

// Enum value maps for ImportJob_ImportJobState.
var (
	ImportJob_ImportJobState_name = map[int32]string{
		0: "IMPORT_JOB_STATE_UNSPECIFIED",
		1: "IMPORT_JOB_STATE_PENDING",
		2: "IMPORT_JOB_STATE_RUNNING",
		3: "IMPORT_JOB_STATE_COMPLETED",
		4: "IMPORT_JOB_STATE_FAILED",
		5: "IMPORT_JOB_STATE_VALIDATING",
		6: "IMPORT_JOB_STATE_FAILED_VALIDATION",
		7: "IMPORT_JOB_STATE_READY",
	}
	ImportJob_ImportJobState_value = map[string]int32{
		"IMPORT_JOB_STATE_UNSPECIFIED":       0,
		"IMPORT_JOB_STATE_PENDING":           1,
		"IMPORT_JOB_STATE_RUNNING":           2,
		"IMPORT_JOB_STATE_COMPLETED":         3,
		"IMPORT_JOB_STATE_FAILED":            4,
		"IMPORT_JOB_STATE_VALIDATING":        5,
		"IMPORT_JOB_STATE_FAILED_VALIDATION": 6,
		"IMPORT_JOB_STATE_READY":             7,
	}
)

func (x ImportJob_ImportJobState) Enum() *ImportJob_ImportJobState {
	p := new(ImportJob_ImportJobState)
	*p = x
	return p
}

func (x ImportJob_ImportJobState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportJob_ImportJobState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[11].Descriptor()
}

func (ImportJob_ImportJobState) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[11]
}

func (x ImportJob_ImportJobState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportJob_ImportJobState.Descriptor instead.
func (ImportJob_ImportJobState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{2, 0}
}

// Enumerates possible states of an import data file.
type ImportDataFile_State int32

const (
	// Default value.
	ImportDataFile_STATE_UNSPECIFIED ImportDataFile_State = 0
	// The data file is being created.
	ImportDataFile_CREATING ImportDataFile_State = 1
	// The data file completed initialization.
	ImportDataFile_ACTIVE ImportDataFile_State = 2
)

// Enum value maps for ImportDataFile_State.
var (
	ImportDataFile_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
	}
	ImportDataFile_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
	}
)

func (x ImportDataFile_State) Enum() *ImportDataFile_State {
	p := new(ImportDataFile_State)
	*p = x
	return p
}

func (x ImportDataFile_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportDataFile_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[12].Descriptor()
}

func (ImportDataFile_State) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[12]
}

func (x ImportDataFile_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportDataFile_State.Descriptor instead.
func (ImportDataFile_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{3, 0}
}

type Source_SourceType int32

const (
	// Unspecified
	Source_SOURCE_TYPE_UNKNOWN Source_SourceType = 0
	// Manually uploaded file (e.g. CSV)
	Source_SOURCE_TYPE_UPLOAD Source_SourceType = 1
	// Guest-level info
	Source_SOURCE_TYPE_GUEST_OS_SCAN Source_SourceType = 2
	// Inventory-level scan
	Source_SOURCE_TYPE_INVENTORY_SCAN Source_SourceType = 3
	// Third-party owned sources.
	Source_SOURCE_TYPE_CUSTOM Source_SourceType = 4
)

// Enum value maps for Source_SourceType.
var (
	Source_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNKNOWN",
		1: "SOURCE_TYPE_UPLOAD",
		2: "SOURCE_TYPE_GUEST_OS_SCAN",
		3: "SOURCE_TYPE_INVENTORY_SCAN",
		4: "SOURCE_TYPE_CUSTOM",
	}
	Source_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNKNOWN":        0,
		"SOURCE_TYPE_UPLOAD":         1,
		"SOURCE_TYPE_GUEST_OS_SCAN":  2,
		"SOURCE_TYPE_INVENTORY_SCAN": 3,
		"SOURCE_TYPE_CUSTOM":         4,
	}
)

func (x Source_SourceType) Enum() *Source_SourceType {
	p := new(Source_SourceType)
	*p = x
	return p
}

func (x Source_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Source_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[13].Descriptor()
}

func (Source_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[13]
}

func (x Source_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Source_SourceType.Descriptor instead.
func (Source_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{6, 0}
}

// Enumerates possible states of a source.
type Source_State int32

const (
	// Unspecified.
	Source_STATE_UNSPECIFIED Source_State = 0
	// The source is active and ready to be used.
	Source_ACTIVE Source_State = 1
	// In the process of being deleted.
	Source_DELETING Source_State = 2
	// Source is in an invalid state. Asset frames reported to it will be
	// ignored.
	Source_INVALID Source_State = 3
)

// Enum value maps for Source_State.
var (
	Source_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DELETING",
		3: "INVALID",
	}
	Source_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DELETING":          2,
		"INVALID":           3,
	}
)

func (x Source_State) Enum() *Source_State {
	p := new(Source_State)
	*p = x
	return p
}

func (x Source_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Source_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[14].Descriptor()
}

func (Source_State) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[14]
}

func (x Source_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Source_State.Descriptor instead.
func (Source_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{6, 1}
}

// Report type.
type Report_Type int32

const (
	// Default Report type.
	Report_TYPE_UNSPECIFIED Report_Type = 0
	// Total cost of ownership Report type.
	Report_TOTAL_COST_OF_OWNERSHIP Report_Type = 1
)

// Enum value maps for Report_Type.
var (
	Report_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TOTAL_COST_OF_OWNERSHIP",
	}
	Report_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":        0,
		"TOTAL_COST_OF_OWNERSHIP": 1,
	}
)

func (x Report_Type) Enum() *Report_Type {
	p := new(Report_Type)
	*p = x
	return p
}

func (x Report_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[15].Descriptor()
}

func (Report_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[15]
}

func (x Report_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_Type.Descriptor instead.
func (Report_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{8, 0}
}

// Report creation state.
type Report_State int32

const (
	// Default Report creation state.
	Report_STATE_UNSPECIFIED Report_State = 0
	// Creating Report.
	Report_PENDING Report_State = 1
	// Successfully created Report.
	Report_SUCCEEDED Report_State = 2
	// Failed to create Report.
	Report_FAILED Report_State = 3
)

// Enum value maps for Report_State.
var (
	Report_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	Report_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x Report_State) Enum() *Report_State {
	p := new(Report_State)
	*p = x
	return p
}

func (x Report_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Report_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[16].Descriptor()
}

func (Report_State) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[16]
}

func (x Report_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Report_State.Descriptor instead.
func (Report_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{8, 1}
}

// Machine power state.
type MachineDetails_PowerState int32

const (
	// Power state is unknown.
	MachineDetails_POWER_STATE_UNSPECIFIED MachineDetails_PowerState = 0
	// The machine is preparing to enter the ACTIVE state. An instance may enter
	// the PENDING state when it launches for the first time, or when it is
	// started after being in the SUSPENDED state.
	MachineDetails_PENDING MachineDetails_PowerState = 1
	// The machine is active.
	MachineDetails_ACTIVE MachineDetails_PowerState = 2
	// The machine is being turned off.
	MachineDetails_SUSPENDING MachineDetails_PowerState = 3
	// The machine is off.
	MachineDetails_SUSPENDED MachineDetails_PowerState = 4
	// The machine is being deleted from the hosting platform.
	MachineDetails_DELETING MachineDetails_PowerState = 5
	// The machine is deleted from the hosting platform.
	MachineDetails_DELETED MachineDetails_PowerState = 6
)

// Enum value maps for MachineDetails_PowerState.
var (
	MachineDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		3: "SUSPENDING",
		4: "SUSPENDED",
		5: "DELETING",
		6: "DELETED",
	}
	MachineDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"PENDING":                 1,
		"ACTIVE":                  2,
		"SUSPENDING":              3,
		"SUSPENDED":               4,
		"DELETING":                5,
		"DELETED":                 6,
	}
)

func (x MachineDetails_PowerState) Enum() *MachineDetails_PowerState {
	p := new(MachineDetails_PowerState)
	*p = x
	return p
}

func (x MachineDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[17].Descriptor()
}

func (MachineDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[17]
}

func (x MachineDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineDetails_PowerState.Descriptor instead.
func (MachineDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{72, 0}
}

// Firmware type.
type MachineArchitectureDetails_FirmwareType int32

const (
	// Unspecified or unknown.
	MachineArchitectureDetails_FIRMWARE_TYPE_UNSPECIFIED MachineArchitectureDetails_FirmwareType = 0
	// BIOS firmware.
	MachineArchitectureDetails_BIOS MachineArchitectureDetails_FirmwareType = 1
	// EFI firmware.
	MachineArchitectureDetails_EFI MachineArchitectureDetails_FirmwareType = 2
)

// Enum value maps for MachineArchitectureDetails_FirmwareType.
var (
	MachineArchitectureDetails_FirmwareType_name = map[int32]string{
		0: "FIRMWARE_TYPE_UNSPECIFIED",
		1: "BIOS",
		2: "EFI",
	}
	MachineArchitectureDetails_FirmwareType_value = map[string]int32{
		"FIRMWARE_TYPE_UNSPECIFIED": 0,
		"BIOS":                      1,
		"EFI":                       2,
	}
)

func (x MachineArchitectureDetails_FirmwareType) Enum() *MachineArchitectureDetails_FirmwareType {
	p := new(MachineArchitectureDetails_FirmwareType)
	*p = x
	return p
}

func (x MachineArchitectureDetails_FirmwareType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineArchitectureDetails_FirmwareType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[18].Descriptor()
}

func (MachineArchitectureDetails_FirmwareType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[18]
}

func (x MachineArchitectureDetails_FirmwareType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineArchitectureDetails_FirmwareType.Descriptor instead.
func (MachineArchitectureDetails_FirmwareType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{73, 0}
}

// CPU hyper-threading support.
type MachineArchitectureDetails_CpuHyperThreading int32

const (
	// Unspecified or unknown.
	MachineArchitectureDetails_CPU_HYPER_THREADING_UNSPECIFIED MachineArchitectureDetails_CpuHyperThreading = 0
	// Hyper-threading is disabled.
	MachineArchitectureDetails_DISABLED MachineArchitectureDetails_CpuHyperThreading = 1
	// Hyper-threading is enabled.
	MachineArchitectureDetails_ENABLED MachineArchitectureDetails_CpuHyperThreading = 2
)

// Enum value maps for MachineArchitectureDetails_CpuHyperThreading.
var (
	MachineArchitectureDetails_CpuHyperThreading_name = map[int32]string{
		0: "CPU_HYPER_THREADING_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	MachineArchitectureDetails_CpuHyperThreading_value = map[string]int32{
		"CPU_HYPER_THREADING_UNSPECIFIED": 0,
		"DISABLED":                        1,
		"ENABLED":                         2,
	}
)

func (x MachineArchitectureDetails_CpuHyperThreading) Enum() *MachineArchitectureDetails_CpuHyperThreading {
	p := new(MachineArchitectureDetails_CpuHyperThreading)
	*p = x
	return p
}

func (x MachineArchitectureDetails_CpuHyperThreading) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MachineArchitectureDetails_CpuHyperThreading) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[19].Descriptor()
}

func (MachineArchitectureDetails_CpuHyperThreading) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[19]
}

func (x MachineArchitectureDetails_CpuHyperThreading) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MachineArchitectureDetails_CpuHyperThreading.Descriptor instead.
func (MachineArchitectureDetails_CpuHyperThreading) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{73, 1}
}

// Network address assignment.
type NetworkAddress_AddressAssignment int32

const (
	// Unknown (default value).
	NetworkAddress_ADDRESS_ASSIGNMENT_UNSPECIFIED NetworkAddress_AddressAssignment = 0
	// Staticly assigned IP.
	NetworkAddress_ADDRESS_ASSIGNMENT_STATIC NetworkAddress_AddressAssignment = 1
	// Dynamically assigned IP (DHCP).
	NetworkAddress_ADDRESS_ASSIGNMENT_DHCP NetworkAddress_AddressAssignment = 2
)

// Enum value maps for NetworkAddress_AddressAssignment.
var (
	NetworkAddress_AddressAssignment_name = map[int32]string{
		0: "ADDRESS_ASSIGNMENT_UNSPECIFIED",
		1: "ADDRESS_ASSIGNMENT_STATIC",
		2: "ADDRESS_ASSIGNMENT_DHCP",
	}
	NetworkAddress_AddressAssignment_value = map[string]int32{
		"ADDRESS_ASSIGNMENT_UNSPECIFIED": 0,
		"ADDRESS_ASSIGNMENT_STATIC":      1,
		"ADDRESS_ASSIGNMENT_DHCP":        2,
	}
)

func (x NetworkAddress_AddressAssignment) Enum() *NetworkAddress_AddressAssignment {
	p := new(NetworkAddress_AddressAssignment)
	*p = x
	return p
}

func (x NetworkAddress_AddressAssignment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkAddress_AddressAssignment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[20].Descriptor()
}

func (NetworkAddress_AddressAssignment) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[20]
}

func (x NetworkAddress_AddressAssignment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkAddress_AddressAssignment.Descriptor instead.
func (NetworkAddress_AddressAssignment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{79, 0}
}

// Disks interface type.
type DiskEntry_InterfaceType int32

const (
	// Interface type unknown or unspecified.
	DiskEntry_INTERFACE_TYPE_UNSPECIFIED DiskEntry_InterfaceType = 0
	// IDE interface type.
	DiskEntry_IDE DiskEntry_InterfaceType = 1
	// SATA interface type.
	DiskEntry_SATA DiskEntry_InterfaceType = 2
	// SAS interface type.
	DiskEntry_SAS DiskEntry_InterfaceType = 3
	// SCSI interface type.
	DiskEntry_SCSI DiskEntry_InterfaceType = 4
	// NVME interface type.
	DiskEntry_NVME DiskEntry_InterfaceType = 5
	// FC interface type.
	DiskEntry_FC DiskEntry_InterfaceType = 6
	// iSCSI interface type.
	DiskEntry_ISCSI DiskEntry_InterfaceType = 7
)

// Enum value maps for DiskEntry_InterfaceType.
var (
	DiskEntry_InterfaceType_name = map[int32]string{
		0: "INTERFACE_TYPE_UNSPECIFIED",
		1: "IDE",
		2: "SATA",
		3: "SAS",
		4: "SCSI",
		5: "NVME",
		6: "FC",
		7: "ISCSI",
	}
	DiskEntry_InterfaceType_value = map[string]int32{
		"INTERFACE_TYPE_UNSPECIFIED": 0,
		"IDE":                        1,
		"SATA":                       2,
		"SAS":                        3,
		"SCSI":                       4,
		"NVME":                       5,
		"FC":                         6,
		"ISCSI":                      7,
	}
)

func (x DiskEntry_InterfaceType) Enum() *DiskEntry_InterfaceType {
	p := new(DiskEntry_InterfaceType)
	*p = x
	return p
}

func (x DiskEntry_InterfaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskEntry_InterfaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[21].Descriptor()
}

func (DiskEntry_InterfaceType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[21]
}

func (x DiskEntry_InterfaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskEntry_InterfaceType.Descriptor instead.
func (DiskEntry_InterfaceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{82, 0}
}

// VMDK backing type possible values.
type VmwareDiskConfig_BackingType int32

const (
	// Default value.
	VmwareDiskConfig_BACKING_TYPE_UNSPECIFIED VmwareDiskConfig_BackingType = 0
	// Flat v1.
	VmwareDiskConfig_BACKING_TYPE_FLAT_V1 VmwareDiskConfig_BackingType = 1
	// Flat v2.
	VmwareDiskConfig_BACKING_TYPE_FLAT_V2 VmwareDiskConfig_BackingType = 2
	// Persistent memory, also known as Non-Volatile Memory (NVM).
	VmwareDiskConfig_BACKING_TYPE_PMEM VmwareDiskConfig_BackingType = 3
	// Raw Disk Memory v1.
	VmwareDiskConfig_BACKING_TYPE_RDM_V1 VmwareDiskConfig_BackingType = 4
	// Raw Disk Memory v2.
	VmwareDiskConfig_BACKING_TYPE_RDM_V2 VmwareDiskConfig_BackingType = 5
	// SEsparse is a snapshot format introduced in vSphere 5.5 for large disks.
	VmwareDiskConfig_BACKING_TYPE_SESPARSE VmwareDiskConfig_BackingType = 6
	// SEsparse v1.
	VmwareDiskConfig_BACKING_TYPE_SESPARSE_V1 VmwareDiskConfig_BackingType = 7
	// SEsparse v1.
	VmwareDiskConfig_BACKING_TYPE_SESPARSE_V2 VmwareDiskConfig_BackingType = 8
)

// Enum value maps for VmwareDiskConfig_BackingType.
var (
	VmwareDiskConfig_BackingType_name = map[int32]string{
		0: "BACKING_TYPE_UNSPECIFIED",
		1: "BACKING_TYPE_FLAT_V1",
		2: "BACKING_TYPE_FLAT_V2",
		3: "BACKING_TYPE_PMEM",
		4: "BACKING_TYPE_RDM_V1",
		5: "BACKING_TYPE_RDM_V2",
		6: "BACKING_TYPE_SESPARSE",
		7: "BACKING_TYPE_SESPARSE_V1",
		8: "BACKING_TYPE_SESPARSE_V2",
	}
	VmwareDiskConfig_BackingType_value = map[string]int32{
		"BACKING_TYPE_UNSPECIFIED": 0,
		"BACKING_TYPE_FLAT_V1":     1,
		"BACKING_TYPE_FLAT_V2":     2,
		"BACKING_TYPE_PMEM":        3,
		"BACKING_TYPE_RDM_V1":      4,
		"BACKING_TYPE_RDM_V2":      5,
		"BACKING_TYPE_SESPARSE":    6,
		"BACKING_TYPE_SESPARSE_V1": 7,
		"BACKING_TYPE_SESPARSE_V2": 8,
	}
)

func (x VmwareDiskConfig_BackingType) Enum() *VmwareDiskConfig_BackingType {
	p := new(VmwareDiskConfig_BackingType)
	*p = x
	return p
}

func (x VmwareDiskConfig_BackingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareDiskConfig_BackingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[22].Descriptor()
}

func (VmwareDiskConfig_BackingType) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[22]
}

func (x VmwareDiskConfig_BackingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareDiskConfig_BackingType.Descriptor instead.
func (VmwareDiskConfig_BackingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{85, 0}
}

// VMDK disk mode.
type VmwareDiskConfig_VmdkMode int32

const (
	// VMDK disk mode unspecified or unknown.
	VmwareDiskConfig_VMDK_MODE_UNSPECIFIED VmwareDiskConfig_VmdkMode = 0
	// Dependent disk mode.
	VmwareDiskConfig_DEPENDENT VmwareDiskConfig_VmdkMode = 1
	// Independent - Persistent disk mode.
	VmwareDiskConfig_INDEPENDENT_PERSISTENT VmwareDiskConfig_VmdkMode = 2
	// Independent - Nonpersistent disk mode.
	VmwareDiskConfig_INDEPENDENT_NONPERSISTENT VmwareDiskConfig_VmdkMode = 3
)

// Enum value maps for VmwareDiskConfig_VmdkMode.
var (
	VmwareDiskConfig_VmdkMode_name = map[int32]string{
		0: "VMDK_MODE_UNSPECIFIED",
		1: "DEPENDENT",
		2: "INDEPENDENT_PERSISTENT",
		3: "INDEPENDENT_NONPERSISTENT",
	}
	VmwareDiskConfig_VmdkMode_value = map[string]int32{
		"VMDK_MODE_UNSPECIFIED":     0,
		"DEPENDENT":                 1,
		"INDEPENDENT_PERSISTENT":    2,
		"INDEPENDENT_NONPERSISTENT": 3,
	}
)

func (x VmwareDiskConfig_VmdkMode) Enum() *VmwareDiskConfig_VmdkMode {
	p := new(VmwareDiskConfig_VmdkMode)
	*p = x
	return p
}

func (x VmwareDiskConfig_VmdkMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareDiskConfig_VmdkMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[23].Descriptor()
}

func (VmwareDiskConfig_VmdkMode) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[23]
}

func (x VmwareDiskConfig_VmdkMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareDiskConfig_VmdkMode.Descriptor instead.
func (VmwareDiskConfig_VmdkMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{85, 1}
}

// RDM compatibility mode.
type VmwareDiskConfig_RdmCompatibility int32

const (
	// Compatibility mode unspecified or unknown.
	VmwareDiskConfig_RDM_COMPATIBILITY_UNSPECIFIED VmwareDiskConfig_RdmCompatibility = 0
	// Physical compatibility mode.
	VmwareDiskConfig_PHYSICAL_COMPATIBILITY VmwareDiskConfig_RdmCompatibility = 1
	// Virtual compatibility mode.
	VmwareDiskConfig_VIRTUAL_COMPATIBILITY VmwareDiskConfig_RdmCompatibility = 2
)

// Enum value maps for VmwareDiskConfig_RdmCompatibility.
var (
	VmwareDiskConfig_RdmCompatibility_name = map[int32]string{
		0: "RDM_COMPATIBILITY_UNSPECIFIED",
		1: "PHYSICAL_COMPATIBILITY",
		2: "VIRTUAL_COMPATIBILITY",
	}
	VmwareDiskConfig_RdmCompatibility_value = map[string]int32{
		"RDM_COMPATIBILITY_UNSPECIFIED": 0,
		"PHYSICAL_COMPATIBILITY":        1,
		"VIRTUAL_COMPATIBILITY":         2,
	}
)

func (x VmwareDiskConfig_RdmCompatibility) Enum() *VmwareDiskConfig_RdmCompatibility {
	p := new(VmwareDiskConfig_RdmCompatibility)
	*p = x
	return p
}

func (x VmwareDiskConfig_RdmCompatibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareDiskConfig_RdmCompatibility) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[24].Descriptor()
}

func (VmwareDiskConfig_RdmCompatibility) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[24]
}

func (x VmwareDiskConfig_RdmCompatibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareDiskConfig_RdmCompatibility.Descriptor instead.
func (VmwareDiskConfig_RdmCompatibility) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{85, 2}
}

// Security-Enhanced Linux (SELinux) mode.
type GuestConfigDetails_SeLinuxMode int32

const (
	// SELinux mode unknown or unspecified.
	GuestConfigDetails_SE_LINUX_MODE_UNSPECIFIED GuestConfigDetails_SeLinuxMode = 0
	// SELinux is disabled.
	GuestConfigDetails_SE_LINUX_MODE_DISABLED GuestConfigDetails_SeLinuxMode = 1
	// SELinux permissive mode.
	GuestConfigDetails_SE_LINUX_MODE_PERMISSIVE GuestConfigDetails_SeLinuxMode = 2
	// SELinux enforcing mode.
	GuestConfigDetails_SE_LINUX_MODE_ENFORCING GuestConfigDetails_SeLinuxMode = 3
)

// Enum value maps for GuestConfigDetails_SeLinuxMode.
var (
	GuestConfigDetails_SeLinuxMode_name = map[int32]string{
		0: "SE_LINUX_MODE_UNSPECIFIED",
		1: "SE_LINUX_MODE_DISABLED",
		2: "SE_LINUX_MODE_PERMISSIVE",
		3: "SE_LINUX_MODE_ENFORCING",
	}
	GuestConfigDetails_SeLinuxMode_value = map[string]int32{
		"SE_LINUX_MODE_UNSPECIFIED": 0,
		"SE_LINUX_MODE_DISABLED":    1,
		"SE_LINUX_MODE_PERMISSIVE":  2,
		"SE_LINUX_MODE_ENFORCING":   3,
	}
)

func (x GuestConfigDetails_SeLinuxMode) Enum() *GuestConfigDetails_SeLinuxMode {
	p := new(GuestConfigDetails_SeLinuxMode)
	*p = x
	return p
}

func (x GuestConfigDetails_SeLinuxMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestConfigDetails_SeLinuxMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[25].Descriptor()
}

func (GuestConfigDetails_SeLinuxMode) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[25]
}

func (x GuestConfigDetails_SeLinuxMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestConfigDetails_SeLinuxMode.Descriptor instead.
func (GuestConfigDetails_SeLinuxMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{87, 0}
}

// Service state (OS-agnostic).
type RunningService_State int32

const (
	// Service state unspecified.
	RunningService_STATE_UNSPECIFIED RunningService_State = 0
	// Service is active.
	RunningService_ACTIVE RunningService_State = 1
	// Service is paused.
	RunningService_PAUSED RunningService_State = 2
	// Service is stopped.
	RunningService_STOPPED RunningService_State = 3
)

// Enum value maps for RunningService_State.
var (
	RunningService_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PAUSED",
		3: "STOPPED",
	}
	RunningService_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"PAUSED":            2,
		"STOPPED":           3,
	}
)

func (x RunningService_State) Enum() *RunningService_State {
	p := new(RunningService_State)
	*p = x
	return p
}

func (x RunningService_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunningService_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[26].Descriptor()
}

func (RunningService_State) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[26]
}

func (x RunningService_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunningService_State.Descriptor instead.
func (RunningService_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{96, 0}
}

// Service start mode (OS-agnostic).
type RunningService_StartMode int32

const (
	// Start mode unspecified.
	RunningService_START_MODE_UNSPECIFIED RunningService_StartMode = 0
	// The service is a device driver started by the system loader.
	RunningService_BOOT RunningService_StartMode = 1
	// The service is a device driver started by the IOInitSystem function.
	RunningService_SYSTEM RunningService_StartMode = 2
	// The service is started by the operating system, at system start-up
	RunningService_AUTO RunningService_StartMode = 3
	// The service is started only manually, by a user.
	RunningService_MANUAL RunningService_StartMode = 4
	// The service is disabled.
	RunningService_DISABLED RunningService_StartMode = 5
)

// Enum value maps for RunningService_StartMode.
var (
	RunningService_StartMode_name = map[int32]string{
		0: "START_MODE_UNSPECIFIED",
		1: "BOOT",
		2: "SYSTEM",
		3: "AUTO",
		4: "MANUAL",
		5: "DISABLED",
	}
	RunningService_StartMode_value = map[string]int32{
		"START_MODE_UNSPECIFIED": 0,
		"BOOT":                   1,
		"SYSTEM":                 2,
		"AUTO":                   3,
		"MANUAL":                 4,
		"DISABLED":               5,
	}
)

func (x RunningService_StartMode) Enum() *RunningService_StartMode {
	p := new(RunningService_StartMode)
	*p = x
	return p
}

func (x RunningService_StartMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunningService_StartMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[27].Descriptor()
}

func (RunningService_StartMode) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[27]
}

func (x RunningService_StartMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunningService_StartMode.Descriptor instead.
func (RunningService_StartMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{96, 1}
}

// Network connection state.
type NetworkConnection_State int32

const (
	// Connection state is unknown or unspecified.
	NetworkConnection_STATE_UNSPECIFIED NetworkConnection_State = 0
	// The connection is being opened.
	NetworkConnection_OPENING NetworkConnection_State = 1
	// The connection is open.
	NetworkConnection_OPEN NetworkConnection_State = 2
	// Listening for incoming connections.
	NetworkConnection_LISTEN NetworkConnection_State = 3
	// The connection is being closed.
	NetworkConnection_CLOSING NetworkConnection_State = 4
	// The connection is closed.
	NetworkConnection_CLOSED NetworkConnection_State = 5
)

// Enum value maps for NetworkConnection_State.
var (
	NetworkConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "OPENING",
		2: "OPEN",
		3: "LISTEN",
		4: "CLOSING",
		5: "CLOSED",
	}
	NetworkConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"OPENING":           1,
		"OPEN":              2,
		"LISTEN":            3,
		"CLOSING":           4,
		"CLOSED":            5,
	}
)

func (x NetworkConnection_State) Enum() *NetworkConnection_State {
	p := new(NetworkConnection_State)
	*p = x
	return p
}

func (x NetworkConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[28].Descriptor()
}

func (NetworkConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[28]
}

func (x NetworkConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConnection_State.Descriptor instead.
func (NetworkConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{101, 0}
}

// Fit level.
type FitDescriptor_FitLevel int32

const (
	// Not enough information.
	FitDescriptor_FIT_LEVEL_UNSPECIFIED FitDescriptor_FitLevel = 0
	// Fit.
	FitDescriptor_FIT FitDescriptor_FitLevel = 1
	// No Fit.
	FitDescriptor_NO_FIT FitDescriptor_FitLevel = 2
	// Fit with effort.
	FitDescriptor_REQUIRES_EFFORT FitDescriptor_FitLevel = 3
)

// Enum value maps for FitDescriptor_FitLevel.
var (
	FitDescriptor_FitLevel_name = map[int32]string{
		0: "FIT_LEVEL_UNSPECIFIED",
		1: "FIT",
		2: "NO_FIT",
		3: "REQUIRES_EFFORT",
	}
	FitDescriptor_FitLevel_value = map[string]int32{
		"FIT_LEVEL_UNSPECIFIED": 0,
		"FIT":                   1,
		"NO_FIT":                2,
		"REQUIRES_EFFORT":       3,
	}
)

func (x FitDescriptor_FitLevel) Enum() *FitDescriptor_FitLevel {
	p := new(FitDescriptor_FitLevel)
	*p = x
	return p
}

func (x FitDescriptor_FitLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FitDescriptor_FitLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[29].Descriptor()
}

func (FitDescriptor_FitLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[29]
}

func (x FitDescriptor_FitLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FitDescriptor_FitLevel.Descriptor instead.
func (FitDescriptor_FitLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{126, 0}
}

// Enumerate possible error severity.
type ImportError_Severity int32

const (
	ImportError_SEVERITY_UNSPECIFIED ImportError_Severity = 0
	ImportError_ERROR                ImportError_Severity = 1
	ImportError_WARNING              ImportError_Severity = 2
	ImportError_INFO                 ImportError_Severity = 3
)

// Enum value maps for ImportError_Severity.
var (
	ImportError_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "ERROR",
		2: "WARNING",
		3: "INFO",
	}
	ImportError_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"ERROR":                1,
		"WARNING":              2,
		"INFO":                 3,
	}
)

func (x ImportError_Severity) Enum() *ImportError_Severity {
	p := new(ImportError_Severity)
	*p = x
	return p
}

func (x ImportError_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportError_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[30].Descriptor()
}

func (ImportError_Severity) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[30]
}

func (x ImportError_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportError_Severity.Descriptor instead.
func (ImportError_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{132, 0}
}

// Type of committed use discount.
type VmwareEnginePreferences_CommitmentPlan int32

const (
	// Unspecified commitment plan.
	VmwareEnginePreferences_COMMITMENT_PLAN_UNSPECIFIED VmwareEnginePreferences_CommitmentPlan = 0
	// No commitment plan (on-demand usage).
	VmwareEnginePreferences_ON_DEMAND VmwareEnginePreferences_CommitmentPlan = 1
	// 1 year commitment (monthly payments).
	VmwareEnginePreferences_COMMITMENT_1_YEAR_MONTHLY_PAYMENTS VmwareEnginePreferences_CommitmentPlan = 2
	// 3 year commitment (monthly payments).
	VmwareEnginePreferences_COMMITMENT_3_YEAR_MONTHLY_PAYMENTS VmwareEnginePreferences_CommitmentPlan = 3
	// 1 year commitment (upfront payment).
	VmwareEnginePreferences_COMMITMENT_1_YEAR_UPFRONT_PAYMENT VmwareEnginePreferences_CommitmentPlan = 4
	// 3 years commitment (upfront payment).
	VmwareEnginePreferences_COMMITMENT_3_YEAR_UPFRONT_PAYMENT VmwareEnginePreferences_CommitmentPlan = 5
)

// Enum value maps for VmwareEnginePreferences_CommitmentPlan.
var (
	VmwareEnginePreferences_CommitmentPlan_name = map[int32]string{
		0: "COMMITMENT_PLAN_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "COMMITMENT_1_YEAR_MONTHLY_PAYMENTS",
		3: "COMMITMENT_3_YEAR_MONTHLY_PAYMENTS",
		4: "COMMITMENT_1_YEAR_UPFRONT_PAYMENT",
		5: "COMMITMENT_3_YEAR_UPFRONT_PAYMENT",
	}
	VmwareEnginePreferences_CommitmentPlan_value = map[string]int32{
		"COMMITMENT_PLAN_UNSPECIFIED":        0,
		"ON_DEMAND":                          1,
		"COMMITMENT_1_YEAR_MONTHLY_PAYMENTS": 2,
		"COMMITMENT_3_YEAR_MONTHLY_PAYMENTS": 3,
		"COMMITMENT_1_YEAR_UPFRONT_PAYMENT":  4,
		"COMMITMENT_3_YEAR_UPFRONT_PAYMENT":  5,
	}
)

func (x VmwareEnginePreferences_CommitmentPlan) Enum() *VmwareEnginePreferences_CommitmentPlan {
	p := new(VmwareEnginePreferences_CommitmentPlan)
	*p = x
	return p
}

func (x VmwareEnginePreferences_CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEnginePreferences_CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[31].Descriptor()
}

func (VmwareEnginePreferences_CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[31]
}

func (x VmwareEnginePreferences_CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEnginePreferences_CommitmentPlan.Descriptor instead.
func (VmwareEnginePreferences_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{141, 0}
}

// Sole Tenancy nodes maintenance policy.
type SoleTenancyPreferences_HostMaintenancePolicy int32

const (
	// Unspecified host maintenance policy.
	SoleTenancyPreferences_HOST_MAINTENANCE_POLICY_UNSPECIFIED SoleTenancyPreferences_HostMaintenancePolicy = 0
	// Default host maintenance policy.
	SoleTenancyPreferences_HOST_MAINTENANCE_POLICY_DEFAULT SoleTenancyPreferences_HostMaintenancePolicy = 1
	// Restart in place host maintenance policy.
	SoleTenancyPreferences_HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE SoleTenancyPreferences_HostMaintenancePolicy = 2
	// Migrate within node group host maintenance policy.
	SoleTenancyPreferences_HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP SoleTenancyPreferences_HostMaintenancePolicy = 3
)

// Enum value maps for SoleTenancyPreferences_HostMaintenancePolicy.
var (
	SoleTenancyPreferences_HostMaintenancePolicy_name = map[int32]string{
		0: "HOST_MAINTENANCE_POLICY_UNSPECIFIED",
		1: "HOST_MAINTENANCE_POLICY_DEFAULT",
		2: "HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE",
		3: "HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP",
	}
	SoleTenancyPreferences_HostMaintenancePolicy_value = map[string]int32{
		"HOST_MAINTENANCE_POLICY_UNSPECIFIED":               0,
		"HOST_MAINTENANCE_POLICY_DEFAULT":                   1,
		"HOST_MAINTENANCE_POLICY_RESTART_IN_PLACE":          2,
		"HOST_MAINTENANCE_POLICY_MIGRATE_WITHIN_NODE_GROUP": 3,
	}
)

func (x SoleTenancyPreferences_HostMaintenancePolicy) Enum() *SoleTenancyPreferences_HostMaintenancePolicy {
	p := new(SoleTenancyPreferences_HostMaintenancePolicy)
	*p = x
	return p
}

func (x SoleTenancyPreferences_HostMaintenancePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SoleTenancyPreferences_HostMaintenancePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[32].Descriptor()
}

func (SoleTenancyPreferences_HostMaintenancePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[32]
}

func (x SoleTenancyPreferences_HostMaintenancePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SoleTenancyPreferences_HostMaintenancePolicy.Descriptor instead.
func (SoleTenancyPreferences_HostMaintenancePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{142, 0}
}

// Type of committed use discount.
type SoleTenancyPreferences_CommitmentPlan int32

const (
	// Unspecified commitment plan.
	SoleTenancyPreferences_COMMITMENT_PLAN_UNSPECIFIED SoleTenancyPreferences_CommitmentPlan = 0
	// No commitment plan (on-demand usage).
	SoleTenancyPreferences_ON_DEMAND SoleTenancyPreferences_CommitmentPlan = 1
	// 1 year commitment.
	SoleTenancyPreferences_COMMITMENT_1_YEAR SoleTenancyPreferences_CommitmentPlan = 2
	// 3 years commitment.
	SoleTenancyPreferences_COMMITMENT_3_YEAR SoleTenancyPreferences_CommitmentPlan = 3
)

// Enum value maps for SoleTenancyPreferences_CommitmentPlan.
var (
	SoleTenancyPreferences_CommitmentPlan_name = map[int32]string{
		0: "COMMITMENT_PLAN_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "COMMITMENT_1_YEAR",
		3: "COMMITMENT_3_YEAR",
	}
	SoleTenancyPreferences_CommitmentPlan_value = map[string]int32{
		"COMMITMENT_PLAN_UNSPECIFIED": 0,
		"ON_DEMAND":                   1,
		"COMMITMENT_1_YEAR":           2,
		"COMMITMENT_3_YEAR":           3,
	}
)

func (x SoleTenancyPreferences_CommitmentPlan) Enum() *SoleTenancyPreferences_CommitmentPlan {
	p := new(SoleTenancyPreferences_CommitmentPlan)
	*p = x
	return p
}

func (x SoleTenancyPreferences_CommitmentPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SoleTenancyPreferences_CommitmentPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[33].Descriptor()
}

func (SoleTenancyPreferences_CommitmentPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes[33]
}

func (x SoleTenancyPreferences_CommitmentPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SoleTenancyPreferences_CommitmentPlan.Descriptor instead.
func (SoleTenancyPreferences_CommitmentPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{142, 1}
}

// An asset represents a resource in your environment. Asset types include
// virtual machines and databases.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the asset.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the asset was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the asset was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Generic asset attributes.
	Attributes map[string]string `protobuf:"bytes,5,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The internal information of an asset. Only one field can be specified
	// with different attributes based on the type of the asset.
	//
	// Types that are assignable to AssetDetails:
	//
	//	*Asset_MachineDetails
	AssetDetails isAsset_AssetDetails `protobuf_oneof:"AssetDetails"`
	// Output only. The list of insights associated with the asset.
	InsightList *InsightList `protobuf:"bytes,20,opt,name=insight_list,json=insightList,proto3" json:"insight_list,omitempty"`
	// Output only. Performance data for the asset.
	PerformanceData *AssetPerformanceData `protobuf:"bytes,21,opt,name=performance_data,json=performanceData,proto3" json:"performance_data,omitempty"`
	// Output only. The list of sources contributing to the asset.
	Sources []string `protobuf:"bytes,22,rep,name=sources,proto3" json:"sources,omitempty"`
	// Output only. The list of groups that the asset is assigned to.
	AssignedGroups []string `protobuf:"bytes,23,rep,name=assigned_groups,json=assignedGroups,proto3" json:"assigned_groups,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{0}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Asset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Asset) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (m *Asset) GetAssetDetails() isAsset_AssetDetails {
	if m != nil {
		return m.AssetDetails
	}
	return nil
}

func (x *Asset) GetMachineDetails() *MachineDetails {
	if x, ok := x.GetAssetDetails().(*Asset_MachineDetails); ok {
		return x.MachineDetails
	}
	return nil
}

func (x *Asset) GetInsightList() *InsightList {
	if x != nil {
		return x.InsightList
	}
	return nil
}

func (x *Asset) GetPerformanceData() *AssetPerformanceData {
	if x != nil {
		return x.PerformanceData
	}
	return nil
}

func (x *Asset) GetSources() []string {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *Asset) GetAssignedGroups() []string {
	if x != nil {
		return x.AssignedGroups
	}
	return nil
}

type isAsset_AssetDetails interface {
	isAsset_AssetDetails()
}

type Asset_MachineDetails struct {
	// Output only. Asset information specific for virtual and physical
	// machines.
	MachineDetails *MachineDetails `protobuf:"bytes,6,opt,name=machine_details,json=machineDetails,proto3,oneof"`
}

func (*Asset_MachineDetails) isAsset_AssetDetails() {}

// The preferences that apply to all assets in a given context.
type PreferenceSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the preference set.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the preference set was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the preference set was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-friendly display name. Maximum length is 63 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description of the preference set.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// A set of preferences that applies to all virtual machines in the context.
	VirtualMachinePreferences *VirtualMachinePreferences `protobuf:"bytes,6,opt,name=virtual_machine_preferences,json=virtualMachinePreferences,proto3" json:"virtual_machine_preferences,omitempty"`
}

func (x *PreferenceSet) Reset() {
	*x = PreferenceSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreferenceSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreferenceSet) ProtoMessage() {}

func (x *PreferenceSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreferenceSet.ProtoReflect.Descriptor instead.
func (*PreferenceSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{1}
}

func (x *PreferenceSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PreferenceSet) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PreferenceSet) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PreferenceSet) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PreferenceSet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PreferenceSet) GetVirtualMachinePreferences() *VirtualMachinePreferences {
	if x != nil {
		return x.VirtualMachinePreferences
	}
	return nil
}

// A resource that represents the background job that imports asset frames.
type ImportJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the import job.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-friendly display name. Maximum length is 63 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The timestamp when the import job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the import job was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The timestamp when the import job was completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. The state of the import job.
	State ImportJob_ImportJobState `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.ImportJob_ImportJobState" json:"state,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Reference to a source.
	AssetSource string `protobuf:"bytes,8,opt,name=asset_source,json=assetSource,proto3" json:"asset_source,omitempty"`
	// Holds the various report types of an import job.
	//
	// Types that are assignable to Report:
	//
	//	*ImportJob_ValidationReport
	//	*ImportJob_ExecutionReport
	Report isImportJob_Report `protobuf_oneof:"report"`
}

func (x *ImportJob) Reset() {
	*x = ImportJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportJob) ProtoMessage() {}

func (x *ImportJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportJob.ProtoReflect.Descriptor instead.
func (*ImportJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{2}
}

func (x *ImportJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ImportJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportJob) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *ImportJob) GetState() ImportJob_ImportJobState {
	if x != nil {
		return x.State
	}
	return ImportJob_IMPORT_JOB_STATE_UNSPECIFIED
}

func (x *ImportJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ImportJob) GetAssetSource() string {
	if x != nil {
		return x.AssetSource
	}
	return ""
}

func (m *ImportJob) GetReport() isImportJob_Report {
	if m != nil {
		return m.Report
	}
	return nil
}

func (x *ImportJob) GetValidationReport() *ValidationReport {
	if x, ok := x.GetReport().(*ImportJob_ValidationReport); ok {
		return x.ValidationReport
	}
	return nil
}

func (x *ImportJob) GetExecutionReport() *ExecutionReport {
	if x, ok := x.GetReport().(*ImportJob_ExecutionReport); ok {
		return x.ExecutionReport
	}
	return nil
}

type isImportJob_Report interface {
	isImportJob_Report()
}

type ImportJob_ValidationReport struct {
	// Output only. The report with the validation results of the import job.
	ValidationReport *ValidationReport `protobuf:"bytes,10,opt,name=validation_report,json=validationReport,proto3,oneof"`
}

type ImportJob_ExecutionReport struct {
	// Output only. The report with the results of running the import job.
	ExecutionReport *ExecutionReport `protobuf:"bytes,11,opt,name=execution_report,json=executionReport,proto3,oneof"`
}

func (*ImportJob_ValidationReport) isImportJob_Report() {}

func (*ImportJob_ExecutionReport) isImportJob_Report() {}

// A resource that represents a payload file in an import job.
type ImportDataFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the file.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-friendly display name. Maximum length is 63 characters.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The payload format.
	Format ImportJobFormat `protobuf:"varint,2,opt,name=format,proto3,enum=google.cloud.migrationcenter.v1.ImportJobFormat" json:"format,omitempty"`
	// Output only. The timestamp when the file was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The state of the import data file.
	State ImportDataFile_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.ImportDataFile_State" json:"state,omitempty"`
	// Types that are assignable to FileInfo:
	//
	//	*ImportDataFile_UploadFileInfo
	FileInfo isImportDataFile_FileInfo `protobuf_oneof:"file_info"`
}

func (x *ImportDataFile) Reset() {
	*x = ImportDataFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDataFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataFile) ProtoMessage() {}

func (x *ImportDataFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataFile.ProtoReflect.Descriptor instead.
func (*ImportDataFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{3}
}

func (x *ImportDataFile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportDataFile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ImportDataFile) GetFormat() ImportJobFormat {
	if x != nil {
		return x.Format
	}
	return ImportJobFormat_IMPORT_JOB_FORMAT_UNSPECIFIED
}

func (x *ImportDataFile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportDataFile) GetState() ImportDataFile_State {
	if x != nil {
		return x.State
	}
	return ImportDataFile_STATE_UNSPECIFIED
}

func (m *ImportDataFile) GetFileInfo() isImportDataFile_FileInfo {
	if m != nil {
		return m.FileInfo
	}
	return nil
}

func (x *ImportDataFile) GetUploadFileInfo() *UploadFileInfo {
	if x, ok := x.GetFileInfo().(*ImportDataFile_UploadFileInfo); ok {
		return x.UploadFileInfo
	}
	return nil
}

type isImportDataFile_FileInfo interface {
	isImportDataFile_FileInfo()
}

type ImportDataFile_UploadFileInfo struct {
	// Information about a file that is uploaded to a storage service.
	UploadFileInfo *UploadFileInfo `protobuf:"bytes,5,opt,name=upload_file_info,json=uploadFileInfo,proto3,oneof"`
}

func (*ImportDataFile_UploadFileInfo) isImportDataFile_FileInfo() {}

// A resource that represents an asset group.
// The purpose of an asset group is to bundle a set of assets that have
// something in common, while allowing users to add annotations to the group.
// An asset can belong to multiple groups.
type Group struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the group was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the group was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User-friendly display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the resource.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Group) Reset() {
	*x = Group{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{4}
}

func (x *Group) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Group) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Group) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Group) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Group) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Group) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Message representing a frame which failed to be processed due to an error.
type ErrorFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The identifier of the ErrorFrame.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. All the violations that were detected for the frame.
	Violations []*FrameViolationEntry `protobuf:"bytes,2,rep,name=violations,proto3" json:"violations,omitempty"`
	// Output only. The frame that was originally reported.
	OriginalFrame *AssetFrame `protobuf:"bytes,3,opt,name=original_frame,json=originalFrame,proto3" json:"original_frame,omitempty"`
	// Output only. Frame ingestion time.
	IngestionTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=ingestion_time,json=ingestionTime,proto3" json:"ingestion_time,omitempty"`
}

func (x *ErrorFrame) Reset() {
	*x = ErrorFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorFrame) ProtoMessage() {}

func (x *ErrorFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorFrame.ProtoReflect.Descriptor instead.
func (*ErrorFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{5}
}

func (x *ErrorFrame) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ErrorFrame) GetViolations() []*FrameViolationEntry {
	if x != nil {
		return x.Violations
	}
	return nil
}

func (x *ErrorFrame) GetOriginalFrame() *AssetFrame {
	if x != nil {
		return x.OriginalFrame
	}
	return nil
}

func (x *ErrorFrame) GetIngestionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IngestionTime
	}
	return nil
}

// Source represents an object from which asset information is
// streamed to Migration Center.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the source.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the source was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the source was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-friendly display name.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Free-text description.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Data source type.
	Type Source_SourceType `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.migrationcenter.v1.Source_SourceType" json:"type,omitempty"`
	// The information confidence of the source.
	// The higher the value, the higher the confidence.
	Priority int32 `protobuf:"varint,7,opt,name=priority,proto3" json:"priority,omitempty"`
	// If `true`, the source is managed by other service(s).
	Managed bool `protobuf:"varint,8,opt,name=managed,proto3" json:"managed,omitempty"`
	// Output only. Number of frames that are still being processed.
	PendingFrameCount int32 `protobuf:"varint,9,opt,name=pending_frame_count,json=pendingFrameCount,proto3" json:"pending_frame_count,omitempty"`
	// Output only. The number of frames that were reported by the source and
	// contained errors.
	ErrorFrameCount int32 `protobuf:"varint,10,opt,name=error_frame_count,json=errorFrameCount,proto3" json:"error_frame_count,omitempty"`
	// Output only. The state of the source.
	State Source_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.Source_State" json:"state,omitempty"`
}

func (x *Source) Reset() {
	*x = Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{6}
}

func (x *Source) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Source) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Source) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Source) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Source) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Source) GetType() Source_SourceType {
	if x != nil {
		return x.Type
	}
	return Source_SOURCE_TYPE_UNKNOWN
}

func (x *Source) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Source) GetManaged() bool {
	if x != nil {
		return x.Managed
	}
	return false
}

func (x *Source) GetPendingFrameCount() int32 {
	if x != nil {
		return x.PendingFrameCount
	}
	return 0
}

func (x *Source) GetErrorFrameCount() int32 {
	if x != nil {
		return x.ErrorFrameCount
	}
	return 0
}

func (x *Source) GetState() Source_State {
	if x != nil {
		return x.State
	}
	return Source_STATE_UNSPECIFIED
}

// The groups and associated preference sets on which
// we can generate reports.
type ReportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-friendly display name. Maximum length is 63 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Free-text description.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Collection of combinations of groups and preference sets.
	GroupPreferencesetAssignments []*ReportConfig_GroupPreferenceSetAssignment `protobuf:"bytes,6,rep,name=group_preferenceset_assignments,json=groupPreferencesetAssignments,proto3" json:"group_preferenceset_assignments,omitempty"`
}

func (x *ReportConfig) Reset() {
	*x = ReportConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportConfig) ProtoMessage() {}

func (x *ReportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportConfig.ProtoReflect.Descriptor instead.
func (*ReportConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{7}
}

func (x *ReportConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReportConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReportConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReportConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ReportConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReportConfig) GetGroupPreferencesetAssignments() []*ReportConfig_GroupPreferenceSetAssignment {
	if x != nil {
		return x.GroupPreferencesetAssignments
	}
	return nil
}

// Report represents a point-in-time rendering of the ReportConfig results.
type Report struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-friendly display name. Maximum length is 63 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Free-text description.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Report type.
	Type Report_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.migrationcenter.v1.Report_Type" json:"type,omitempty"`
	// Report creation state.
	State Report_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.Report_State" json:"state,omitempty"`
	// Output only. Summary view of the Report.
	Summary *ReportSummary `protobuf:"bytes,8,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *Report) Reset() {
	*x = Report{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Report) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Report) ProtoMessage() {}

func (x *Report) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Report.ProtoReflect.Descriptor instead.
func (*Report) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{8}
}

func (x *Report) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Report) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Report) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Report) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Report) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Report) GetType() Report_Type {
	if x != nil {
		return x.Type
	}
	return Report_TYPE_UNSPECIFIED
}

func (x *Report) GetState() Report_State {
	if x != nil {
		return x.State
	}
	return Report_STATE_UNSPECIFIED
}

func (x *Report) GetSummary() *ReportSummary {
	if x != nil {
		return x.Summary
	}
	return nil
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{9}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Message for requesting a list of assets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListAssetsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// View of the assets. Defaults to BASIC.
	View AssetView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.AssetView" json:"view,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{10}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAssetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListAssetsRequest) GetView() AssetView {
	if x != nil {
		return x.View
	}
	return AssetView_ASSET_VIEW_UNSPECIFIED
}

// Response message for listing assets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of assets.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{11}
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAssetsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Asset.
type GetAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// View of the assets. Defaults to BASIC.
	View AssetView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.AssetView" json:"view,omitempty"`
}

func (x *GetAssetRequest) Reset() {
	*x = GetAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAssetRequest) ProtoMessage() {}

func (x *GetAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAssetRequest.ProtoReflect.Descriptor instead.
func (*GetAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{12}
}

func (x *GetAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAssetRequest) GetView() AssetView {
	if x != nil {
		return x.View
	}
	return AssetView_ASSET_VIEW_UNSPECIFIED
}

// A request to update an asset.
type UpdateAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Asset` resource by the update.
	// The values specified in the `update_mask` field are relative to the
	// resource, not the full request.
	// A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Asset *Asset `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateAssetRequest) Reset() {
	*x = UpdateAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAssetRequest) ProtoMessage() {}

func (x *UpdateAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAssetRequest.ProtoReflect.Descriptor instead.
func (*UpdateAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateAssetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAssetRequest) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *UpdateAssetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to update a list of assets.
type BatchUpdateAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for batch asset update.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the resources to update.
	// A maximum of 1000 assets can be modified in a batch.
	Requests []*UpdateAssetRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateAssetsRequest) Reset() {
	*x = BatchUpdateAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateAssetsRequest) ProtoMessage() {}

func (x *BatchUpdateAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateAssetsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{14}
}

func (x *BatchUpdateAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateAssetsRequest) GetRequests() []*UpdateAssetRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response for updating a list of assets.
type BatchUpdateAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Update asset content.
	// The content only includes values after field mask being applied.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
}

func (x *BatchUpdateAssetsResponse) Reset() {
	*x = BatchUpdateAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateAssetsResponse) ProtoMessage() {}

func (x *BatchUpdateAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateAssetsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{15}
}

func (x *BatchUpdateAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

// A request to delete an asset.
type DeleteAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteAssetRequest) Reset() {
	*x = DeleteAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssetRequest) ProtoMessage() {}

func (x *DeleteAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssetRequest.ProtoReflect.Descriptor instead.
func (*DeleteAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAssetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a list of  asset.
type BatchDeleteAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for batch asset delete.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The IDs of the assets to delete.
	// A maximum of 1000 assets can be deleted in a batch.
	// Format: projects/{project}/locations/{location}/assets/{name}.
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
	// Optional. When this value is set to `true` the request is a no-op for
	// non-existing assets. See https://google.aip.dev/135#delete-if-existing for
	// additional details. Default value is `false`.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *BatchDeleteAssetsRequest) Reset() {
	*x = BatchDeleteAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteAssetsRequest) ProtoMessage() {}

func (x *BatchDeleteAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteAssetsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{17}
}

func (x *BatchDeleteAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteAssetsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *BatchDeleteAssetsRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// A request to report a set of asset frames.
type ReportAssetFramesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent of the resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Collection of frames data.
	Frames *Frames `protobuf:"bytes,2,opt,name=frames,proto3" json:"frames,omitempty"`
	// Required. Reference to a source.
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *ReportAssetFramesRequest) Reset() {
	*x = ReportAssetFramesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportAssetFramesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportAssetFramesRequest) ProtoMessage() {}

func (x *ReportAssetFramesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportAssetFramesRequest.ProtoReflect.Descriptor instead.
func (*ReportAssetFramesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{18}
}

func (x *ReportAssetFramesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReportAssetFramesRequest) GetFrames() *Frames {
	if x != nil {
		return x.Frames
	}
	return nil
}

func (x *ReportAssetFramesRequest) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

// A response to a call to `ReportAssetFrame`.
type ReportAssetFramesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportAssetFramesResponse) Reset() {
	*x = ReportAssetFramesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportAssetFramesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportAssetFramesResponse) ProtoMessage() {}

func (x *ReportAssetFramesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportAssetFramesResponse.ProtoReflect.Descriptor instead.
func (*ReportAssetFramesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{19}
}

// A request to aggregate one or more values.
type AggregateAssetsValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `AggregateAssetsValuesRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Array of aggregations to perform.
	// Up to 25 aggregations can be defined.
	Aggregations []*Aggregation `protobuf:"bytes,2,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
	// The aggregation will be performed on assets that match the provided filter.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *AggregateAssetsValuesRequest) Reset() {
	*x = AggregateAssetsValuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateAssetsValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateAssetsValuesRequest) ProtoMessage() {}

func (x *AggregateAssetsValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateAssetsValuesRequest.ProtoReflect.Descriptor instead.
func (*AggregateAssetsValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{20}
}

func (x *AggregateAssetsValuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AggregateAssetsValuesRequest) GetAggregations() []*Aggregation {
	if x != nil {
		return x.Aggregations
	}
	return nil
}

func (x *AggregateAssetsValuesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A response to a request to aggregated assets values.
type AggregateAssetsValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The aggregation results.
	Results []*AggregationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *AggregateAssetsValuesResponse) Reset() {
	*x = AggregateAssetsValuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregateAssetsValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregateAssetsValuesResponse) ProtoMessage() {}

func (x *AggregateAssetsValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregateAssetsValuesResponse.ProtoReflect.Descriptor instead.
func (*AggregateAssetsValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{21}
}

func (x *AggregateAssetsValuesResponse) GetResults() []*AggregationResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// A request to create an import job.
type CreateImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. ID of the import job.
	ImportJobId string `protobuf:"bytes,2,opt,name=import_job_id,json=importJobId,proto3" json:"import_job_id,omitempty"`
	// Required. The resource being created.
	ImportJob *ImportJob `protobuf:"bytes,3,opt,name=import_job,json=importJob,proto3" json:"import_job,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateImportJobRequest) Reset() {
	*x = CreateImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateImportJobRequest) ProtoMessage() {}

func (x *CreateImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateImportJobRequest.ProtoReflect.Descriptor instead.
func (*CreateImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{22}
}

func (x *CreateImportJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateImportJobRequest) GetImportJobId() string {
	if x != nil {
		return x.ImportJobId
	}
	return ""
}

func (x *CreateImportJobRequest) GetImportJob() *ImportJob {
	if x != nil {
		return x.ImportJob
	}
	return nil
}

func (x *CreateImportJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to list import jobs.
type ListImportJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListImportJobsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The level of details of each import job.
	// Default value is BASIC.
	View ImportJobView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ImportJobView" json:"view,omitempty"`
}

func (x *ListImportJobsRequest) Reset() {
	*x = ListImportJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImportJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImportJobsRequest) ProtoMessage() {}

func (x *ListImportJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImportJobsRequest.ProtoReflect.Descriptor instead.
func (*ListImportJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{23}
}

func (x *ListImportJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListImportJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImportJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListImportJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImportJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListImportJobsRequest) GetView() ImportJobView {
	if x != nil {
		return x.View
	}
	return ImportJobView_IMPORT_JOB_VIEW_UNSPECIFIED
}

// A response for listing import jobs.
type ListImportJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of import jobs.
	ImportJobs []*ImportJob `protobuf:"bytes,1,rep,name=import_jobs,json=importJobs,proto3" json:"import_jobs,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListImportJobsResponse) Reset() {
	*x = ListImportJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImportJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImportJobsResponse) ProtoMessage() {}

func (x *ListImportJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImportJobsResponse.ProtoReflect.Descriptor instead.
func (*ListImportJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{24}
}

func (x *ListImportJobsResponse) GetImportJobs() []*ImportJob {
	if x != nil {
		return x.ImportJobs
	}
	return nil
}

func (x *ListImportJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListImportJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to get an import job.
type GetImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of details of the import job.
	// Default value is FULL.
	View ImportJobView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ImportJobView" json:"view,omitempty"`
}

func (x *GetImportJobRequest) Reset() {
	*x = GetImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImportJobRequest) ProtoMessage() {}

func (x *GetImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImportJobRequest.ProtoReflect.Descriptor instead.
func (*GetImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{25}
}

func (x *GetImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetImportJobRequest) GetView() ImportJobView {
	if x != nil {
		return x.View
	}
	return ImportJobView_IMPORT_JOB_VIEW_UNSPECIFIED
}

// A request to delete an import job.
type DeleteImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to `true`, any `ImportDataFiles` of this job will also be
	// deleted If set to `false`, the request only works if the job has no data
	// files.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteImportJobRequest) Reset() {
	*x = DeleteImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteImportJobRequest) ProtoMessage() {}

func (x *DeleteImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteImportJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteImportJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteImportJobRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// A request to update an import job.
type UpdateImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Asset` resource by the update.
	// The values specified in the `update_mask` field are relative to the
	// resource, not the full request.
	// A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	ImportJob *ImportJob `protobuf:"bytes,2,opt,name=import_job,json=importJob,proto3" json:"import_job,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateImportJobRequest) Reset() {
	*x = UpdateImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateImportJobRequest) ProtoMessage() {}

func (x *UpdateImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateImportJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateImportJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateImportJobRequest) GetImportJob() *ImportJob {
	if x != nil {
		return x.ImportJob
	}
	return nil
}

func (x *UpdateImportJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to validate an import job.
type ValidateImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the import job to validate.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ValidateImportJobRequest) Reset() {
	*x = ValidateImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidateImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateImportJobRequest) ProtoMessage() {}

func (x *ValidateImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateImportJobRequest.ProtoReflect.Descriptor instead.
func (*ValidateImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{28}
}

func (x *ValidateImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValidateImportJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to run an import job.
type RunImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the import job to run.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *RunImportJobRequest) Reset() {
	*x = RunImportJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunImportJobRequest) ProtoMessage() {}

func (x *RunImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunImportJobRequest.ProtoReflect.Descriptor instead.
func (*RunImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{29}
}

func (x *RunImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RunImportJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to get an import data file.
type GetImportDataFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ImportDataFile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetImportDataFileRequest) Reset() {
	*x = GetImportDataFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetImportDataFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImportDataFileRequest) ProtoMessage() {}

func (x *GetImportDataFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImportDataFileRequest.ProtoReflect.Descriptor instead.
func (*GetImportDataFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{30}
}

func (x *GetImportDataFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list import data files of an import job.
type ListImportDataFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent of the `ImportDataFiles` resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of data files to return. The service may return
	// fewer than this value. If unspecified, at most 500 data files will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListImportDataFiles` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListImportDataFiles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListImportDataFilesRequest) Reset() {
	*x = ListImportDataFilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImportDataFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImportDataFilesRequest) ProtoMessage() {}

func (x *ListImportDataFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImportDataFilesRequest.ProtoReflect.Descriptor instead.
func (*ListImportDataFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{31}
}

func (x *ListImportDataFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListImportDataFilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImportDataFilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListImportDataFilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImportDataFilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for listing payload files of an import job.
type ListImportDataFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of import data files.
	ImportDataFiles []*ImportDataFile `protobuf:"bytes,1,rep,name=import_data_files,json=importDataFiles,proto3" json:"import_data_files,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListImportDataFilesResponse) Reset() {
	*x = ListImportDataFilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListImportDataFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImportDataFilesResponse) ProtoMessage() {}

func (x *ListImportDataFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImportDataFilesResponse.ProtoReflect.Descriptor instead.
func (*ListImportDataFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{32}
}

func (x *ListImportDataFilesResponse) GetImportDataFiles() []*ImportDataFile {
	if x != nil {
		return x.ImportDataFiles
	}
	return nil
}

func (x *ListImportDataFilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListImportDataFilesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to create an `ImportDataFile` resource.
type CreateImportDataFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent of the ImportDataFile.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the new data file.
	ImportDataFileId string `protobuf:"bytes,2,opt,name=import_data_file_id,json=importDataFileId,proto3" json:"import_data_file_id,omitempty"`
	// Required. The resource being created.
	ImportDataFile *ImportDataFile `protobuf:"bytes,3,opt,name=import_data_file,json=importDataFile,proto3" json:"import_data_file,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateImportDataFileRequest) Reset() {
	*x = CreateImportDataFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateImportDataFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateImportDataFileRequest) ProtoMessage() {}

func (x *CreateImportDataFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateImportDataFileRequest.ProtoReflect.Descriptor instead.
func (*CreateImportDataFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{33}
}

func (x *CreateImportDataFileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateImportDataFileRequest) GetImportDataFileId() string {
	if x != nil {
		return x.ImportDataFileId
	}
	return ""
}

func (x *CreateImportDataFileRequest) GetImportDataFile() *ImportDataFile {
	if x != nil {
		return x.ImportDataFile
	}
	return nil
}

func (x *CreateImportDataFileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete an `ImportDataFile` resource.
type DeleteImportDataFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ImportDataFile to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteImportDataFileRequest) Reset() {
	*x = DeleteImportDataFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteImportDataFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteImportDataFileRequest) ProtoMessage() {}

func (x *DeleteImportDataFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteImportDataFileRequest.ProtoReflect.Descriptor instead.
func (*DeleteImportDataFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteImportDataFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteImportDataFileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to list groups.
type ListGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListGroupsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGroupsRequest) Reset() {
	*x = ListGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsRequest) ProtoMessage() {}

func (x *ListGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{35}
}

func (x *ListGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// A response for listing groups.
type ListGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Group
	Groups []*Group `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGroupsResponse) Reset() {
	*x = ListGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsResponse) ProtoMessage() {}

func (x *ListGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{36}
}

func (x *ListGroupsResponse) GetGroups() []*Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *ListGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGroupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to get a group.
type GetGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGroupRequest) Reset() {
	*x = GetGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupRequest) ProtoMessage() {}

func (x *GetGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupRequest.ProtoReflect.Descriptor instead.
func (*GetGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{37}
}

func (x *GetGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to create a group.
type CreateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User specified ID for the group. It will become the last
	// component of the group name. The ID must be unique within the project, must
	// conform with RFC-1034, is restricted to lower-cased letters, and has a
	// maximum length of 63 characters. The ID must match the regular expression:
	// `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Required. The group resource being created.
	Group *Group `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateGroupRequest) Reset() {
	*x = CreateGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupRequest) ProtoMessage() {}

func (x *CreateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{38}
}

func (x *CreateGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGroupRequest) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *CreateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *CreateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to update a group.
type UpdateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Group` resource by the update.
	// The values specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The group resource being updated.
	Group *Group `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateGroupRequest) Reset() {
	*x = UpdateGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGroupRequest) ProtoMessage() {}

func (x *UpdateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{39}
}

func (x *UpdateGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *UpdateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a group.
type DeleteGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the group resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteGroupRequest) Reset() {
	*x = DeleteGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGroupRequest) ProtoMessage() {}

func (x *DeleteGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{40}
}

func (x *DeleteGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to add assets to a group.
type AddAssetsToGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Group reference.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. List of assets to be added.
	// The maximum number of assets that can be added in a single request is
	// 1000.
	Assets *AssetList `protobuf:"bytes,3,opt,name=assets,proto3" json:"assets,omitempty"`
	// Optional. When this value is set to `false` and one of the given assets is
	// already an existing member of the group, the operation fails with an
	// `Already Exists` error. When set to `true` this situation is silently
	// ignored by the server.
	//
	// Default value is `false`.
	AllowExisting bool `protobuf:"varint,4,opt,name=allow_existing,json=allowExisting,proto3" json:"allow_existing,omitempty"`
}

func (x *AddAssetsToGroupRequest) Reset() {
	*x = AddAssetsToGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddAssetsToGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddAssetsToGroupRequest) ProtoMessage() {}

func (x *AddAssetsToGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddAssetsToGroupRequest.ProtoReflect.Descriptor instead.
func (*AddAssetsToGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{41}
}

func (x *AddAssetsToGroupRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *AddAssetsToGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *AddAssetsToGroupRequest) GetAssets() *AssetList {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *AddAssetsToGroupRequest) GetAllowExisting() bool {
	if x != nil {
		return x.AllowExisting
	}
	return false
}

// A request to remove assets from a group.
type RemoveAssetsFromGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Group reference.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. List of assets to be removed.
	// The maximum number of assets that can be removed in a single request is
	// 1000.
	Assets *AssetList `protobuf:"bytes,3,opt,name=assets,proto3" json:"assets,omitempty"`
	// Optional. When this value is set to `false` and one of the given assets is
	// not an existing member of the group, the operation fails with a `Not Found`
	// error. When set to `true` this situation is silently ignored by the server.
	//
	// Default value is `false`.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *RemoveAssetsFromGroupRequest) Reset() {
	*x = RemoveAssetsFromGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveAssetsFromGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveAssetsFromGroupRequest) ProtoMessage() {}

func (x *RemoveAssetsFromGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveAssetsFromGroupRequest.ProtoReflect.Descriptor instead.
func (*RemoveAssetsFromGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{42}
}

func (x *RemoveAssetsFromGroupRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *RemoveAssetsFromGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *RemoveAssetsFromGroupRequest) GetAssets() *AssetList {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *RemoveAssetsFromGroupRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// A request to list error frames for a source.
type ListErrorFramesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value (the source) for `ListErrorFramesRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An optional view mode to control the level of details of each
	// error frame. The default is a BASIC frame view.
	View ErrorFrameView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ErrorFrameView" json:"view,omitempty"`
}

func (x *ListErrorFramesRequest) Reset() {
	*x = ListErrorFramesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListErrorFramesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListErrorFramesRequest) ProtoMessage() {}

func (x *ListErrorFramesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListErrorFramesRequest.ProtoReflect.Descriptor instead.
func (*ListErrorFramesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{43}
}

func (x *ListErrorFramesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListErrorFramesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListErrorFramesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListErrorFramesRequest) GetView() ErrorFrameView {
	if x != nil {
		return x.View
	}
	return ErrorFrameView_ERROR_FRAME_VIEW_UNSPECIFIED
}

// A response for listing error frames.
type ListErrorFramesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of error frames.
	ErrorFrames []*ErrorFrame `protobuf:"bytes,1,rep,name=error_frames,json=errorFrames,proto3" json:"error_frames,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListErrorFramesResponse) Reset() {
	*x = ListErrorFramesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListErrorFramesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListErrorFramesResponse) ProtoMessage() {}

func (x *ListErrorFramesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListErrorFramesResponse.ProtoReflect.Descriptor instead.
func (*ListErrorFramesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{44}
}

func (x *ListErrorFramesResponse) GetErrorFrames() []*ErrorFrame {
	if x != nil {
		return x.ErrorFrames
	}
	return nil
}

func (x *ListErrorFramesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListErrorFramesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

type GetErrorFrameRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the frame to retrieve.
	// Format:
	// projects/{project}/locations/{location}/sources/{source}/errorFrames/{error_frame}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional view mode to control the level of details for the
	// frame. The default is a basic frame view.
	View ErrorFrameView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ErrorFrameView" json:"view,omitempty"`
}

func (x *GetErrorFrameRequest) Reset() {
	*x = GetErrorFrameRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetErrorFrameRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetErrorFrameRequest) ProtoMessage() {}

func (x *GetErrorFrameRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetErrorFrameRequest.ProtoReflect.Descriptor instead.
func (*GetErrorFrameRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{45}
}

func (x *GetErrorFrameRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetErrorFrameRequest) GetView() ErrorFrameView {
	if x != nil {
		return x.View
	}
	return ErrorFrameView_ERROR_FRAME_VIEW_UNSPECIFIED
}

// A request for a list of sources.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListSourcesRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server may return fewer items than requested.
	// If unspecified, the server will pick an appropriate default value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results that the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{46}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing sources.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of sources.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{47}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSourcesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to get a source.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{48}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to create a source.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User specified ID for the source. It will become the last
	// component of the source name. The ID must be unique within the project,
	// must conform with RFC-1034, is restricted to lower-cased letters, and has a
	// maximum length of 63 characters. The ID must match the regular expression:
	// `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
	SourceId string `protobuf:"bytes,2,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Required. The resource being created.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{49}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CreateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to update a source.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Source` resource by the update.
	// The values specified in the `update_mask` field are relative to the
	// resource, not the full request.
	// A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{50}
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a source.
type DeleteSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteSourceRequest) Reset() {
	*x = DeleteSourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSourceRequest) ProtoMessage() {}

func (x *DeleteSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSourceRequest.ProtoReflect.Descriptor instead.
func (*DeleteSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{51}
}

func (x *DeleteSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for listing preference sets.
type ListPreferenceSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListPreferenceSetsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, at most 500 preference sets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPreferenceSetsRequest) Reset() {
	*x = ListPreferenceSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPreferenceSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPreferenceSetsRequest) ProtoMessage() {}

func (x *ListPreferenceSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPreferenceSetsRequest.ProtoReflect.Descriptor instead.
func (*ListPreferenceSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{52}
}

func (x *ListPreferenceSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPreferenceSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPreferenceSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPreferenceSetsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing preference sets.
type ListPreferenceSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of PreferenceSets
	PreferenceSets []*PreferenceSet `protobuf:"bytes,1,rep,name=preference_sets,json=preferenceSets,proto3" json:"preference_sets,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPreferenceSetsResponse) Reset() {
	*x = ListPreferenceSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPreferenceSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPreferenceSetsResponse) ProtoMessage() {}

func (x *ListPreferenceSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPreferenceSetsResponse.ProtoReflect.Descriptor instead.
func (*ListPreferenceSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{53}
}

func (x *ListPreferenceSetsResponse) GetPreferenceSets() []*PreferenceSet {
	if x != nil {
		return x.PreferenceSets
	}
	return nil
}

func (x *ListPreferenceSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPreferenceSetsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to get a preference set.
type GetPreferenceSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPreferenceSetRequest) Reset() {
	*x = GetPreferenceSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPreferenceSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPreferenceSetRequest) ProtoMessage() {}

func (x *GetPreferenceSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPreferenceSetRequest.ProtoReflect.Descriptor instead.
func (*GetPreferenceSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{54}
}

func (x *GetPreferenceSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to create a preference set.
type CreatePreferenceSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User specified ID for the preference set. It will become the last
	// component of the preference set name. The ID must be unique within the
	// project, must conform with RFC-1034, is restricted to lower-cased letters,
	// and has a maximum length of 63 characters. The ID must match the regular
	// expression
	// `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
	PreferenceSetId string `protobuf:"bytes,2,opt,name=preference_set_id,json=preferenceSetId,proto3" json:"preference_set_id,omitempty"`
	// Required. The preference set resource being created.
	PreferenceSet *PreferenceSet `protobuf:"bytes,3,opt,name=preference_set,json=preferenceSet,proto3" json:"preference_set,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreatePreferenceSetRequest) Reset() {
	*x = CreatePreferenceSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePreferenceSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePreferenceSetRequest) ProtoMessage() {}

func (x *CreatePreferenceSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePreferenceSetRequest.ProtoReflect.Descriptor instead.
func (*CreatePreferenceSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{55}
}

func (x *CreatePreferenceSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePreferenceSetRequest) GetPreferenceSetId() string {
	if x != nil {
		return x.PreferenceSetId
	}
	return ""
}

func (x *CreatePreferenceSetRequest) GetPreferenceSet() *PreferenceSet {
	if x != nil {
		return x.PreferenceSet
	}
	return nil
}

func (x *CreatePreferenceSetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to update a preference set.
type UpdatePreferenceSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `PreferenceSet` resource by the update.
	// The values specified in the `update_mask` field are relative to the
	// resource, not the full request.
	// A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The preference set resource being updated.
	PreferenceSet *PreferenceSet `protobuf:"bytes,2,opt,name=preference_set,json=preferenceSet,proto3" json:"preference_set,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdatePreferenceSetRequest) Reset() {
	*x = UpdatePreferenceSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePreferenceSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePreferenceSetRequest) ProtoMessage() {}

func (x *UpdatePreferenceSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePreferenceSetRequest.ProtoReflect.Descriptor instead.
func (*UpdatePreferenceSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{56}
}

func (x *UpdatePreferenceSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePreferenceSetRequest) GetPreferenceSet() *PreferenceSet {
	if x != nil {
		return x.PreferenceSet
	}
	return nil
}

func (x *UpdatePreferenceSetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a preference set.
type DeletePreferenceSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the group resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeletePreferenceSetRequest) Reset() {
	*x = DeletePreferenceSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePreferenceSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePreferenceSetRequest) ProtoMessage() {}

func (x *DeletePreferenceSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePreferenceSetRequest.ProtoReflect.Descriptor instead.
func (*DeletePreferenceSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{57}
}

func (x *DeletePreferenceSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePreferenceSetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to get the settings.
type GetSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSettingsRequest) Reset() {
	*x = GetSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingsRequest) ProtoMessage() {}

func (x *GetSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{58}
}

func (x *GetSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update the settings.
type UpdateSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Settings` resource by the update.
	// The values specified in the `update_mask` field are relative to the
	// resource, not the full request.
	// A field will be overwritten if it is in the mask.
	// A single * value in the mask lets you to overwrite all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The project settings resource being updated.
	Settings *Settings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSettingsRequest) Reset() {
	*x = UpdateSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingsRequest) ProtoMessage() {}

func (x *UpdateSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{59}
}

func (x *UpdateSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSettingsRequest) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateSettingsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to create a `ReportConfig` resource.
type CreateReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User specified ID for the report config. It will become the last
	// component of the report config name. The ID must be unique within the
	// project, must conform with RFC-1034, is restricted to lower-cased letters,
	// and has a maximum length of 63 characters. The ID must match the regular
	// expression: [a-z]([a-z0-9-]{0,61}[a-z0-9])?.
	ReportConfigId string `protobuf:"bytes,2,opt,name=report_config_id,json=reportConfigId,proto3" json:"report_config_id,omitempty"`
	// Required. The report config set resource being created.
	ReportConfig *ReportConfig `protobuf:"bytes,3,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateReportConfigRequest) Reset() {
	*x = CreateReportConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReportConfigRequest) ProtoMessage() {}

func (x *CreateReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReportConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{60}
}

func (x *CreateReportConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReportConfigRequest) GetReportConfigId() string {
	if x != nil {
		return x.ReportConfigId
	}
	return ""
}

func (x *CreateReportConfigRequest) GetReportConfig() *ReportConfig {
	if x != nil {
		return x.ReportConfig
	}
	return nil
}

func (x *CreateReportConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to delete a ReportConfig.
type DeleteReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to `true`, any child `Reports` of this entity will also be
	// deleted. If set to `false`, the request only works if the resource has no
	// children.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteReportConfigRequest) Reset() {
	*x = DeleteReportConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReportConfigRequest) ProtoMessage() {}

func (x *DeleteReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReportConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{61}
}

func (x *DeleteReportConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteReportConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteReportConfigRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// A request to get a Report.
type GetReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Determines what information to retrieve for the Report.
	View ReportView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ReportView" json:"view,omitempty"`
}

func (x *GetReportRequest) Reset() {
	*x = GetReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReportRequest) ProtoMessage() {}

func (x *GetReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReportRequest.ProtoReflect.Descriptor instead.
func (*GetReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{62}
}

func (x *GetReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetReportRequest) GetView() ReportView {
	if x != nil {
		return x.View
	}
	return ReportView_REPORT_VIEW_UNSPECIFIED
}

// A request for a list of Reports.
type ListReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListReportsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. The server may return fewer items than requested.
	// If unspecified, the server will pick an appropriate default value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results that the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Determines what information to retrieve for each Report.
	View ReportView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.migrationcenter.v1.ReportView" json:"view,omitempty"`
}

func (x *ListReportsRequest) Reset() {
	*x = ListReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportsRequest) ProtoMessage() {}

func (x *ListReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportsRequest.ProtoReflect.Descriptor instead.
func (*ListReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{63}
}

func (x *ListReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReportsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListReportsRequest) GetView() ReportView {
	if x != nil {
		return x.View
	}
	return ReportView_REPORT_VIEW_UNSPECIFIED
}

// Response message for listing Reports.
type ListReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Reports.
	Reports []*Report `protobuf:"bytes,1,rep,name=reports,proto3" json:"reports,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReportsResponse) Reset() {
	*x = ListReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportsResponse) ProtoMessage() {}

func (x *ListReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportsResponse.ProtoReflect.Descriptor instead.
func (*ListReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{64}
}

func (x *ListReportsResponse) GetReports() []*Report {
	if x != nil {
		return x.Reports
	}
	return nil
}

func (x *ListReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReportsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to delete a Report.
type DeleteReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteReportRequest) Reset() {
	*x = DeleteReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReportRequest) ProtoMessage() {}

func (x *DeleteReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReportRequest.ProtoReflect.Descriptor instead.
func (*DeleteReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{65}
}

func (x *DeleteReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to get a `ReportConfig` resource.
type GetReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReportConfigRequest) Reset() {
	*x = GetReportConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReportConfigRequest) ProtoMessage() {}

func (x *GetReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReportConfigRequest.ProtoReflect.Descriptor instead.
func (*GetReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{66}
}

func (x *GetReportConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to get a list of `ReportConfig` resources.
type ListReportConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for `ListReportConfigsRequest`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to sort by. See https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReportConfigsRequest) Reset() {
	*x = ListReportConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportConfigsRequest) ProtoMessage() {}

func (x *ListReportConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListReportConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{67}
}

func (x *ListReportConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReportConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReportConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReportConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReportConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for listing report configs.
type ListReportConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of report configs.
	ReportConfigs []*ReportConfig `protobuf:"bytes,1,rep,name=report_configs,json=reportConfigs,proto3" json:"report_configs,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReportConfigsResponse) Reset() {
	*x = ListReportConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReportConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportConfigsResponse) ProtoMessage() {}

func (x *ListReportConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListReportConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{68}
}

func (x *ListReportConfigsResponse) GetReportConfigs() []*ReportConfig {
	if x != nil {
		return x.ReportConfigs
	}
	return nil
}

func (x *ListReportConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReportConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for creating a Report.
type CreateReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User specified id for the report. It will become the last
	// component of the report name. The id must be unique within the project,
	// must conform with RFC-1034, is restricted to lower-cased letters, and has a
	// maximum length of 63 characters. The id must match the regular expression:
	// [a-z]([a-z0-9-]{0,61}[a-z0-9])?.
	ReportId string `protobuf:"bytes,2,opt,name=report_id,json=reportId,proto3" json:"report_id,omitempty"`
	// Required. The report resource being created.
	Report *Report `protobuf:"bytes,3,opt,name=report,proto3" json:"report,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateReportRequest) Reset() {
	*x = CreateReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReportRequest) ProtoMessage() {}

func (x *CreateReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReportRequest.ProtoReflect.Descriptor instead.
func (*CreateReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{69}
}

func (x *CreateReportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReportRequest) GetReportId() string {
	if x != nil {
		return x.ReportId
	}
	return ""
}

func (x *CreateReportRequest) GetReport() *Report {
	if x != nil {
		return x.Report
	}
	return nil
}

func (x *CreateReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Collection of frame data.
type Frames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A repeated field of asset data.
	FramesData []*AssetFrame `protobuf:"bytes,1,rep,name=frames_data,json=framesData,proto3" json:"frames_data,omitempty"`
}

func (x *Frames) Reset() {
	*x = Frames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Frames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Frames) ProtoMessage() {}

func (x *Frames) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Frames.ProtoReflect.Descriptor instead.
func (*Frames) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{70}
}

func (x *Frames) GetFramesData() []*AssetFrame {
	if x != nil {
		return x.FramesData
	}
	return nil
}

// Contains data reported from an inventory source on an asset.
type AssetFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The internal data of the frame is a oneof field depending on the type
	// of asset information in the frame.
	//
	// Types that are assignable to FrameData:
	//
	//	*AssetFrame_MachineDetails
	FrameData isAssetFrame_FrameData `protobuf_oneof:"FrameData"`
	// The time the data was reported.
	ReportTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=report_time,json=reportTime,proto3" json:"report_time,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,11,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Generic asset attributes.
	Attributes map[string]string `protobuf:"bytes,12,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Asset performance data samples.
	// Samples that are from more than 40 days ago or after tomorrow are ignored.
	PerformanceSamples []*PerformanceSample `protobuf:"bytes,13,rep,name=performance_samples,json=performanceSamples,proto3" json:"performance_samples,omitempty"`
	// Optional. Trace token is optionally provided to assist with debugging and
	// traceability.
	TraceToken string `protobuf:"bytes,14,opt,name=trace_token,json=traceToken,proto3" json:"trace_token,omitempty"`
}

func (x *AssetFrame) Reset() {
	*x = AssetFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetFrame) ProtoMessage() {}

func (x *AssetFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetFrame.ProtoReflect.Descriptor instead.
func (*AssetFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{71}
}

func (m *AssetFrame) GetFrameData() isAssetFrame_FrameData {
	if m != nil {
		return m.FrameData
	}
	return nil
}

func (x *AssetFrame) GetMachineDetails() *MachineDetails {
	if x, ok := x.GetFrameData().(*AssetFrame_MachineDetails); ok {
		return x.MachineDetails
	}
	return nil
}

func (x *AssetFrame) GetReportTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReportTime
	}
	return nil
}

func (x *AssetFrame) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AssetFrame) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *AssetFrame) GetPerformanceSamples() []*PerformanceSample {
	if x != nil {
		return x.PerformanceSamples
	}
	return nil
}

func (x *AssetFrame) GetTraceToken() string {
	if x != nil {
		return x.TraceToken
	}
	return ""
}

type isAssetFrame_FrameData interface {
	isAssetFrame_FrameData()
}

type AssetFrame_MachineDetails struct {
	// Asset information specific for virtual machines.
	MachineDetails *MachineDetails `protobuf:"bytes,1,opt,name=machine_details,json=machineDetails,proto3,oneof"`
}

func (*AssetFrame_MachineDetails) isAssetFrame_FrameData() {}

// Details of a machine.
type MachineDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Machine unique identifier.
	Uuid string `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// Machine name.
	MachineName string `protobuf:"bytes,2,opt,name=machine_name,json=machineName,proto3" json:"machine_name,omitempty"`
	// Machine creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Number of CPU cores in the machine. Must be non-negative.
	CoreCount int32 `protobuf:"varint,4,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
	// The amount of memory in the machine. Must be non-negative.
	MemoryMb int32 `protobuf:"varint,5,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// Power state of the machine.
	PowerState MachineDetails_PowerState `protobuf:"varint,6,opt,name=power_state,json=powerState,proto3,enum=google.cloud.migrationcenter.v1.MachineDetails_PowerState" json:"power_state,omitempty"`
	// Architecture details (vendor, CPU architecture).
	Architecture *MachineArchitectureDetails `protobuf:"bytes,7,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Guest OS information.
	GuestOs *GuestOsDetails `protobuf:"bytes,8,opt,name=guest_os,json=guestOs,proto3" json:"guest_os,omitempty"`
	// Network details.
	Network *MachineNetworkDetails `protobuf:"bytes,9,opt,name=network,proto3" json:"network,omitempty"`
	// Disk details.
	Disks *MachineDiskDetails `protobuf:"bytes,10,opt,name=disks,proto3" json:"disks,omitempty"`
	// Platform specific information.
	Platform *PlatformDetails `protobuf:"bytes,11,opt,name=platform,proto3" json:"platform,omitempty"`
}

func (x *MachineDetails) Reset() {
	*x = MachineDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineDetails) ProtoMessage() {}

func (x *MachineDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineDetails.ProtoReflect.Descriptor instead.
func (*MachineDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{72}
}

func (x *MachineDetails) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *MachineDetails) GetMachineName() string {
	if x != nil {
		return x.MachineName
	}
	return ""
}

func (x *MachineDetails) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MachineDetails) GetCoreCount() int32 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

func (x *MachineDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *MachineDetails) GetPowerState() MachineDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return MachineDetails_POWER_STATE_UNSPECIFIED
}

func (x *MachineDetails) GetArchitecture() *MachineArchitectureDetails {
	if x != nil {
		return x.Architecture
	}
	return nil
}

func (x *MachineDetails) GetGuestOs() *GuestOsDetails {
	if x != nil {
		return x.GuestOs
	}
	return nil
}

func (x *MachineDetails) GetNetwork() *MachineNetworkDetails {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *MachineDetails) GetDisks() *MachineDiskDetails {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *MachineDetails) GetPlatform() *PlatformDetails {
	if x != nil {
		return x.Platform
	}
	return nil
}

// Details of the machine architecture.
type MachineArchitectureDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU architecture, e.g., "x64-based PC", "x86_64", "i686" etc.
	CpuArchitecture string `protobuf:"bytes,1,opt,name=cpu_architecture,json=cpuArchitecture,proto3" json:"cpu_architecture,omitempty"`
	// CPU name, e.g., "Intel Xeon E5-2690", "AMD EPYC 7571" etc.
	CpuName string `protobuf:"bytes,2,opt,name=cpu_name,json=cpuName,proto3" json:"cpu_name,omitempty"`
	// Hardware vendor.
	Vendor string `protobuf:"bytes,3,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// Number of CPU threads allocated to the machine.
	CpuThreadCount int32 `protobuf:"varint,4,opt,name=cpu_thread_count,json=cpuThreadCount,proto3" json:"cpu_thread_count,omitempty"`
	// Number of processor sockets allocated to the machine.
	CpuSocketCount int32 `protobuf:"varint,5,opt,name=cpu_socket_count,json=cpuSocketCount,proto3" json:"cpu_socket_count,omitempty"`
	// BIOS Details.
	Bios *BiosDetails `protobuf:"bytes,6,opt,name=bios,proto3" json:"bios,omitempty"`
	// Firmware type.
	FirmwareType MachineArchitectureDetails_FirmwareType `protobuf:"varint,7,opt,name=firmware_type,json=firmwareType,proto3,enum=google.cloud.migrationcenter.v1.MachineArchitectureDetails_FirmwareType" json:"firmware_type,omitempty"`
	// CPU hyper-threading support.
	Hyperthreading MachineArchitectureDetails_CpuHyperThreading `protobuf:"varint,8,opt,name=hyperthreading,proto3,enum=google.cloud.migrationcenter.v1.MachineArchitectureDetails_CpuHyperThreading" json:"hyperthreading,omitempty"`
}

func (x *MachineArchitectureDetails) Reset() {
	*x = MachineArchitectureDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineArchitectureDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineArchitectureDetails) ProtoMessage() {}

func (x *MachineArchitectureDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineArchitectureDetails.ProtoReflect.Descriptor instead.
func (*MachineArchitectureDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{73}
}

func (x *MachineArchitectureDetails) GetCpuArchitecture() string {
	if x != nil {
		return x.CpuArchitecture
	}
	return ""
}

func (x *MachineArchitectureDetails) GetCpuName() string {
	if x != nil {
		return x.CpuName
	}
	return ""
}

func (x *MachineArchitectureDetails) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

func (x *MachineArchitectureDetails) GetCpuThreadCount() int32 {
	if x != nil {
		return x.CpuThreadCount
	}
	return 0
}

func (x *MachineArchitectureDetails) GetCpuSocketCount() int32 {
	if x != nil {
		return x.CpuSocketCount
	}
	return 0
}

func (x *MachineArchitectureDetails) GetBios() *BiosDetails {
	if x != nil {
		return x.Bios
	}
	return nil
}

func (x *MachineArchitectureDetails) GetFirmwareType() MachineArchitectureDetails_FirmwareType {
	if x != nil {
		return x.FirmwareType
	}
	return MachineArchitectureDetails_FIRMWARE_TYPE_UNSPECIFIED
}

func (x *MachineArchitectureDetails) GetHyperthreading() MachineArchitectureDetails_CpuHyperThreading {
	if x != nil {
		return x.Hyperthreading
	}
	return MachineArchitectureDetails_CPU_HYPER_THREADING_UNSPECIFIED
}

// Details about the BIOS.
type BiosDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BIOS name.
	// This fields is deprecated. Please use the `id` field instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
	BiosName string `protobuf:"bytes,1,opt,name=bios_name,json=biosName,proto3" json:"bios_name,omitempty"`
	// BIOS ID.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// BIOS manufacturer.
	Manufacturer string `protobuf:"bytes,3,opt,name=manufacturer,proto3" json:"manufacturer,omitempty"`
	// BIOS version.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// BIOS release date.
	ReleaseDate *date.Date `protobuf:"bytes,5,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
	// SMBIOS UUID.
	SmbiosUuid string `protobuf:"bytes,6,opt,name=smbios_uuid,json=smbiosUuid,proto3" json:"smbios_uuid,omitempty"`
}

func (x *BiosDetails) Reset() {
	*x = BiosDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BiosDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BiosDetails) ProtoMessage() {}

func (x *BiosDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BiosDetails.ProtoReflect.Descriptor instead.
func (*BiosDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{74}
}

// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
func (x *BiosDetails) GetBiosName() string {
	if x != nil {
		return x.BiosName
	}
	return ""
}

func (x *BiosDetails) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BiosDetails) GetManufacturer() string {
	if x != nil {
		return x.Manufacturer
	}
	return ""
}

func (x *BiosDetails) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *BiosDetails) GetReleaseDate() *date.Date {
	if x != nil {
		return x.ReleaseDate
	}
	return nil
}

func (x *BiosDetails) GetSmbiosUuid() string {
	if x != nil {
		return x.SmbiosUuid
	}
	return ""
}

// Details of network adapters and settings.
type MachineNetworkDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The primary IP address of the machine.
	PrimaryIpAddress string `protobuf:"bytes,1,opt,name=primary_ip_address,json=primaryIpAddress,proto3" json:"primary_ip_address,omitempty"`
	// The public IP address of the machine.
	PublicIpAddress string `protobuf:"bytes,2,opt,name=public_ip_address,json=publicIpAddress,proto3" json:"public_ip_address,omitempty"`
	// MAC address of the machine.
	// This property is used to uniqly identify the machine.
	PrimaryMacAddress string `protobuf:"bytes,3,opt,name=primary_mac_address,json=primaryMacAddress,proto3" json:"primary_mac_address,omitempty"`
	// List of network adapters.
	Adapters *NetworkAdapterList `protobuf:"bytes,4,opt,name=adapters,proto3" json:"adapters,omitempty"`
}

func (x *MachineNetworkDetails) Reset() {
	*x = MachineNetworkDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineNetworkDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineNetworkDetails) ProtoMessage() {}

func (x *MachineNetworkDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineNetworkDetails.ProtoReflect.Descriptor instead.
func (*MachineNetworkDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{75}
}

func (x *MachineNetworkDetails) GetPrimaryIpAddress() string {
	if x != nil {
		return x.PrimaryIpAddress
	}
	return ""
}

func (x *MachineNetworkDetails) GetPublicIpAddress() string {
	if x != nil {
		return x.PublicIpAddress
	}
	return ""
}

func (x *MachineNetworkDetails) GetPrimaryMacAddress() string {
	if x != nil {
		return x.PrimaryMacAddress
	}
	return ""
}

func (x *MachineNetworkDetails) GetAdapters() *NetworkAdapterList {
	if x != nil {
		return x.Adapters
	}
	return nil
}

// List of network adapters.
type NetworkAdapterList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network adapter entries.
	Entries []*NetworkAdapterDetails `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *NetworkAdapterList) Reset() {
	*x = NetworkAdapterList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkAdapterList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAdapterList) ProtoMessage() {}

func (x *NetworkAdapterList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAdapterList.ProtoReflect.Descriptor instead.
func (*NetworkAdapterList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{76}
}

func (x *NetworkAdapterList) GetEntries() []*NetworkAdapterDetails {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Details of network adapter.
type NetworkAdapterDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network adapter type (e.g. VMXNET3).
	AdapterType string `protobuf:"bytes,1,opt,name=adapter_type,json=adapterType,proto3" json:"adapter_type,omitempty"`
	// MAC address.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// NetworkAddressList
	Addresses *NetworkAddressList `protobuf:"bytes,3,opt,name=addresses,proto3" json:"addresses,omitempty"`
}

func (x *NetworkAdapterDetails) Reset() {
	*x = NetworkAdapterDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkAdapterDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAdapterDetails) ProtoMessage() {}

func (x *NetworkAdapterDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAdapterDetails.ProtoReflect.Descriptor instead.
func (*NetworkAdapterDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{77}
}

func (x *NetworkAdapterDetails) GetAdapterType() string {
	if x != nil {
		return x.AdapterType
	}
	return ""
}

func (x *NetworkAdapterDetails) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *NetworkAdapterDetails) GetAddresses() *NetworkAddressList {
	if x != nil {
		return x.Addresses
	}
	return nil
}

// List of allocated/assigned network addresses.
type NetworkAddressList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network address entries.
	Entries []*NetworkAddress `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *NetworkAddressList) Reset() {
	*x = NetworkAddressList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkAddressList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAddressList) ProtoMessage() {}

func (x *NetworkAddressList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAddressList.ProtoReflect.Descriptor instead.
func (*NetworkAddressList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{78}
}

func (x *NetworkAddressList) GetEntries() []*NetworkAddress {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Details of network address.
type NetworkAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Assigned or configured IP Address.
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Subnet mask.
	SubnetMask string `protobuf:"bytes,2,opt,name=subnet_mask,json=subnetMask,proto3" json:"subnet_mask,omitempty"`
	// Broadcast address.
	Bcast string `protobuf:"bytes,3,opt,name=bcast,proto3" json:"bcast,omitempty"`
	// Fully qualified domain name.
	Fqdn string `protobuf:"bytes,4,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// Whether DHCP is used to assign addresses.
	Assignment NetworkAddress_AddressAssignment `protobuf:"varint,5,opt,name=assignment,proto3,enum=google.cloud.migrationcenter.v1.NetworkAddress_AddressAssignment" json:"assignment,omitempty"`
}

func (x *NetworkAddress) Reset() {
	*x = NetworkAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAddress) ProtoMessage() {}

func (x *NetworkAddress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAddress.ProtoReflect.Descriptor instead.
func (*NetworkAddress) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{79}
}

func (x *NetworkAddress) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *NetworkAddress) GetSubnetMask() string {
	if x != nil {
		return x.SubnetMask
	}
	return ""
}

func (x *NetworkAddress) GetBcast() string {
	if x != nil {
		return x.Bcast
	}
	return ""
}

func (x *NetworkAddress) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

func (x *NetworkAddress) GetAssignment() NetworkAddress_AddressAssignment {
	if x != nil {
		return x.Assignment
	}
	return NetworkAddress_ADDRESS_ASSIGNMENT_UNSPECIFIED
}

// Details of machine disks.
type MachineDiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk total Capacity.
	TotalCapacityBytes int64 `protobuf:"varint,1,opt,name=total_capacity_bytes,json=totalCapacityBytes,proto3" json:"total_capacity_bytes,omitempty"`
	// Total disk free space.
	TotalFreeBytes int64 `protobuf:"varint,2,opt,name=total_free_bytes,json=totalFreeBytes,proto3" json:"total_free_bytes,omitempty"`
	// List of disks.
	Disks *DiskEntryList `protobuf:"bytes,3,opt,name=disks,proto3" json:"disks,omitempty"`
}

func (x *MachineDiskDetails) Reset() {
	*x = MachineDiskDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineDiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineDiskDetails) ProtoMessage() {}

func (x *MachineDiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineDiskDetails.ProtoReflect.Descriptor instead.
func (*MachineDiskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{80}
}

func (x *MachineDiskDetails) GetTotalCapacityBytes() int64 {
	if x != nil {
		return x.TotalCapacityBytes
	}
	return 0
}

func (x *MachineDiskDetails) GetTotalFreeBytes() int64 {
	if x != nil {
		return x.TotalFreeBytes
	}
	return 0
}

func (x *MachineDiskDetails) GetDisks() *DiskEntryList {
	if x != nil {
		return x.Disks
	}
	return nil
}

// VM disks.
type DiskEntryList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk entries.
	Entries []*DiskEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *DiskEntryList) Reset() {
	*x = DiskEntryList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEntryList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEntryList) ProtoMessage() {}

func (x *DiskEntryList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEntryList.ProtoReflect.Descriptor instead.
func (*DiskEntryList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{81}
}

func (x *DiskEntryList) GetEntries() []*DiskEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Single disk entry.
type DiskEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk capacity.
	CapacityBytes int64 `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes,proto3" json:"capacity_bytes,omitempty"`
	// Disk free space.
	FreeBytes int64 `protobuf:"varint,2,opt,name=free_bytes,json=freeBytes,proto3" json:"free_bytes,omitempty"`
	// Disk label.
	DiskLabel string `protobuf:"bytes,3,opt,name=disk_label,json=diskLabel,proto3" json:"disk_label,omitempty"`
	// Disk label type (e.g. BIOS/GPT)
	DiskLabelType string `protobuf:"bytes,4,opt,name=disk_label_type,json=diskLabelType,proto3" json:"disk_label_type,omitempty"`
	// Disks interface type.
	InterfaceType DiskEntry_InterfaceType `protobuf:"varint,5,opt,name=interface_type,json=interfaceType,proto3,enum=google.cloud.migrationcenter.v1.DiskEntry_InterfaceType" json:"interface_type,omitempty"`
	// Partition layout.
	Partitions *DiskPartitionList `protobuf:"bytes,6,opt,name=partitions,proto3" json:"partitions,omitempty"`
	// Disk hardware address (e.g. 0:1 for SCSI).
	HwAddress string `protobuf:"bytes,7,opt,name=hw_address,json=hwAddress,proto3" json:"hw_address,omitempty"`
	// Additional details for specific platforms.
	//
	// Types that are assignable to PlatformSpecific:
	//
	//	*DiskEntry_Vmware
	PlatformSpecific isDiskEntry_PlatformSpecific `protobuf_oneof:"platform_specific"`
}

func (x *DiskEntry) Reset() {
	*x = DiskEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEntry) ProtoMessage() {}

func (x *DiskEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEntry.ProtoReflect.Descriptor instead.
func (*DiskEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{82}
}

func (x *DiskEntry) GetCapacityBytes() int64 {
	if x != nil {
		return x.CapacityBytes
	}
	return 0
}

func (x *DiskEntry) GetFreeBytes() int64 {
	if x != nil {
		return x.FreeBytes
	}
	return 0
}

func (x *DiskEntry) GetDiskLabel() string {
	if x != nil {
		return x.DiskLabel
	}
	return ""
}

func (x *DiskEntry) GetDiskLabelType() string {
	if x != nil {
		return x.DiskLabelType
	}
	return ""
}

func (x *DiskEntry) GetInterfaceType() DiskEntry_InterfaceType {
	if x != nil {
		return x.InterfaceType
	}
	return DiskEntry_INTERFACE_TYPE_UNSPECIFIED
}

func (x *DiskEntry) GetPartitions() *DiskPartitionList {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *DiskEntry) GetHwAddress() string {
	if x != nil {
		return x.HwAddress
	}
	return ""
}

func (m *DiskEntry) GetPlatformSpecific() isDiskEntry_PlatformSpecific {
	if m != nil {
		return m.PlatformSpecific
	}
	return nil
}

func (x *DiskEntry) GetVmware() *VmwareDiskConfig {
	if x, ok := x.GetPlatformSpecific().(*DiskEntry_Vmware); ok {
		return x.Vmware
	}
	return nil
}

type isDiskEntry_PlatformSpecific interface {
	isDiskEntry_PlatformSpecific()
}

type DiskEntry_Vmware struct {
	// VMware disk details.
	Vmware *VmwareDiskConfig `protobuf:"bytes,20,opt,name=vmware,proto3,oneof"`
}

func (*DiskEntry_Vmware) isDiskEntry_PlatformSpecific() {}

// Disk partition list.
type DiskPartitionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition entries.
	Entries []*DiskPartition `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *DiskPartitionList) Reset() {
	*x = DiskPartitionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskPartitionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskPartitionList) ProtoMessage() {}

func (x *DiskPartitionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskPartitionList.ProtoReflect.Descriptor instead.
func (*DiskPartitionList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{83}
}

func (x *DiskPartitionList) GetEntries() []*DiskPartition {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Disk Partition details.
type DiskPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Partition file system.
	FileSystem string `protobuf:"bytes,2,opt,name=file_system,json=fileSystem,proto3" json:"file_system,omitempty"`
	// Mount pount (Linux/Windows) or drive letter (Windows).
	MountPoint string `protobuf:"bytes,3,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	// Partition capacity.
	CapacityBytes int64 `protobuf:"varint,4,opt,name=capacity_bytes,json=capacityBytes,proto3" json:"capacity_bytes,omitempty"`
	// Partition free space.
	FreeBytes int64 `protobuf:"varint,5,opt,name=free_bytes,json=freeBytes,proto3" json:"free_bytes,omitempty"`
	// Partition UUID.
	Uuid string `protobuf:"bytes,6,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// Sub-partitions.
	SubPartitions *DiskPartitionList `protobuf:"bytes,7,opt,name=sub_partitions,json=subPartitions,proto3" json:"sub_partitions,omitempty"`
}

func (x *DiskPartition) Reset() {
	*x = DiskPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskPartition) ProtoMessage() {}

func (x *DiskPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskPartition.ProtoReflect.Descriptor instead.
func (*DiskPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{84}
}

func (x *DiskPartition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DiskPartition) GetFileSystem() string {
	if x != nil {
		return x.FileSystem
	}
	return ""
}

func (x *DiskPartition) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

func (x *DiskPartition) GetCapacityBytes() int64 {
	if x != nil {
		return x.CapacityBytes
	}
	return 0
}

func (x *DiskPartition) GetFreeBytes() int64 {
	if x != nil {
		return x.FreeBytes
	}
	return 0
}

func (x *DiskPartition) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *DiskPartition) GetSubPartitions() *DiskPartitionList {
	if x != nil {
		return x.SubPartitions
	}
	return nil
}

// VMware disk config details.
type VmwareDiskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// VMDK backing type.
	BackingType VmwareDiskConfig_BackingType `protobuf:"varint,1,opt,name=backing_type,json=backingType,proto3,enum=google.cloud.migrationcenter.v1.VmwareDiskConfig_BackingType" json:"backing_type,omitempty"`
	// Is VMDK shared with other VMs.
	Shared bool `protobuf:"varint,2,opt,name=shared,proto3" json:"shared,omitempty"`
	// VMDK disk mode.
	VmdkMode VmwareDiskConfig_VmdkMode `protobuf:"varint,3,opt,name=vmdk_mode,json=vmdkMode,proto3,enum=google.cloud.migrationcenter.v1.VmwareDiskConfig_VmdkMode" json:"vmdk_mode,omitempty"`
	// RDM compatibility mode.
	RdmCompatibility VmwareDiskConfig_RdmCompatibility `protobuf:"varint,4,opt,name=rdm_compatibility,json=rdmCompatibility,proto3,enum=google.cloud.migrationcenter.v1.VmwareDiskConfig_RdmCompatibility" json:"rdm_compatibility,omitempty"`
}

func (x *VmwareDiskConfig) Reset() {
	*x = VmwareDiskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareDiskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareDiskConfig) ProtoMessage() {}

func (x *VmwareDiskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareDiskConfig.ProtoReflect.Descriptor instead.
func (*VmwareDiskConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{85}
}

func (x *VmwareDiskConfig) GetBackingType() VmwareDiskConfig_BackingType {
	if x != nil {
		return x.BackingType
	}
	return VmwareDiskConfig_BACKING_TYPE_UNSPECIFIED
}

func (x *VmwareDiskConfig) GetShared() bool {
	if x != nil {
		return x.Shared
	}
	return false
}

func (x *VmwareDiskConfig) GetVmdkMode() VmwareDiskConfig_VmdkMode {
	if x != nil {
		return x.VmdkMode
	}
	return VmwareDiskConfig_VMDK_MODE_UNSPECIFIED
}

func (x *VmwareDiskConfig) GetRdmCompatibility() VmwareDiskConfig_RdmCompatibility {
	if x != nil {
		return x.RdmCompatibility
	}
	return VmwareDiskConfig_RDM_COMPATIBILITY_UNSPECIFIED
}

// Information from Guest-level collections.
type GuestOsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the operating system.
	OsName string `protobuf:"bytes,1,opt,name=os_name,json=osName,proto3" json:"os_name,omitempty"`
	// What family the OS belong to, if known.
	Family OperatingSystemFamily `protobuf:"varint,2,opt,name=family,proto3,enum=google.cloud.migrationcenter.v1.OperatingSystemFamily" json:"family,omitempty"`
	// The version of the operating system.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// OS and app configuration.
	Config *GuestConfigDetails `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	// Runtime information.
	Runtime *GuestRuntimeDetails `protobuf:"bytes,5,opt,name=runtime,proto3" json:"runtime,omitempty"`
}

func (x *GuestOsDetails) Reset() {
	*x = GuestOsDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestOsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestOsDetails) ProtoMessage() {}

func (x *GuestOsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestOsDetails.ProtoReflect.Descriptor instead.
func (*GuestOsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{86}
}

func (x *GuestOsDetails) GetOsName() string {
	if x != nil {
		return x.OsName
	}
	return ""
}

func (x *GuestOsDetails) GetFamily() OperatingSystemFamily {
	if x != nil {
		return x.Family
	}
	return OperatingSystemFamily_OS_FAMILY_UNKNOWN
}

func (x *GuestOsDetails) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GuestOsDetails) GetConfig() *GuestConfigDetails {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *GuestOsDetails) GetRuntime() *GuestRuntimeDetails {
	if x != nil {
		return x.Runtime
	}
	return nil
}

// Guest OS config information.
type GuestConfigDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OS issue (typically /etc/issue in Linux).
	Issue string `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// Mount list (Linux fstab).
	Fstab *FstabEntryList `protobuf:"bytes,2,opt,name=fstab,proto3" json:"fstab,omitempty"`
	// Hosts file (/etc/hosts).
	Hosts *HostsEntryList `protobuf:"bytes,3,opt,name=hosts,proto3" json:"hosts,omitempty"`
	// NFS exports.
	NfsExports *NfsExportList `protobuf:"bytes,4,opt,name=nfs_exports,json=nfsExports,proto3" json:"nfs_exports,omitempty"`
	// Security-Enhanced Linux (SELinux) mode.
	SelinuxMode GuestConfigDetails_SeLinuxMode `protobuf:"varint,5,opt,name=selinux_mode,json=selinuxMode,proto3,enum=google.cloud.migrationcenter.v1.GuestConfigDetails_SeLinuxMode" json:"selinux_mode,omitempty"`
}

func (x *GuestConfigDetails) Reset() {
	*x = GuestConfigDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestConfigDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestConfigDetails) ProtoMessage() {}

func (x *GuestConfigDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestConfigDetails.ProtoReflect.Descriptor instead.
func (*GuestConfigDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{87}
}

func (x *GuestConfigDetails) GetIssue() string {
	if x != nil {
		return x.Issue
	}
	return ""
}

func (x *GuestConfigDetails) GetFstab() *FstabEntryList {
	if x != nil {
		return x.Fstab
	}
	return nil
}

func (x *GuestConfigDetails) GetHosts() *HostsEntryList {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *GuestConfigDetails) GetNfsExports() *NfsExportList {
	if x != nil {
		return x.NfsExports
	}
	return nil
}

func (x *GuestConfigDetails) GetSelinuxMode() GuestConfigDetails_SeLinuxMode {
	if x != nil {
		return x.SelinuxMode
	}
	return GuestConfigDetails_SE_LINUX_MODE_UNSPECIFIED
}

// Fstab content.
type FstabEntryList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fstab entries.
	Entries []*FstabEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *FstabEntryList) Reset() {
	*x = FstabEntryList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FstabEntryList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FstabEntryList) ProtoMessage() {}

func (x *FstabEntryList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FstabEntryList.ProtoReflect.Descriptor instead.
func (*FstabEntryList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{88}
}

func (x *FstabEntryList) GetEntries() []*FstabEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Single fstab entry.
type FstabEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The block special device or remote filesystem to be mounted.
	Spec string `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// The mount point for the filesystem.
	File string `protobuf:"bytes,2,opt,name=file,proto3" json:"file,omitempty"`
	// The type of the filesystem.
	Vfstype string `protobuf:"bytes,3,opt,name=vfstype,proto3" json:"vfstype,omitempty"`
	// Mount options associated with the filesystem.
	Mntops string `protobuf:"bytes,4,opt,name=mntops,proto3" json:"mntops,omitempty"`
	// Used by dump to determine which filesystems need to be dumped.
	Freq int32 `protobuf:"varint,5,opt,name=freq,proto3" json:"freq,omitempty"`
	// Used by the fsck(8) program to determine the order in which filesystem
	// checks are done at reboot time.
	Passno int32 `protobuf:"varint,6,opt,name=passno,proto3" json:"passno,omitempty"`
}

func (x *FstabEntry) Reset() {
	*x = FstabEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FstabEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FstabEntry) ProtoMessage() {}

func (x *FstabEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FstabEntry.ProtoReflect.Descriptor instead.
func (*FstabEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{89}
}

func (x *FstabEntry) GetSpec() string {
	if x != nil {
		return x.Spec
	}
	return ""
}

func (x *FstabEntry) GetFile() string {
	if x != nil {
		return x.File
	}
	return ""
}

func (x *FstabEntry) GetVfstype() string {
	if x != nil {
		return x.Vfstype
	}
	return ""
}

func (x *FstabEntry) GetMntops() string {
	if x != nil {
		return x.Mntops
	}
	return ""
}

func (x *FstabEntry) GetFreq() int32 {
	if x != nil {
		return x.Freq
	}
	return 0
}

func (x *FstabEntry) GetPassno() int32 {
	if x != nil {
		return x.Passno
	}
	return 0
}

// Hosts content.
type HostsEntryList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hosts entries.
	Entries []*HostsEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *HostsEntryList) Reset() {
	*x = HostsEntryList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostsEntryList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostsEntryList) ProtoMessage() {}

func (x *HostsEntryList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostsEntryList.ProtoReflect.Descriptor instead.
func (*HostsEntryList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{90}
}

func (x *HostsEntryList) GetEntries() []*HostsEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Single /etc/hosts entry.
type HostsEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IP (raw, IPv4/6 agnostic).
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// List of host names / aliases.
	HostNames []string `protobuf:"bytes,2,rep,name=host_names,json=hostNames,proto3" json:"host_names,omitempty"`
}

func (x *HostsEntry) Reset() {
	*x = HostsEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostsEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostsEntry) ProtoMessage() {}

func (x *HostsEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostsEntry.ProtoReflect.Descriptor instead.
func (*HostsEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{91}
}

func (x *HostsEntry) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *HostsEntry) GetHostNames() []string {
	if x != nil {
		return x.HostNames
	}
	return nil
}

// NFS exports.
type NfsExportList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// NFS export entries.
	Entries []*NfsExport `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *NfsExportList) Reset() {
	*x = NfsExportList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NfsExportList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NfsExportList) ProtoMessage() {}

func (x *NfsExportList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NfsExportList.ProtoReflect.Descriptor instead.
func (*NfsExportList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{92}
}

func (x *NfsExportList) GetEntries() []*NfsExport {
	if x != nil {
		return x.Entries
	}
	return nil
}

// NFS export.
type NfsExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The directory being exported.
	ExportDirectory string `protobuf:"bytes,1,opt,name=export_directory,json=exportDirectory,proto3" json:"export_directory,omitempty"`
	// The hosts or networks to which the export is being shared.
	Hosts []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
}

func (x *NfsExport) Reset() {
	*x = NfsExport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NfsExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NfsExport) ProtoMessage() {}

func (x *NfsExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NfsExport.ProtoReflect.Descriptor instead.
func (*NfsExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{93}
}

func (x *NfsExport) GetExportDirectory() string {
	if x != nil {
		return x.ExportDirectory
	}
	return ""
}

func (x *NfsExport) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

// Guest OS runtime information.
type GuestRuntimeDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Running background services.
	Services *RunningServiceList `protobuf:"bytes,1,opt,name=services,proto3" json:"services,omitempty"`
	// Running processes.
	Processes *RunningProcessList `protobuf:"bytes,2,opt,name=processes,proto3" json:"processes,omitempty"`
	// Runtime network information (connections, ports).
	Network *RuntimeNetworkInfo `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// Last time the OS was booted.
	LastBootTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_boot_time,json=lastBootTime,proto3" json:"last_boot_time,omitempty"`
	// Domain, e.g. c.stratozone-development.internal.
	Domain string `protobuf:"bytes,5,opt,name=domain,proto3" json:"domain,omitempty"`
	// Machine name.
	MachineName string `protobuf:"bytes,6,opt,name=machine_name,json=machineName,proto3" json:"machine_name,omitempty"`
	// Installed applications information.
	InstalledApps *GuestInstalledApplicationList `protobuf:"bytes,7,opt,name=installed_apps,json=installedApps,proto3" json:"installed_apps,omitempty"`
	// Open files information.
	OpenFileList *OpenFileList `protobuf:"bytes,8,opt,name=open_file_list,json=openFileList,proto3" json:"open_file_list,omitempty"`
}

func (x *GuestRuntimeDetails) Reset() {
	*x = GuestRuntimeDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestRuntimeDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestRuntimeDetails) ProtoMessage() {}

func (x *GuestRuntimeDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestRuntimeDetails.ProtoReflect.Descriptor instead.
func (*GuestRuntimeDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{94}
}

func (x *GuestRuntimeDetails) GetServices() *RunningServiceList {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *GuestRuntimeDetails) GetProcesses() *RunningProcessList {
	if x != nil {
		return x.Processes
	}
	return nil
}

func (x *GuestRuntimeDetails) GetNetwork() *RuntimeNetworkInfo {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *GuestRuntimeDetails) GetLastBootTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastBootTime
	}
	return nil
}

func (x *GuestRuntimeDetails) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *GuestRuntimeDetails) GetMachineName() string {
	if x != nil {
		return x.MachineName
	}
	return ""
}

func (x *GuestRuntimeDetails) GetInstalledApps() *GuestInstalledApplicationList {
	if x != nil {
		return x.InstalledApps
	}
	return nil
}

func (x *GuestRuntimeDetails) GetOpenFileList() *OpenFileList {
	if x != nil {
		return x.OpenFileList
	}
	return nil
}

// List of running guest OS services.
type RunningServiceList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Running service entries.
	Entries []*RunningService `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *RunningServiceList) Reset() {
	*x = RunningServiceList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunningServiceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunningServiceList) ProtoMessage() {}

func (x *RunningServiceList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunningServiceList.ProtoReflect.Descriptor instead.
func (*RunningServiceList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{95}
}

func (x *RunningServiceList) GetEntries() []*RunningService {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Guest OS running service details.
type RunningService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Service state (OS-agnostic).
	State RunningService_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.RunningService_State" json:"state,omitempty"`
	// Service start mode (OS-agnostic).
	StartMode RunningService_StartMode `protobuf:"varint,3,opt,name=start_mode,json=startMode,proto3,enum=google.cloud.migrationcenter.v1.RunningService_StartMode" json:"start_mode,omitempty"`
	// Service binary path.
	ExePath string `protobuf:"bytes,4,opt,name=exe_path,json=exePath,proto3" json:"exe_path,omitempty"`
	// Service command line.
	Cmdline string `protobuf:"bytes,5,opt,name=cmdline,proto3" json:"cmdline,omitempty"`
	// Service pid.
	Pid int64 `protobuf:"varint,6,opt,name=pid,proto3" json:"pid,omitempty"`
}

func (x *RunningService) Reset() {
	*x = RunningService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunningService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunningService) ProtoMessage() {}

func (x *RunningService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunningService.ProtoReflect.Descriptor instead.
func (*RunningService) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{96}
}

func (x *RunningService) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *RunningService) GetState() RunningService_State {
	if x != nil {
		return x.State
	}
	return RunningService_STATE_UNSPECIFIED
}

func (x *RunningService) GetStartMode() RunningService_StartMode {
	if x != nil {
		return x.StartMode
	}
	return RunningService_START_MODE_UNSPECIFIED
}

func (x *RunningService) GetExePath() string {
	if x != nil {
		return x.ExePath
	}
	return ""
}

func (x *RunningService) GetCmdline() string {
	if x != nil {
		return x.Cmdline
	}
	return ""
}

func (x *RunningService) GetPid() int64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

// List of running guest OS processes.
type RunningProcessList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Running process entries.
	Entries []*RunningProcess `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *RunningProcessList) Reset() {
	*x = RunningProcessList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunningProcessList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunningProcessList) ProtoMessage() {}

func (x *RunningProcessList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunningProcessList.ProtoReflect.Descriptor instead.
func (*RunningProcessList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{97}
}

func (x *RunningProcessList) GetEntries() []*RunningProcess {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Guest OS running process details.
type RunningProcess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Process ID.
	Pid int64 `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	// Process binary path.
	ExePath string `protobuf:"bytes,2,opt,name=exe_path,json=exePath,proto3" json:"exe_path,omitempty"`
	// Process full command line.
	Cmdline string `protobuf:"bytes,3,opt,name=cmdline,proto3" json:"cmdline,omitempty"`
	// User running the process.
	User string `protobuf:"bytes,4,opt,name=user,proto3" json:"user,omitempty"`
	// Process extended attributes.
	Attributes map[string]string `protobuf:"bytes,100,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RunningProcess) Reset() {
	*x = RunningProcess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunningProcess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunningProcess) ProtoMessage() {}

func (x *RunningProcess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunningProcess.ProtoReflect.Descriptor instead.
func (*RunningProcess) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{98}
}

func (x *RunningProcess) GetPid() int64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *RunningProcess) GetExePath() string {
	if x != nil {
		return x.ExePath
	}
	return ""
}

func (x *RunningProcess) GetCmdline() string {
	if x != nil {
		return x.Cmdline
	}
	return ""
}

func (x *RunningProcess) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *RunningProcess) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Runtime networking information.
type RuntimeNetworkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time of the last network scan.
	ScanTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=scan_time,json=scanTime,proto3" json:"scan_time,omitempty"`
	// Network connections.
	Connections *NetworkConnectionList `protobuf:"bytes,2,opt,name=connections,proto3" json:"connections,omitempty"`
}

func (x *RuntimeNetworkInfo) Reset() {
	*x = RuntimeNetworkInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeNetworkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeNetworkInfo) ProtoMessage() {}

func (x *RuntimeNetworkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeNetworkInfo.ProtoReflect.Descriptor instead.
func (*RuntimeNetworkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{99}
}

func (x *RuntimeNetworkInfo) GetScanTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScanTime
	}
	return nil
}

func (x *RuntimeNetworkInfo) GetConnections() *NetworkConnectionList {
	if x != nil {
		return x.Connections
	}
	return nil
}

// Network connection list.
type NetworkConnectionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network connection entries.
	Entries []*NetworkConnection `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *NetworkConnectionList) Reset() {
	*x = NetworkConnectionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConnectionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConnectionList) ProtoMessage() {}

func (x *NetworkConnectionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConnectionList.ProtoReflect.Descriptor instead.
func (*NetworkConnectionList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{100}
}

func (x *NetworkConnectionList) GetEntries() []*NetworkConnection {
	if x != nil {
		return x.Entries
	}
	return nil
}

type NetworkConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Connection protocol (e.g. TCP/UDP).
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Local IP address.
	LocalIpAddress string `protobuf:"bytes,2,opt,name=local_ip_address,json=localIpAddress,proto3" json:"local_ip_address,omitempty"`
	// Local port.
	LocalPort int32 `protobuf:"varint,3,opt,name=local_port,json=localPort,proto3" json:"local_port,omitempty"`
	// Remote IP address.
	RemoteIpAddress string `protobuf:"bytes,4,opt,name=remote_ip_address,json=remoteIpAddress,proto3" json:"remote_ip_address,omitempty"`
	// Remote port.
	RemotePort int32 `protobuf:"varint,5,opt,name=remote_port,json=remotePort,proto3" json:"remote_port,omitempty"`
	// Network connection state.
	State NetworkConnection_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.migrationcenter.v1.NetworkConnection_State" json:"state,omitempty"`
	// Process ID.
	Pid int64 `protobuf:"varint,7,opt,name=pid,proto3" json:"pid,omitempty"`
	// Process or service name.
	ProcessName string `protobuf:"bytes,8,opt,name=process_name,json=processName,proto3" json:"process_name,omitempty"`
}

func (x *NetworkConnection) Reset() {
	*x = NetworkConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConnection) ProtoMessage() {}

func (x *NetworkConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConnection.ProtoReflect.Descriptor instead.
func (*NetworkConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{101}
}

func (x *NetworkConnection) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *NetworkConnection) GetLocalIpAddress() string {
	if x != nil {
		return x.LocalIpAddress
	}
	return ""
}

func (x *NetworkConnection) GetLocalPort() int32 {
	if x != nil {
		return x.LocalPort
	}
	return 0
}

func (x *NetworkConnection) GetRemoteIpAddress() string {
	if x != nil {
		return x.RemoteIpAddress
	}
	return ""
}

func (x *NetworkConnection) GetRemotePort() int32 {
	if x != nil {
		return x.RemotePort
	}
	return 0
}

func (x *NetworkConnection) GetState() NetworkConnection_State {
	if x != nil {
		return x.State
	}
	return NetworkConnection_STATE_UNSPECIFIED
}

func (x *NetworkConnection) GetPid() int64 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *NetworkConnection) GetProcessName() string {
	if x != nil {
		return x.ProcessName
	}
	return ""
}

// Guest installed application list.
type GuestInstalledApplicationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application entries.
	Entries []*GuestInstalledApplication `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *GuestInstalledApplicationList) Reset() {
	*x = GuestInstalledApplicationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestInstalledApplicationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestInstalledApplicationList) ProtoMessage() {}

func (x *GuestInstalledApplicationList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestInstalledApplicationList.ProtoReflect.Descriptor instead.
func (*GuestInstalledApplicationList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{102}
}

func (x *GuestInstalledApplicationList) GetEntries() []*GuestInstalledApplication {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Guest installed application information.
type GuestInstalledApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Installed application name.
	ApplicationName string `protobuf:"bytes,1,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Installed application vendor.
	Vendor string `protobuf:"bytes,2,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// The time when the application was installed.
	InstallTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=install_time,json=installTime,proto3" json:"install_time,omitempty"`
	// Source path.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// Installed application version.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GuestInstalledApplication) Reset() {
	*x = GuestInstalledApplication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestInstalledApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestInstalledApplication) ProtoMessage() {}

func (x *GuestInstalledApplication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestInstalledApplication.ProtoReflect.Descriptor instead.
func (*GuestInstalledApplication) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{103}
}

func (x *GuestInstalledApplication) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *GuestInstalledApplication) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

func (x *GuestInstalledApplication) GetInstallTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InstallTime
	}
	return nil
}

func (x *GuestInstalledApplication) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *GuestInstalledApplication) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Open file list.
type OpenFileList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Open file details entries.
	Entries []*OpenFileDetails `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *OpenFileList) Reset() {
	*x = OpenFileList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenFileList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenFileList) ProtoMessage() {}

func (x *OpenFileList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenFileList.ProtoReflect.Descriptor instead.
func (*OpenFileList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{104}
}

func (x *OpenFileList) GetEntries() []*OpenFileDetails {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Open file Information.
type OpenFileDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opened file command.
	Command string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	// Opened file user.
	User string `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	// Opened file file type.
	FileType string `protobuf:"bytes,3,opt,name=file_type,json=fileType,proto3" json:"file_type,omitempty"`
	// Opened file file path.
	FilePath string `protobuf:"bytes,4,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
}

func (x *OpenFileDetails) Reset() {
	*x = OpenFileDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OpenFileDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenFileDetails) ProtoMessage() {}

func (x *OpenFileDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenFileDetails.ProtoReflect.Descriptor instead.
func (*OpenFileDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{105}
}

func (x *OpenFileDetails) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *OpenFileDetails) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *OpenFileDetails) GetFileType() string {
	if x != nil {
		return x.FileType
	}
	return ""
}

func (x *OpenFileDetails) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

// Information about the platform.
type PlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to VendorDetails:
	//
	//	*PlatformDetails_VmwareDetails
	//	*PlatformDetails_AwsEc2Details
	//	*PlatformDetails_AzureVmDetails
	//	*PlatformDetails_GenericDetails
	//	*PlatformDetails_PhysicalDetails
	VendorDetails isPlatformDetails_VendorDetails `protobuf_oneof:"vendor_details"`
}

func (x *PlatformDetails) Reset() {
	*x = PlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDetails) ProtoMessage() {}

func (x *PlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDetails.ProtoReflect.Descriptor instead.
func (*PlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{106}
}

func (m *PlatformDetails) GetVendorDetails() isPlatformDetails_VendorDetails {
	if m != nil {
		return m.VendorDetails
	}
	return nil
}

func (x *PlatformDetails) GetVmwareDetails() *VmwarePlatformDetails {
	if x, ok := x.GetVendorDetails().(*PlatformDetails_VmwareDetails); ok {
		return x.VmwareDetails
	}
	return nil
}

func (x *PlatformDetails) GetAwsEc2Details() *AwsEc2PlatformDetails {
	if x, ok := x.GetVendorDetails().(*PlatformDetails_AwsEc2Details); ok {
		return x.AwsEc2Details
	}
	return nil
}

func (x *PlatformDetails) GetAzureVmDetails() *AzureVmPlatformDetails {
	if x, ok := x.GetVendorDetails().(*PlatformDetails_AzureVmDetails); ok {
		return x.AzureVmDetails
	}
	return nil
}

func (x *PlatformDetails) GetGenericDetails() *GenericPlatformDetails {
	if x, ok := x.GetVendorDetails().(*PlatformDetails_GenericDetails); ok {
		return x.GenericDetails
	}
	return nil
}

func (x *PlatformDetails) GetPhysicalDetails() *PhysicalPlatformDetails {
	if x, ok := x.GetVendorDetails().(*PlatformDetails_PhysicalDetails); ok {
		return x.PhysicalDetails
	}
	return nil
}

type isPlatformDetails_VendorDetails interface {
	isPlatformDetails_VendorDetails()
}

type PlatformDetails_VmwareDetails struct {
	// VMware specific details.
	VmwareDetails *VmwarePlatformDetails `protobuf:"bytes,1,opt,name=vmware_details,json=vmwareDetails,proto3,oneof"`
}

type PlatformDetails_AwsEc2Details struct {
	// AWS EC2 specific details.
	AwsEc2Details *AwsEc2PlatformDetails `protobuf:"bytes,2,opt,name=aws_ec2_details,json=awsEc2Details,proto3,oneof"`
}

type PlatformDetails_AzureVmDetails struct {
	// Azure VM specific details.
	AzureVmDetails *AzureVmPlatformDetails `protobuf:"bytes,3,opt,name=azure_vm_details,json=azureVmDetails,proto3,oneof"`
}

type PlatformDetails_GenericDetails struct {
	// Generic platform details.
	GenericDetails *GenericPlatformDetails `protobuf:"bytes,4,opt,name=generic_details,json=genericDetails,proto3,oneof"`
}

type PlatformDetails_PhysicalDetails struct {
	// Physical machines platform details.
	PhysicalDetails *PhysicalPlatformDetails `protobuf:"bytes,5,opt,name=physical_details,json=physicalDetails,proto3,oneof"`
}

func (*PlatformDetails_VmwareDetails) isPlatformDetails_VendorDetails() {}

func (*PlatformDetails_AwsEc2Details) isPlatformDetails_VendorDetails() {}

func (*PlatformDetails_AzureVmDetails) isPlatformDetails_VendorDetails() {}

func (*PlatformDetails_GenericDetails) isPlatformDetails_VendorDetails() {}

func (*PlatformDetails_PhysicalDetails) isPlatformDetails_VendorDetails() {}

// VMware specific details.
type VmwarePlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// vCenter version.
	VcenterVersion string `protobuf:"bytes,1,opt,name=vcenter_version,json=vcenterVersion,proto3" json:"vcenter_version,omitempty"`
	// ESX version.
	EsxVersion string `protobuf:"bytes,2,opt,name=esx_version,json=esxVersion,proto3" json:"esx_version,omitempty"`
	// VMware os enum -
	// https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html.
	Osid string `protobuf:"bytes,3,opt,name=osid,proto3" json:"osid,omitempty"`
	// Folder name in vCenter where asset resides.
	VcenterFolder string `protobuf:"bytes,4,opt,name=vcenter_folder,json=vcenterFolder,proto3" json:"vcenter_folder,omitempty"`
	// vCenter URI used in collection.
	VcenterUri string `protobuf:"bytes,5,opt,name=vcenter_uri,json=vcenterUri,proto3" json:"vcenter_uri,omitempty"`
	// vCenter VM ID.
	VcenterVmId string `protobuf:"bytes,6,opt,name=vcenter_vm_id,json=vcenterVmId,proto3" json:"vcenter_vm_id,omitempty"`
}

func (x *VmwarePlatformDetails) Reset() {
	*x = VmwarePlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwarePlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwarePlatformDetails) ProtoMessage() {}

func (x *VmwarePlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwarePlatformDetails.ProtoReflect.Descriptor instead.
func (*VmwarePlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{107}
}

func (x *VmwarePlatformDetails) GetVcenterVersion() string {
	if x != nil {
		return x.VcenterVersion
	}
	return ""
}

func (x *VmwarePlatformDetails) GetEsxVersion() string {
	if x != nil {
		return x.EsxVersion
	}
	return ""
}

func (x *VmwarePlatformDetails) GetOsid() string {
	if x != nil {
		return x.Osid
	}
	return ""
}

func (x *VmwarePlatformDetails) GetVcenterFolder() string {
	if x != nil {
		return x.VcenterFolder
	}
	return ""
}

func (x *VmwarePlatformDetails) GetVcenterUri() string {
	if x != nil {
		return x.VcenterUri
	}
	return ""
}

func (x *VmwarePlatformDetails) GetVcenterVmId() string {
	if x != nil {
		return x.VcenterVmId
	}
	return ""
}

// AWS EC2 specific details.
type AwsEc2PlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AWS platform's machine type label.
	MachineTypeLabel string `protobuf:"bytes,1,opt,name=machine_type_label,json=machineTypeLabel,proto3" json:"machine_type_label,omitempty"`
	// The location of the machine in the AWS format.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *AwsEc2PlatformDetails) Reset() {
	*x = AwsEc2PlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsEc2PlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsEc2PlatformDetails) ProtoMessage() {}

func (x *AwsEc2PlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsEc2PlatformDetails.ProtoReflect.Descriptor instead.
func (*AwsEc2PlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{108}
}

func (x *AwsEc2PlatformDetails) GetMachineTypeLabel() string {
	if x != nil {
		return x.MachineTypeLabel
	}
	return ""
}

func (x *AwsEc2PlatformDetails) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Azure VM specific details.
type AzureVmPlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Azure platform's machine type label.
	MachineTypeLabel string `protobuf:"bytes,1,opt,name=machine_type_label,json=machineTypeLabel,proto3" json:"machine_type_label,omitempty"`
	// The location of the machine in the Azure format.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Azure platform's provisioning state.
	ProvisioningState string `protobuf:"bytes,3,opt,name=provisioning_state,json=provisioningState,proto3" json:"provisioning_state,omitempty"`
}

func (x *AzureVmPlatformDetails) Reset() {
	*x = AzureVmPlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AzureVmPlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmPlatformDetails) ProtoMessage() {}

func (x *AzureVmPlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmPlatformDetails.ProtoReflect.Descriptor instead.
func (*AzureVmPlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{109}
}

func (x *AzureVmPlatformDetails) GetMachineTypeLabel() string {
	if x != nil {
		return x.MachineTypeLabel
	}
	return ""
}

func (x *AzureVmPlatformDetails) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *AzureVmPlatformDetails) GetProvisioningState() string {
	if x != nil {
		return x.ProvisioningState
	}
	return ""
}

// Generic platform details.
type GenericPlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Free text representation of the machine location.
	// The format of this field should not be relied on. Different VMs in the same
	// location may have different string values for this field.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GenericPlatformDetails) Reset() {
	*x = GenericPlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenericPlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericPlatformDetails) ProtoMessage() {}

func (x *GenericPlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericPlatformDetails.ProtoReflect.Descriptor instead.
func (*GenericPlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{110}
}

func (x *GenericPlatformDetails) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Platform specific details for Physical Machines.
type PhysicalPlatformDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Free text representation of the machine location.
	// The format of this field should not be relied on. Different machines in the
	// same location may have different string values for this field.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *PhysicalPlatformDetails) Reset() {
	*x = PhysicalPlatformDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhysicalPlatformDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhysicalPlatformDetails) ProtoMessage() {}

func (x *PhysicalPlatformDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhysicalPlatformDetails.ProtoReflect.Descriptor instead.
func (*PhysicalPlatformDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{111}
}

func (x *PhysicalPlatformDetails) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Memory usage sample.
type MemoryUsageSample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Percentage of system memory utilized. Must be in the interval [0, 100].
	UtilizedPercentage float32 `protobuf:"fixed32,1,opt,name=utilized_percentage,json=utilizedPercentage,proto3" json:"utilized_percentage,omitempty"`
}

func (x *MemoryUsageSample) Reset() {
	*x = MemoryUsageSample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MemoryUsageSample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MemoryUsageSample) ProtoMessage() {}

func (x *MemoryUsageSample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MemoryUsageSample.ProtoReflect.Descriptor instead.
func (*MemoryUsageSample) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{112}
}

func (x *MemoryUsageSample) GetUtilizedPercentage() float32 {
	if x != nil {
		return x.UtilizedPercentage
	}
	return 0
}

// CPU usage sample.
type CpuUsageSample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Percentage of total CPU capacity utilized. Must be in the interval [0,
	// 100]. On most systems can be calculated using 100 - idle percentage.
	UtilizedPercentage float32 `protobuf:"fixed32,1,opt,name=utilized_percentage,json=utilizedPercentage,proto3" json:"utilized_percentage,omitempty"`
}

func (x *CpuUsageSample) Reset() {
	*x = CpuUsageSample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CpuUsageSample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CpuUsageSample) ProtoMessage() {}

func (x *CpuUsageSample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CpuUsageSample.ProtoReflect.Descriptor instead.
func (*CpuUsageSample) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{113}
}

func (x *CpuUsageSample) GetUtilizedPercentage() float32 {
	if x != nil {
		return x.UtilizedPercentage
	}
	return 0
}

// Network usage sample. Values are across all network interfaces.
type NetworkUsageSample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average network ingress in B/s sampled over a short window.
	// Must be non-negative.
	AverageIngressBps float32 `protobuf:"fixed32,1,opt,name=average_ingress_bps,json=averageIngressBps,proto3" json:"average_ingress_bps,omitempty"`
	// Average network egress in B/s sampled over a short window.
	// Must be non-negative.
	AverageEgressBps float32 `protobuf:"fixed32,2,opt,name=average_egress_bps,json=averageEgressBps,proto3" json:"average_egress_bps,omitempty"`
}

func (x *NetworkUsageSample) Reset() {
	*x = NetworkUsageSample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkUsageSample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkUsageSample) ProtoMessage() {}

func (x *NetworkUsageSample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkUsageSample.ProtoReflect.Descriptor instead.
func (*NetworkUsageSample) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{114}
}

func (x *NetworkUsageSample) GetAverageIngressBps() float32 {
	if x != nil {
		return x.AverageIngressBps
	}
	return 0
}

func (x *NetworkUsageSample) GetAverageEgressBps() float32 {
	if x != nil {
		return x.AverageEgressBps
	}
	return 0
}

// Disk usage sample. Values are across all disks.
type DiskUsageSample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average IOPS sampled over a short window. Must be non-negative.
	AverageIops float32 `protobuf:"fixed32,1,opt,name=average_iops,json=averageIops,proto3" json:"average_iops,omitempty"`
}

func (x *DiskUsageSample) Reset() {
	*x = DiskUsageSample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskUsageSample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskUsageSample) ProtoMessage() {}

func (x *DiskUsageSample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskUsageSample.ProtoReflect.Descriptor instead.
func (*DiskUsageSample) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{115}
}

func (x *DiskUsageSample) GetAverageIops() float32 {
	if x != nil {
		return x.AverageIops
	}
	return 0
}

// Performance data sample.
type PerformanceSample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the sample was collected.
	// If omitted, the frame report time will be used.
	SampleTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=sample_time,json=sampleTime,proto3" json:"sample_time,omitempty"`
	// Memory usage sample.
	Memory *MemoryUsageSample `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// CPU usage sample.
	Cpu *CpuUsageSample `protobuf:"bytes,3,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Network usage sample.
	Network *NetworkUsageSample `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// Disk usage sample.
	Disk *DiskUsageSample `protobuf:"bytes,5,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *PerformanceSample) Reset() {
	*x = PerformanceSample{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerformanceSample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerformanceSample) ProtoMessage() {}

func (x *PerformanceSample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerformanceSample.ProtoReflect.Descriptor instead.
func (*PerformanceSample) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{116}
}

func (x *PerformanceSample) GetSampleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SampleTime
	}
	return nil
}

func (x *PerformanceSample) GetMemory() *MemoryUsageSample {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *PerformanceSample) GetCpu() *CpuUsageSample {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *PerformanceSample) GetNetwork() *NetworkUsageSample {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *PerformanceSample) GetDisk() *DiskUsageSample {
	if x != nil {
		return x.Disk
	}
	return nil
}

// Performance data for an asset.
type AssetPerformanceData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Daily resource usage aggregations.
	// Contains all of the data available for an asset, up to the last 420 days.
	// Aggregations are sorted from oldest to most recent.
	DailyResourceUsageAggregations []*DailyResourceUsageAggregation `protobuf:"bytes,1,rep,name=daily_resource_usage_aggregations,json=dailyResourceUsageAggregations,proto3" json:"daily_resource_usage_aggregations,omitempty"`
}

func (x *AssetPerformanceData) Reset() {
	*x = AssetPerformanceData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetPerformanceData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetPerformanceData) ProtoMessage() {}

func (x *AssetPerformanceData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetPerformanceData.ProtoReflect.Descriptor instead.
func (*AssetPerformanceData) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{117}
}

func (x *AssetPerformanceData) GetDailyResourceUsageAggregations() []*DailyResourceUsageAggregation {
	if x != nil {
		return x.DailyResourceUsageAggregations
	}
	return nil
}

// Usage data aggregation for a single day.
type DailyResourceUsageAggregation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregation date. Day boundaries are at midnight UTC.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// CPU usage.
	Cpu *DailyResourceUsageAggregation_CPU `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Memory usage.
	Memory *DailyResourceUsageAggregation_Memory `protobuf:"bytes,3,opt,name=memory,proto3" json:"memory,omitempty"`
	// Network usage.
	Network *DailyResourceUsageAggregation_Network `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// Disk usage.
	Disk *DailyResourceUsageAggregation_Disk `protobuf:"bytes,5,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *DailyResourceUsageAggregation) Reset() {
	*x = DailyResourceUsageAggregation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation) ProtoMessage() {}

func (x *DailyResourceUsageAggregation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118}
}

func (x *DailyResourceUsageAggregation) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *DailyResourceUsageAggregation) GetCpu() *DailyResourceUsageAggregation_CPU {
	if x != nil {
		return x.Cpu
	}
	return nil
}

func (x *DailyResourceUsageAggregation) GetMemory() *DailyResourceUsageAggregation_Memory {
	if x != nil {
		return x.Memory
	}
	return nil
}

func (x *DailyResourceUsageAggregation) GetNetwork() *DailyResourceUsageAggregation_Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *DailyResourceUsageAggregation) GetDisk() *DailyResourceUsageAggregation_Disk {
	if x != nil {
		return x.Disk
	}
	return nil
}

// Message containing insights list.
type InsightList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Insights of the list.
	Insights []*Insight `protobuf:"bytes,1,rep,name=insights,proto3" json:"insights,omitempty"`
	// Output only. Update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *InsightList) Reset() {
	*x = InsightList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsightList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsightList) ProtoMessage() {}

func (x *InsightList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsightList.ProtoReflect.Descriptor instead.
func (*InsightList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{119}
}

func (x *InsightList) GetInsights() []*Insight {
	if x != nil {
		return x.Insights
	}
	return nil
}

func (x *InsightList) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// An insight about an asset.
type Insight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Insight:
	//
	//	*Insight_MigrationInsight
	//	*Insight_GenericInsight
	Insight isInsight_Insight `protobuf_oneof:"insight"`
}

func (x *Insight) Reset() {
	*x = Insight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Insight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Insight) ProtoMessage() {}

func (x *Insight) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Insight.ProtoReflect.Descriptor instead.
func (*Insight) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{120}
}

func (m *Insight) GetInsight() isInsight_Insight {
	if m != nil {
		return m.Insight
	}
	return nil
}

func (x *Insight) GetMigrationInsight() *MigrationInsight {
	if x, ok := x.GetInsight().(*Insight_MigrationInsight); ok {
		return x.MigrationInsight
	}
	return nil
}

func (x *Insight) GetGenericInsight() *GenericInsight {
	if x, ok := x.GetInsight().(*Insight_GenericInsight); ok {
		return x.GenericInsight
	}
	return nil
}

type isInsight_Insight interface {
	isInsight_Insight()
}

type Insight_MigrationInsight struct {
	// Output only. An insight about potential migrations for an asset.
	MigrationInsight *MigrationInsight `protobuf:"bytes,1,opt,name=migration_insight,json=migrationInsight,proto3,oneof"`
}

type Insight_GenericInsight struct {
	// Output only. A generic insight about an asset
	GenericInsight *GenericInsight `protobuf:"bytes,2,opt,name=generic_insight,json=genericInsight,proto3,oneof"`
}

func (*Insight_MigrationInsight) isInsight_Insight() {}

func (*Insight_GenericInsight) isInsight_Insight() {}

// A generic insight about an asset.
type GenericInsight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Represents a globally unique message id for
	// this insight, can be used for localization purposes, in case message_code
	// is not yet known by the client use default_message instead.
	MessageId int64 `protobuf:"varint,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// Output only. In case message_code is not yet known by the client
	// default_message will be the message to be used instead.
	DefaultMessage string `protobuf:"bytes,2,opt,name=default_message,json=defaultMessage,proto3" json:"default_message,omitempty"`
	// Output only. Additional information about the insight, each entry can be a
	// logical entry and must make sense if it is displayed with line breaks
	// between each entry. Text can contain md style links.
	AdditionalInformation []string `protobuf:"bytes,3,rep,name=additional_information,json=additionalInformation,proto3" json:"additional_information,omitempty"`
}

func (x *GenericInsight) Reset() {
	*x = GenericInsight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenericInsight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericInsight) ProtoMessage() {}

func (x *GenericInsight) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericInsight.ProtoReflect.Descriptor instead.
func (*GenericInsight) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{121}
}

func (x *GenericInsight) GetMessageId() int64 {
	if x != nil {
		return x.MessageId
	}
	return 0
}

func (x *GenericInsight) GetDefaultMessage() string {
	if x != nil {
		return x.DefaultMessage
	}
	return ""
}

func (x *GenericInsight) GetAdditionalInformation() []string {
	if x != nil {
		return x.AdditionalInformation
	}
	return nil
}

// An insight about potential migrations for an asset.
type MigrationInsight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Description of how well the asset this insight is associated
	// with fits the proposed migration.
	Fit *FitDescriptor `protobuf:"bytes,1,opt,name=fit,proto3" json:"fit,omitempty"`
	// A target for the migration.
	//
	// Types that are assignable to MigrationTarget:
	//
	//	*MigrationInsight_ComputeEngineTarget
	MigrationTarget isMigrationInsight_MigrationTarget `protobuf_oneof:"migration_target"`
}

func (x *MigrationInsight) Reset() {
	*x = MigrationInsight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationInsight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationInsight) ProtoMessage() {}

func (x *MigrationInsight) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationInsight.ProtoReflect.Descriptor instead.
func (*MigrationInsight) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{122}
}

func (x *MigrationInsight) GetFit() *FitDescriptor {
	if x != nil {
		return x.Fit
	}
	return nil
}

func (m *MigrationInsight) GetMigrationTarget() isMigrationInsight_MigrationTarget {
	if m != nil {
		return m.MigrationTarget
	}
	return nil
}

func (x *MigrationInsight) GetComputeEngineTarget() *ComputeEngineMigrationTarget {
	if x, ok := x.GetMigrationTarget().(*MigrationInsight_ComputeEngineTarget); ok {
		return x.ComputeEngineTarget
	}
	return nil
}

type isMigrationInsight_MigrationTarget interface {
	isMigrationInsight_MigrationTarget()
}

type MigrationInsight_ComputeEngineTarget struct {
	// Output only. A Google Compute Engine target.
	ComputeEngineTarget *ComputeEngineMigrationTarget `protobuf:"bytes,10,opt,name=compute_engine_target,json=computeEngineTarget,proto3,oneof"`
}

func (*MigrationInsight_ComputeEngineTarget) isMigrationInsight_MigrationTarget() {}

// Compute engine migration target.
type ComputeEngineMigrationTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the suggested shape for the migration target.
	Shape *ComputeEngineShapeDescriptor `protobuf:"bytes,1,opt,name=shape,proto3" json:"shape,omitempty"`
}

func (x *ComputeEngineMigrationTarget) Reset() {
	*x = ComputeEngineMigrationTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEngineMigrationTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineMigrationTarget) ProtoMessage() {}

func (x *ComputeEngineMigrationTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineMigrationTarget.ProtoReflect.Descriptor instead.
func (*ComputeEngineMigrationTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{123}
}

func (x *ComputeEngineMigrationTarget) GetShape() *ComputeEngineShapeDescriptor {
	if x != nil {
		return x.Shape
	}
	return nil
}

// Compute Engine target shape descriptor.
type ComputeEngineShapeDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Memory in mebibytes.
	MemoryMb int32 `protobuf:"varint,1,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// Number of physical cores.
	PhysicalCoreCount int32 `protobuf:"varint,2,opt,name=physical_core_count,json=physicalCoreCount,proto3" json:"physical_core_count,omitempty"`
	// Number of logical cores.
	LogicalCoreCount int32 `protobuf:"varint,3,opt,name=logical_core_count,json=logicalCoreCount,proto3" json:"logical_core_count,omitempty"`
	// Compute Engine machine series.
	Series string `protobuf:"bytes,4,opt,name=series,proto3" json:"series,omitempty"`
	// Compute Engine machine type.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Compute Engine storage. Never empty.
	Storage []*ComputeStorageDescriptor `protobuf:"bytes,6,rep,name=storage,proto3" json:"storage,omitempty"`
}

func (x *ComputeEngineShapeDescriptor) Reset() {
	*x = ComputeEngineShapeDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEngineShapeDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineShapeDescriptor) ProtoMessage() {}

func (x *ComputeEngineShapeDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineShapeDescriptor.ProtoReflect.Descriptor instead.
func (*ComputeEngineShapeDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{124}
}

func (x *ComputeEngineShapeDescriptor) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *ComputeEngineShapeDescriptor) GetPhysicalCoreCount() int32 {
	if x != nil {
		return x.PhysicalCoreCount
	}
	return 0
}

func (x *ComputeEngineShapeDescriptor) GetLogicalCoreCount() int32 {
	if x != nil {
		return x.LogicalCoreCount
	}
	return 0
}

func (x *ComputeEngineShapeDescriptor) GetSeries() string {
	if x != nil {
		return x.Series
	}
	return ""
}

func (x *ComputeEngineShapeDescriptor) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngineShapeDescriptor) GetStorage() []*ComputeStorageDescriptor {
	if x != nil {
		return x.Storage
	}
	return nil
}

// Compute Engine storage option descriptor.
type ComputeStorageDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk type backing the storage.
	Type PersistentDiskType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.migrationcenter.v1.PersistentDiskType" json:"type,omitempty"`
	// Disk size in GiB.
	SizeGb int32 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *ComputeStorageDescriptor) Reset() {
	*x = ComputeStorageDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeStorageDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeStorageDescriptor) ProtoMessage() {}

func (x *ComputeStorageDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeStorageDescriptor.ProtoReflect.Descriptor instead.
func (*ComputeStorageDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{125}
}

func (x *ComputeStorageDescriptor) GetType() PersistentDiskType {
	if x != nil {
		return x.Type
	}
	return PersistentDiskType_PERSISTENT_DISK_TYPE_UNSPECIFIED
}

func (x *ComputeStorageDescriptor) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// Describes the fit level of an asset for migration to a specific target.
type FitDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fit level.
	FitLevel FitDescriptor_FitLevel `protobuf:"varint,1,opt,name=fit_level,json=fitLevel,proto3,enum=google.cloud.migrationcenter.v1.FitDescriptor_FitLevel" json:"fit_level,omitempty"`
}

func (x *FitDescriptor) Reset() {
	*x = FitDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FitDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FitDescriptor) ProtoMessage() {}

func (x *FitDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FitDescriptor.ProtoReflect.Descriptor instead.
func (*FitDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{126}
}

func (x *FitDescriptor) GetFitLevel() FitDescriptor_FitLevel {
	if x != nil {
		return x.FitLevel
	}
	return FitDescriptor_FIT_LEVEL_UNSPECIFIED
}

// Message describing an aggregation. The message includes the aggregation type,
// parameters, and the field on which to perform the aggregation.
type Aggregation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the field on which to aggregate.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Types that are assignable to AggregationFunction:
	//
	//	*Aggregation_Count_
	//	*Aggregation_Sum_
	//	*Aggregation_Histogram_
	//	*Aggregation_Frequency_
	AggregationFunction isAggregation_AggregationFunction `protobuf_oneof:"aggregation_function"`
}

func (x *Aggregation) Reset() {
	*x = Aggregation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation) ProtoMessage() {}

func (x *Aggregation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation.ProtoReflect.Descriptor instead.
func (*Aggregation) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{127}
}

func (x *Aggregation) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (m *Aggregation) GetAggregationFunction() isAggregation_AggregationFunction {
	if m != nil {
		return m.AggregationFunction
	}
	return nil
}

func (x *Aggregation) GetCount() *Aggregation_Count {
	if x, ok := x.GetAggregationFunction().(*Aggregation_Count_); ok {
		return x.Count
	}
	return nil
}

func (x *Aggregation) GetSum() *Aggregation_Sum {
	if x, ok := x.GetAggregationFunction().(*Aggregation_Sum_); ok {
		return x.Sum
	}
	return nil
}

func (x *Aggregation) GetHistogram() *Aggregation_Histogram {
	if x, ok := x.GetAggregationFunction().(*Aggregation_Histogram_); ok {
		return x.Histogram
	}
	return nil
}

func (x *Aggregation) GetFrequency() *Aggregation_Frequency {
	if x, ok := x.GetAggregationFunction().(*Aggregation_Frequency_); ok {
		return x.Frequency
	}
	return nil
}

type isAggregation_AggregationFunction interface {
	isAggregation_AggregationFunction()
}

type Aggregation_Count_ struct {
	// Count the number of matching objects.
	Count *Aggregation_Count `protobuf:"bytes,2,opt,name=count,proto3,oneof"`
}

type Aggregation_Sum_ struct {
	// Sum over a numeric field.
	Sum *Aggregation_Sum `protobuf:"bytes,3,opt,name=sum,proto3,oneof"`
}

type Aggregation_Histogram_ struct {
	// Creates a bucketed histogram of field values.
	Histogram *Aggregation_Histogram `protobuf:"bytes,4,opt,name=histogram,proto3,oneof"`
}

type Aggregation_Frequency_ struct {
	// Creates a frequency distribution of all field values.
	Frequency *Aggregation_Frequency `protobuf:"bytes,5,opt,name=frequency,proto3,oneof"`
}

func (*Aggregation_Count_) isAggregation_AggregationFunction() {}

func (*Aggregation_Sum_) isAggregation_AggregationFunction() {}

func (*Aggregation_Histogram_) isAggregation_AggregationFunction() {}

func (*Aggregation_Frequency_) isAggregation_AggregationFunction() {}

// Message describing a result of an aggregation.
type AggregationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// Types that are assignable to Result:
	//
	//	*AggregationResult_Count_
	//	*AggregationResult_Sum_
	//	*AggregationResult_Histogram_
	//	*AggregationResult_Frequency_
	Result isAggregationResult_Result `protobuf_oneof:"result"`
}

func (x *AggregationResult) Reset() {
	*x = AggregationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult) ProtoMessage() {}

func (x *AggregationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult.ProtoReflect.Descriptor instead.
func (*AggregationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128}
}

func (x *AggregationResult) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (m *AggregationResult) GetResult() isAggregationResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *AggregationResult) GetCount() *AggregationResult_Count {
	if x, ok := x.GetResult().(*AggregationResult_Count_); ok {
		return x.Count
	}
	return nil
}

func (x *AggregationResult) GetSum() *AggregationResult_Sum {
	if x, ok := x.GetResult().(*AggregationResult_Sum_); ok {
		return x.Sum
	}
	return nil
}

func (x *AggregationResult) GetHistogram() *AggregationResult_Histogram {
	if x, ok := x.GetResult().(*AggregationResult_Histogram_); ok {
		return x.Histogram
	}
	return nil
}

func (x *AggregationResult) GetFrequency() *AggregationResult_Frequency {
	if x, ok := x.GetResult().(*AggregationResult_Frequency_); ok {
		return x.Frequency
	}
	return nil
}

type isAggregationResult_Result interface {
	isAggregationResult_Result()
}

type AggregationResult_Count_ struct {
	Count *AggregationResult_Count `protobuf:"bytes,2,opt,name=count,proto3,oneof"`
}

type AggregationResult_Sum_ struct {
	Sum *AggregationResult_Sum `protobuf:"bytes,3,opt,name=sum,proto3,oneof"`
}

type AggregationResult_Histogram_ struct {
	Histogram *AggregationResult_Histogram `protobuf:"bytes,4,opt,name=histogram,proto3,oneof"`
}

type AggregationResult_Frequency_ struct {
	Frequency *AggregationResult_Frequency `protobuf:"bytes,5,opt,name=frequency,proto3,oneof"`
}

func (*AggregationResult_Count_) isAggregationResult_Result() {}

func (*AggregationResult_Sum_) isAggregationResult_Result() {}

func (*AggregationResult_Histogram_) isAggregationResult_Result() {}

func (*AggregationResult_Frequency_) isAggregationResult_Result() {}

// A resource that aggregates the validation errors found in an import job file.
type FileValidationReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the file.
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Partial list of rows that encountered validation error.
	RowErrors []*ImportRowError `protobuf:"bytes,2,rep,name=row_errors,json=rowErrors,proto3" json:"row_errors,omitempty"`
	// Flag indicating that processing was aborted due to maximum number of
	// errors.
	PartialReport bool `protobuf:"varint,3,opt,name=partial_report,json=partialReport,proto3" json:"partial_report,omitempty"`
	// List of file level errors.
	FileErrors []*ImportError `protobuf:"bytes,4,rep,name=file_errors,json=fileErrors,proto3" json:"file_errors,omitempty"`
}

func (x *FileValidationReport) Reset() {
	*x = FileValidationReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileValidationReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileValidationReport) ProtoMessage() {}

func (x *FileValidationReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileValidationReport.ProtoReflect.Descriptor instead.
func (*FileValidationReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{129}
}

func (x *FileValidationReport) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *FileValidationReport) GetRowErrors() []*ImportRowError {
	if x != nil {
		return x.RowErrors
	}
	return nil
}

func (x *FileValidationReport) GetPartialReport() bool {
	if x != nil {
		return x.PartialReport
	}
	return false
}

func (x *FileValidationReport) GetFileErrors() []*ImportError {
	if x != nil {
		return x.FileErrors
	}
	return nil
}

// A resource that aggregates errors across import job files.
type ValidationReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of errors found in files.
	FileValidations []*FileValidationReport `protobuf:"bytes,1,rep,name=file_validations,json=fileValidations,proto3" json:"file_validations,omitempty"`
	// List of job level errors.
	JobErrors []*ImportError `protobuf:"bytes,2,rep,name=job_errors,json=jobErrors,proto3" json:"job_errors,omitempty"`
}

func (x *ValidationReport) Reset() {
	*x = ValidationReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationReport) ProtoMessage() {}

func (x *ValidationReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationReport.ProtoReflect.Descriptor instead.
func (*ValidationReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{130}
}

func (x *ValidationReport) GetFileValidations() []*FileValidationReport {
	if x != nil {
		return x.FileValidations
	}
	return nil
}

func (x *ValidationReport) GetJobErrors() []*ImportError {
	if x != nil {
		return x.JobErrors
	}
	return nil
}

// A resource that reports result of the import job execution.
type ExecutionReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of asset frames reported for the import job.
	FramesReported int32 `protobuf:"varint,1,opt,name=frames_reported,json=framesReported,proto3" json:"frames_reported,omitempty"`
	// Validation errors encountered during the execution of the import job.
	ExecutionErrors *ValidationReport `protobuf:"bytes,2,opt,name=execution_errors,json=executionErrors,proto3" json:"execution_errors,omitempty"`
	// Output only. Total number of rows in the import job.
	TotalRowsCount int32 `protobuf:"varint,3,opt,name=total_rows_count,json=totalRowsCount,proto3" json:"total_rows_count,omitempty"`
}

func (x *ExecutionReport) Reset() {
	*x = ExecutionReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionReport) ProtoMessage() {}

func (x *ExecutionReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionReport.ProtoReflect.Descriptor instead.
func (*ExecutionReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{131}
}

func (x *ExecutionReport) GetFramesReported() int32 {
	if x != nil {
		return x.FramesReported
	}
	return 0
}

func (x *ExecutionReport) GetExecutionErrors() *ValidationReport {
	if x != nil {
		return x.ExecutionErrors
	}
	return nil
}

func (x *ExecutionReport) GetTotalRowsCount() int32 {
	if x != nil {
		return x.TotalRowsCount
	}
	return 0
}

// A resource that reports the errors encountered while processing an
// import job.
type ImportError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The error information.
	ErrorDetails string `protobuf:"bytes,1,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
	// The severity of the error.
	Severity ImportError_Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.cloud.migrationcenter.v1.ImportError_Severity" json:"severity,omitempty"`
}

func (x *ImportError) Reset() {
	*x = ImportError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportError) ProtoMessage() {}

func (x *ImportError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportError.ProtoReflect.Descriptor instead.
func (*ImportError) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{132}
}

func (x *ImportError) GetErrorDetails() string {
	if x != nil {
		return x.ErrorDetails
	}
	return ""
}

func (x *ImportError) GetSeverity() ImportError_Severity {
	if x != nil {
		return x.Severity
	}
	return ImportError_SEVERITY_UNSPECIFIED
}

// A resource that reports the import job errors at row level.
type ImportRowError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The row number where the error was detected.
	//
	// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
	RowNumber int32 `protobuf:"varint,1,opt,name=row_number,json=rowNumber,proto3" json:"row_number,omitempty"`
	// The name of the VM in the row.
	VmName string `protobuf:"bytes,2,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// The VM UUID.
	VmUuid string `protobuf:"bytes,3,opt,name=vm_uuid,json=vmUuid,proto3" json:"vm_uuid,omitempty"`
	// The list of errors detected in the row.
	Errors []*ImportError `protobuf:"bytes,4,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ImportRowError) Reset() {
	*x = ImportRowError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportRowError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRowError) ProtoMessage() {}

func (x *ImportRowError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRowError.ProtoReflect.Descriptor instead.
func (*ImportRowError) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{133}
}

// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
func (x *ImportRowError) GetRowNumber() int32 {
	if x != nil {
		return x.RowNumber
	}
	return 0
}

func (x *ImportRowError) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *ImportRowError) GetVmUuid() string {
	if x != nil {
		return x.VmUuid
	}
	return ""
}

func (x *ImportRowError) GetErrors() []*ImportError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// A resource that contains a URI to which a data file can be uploaded.
type UploadFileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Upload URI for the file.
	SignedUri string `protobuf:"bytes,1,opt,name=signed_uri,json=signedUri,proto3" json:"signed_uri,omitempty"`
	// Output only. The headers that were used to sign the URI.
	Headers map[string]string `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Expiration time of the upload URI.
	UriExpirationTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=uri_expiration_time,json=uriExpirationTime,proto3" json:"uri_expiration_time,omitempty"`
}

func (x *UploadFileInfo) Reset() {
	*x = UploadFileInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadFileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadFileInfo) ProtoMessage() {}

func (x *UploadFileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadFileInfo.ProtoReflect.Descriptor instead.
func (*UploadFileInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{134}
}

func (x *UploadFileInfo) GetSignedUri() string {
	if x != nil {
		return x.SignedUri
	}
	return ""
}

func (x *UploadFileInfo) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *UploadFileInfo) GetUriExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UriExpirationTime
	}
	return nil
}

// Lists the asset IDs of all assets.
type AssetList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of asset IDs
	AssetIds []string `protobuf:"bytes,1,rep,name=asset_ids,json=assetIds,proto3" json:"asset_ids,omitempty"`
}

func (x *AssetList) Reset() {
	*x = AssetList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetList) ProtoMessage() {}

func (x *AssetList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetList.ProtoReflect.Descriptor instead.
func (*AssetList) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{135}
}

func (x *AssetList) GetAssetIds() []string {
	if x != nil {
		return x.AssetIds
	}
	return nil
}

// A resource that contains a single violation of a reported `AssetFrame`
// resource.
type FrameViolationEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field of the original frame where the violation occurred.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A message describing the violation.
	Violation string `protobuf:"bytes,2,opt,name=violation,proto3" json:"violation,omitempty"`
}

func (x *FrameViolationEntry) Reset() {
	*x = FrameViolationEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FrameViolationEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrameViolationEntry) ProtoMessage() {}

func (x *FrameViolationEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrameViolationEntry.ProtoReflect.Descriptor instead.
func (*FrameViolationEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{136}
}

func (x *FrameViolationEntry) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *FrameViolationEntry) GetViolation() string {
	if x != nil {
		return x.Violation
	}
	return ""
}

// VirtualMachinePreferences enables you to create sets of assumptions, for
// example, a geographical location and pricing track, for your migrated virtual
// machines. The set of preferences influence recommendations for migrating
// virtual machine assets.
type VirtualMachinePreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target product for assets using this preference set.
	// Specify either target product or business goal, but
	// not both.
	TargetProduct ComputeMigrationTargetProduct `protobuf:"varint,2,opt,name=target_product,json=targetProduct,proto3,enum=google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct" json:"target_product,omitempty"`
	// Region preferences for assets using this preference set.
	// If you are unsure which value to set, the migration service API region is
	// often a good value to start with.
	RegionPreferences *RegionPreferences `protobuf:"bytes,3,opt,name=region_preferences,json=regionPreferences,proto3" json:"region_preferences,omitempty"`
	// Commitment plan to consider when calculating costs for virtual machine
	// insights and recommendations.
	// If you are unsure which value to set, a 3 year commitment plan is often a
	// good value to start with.
	CommitmentPlan CommitmentPlan `protobuf:"varint,4,opt,name=commitment_plan,json=commitmentPlan,proto3,enum=google.cloud.migrationcenter.v1.CommitmentPlan" json:"commitment_plan,omitempty"`
	// Sizing optimization strategy specifies the preferred strategy used when
	// extrapolating usage data to calculate insights and recommendations for a
	// virtual machine.
	// If you are unsure which value to set, a moderate sizing optimization
	// strategy is often a good value to start with.
	SizingOptimizationStrategy SizingOptimizationStrategy `protobuf:"varint,5,opt,name=sizing_optimization_strategy,json=sizingOptimizationStrategy,proto3,enum=google.cloud.migrationcenter.v1.SizingOptimizationStrategy" json:"sizing_optimization_strategy,omitempty"`
	// Compute Engine preferences concern insights and recommendations for Compute
	// Engine target.
	ComputeEnginePreferences *ComputeEnginePreferences `protobuf:"bytes,6,opt,name=compute_engine_preferences,json=computeEnginePreferences,proto3" json:"compute_engine_preferences,omitempty"`
	// Preferences concerning insights and recommendations for
	// Google Cloud VMware Engine.
	VmwareEnginePreferences *VmwareEnginePreferences `protobuf:"bytes,7,opt,name=vmware_engine_preferences,json=vmwareEnginePreferences,proto3" json:"vmware_engine_preferences,omitempty"`
	// Preferences concerning Sole Tenant nodes and virtual machines.
	SoleTenancyPreferences *SoleTenancyPreferences `protobuf:"bytes,8,opt,name=sole_tenancy_preferences,json=soleTenancyPreferences,proto3" json:"sole_tenancy_preferences,omitempty"`
}

func (x *VirtualMachinePreferences) Reset() {
	*x = VirtualMachinePreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VirtualMachinePreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualMachinePreferences) ProtoMessage() {}

func (x *VirtualMachinePreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualMachinePreferences.ProtoReflect.Descriptor instead.
func (*VirtualMachinePreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{137}
}

func (x *VirtualMachinePreferences) GetTargetProduct() ComputeMigrationTargetProduct {
	if x != nil {
		return x.TargetProduct
	}
	return ComputeMigrationTargetProduct_COMPUTE_MIGRATION_TARGET_PRODUCT_UNSPECIFIED
}

func (x *VirtualMachinePreferences) GetRegionPreferences() *RegionPreferences {
	if x != nil {
		return x.RegionPreferences
	}
	return nil
}

func (x *VirtualMachinePreferences) GetCommitmentPlan() CommitmentPlan {
	if x != nil {
		return x.CommitmentPlan
	}
	return CommitmentPlan_COMMITMENT_PLAN_UNSPECIFIED
}

func (x *VirtualMachinePreferences) GetSizingOptimizationStrategy() SizingOptimizationStrategy {
	if x != nil {
		return x.SizingOptimizationStrategy
	}
	return SizingOptimizationStrategy_SIZING_OPTIMIZATION_STRATEGY_UNSPECIFIED
}

func (x *VirtualMachinePreferences) GetComputeEnginePreferences() *ComputeEnginePreferences {
	if x != nil {
		return x.ComputeEnginePreferences
	}
	return nil
}

func (x *VirtualMachinePreferences) GetVmwareEnginePreferences() *VmwareEnginePreferences {
	if x != nil {
		return x.VmwareEnginePreferences
	}
	return nil
}

func (x *VirtualMachinePreferences) GetSoleTenancyPreferences() *SoleTenancyPreferences {
	if x != nil {
		return x.SoleTenancyPreferences
	}
	return nil
}

// The user preferences relating to Compute Engine target platform.
type ComputeEnginePreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Preferences concerning the machine types to consider on Compute Engine.
	MachinePreferences *MachinePreferences `protobuf:"bytes,2,opt,name=machine_preferences,json=machinePreferences,proto3" json:"machine_preferences,omitempty"`
	// License type to consider when calculating costs for virtual machine
	// insights and recommendations. If unspecified, costs are calculated
	// based on the default licensing plan.
	LicenseType LicenseType `protobuf:"varint,3,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.migrationcenter.v1.LicenseType" json:"license_type,omitempty"`
}

func (x *ComputeEnginePreferences) Reset() {
	*x = ComputeEnginePreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEnginePreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEnginePreferences) ProtoMessage() {}

func (x *ComputeEnginePreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEnginePreferences.ProtoReflect.Descriptor instead.
func (*ComputeEnginePreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{138}
}

func (x *ComputeEnginePreferences) GetMachinePreferences() *MachinePreferences {
	if x != nil {
		return x.MachinePreferences
	}
	return nil
}

func (x *ComputeEnginePreferences) GetLicenseType() LicenseType {
	if x != nil {
		return x.LicenseType
	}
	return LicenseType_LICENSE_TYPE_UNSPECIFIED
}

// The type of machines to consider when calculating virtual machine migration
// insights and recommendations.
// Not all machine types are available in all zones and regions.
type MachinePreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Compute Engine machine series to consider for insights and recommendations.
	// If empty, no restriction is applied on the machine series.
	AllowedMachineSeries []*MachineSeries `protobuf:"bytes,1,rep,name=allowed_machine_series,json=allowedMachineSeries,proto3" json:"allowed_machine_series,omitempty"`
}

func (x *MachinePreferences) Reset() {
	*x = MachinePreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachinePreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachinePreferences) ProtoMessage() {}

func (x *MachinePreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachinePreferences.ProtoReflect.Descriptor instead.
func (*MachinePreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{139}
}

func (x *MachinePreferences) GetAllowedMachineSeries() []*MachineSeries {
	if x != nil {
		return x.AllowedMachineSeries
	}
	return nil
}

// A Compute Engine machine series.
type MachineSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Code to identify a Compute Engine machine series. Consult
	// https://cloud.google.com/compute/docs/machine-resource#machine_type_comparison
	// for more details on the available series.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *MachineSeries) Reset() {
	*x = MachineSeries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MachineSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineSeries) ProtoMessage() {}

func (x *MachineSeries) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineSeries.ProtoReflect.Descriptor instead.
func (*MachineSeries) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{140}
}

func (x *MachineSeries) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// The user preferences relating to Google Cloud VMware Engine target platform.
type VmwareEnginePreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU overcommit ratio.
	// Acceptable values are between 1.0 and 8.0, with 0.1 increment.
	CpuOvercommitRatio float64 `protobuf:"fixed64,1,opt,name=cpu_overcommit_ratio,json=cpuOvercommitRatio,proto3" json:"cpu_overcommit_ratio,omitempty"`
	// Memory overcommit ratio.
	// Acceptable values are 1.0, 1.25, 1.5, 1.75 and 2.0.
	MemoryOvercommitRatio float64 `protobuf:"fixed64,2,opt,name=memory_overcommit_ratio,json=memoryOvercommitRatio,proto3" json:"memory_overcommit_ratio,omitempty"`
	// The Deduplication and Compression ratio is based on the logical (Used
	// Before) space required to store data before applying deduplication and
	// compression, in relation to the physical (Used After) space required after
	// applying deduplication and compression. Specifically, the ratio is the Used
	// Before space divided by the Used After space. For example, if the Used
	// Before space is 3 GB, but the physical Used After space is 1 GB, the
	// deduplication and compression ratio is 3x. Acceptable values are
	// between 1.0 and 4.0.
	StorageDeduplicationCompressionRatio float64 `protobuf:"fixed64,3,opt,name=storage_deduplication_compression_ratio,json=storageDeduplicationCompressionRatio,proto3" json:"storage_deduplication_compression_ratio,omitempty"`
	// Commitment plan to consider when calculating costs for virtual machine
	// insights and recommendations.
	// If you are unsure which value to set, a 3 year commitment plan is often a
	// good value to start with.
	CommitmentPlan VmwareEnginePreferences_CommitmentPlan `protobuf:"varint,4,opt,name=commitment_plan,json=commitmentPlan,proto3,enum=google.cloud.migrationcenter.v1.VmwareEnginePreferences_CommitmentPlan" json:"commitment_plan,omitempty"`
}

func (x *VmwareEnginePreferences) Reset() {
	*x = VmwareEnginePreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareEnginePreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEnginePreferences) ProtoMessage() {}

func (x *VmwareEnginePreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEnginePreferences.ProtoReflect.Descriptor instead.
func (*VmwareEnginePreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{141}
}

func (x *VmwareEnginePreferences) GetCpuOvercommitRatio() float64 {
	if x != nil {
		return x.CpuOvercommitRatio
	}
	return 0
}

func (x *VmwareEnginePreferences) GetMemoryOvercommitRatio() float64 {
	if x != nil {
		return x.MemoryOvercommitRatio
	}
	return 0
}

func (x *VmwareEnginePreferences) GetStorageDeduplicationCompressionRatio() float64 {
	if x != nil {
		return x.StorageDeduplicationCompressionRatio
	}
	return 0
}

func (x *VmwareEnginePreferences) GetCommitmentPlan() VmwareEnginePreferences_CommitmentPlan {
	if x != nil {
		return x.CommitmentPlan
	}
	return VmwareEnginePreferences_COMMITMENT_PLAN_UNSPECIFIED
}

// Preferences concerning Sole Tenancy nodes and VMs.
type SoleTenancyPreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU overcommit ratio.
	// Acceptable values are between 1.0 and 2.0 inclusive.
	CpuOvercommitRatio float64 `protobuf:"fixed64,1,opt,name=cpu_overcommit_ratio,json=cpuOvercommitRatio,proto3" json:"cpu_overcommit_ratio,omitempty"`
	// Sole Tenancy nodes maintenance policy.
	HostMaintenancePolicy SoleTenancyPreferences_HostMaintenancePolicy `protobuf:"varint,2,opt,name=host_maintenance_policy,json=hostMaintenancePolicy,proto3,enum=google.cloud.migrationcenter.v1.SoleTenancyPreferences_HostMaintenancePolicy" json:"host_maintenance_policy,omitempty"`
	// Commitment plan to consider when calculating costs for virtual machine
	// insights and recommendations.
	// If you are unsure which value to set, a 3 year commitment plan is often a
	// good value to start with.
	CommitmentPlan SoleTenancyPreferences_CommitmentPlan `protobuf:"varint,3,opt,name=commitment_plan,json=commitmentPlan,proto3,enum=google.cloud.migrationcenter.v1.SoleTenancyPreferences_CommitmentPlan" json:"commitment_plan,omitempty"`
	// A list of sole tenant node types.
	// An empty list means that all possible node types will be considered.
	NodeTypes []*SoleTenantNodeType `protobuf:"bytes,4,rep,name=node_types,json=nodeTypes,proto3" json:"node_types,omitempty"`
}

func (x *SoleTenancyPreferences) Reset() {
	*x = SoleTenancyPreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoleTenancyPreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoleTenancyPreferences) ProtoMessage() {}

func (x *SoleTenancyPreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoleTenancyPreferences.ProtoReflect.Descriptor instead.
func (*SoleTenancyPreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{142}
}

func (x *SoleTenancyPreferences) GetCpuOvercommitRatio() float64 {
	if x != nil {
		return x.CpuOvercommitRatio
	}
	return 0
}

func (x *SoleTenancyPreferences) GetHostMaintenancePolicy() SoleTenancyPreferences_HostMaintenancePolicy {
	if x != nil {
		return x.HostMaintenancePolicy
	}
	return SoleTenancyPreferences_HOST_MAINTENANCE_POLICY_UNSPECIFIED
}

func (x *SoleTenancyPreferences) GetCommitmentPlan() SoleTenancyPreferences_CommitmentPlan {
	if x != nil {
		return x.CommitmentPlan
	}
	return SoleTenancyPreferences_COMMITMENT_PLAN_UNSPECIFIED
}

func (x *SoleTenancyPreferences) GetNodeTypes() []*SoleTenantNodeType {
	if x != nil {
		return x.NodeTypes
	}
	return nil
}

// A Sole Tenant node type.
type SoleTenantNodeType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Sole Tenant node. Consult
	// https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes
	NodeName string `protobuf:"bytes,1,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
}

func (x *SoleTenantNodeType) Reset() {
	*x = SoleTenantNodeType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SoleTenantNodeType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoleTenantNodeType) ProtoMessage() {}

func (x *SoleTenantNodeType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoleTenantNodeType.ProtoReflect.Descriptor instead.
func (*SoleTenantNodeType) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{143}
}

func (x *SoleTenantNodeType) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

// The user preferences relating to target regions.
type RegionPreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of preferred regions,
	// ordered by the most preferred region first.
	// Set only valid Google Cloud region names.
	// See https://cloud.google.com/compute/docs/regions-zones
	// for available regions.
	PreferredRegions []string `protobuf:"bytes,1,rep,name=preferred_regions,json=preferredRegions,proto3" json:"preferred_regions,omitempty"`
}

func (x *RegionPreferences) Reset() {
	*x = RegionPreferences{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegionPreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegionPreferences) ProtoMessage() {}

func (x *RegionPreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegionPreferences.ProtoReflect.Descriptor instead.
func (*RegionPreferences) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{144}
}

func (x *RegionPreferences) GetPreferredRegions() []string {
	if x != nil {
		return x.PreferredRegions
	}
	return nil
}

// Describes the Migration Center settings related to the project.
type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The preference set used by default for a project.
	PreferenceSet string `protobuf:"bytes,2,opt,name=preference_set,json=preferenceSet,proto3" json:"preference_set,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{145}
}

func (x *Settings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Settings) GetPreferenceSet() string {
	if x != nil {
		return x.PreferenceSet
	}
	return ""
}

// Describes the Summary view of a Report, which contains aggregated values
// for all the groups and preference sets included in this Report.
type ReportSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate statistics for all the assets across all the groups.
	AllAssetsStats *ReportSummary_AssetAggregateStats `protobuf:"bytes,1,opt,name=all_assets_stats,json=allAssetsStats,proto3" json:"all_assets_stats,omitempty"`
	// Findings for each Group included in this report.
	GroupFindings []*ReportSummary_GroupFinding `protobuf:"bytes,2,rep,name=group_findings,json=groupFindings,proto3" json:"group_findings,omitempty"`
}

func (x *ReportSummary) Reset() {
	*x = ReportSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary) ProtoMessage() {}

func (x *ReportSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary.ProtoReflect.Descriptor instead.
func (*ReportSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146}
}

func (x *ReportSummary) GetAllAssetsStats() *ReportSummary_AssetAggregateStats {
	if x != nil {
		return x.AllAssetsStats
	}
	return nil
}

func (x *ReportSummary) GetGroupFindings() []*ReportSummary_GroupFinding {
	if x != nil {
		return x.GroupFindings
	}
	return nil
}

// Represents a combination of a group with a preference set.
type ReportConfig_GroupPreferenceSetAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the group.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Required. Name of the Preference Set.
	PreferenceSet string `protobuf:"bytes,2,opt,name=preference_set,json=preferenceSet,proto3" json:"preference_set,omitempty"`
}

func (x *ReportConfig_GroupPreferenceSetAssignment) Reset() {
	*x = ReportConfig_GroupPreferenceSetAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportConfig_GroupPreferenceSetAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportConfig_GroupPreferenceSetAssignment) ProtoMessage() {}

func (x *ReportConfig_GroupPreferenceSetAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportConfig_GroupPreferenceSetAssignment.ProtoReflect.Descriptor instead.
func (*ReportConfig_GroupPreferenceSetAssignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ReportConfig_GroupPreferenceSetAssignment) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *ReportConfig_GroupPreferenceSetAssignment) GetPreferenceSet() string {
	if x != nil {
		return x.PreferenceSet
	}
	return ""
}

// Statistical aggregation of samples for a single resource usage.
type DailyResourceUsageAggregation_Stats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Average usage value.
	Average float32 `protobuf:"fixed32,1,opt,name=average,proto3" json:"average,omitempty"`
	// Median usage value.
	Median float32 `protobuf:"fixed32,2,opt,name=median,proto3" json:"median,omitempty"`
	// 95th percentile usage value.
	NinteyFifthPercentile float32 `protobuf:"fixed32,3,opt,name=nintey_fifth_percentile,json=ninteyFifthPercentile,proto3" json:"nintey_fifth_percentile,omitempty"`
	// Peak usage value.
	Peak float32 `protobuf:"fixed32,4,opt,name=peak,proto3" json:"peak,omitempty"`
}

func (x *DailyResourceUsageAggregation_Stats) Reset() {
	*x = DailyResourceUsageAggregation_Stats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation_Stats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation_Stats) ProtoMessage() {}

func (x *DailyResourceUsageAggregation_Stats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation_Stats.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation_Stats) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118, 0}
}

func (x *DailyResourceUsageAggregation_Stats) GetAverage() float32 {
	if x != nil {
		return x.Average
	}
	return 0
}

func (x *DailyResourceUsageAggregation_Stats) GetMedian() float32 {
	if x != nil {
		return x.Median
	}
	return 0
}

func (x *DailyResourceUsageAggregation_Stats) GetNinteyFifthPercentile() float32 {
	if x != nil {
		return x.NinteyFifthPercentile
	}
	return 0
}

func (x *DailyResourceUsageAggregation_Stats) GetPeak() float32 {
	if x != nil {
		return x.Peak
	}
	return 0
}

// Statistical aggregation of CPU usage.
type DailyResourceUsageAggregation_CPU struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU utilization percentage.
	UtilizationPercentage *DailyResourceUsageAggregation_Stats `protobuf:"bytes,1,opt,name=utilization_percentage,json=utilizationPercentage,proto3" json:"utilization_percentage,omitempty"`
}

func (x *DailyResourceUsageAggregation_CPU) Reset() {
	*x = DailyResourceUsageAggregation_CPU{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation_CPU) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation_CPU) ProtoMessage() {}

func (x *DailyResourceUsageAggregation_CPU) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation_CPU.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation_CPU) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118, 1}
}

func (x *DailyResourceUsageAggregation_CPU) GetUtilizationPercentage() *DailyResourceUsageAggregation_Stats {
	if x != nil {
		return x.UtilizationPercentage
	}
	return nil
}

// Statistical aggregation of memory usage.
type DailyResourceUsageAggregation_Memory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Memory utilization percentage.
	UtilizationPercentage *DailyResourceUsageAggregation_Stats `protobuf:"bytes,1,opt,name=utilization_percentage,json=utilizationPercentage,proto3" json:"utilization_percentage,omitempty"`
}

func (x *DailyResourceUsageAggregation_Memory) Reset() {
	*x = DailyResourceUsageAggregation_Memory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation_Memory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation_Memory) ProtoMessage() {}

func (x *DailyResourceUsageAggregation_Memory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation_Memory.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation_Memory) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118, 2}
}

func (x *DailyResourceUsageAggregation_Memory) GetUtilizationPercentage() *DailyResourceUsageAggregation_Stats {
	if x != nil {
		return x.UtilizationPercentage
	}
	return nil
}

// Statistical aggregation of network usage.
type DailyResourceUsageAggregation_Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network ingress in B/s.
	IngressBps *DailyResourceUsageAggregation_Stats `protobuf:"bytes,1,opt,name=ingress_bps,json=ingressBps,proto3" json:"ingress_bps,omitempty"`
	// Network egress in B/s.
	EgressBps *DailyResourceUsageAggregation_Stats `protobuf:"bytes,2,opt,name=egress_bps,json=egressBps,proto3" json:"egress_bps,omitempty"`
}

func (x *DailyResourceUsageAggregation_Network) Reset() {
	*x = DailyResourceUsageAggregation_Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation_Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation_Network) ProtoMessage() {}

func (x *DailyResourceUsageAggregation_Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation_Network.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation_Network) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118, 3}
}

func (x *DailyResourceUsageAggregation_Network) GetIngressBps() *DailyResourceUsageAggregation_Stats {
	if x != nil {
		return x.IngressBps
	}
	return nil
}

func (x *DailyResourceUsageAggregation_Network) GetEgressBps() *DailyResourceUsageAggregation_Stats {
	if x != nil {
		return x.EgressBps
	}
	return nil
}

// Statistical aggregation of disk usage.
type DailyResourceUsageAggregation_Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk I/O operations per second.
	Iops *DailyResourceUsageAggregation_Stats `protobuf:"bytes,1,opt,name=iops,proto3" json:"iops,omitempty"`
}

func (x *DailyResourceUsageAggregation_Disk) Reset() {
	*x = DailyResourceUsageAggregation_Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[159]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DailyResourceUsageAggregation_Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyResourceUsageAggregation_Disk) ProtoMessage() {}

func (x *DailyResourceUsageAggregation_Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[159]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyResourceUsageAggregation_Disk.ProtoReflect.Descriptor instead.
func (*DailyResourceUsageAggregation_Disk) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{118, 4}
}

func (x *DailyResourceUsageAggregation_Disk) GetIops() *DailyResourceUsageAggregation_Stats {
	if x != nil {
		return x.Iops
	}
	return nil
}

// Object count.
type Aggregation_Count struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Aggregation_Count) Reset() {
	*x = Aggregation_Count{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation_Count) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation_Count) ProtoMessage() {}

func (x *Aggregation_Count) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation_Count.ProtoReflect.Descriptor instead.
func (*Aggregation_Count) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{127, 0}
}

// Sum of field values.
type Aggregation_Sum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Aggregation_Sum) Reset() {
	*x = Aggregation_Sum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[161]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation_Sum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation_Sum) ProtoMessage() {}

func (x *Aggregation_Sum) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[161]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation_Sum.ProtoReflect.Descriptor instead.
func (*Aggregation_Sum) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{127, 1}
}

// Histogram of bucketed assets counts by field value.
type Aggregation_Histogram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bounds of buckets.
	// The response will contain `n+1` buckets for `n` bounds.
	// The first bucket will count all assets for which the field value is
	// smaller than the first bound.
	// Subsequent buckets will count assets for which the field value is
	// greater or equal to a lower bound and smaller than the next one.
	// The last bucket will count assets for which the field value is greater or
	// equal to the final lower bound.
	// You can define up to 20 lower bounds.
	LowerBounds []float64 `protobuf:"fixed64,1,rep,packed,name=lower_bounds,json=lowerBounds,proto3" json:"lower_bounds,omitempty"`
}

func (x *Aggregation_Histogram) Reset() {
	*x = Aggregation_Histogram{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[162]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation_Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation_Histogram) ProtoMessage() {}

func (x *Aggregation_Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[162]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation_Histogram.ProtoReflect.Descriptor instead.
func (*Aggregation_Histogram) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{127, 2}
}

func (x *Aggregation_Histogram) GetLowerBounds() []float64 {
	if x != nil {
		return x.LowerBounds
	}
	return nil
}

// Frequency distribution of all field values.
type Aggregation_Frequency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Aggregation_Frequency) Reset() {
	*x = Aggregation_Frequency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation_Frequency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation_Frequency) ProtoMessage() {}

func (x *Aggregation_Frequency) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation_Frequency.ProtoReflect.Descriptor instead.
func (*Aggregation_Frequency) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{127, 3}
}

// The result of a count aggregation.
type AggregationResult_Count struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AggregationResult_Count) Reset() {
	*x = AggregationResult_Count{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult_Count) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult_Count) ProtoMessage() {}

func (x *AggregationResult_Count) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult_Count.ProtoReflect.Descriptor instead.
func (*AggregationResult_Count) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128, 0}
}

func (x *AggregationResult_Count) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// The result of a sum aggregation.
type AggregationResult_Sum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AggregationResult_Sum) Reset() {
	*x = AggregationResult_Sum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult_Sum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult_Sum) ProtoMessage() {}

func (x *AggregationResult_Sum) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult_Sum.ProtoReflect.Descriptor instead.
func (*AggregationResult_Sum) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128, 1}
}

func (x *AggregationResult_Sum) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// The result of a bucketed histogram aggregation.
type AggregationResult_Histogram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Buckets in the histogram.
	// There will be `n+1` buckets matching `n` lower bounds in the request.
	// The first bucket will be from -infinity to the first bound.
	// Subsequent buckets will be between one bound and the next.
	// The final bucket will be from the final bound to infinity.
	Buckets []*AggregationResult_Histogram_Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *AggregationResult_Histogram) Reset() {
	*x = AggregationResult_Histogram{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult_Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult_Histogram) ProtoMessage() {}

func (x *AggregationResult_Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult_Histogram.ProtoReflect.Descriptor instead.
func (*AggregationResult_Histogram) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128, 2}
}

func (x *AggregationResult_Histogram) GetBuckets() []*AggregationResult_Histogram_Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// The result of a frequency distribution aggregation.
type AggregationResult_Frequency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values map[string]int64 `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *AggregationResult_Frequency) Reset() {
	*x = AggregationResult_Frequency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult_Frequency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult_Frequency) ProtoMessage() {}

func (x *AggregationResult_Frequency) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult_Frequency.ProtoReflect.Descriptor instead.
func (*AggregationResult_Frequency) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128, 3}
}

func (x *AggregationResult_Frequency) GetValues() map[string]int64 {
	if x != nil {
		return x.Values
	}
	return nil
}

// A histogram bucket with a lower and upper bound, and a count of items
// with a field value between those bounds.
// The lower bound is inclusive and the upper bound is exclusive.
// Lower bound may be -infinity and upper bound may be infinity.
type AggregationResult_Histogram_Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound - inclusive.
	LowerBound float64 `protobuf:"fixed64,1,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Upper bound - exclusive.
	UpperBound float64 `protobuf:"fixed64,2,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
	// Count of items in the bucket.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *AggregationResult_Histogram_Bucket) Reset() {
	*x = AggregationResult_Histogram_Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationResult_Histogram_Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationResult_Histogram_Bucket) ProtoMessage() {}

func (x *AggregationResult_Histogram_Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationResult_Histogram_Bucket.ProtoReflect.Descriptor instead.
func (*AggregationResult_Histogram_Bucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{128, 2, 0}
}

func (x *AggregationResult_Histogram_Bucket) GetLowerBound() float64 {
	if x != nil {
		return x.LowerBound
	}
	return 0
}

func (x *AggregationResult_Histogram_Bucket) GetUpperBound() float64 {
	if x != nil {
		return x.UpperBound
	}
	return 0
}

func (x *AggregationResult_Histogram_Bucket) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Describes a collection of data points rendered as a Chart.
type ReportSummary_ChartData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each data point in the chart is represented as a name-value pair
	// with the name being the x-axis label, and the value being the y-axis
	// value.
	DataPoints []*ReportSummary_ChartData_DataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *ReportSummary_ChartData) Reset() {
	*x = ReportSummary_ChartData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[171]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_ChartData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_ChartData) ProtoMessage() {}

func (x *ReportSummary_ChartData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[171]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_ChartData.ProtoReflect.Descriptor instead.
func (*ReportSummary_ChartData) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 0}
}

func (x *ReportSummary_ChartData) GetDataPoints() []*ReportSummary_ChartData_DataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// Utilization Chart is a specific type of visualization which displays
// a metric classified into "Used" and "Free" buckets.
type ReportSummary_UtilizationChartData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate value which falls into the "Used" bucket.
	Used int64 `protobuf:"varint,1,opt,name=used,proto3" json:"used,omitempty"`
	// Aggregate value which falls into the "Free" bucket.
	Free int64 `protobuf:"varint,2,opt,name=free,proto3" json:"free,omitempty"`
}

func (x *ReportSummary_UtilizationChartData) Reset() {
	*x = ReportSummary_UtilizationChartData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[172]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_UtilizationChartData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_UtilizationChartData) ProtoMessage() {}

func (x *ReportSummary_UtilizationChartData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[172]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_UtilizationChartData.ProtoReflect.Descriptor instead.
func (*ReportSummary_UtilizationChartData) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 1}
}

func (x *ReportSummary_UtilizationChartData) GetUsed() int64 {
	if x != nil {
		return x.Used
	}
	return 0
}

func (x *ReportSummary_UtilizationChartData) GetFree() int64 {
	if x != nil {
		return x.Free
	}
	return 0
}

// A Histogram Chart shows a distribution of values into buckets, showing
// a count of values which fall into a bucket.
type ReportSummary_HistogramChartData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Buckets in the histogram.
	// There will be `n+1` buckets matching `n` lower bounds in the request.
	// The first bucket will be from -infinity to the first bound.
	// Subsequent buckets will be between one bound and the next.
	// The final bucket will be from the final bound to infinity.
	Buckets []*ReportSummary_HistogramChartData_Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *ReportSummary_HistogramChartData) Reset() {
	*x = ReportSummary_HistogramChartData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[173]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_HistogramChartData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_HistogramChartData) ProtoMessage() {}

func (x *ReportSummary_HistogramChartData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[173]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_HistogramChartData.ProtoReflect.Descriptor instead.
func (*ReportSummary_HistogramChartData) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 2}
}

func (x *ReportSummary_HistogramChartData) GetBuckets() []*ReportSummary_HistogramChartData_Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Aggregate statistics for a collection of assets.
type ReportSummary_AssetAggregateStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sum of the memory in bytes of all the assets in this collection.
	TotalMemoryBytes int64 `protobuf:"varint,1,opt,name=total_memory_bytes,json=totalMemoryBytes,proto3" json:"total_memory_bytes,omitempty"`
	// Sum of persistent storage in bytes of all the assets in this collection.
	TotalStorageBytes int64 `protobuf:"varint,2,opt,name=total_storage_bytes,json=totalStorageBytes,proto3" json:"total_storage_bytes,omitempty"`
	// Sum of the CPU core count of all the assets in this collection.
	TotalCores int64 `protobuf:"varint,3,opt,name=total_cores,json=totalCores,proto3" json:"total_cores,omitempty"`
	// Count of the number of unique assets in this collection.
	TotalAssets int64 `protobuf:"varint,4,opt,name=total_assets,json=totalAssets,proto3" json:"total_assets,omitempty"`
	// Total memory split into Used/Free buckets.
	MemoryUtilizationChart *ReportSummary_UtilizationChartData `protobuf:"bytes,5,opt,name=memory_utilization_chart,json=memoryUtilizationChart,proto3" json:"memory_utilization_chart,omitempty"`
	// Total memory split into Used/Free buckets.
	StorageUtilizationChart *ReportSummary_UtilizationChartData `protobuf:"bytes,6,opt,name=storage_utilization_chart,json=storageUtilizationChart,proto3" json:"storage_utilization_chart,omitempty"`
	// Count of assets grouped by Operating System families.
	OperatingSystem *ReportSummary_ChartData `protobuf:"bytes,7,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty"`
	// Histogram showing a distribution of CPU core counts.
	CoreCountHistogram *ReportSummary_HistogramChartData `protobuf:"bytes,8,opt,name=core_count_histogram,json=coreCountHistogram,proto3" json:"core_count_histogram,omitempty"`
	// Histogram showing a distribution of memory sizes.
	MemoryBytesHistogram *ReportSummary_HistogramChartData `protobuf:"bytes,9,opt,name=memory_bytes_histogram,json=memoryBytesHistogram,proto3" json:"memory_bytes_histogram,omitempty"`
	// Histogram showing a distribution of memory sizes.
	StorageBytesHistogram *ReportSummary_HistogramChartData `protobuf:"bytes,10,opt,name=storage_bytes_histogram,json=storageBytesHistogram,proto3" json:"storage_bytes_histogram,omitempty"`
}

func (x *ReportSummary_AssetAggregateStats) Reset() {
	*x = ReportSummary_AssetAggregateStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[174]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_AssetAggregateStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_AssetAggregateStats) ProtoMessage() {}

func (x *ReportSummary_AssetAggregateStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[174]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_AssetAggregateStats.ProtoReflect.Descriptor instead.
func (*ReportSummary_AssetAggregateStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 3}
}

func (x *ReportSummary_AssetAggregateStats) GetTotalMemoryBytes() int64 {
	if x != nil {
		return x.TotalMemoryBytes
	}
	return 0
}

func (x *ReportSummary_AssetAggregateStats) GetTotalStorageBytes() int64 {
	if x != nil {
		return x.TotalStorageBytes
	}
	return 0
}

func (x *ReportSummary_AssetAggregateStats) GetTotalCores() int64 {
	if x != nil {
		return x.TotalCores
	}
	return 0
}

func (x *ReportSummary_AssetAggregateStats) GetTotalAssets() int64 {
	if x != nil {
		return x.TotalAssets
	}
	return 0
}

func (x *ReportSummary_AssetAggregateStats) GetMemoryUtilizationChart() *ReportSummary_UtilizationChartData {
	if x != nil {
		return x.MemoryUtilizationChart
	}
	return nil
}

func (x *ReportSummary_AssetAggregateStats) GetStorageUtilizationChart() *ReportSummary_UtilizationChartData {
	if x != nil {
		return x.StorageUtilizationChart
	}
	return nil
}

func (x *ReportSummary_AssetAggregateStats) GetOperatingSystem() *ReportSummary_ChartData {
	if x != nil {
		return x.OperatingSystem
	}
	return nil
}

func (x *ReportSummary_AssetAggregateStats) GetCoreCountHistogram() *ReportSummary_HistogramChartData {
	if x != nil {
		return x.CoreCountHistogram
	}
	return nil
}

func (x *ReportSummary_AssetAggregateStats) GetMemoryBytesHistogram() *ReportSummary_HistogramChartData {
	if x != nil {
		return x.MemoryBytesHistogram
	}
	return nil
}

func (x *ReportSummary_AssetAggregateStats) GetStorageBytesHistogram() *ReportSummary_HistogramChartData {
	if x != nil {
		return x.StorageBytesHistogram
	}
	return nil
}

// Represents a data point tracking the count of assets allocated for a
// specific Machine Series.
type ReportSummary_MachineSeriesAllocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Machine Series (e.g. "E2", "N2")
	MachineSeries *MachineSeries `protobuf:"bytes,1,opt,name=machine_series,json=machineSeries,proto3" json:"machine_series,omitempty"`
	// Count of assets allocated to this machine series.
	AllocatedAssetCount int64 `protobuf:"varint,2,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
}

func (x *ReportSummary_MachineSeriesAllocation) Reset() {
	*x = ReportSummary_MachineSeriesAllocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[175]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_MachineSeriesAllocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_MachineSeriesAllocation) ProtoMessage() {}

func (x *ReportSummary_MachineSeriesAllocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[175]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_MachineSeriesAllocation.ProtoReflect.Descriptor instead.
func (*ReportSummary_MachineSeriesAllocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 4}
}

func (x *ReportSummary_MachineSeriesAllocation) GetMachineSeries() *MachineSeries {
	if x != nil {
		return x.MachineSeries
	}
	return nil
}

func (x *ReportSummary_MachineSeriesAllocation) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

// A set of findings that applies to assets destined for Compute Engine.
type ReportSummary_ComputeEngineFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of regions in which the assets were allocated.
	AllocatedRegions []string `protobuf:"bytes,1,rep,name=allocated_regions,json=allocatedRegions,proto3" json:"allocated_regions,omitempty"`
	// Count of assets which were allocated.
	AllocatedAssetCount int64 `protobuf:"varint,2,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
	// Distribution of assets based on the Machine Series.
	MachineSeriesAllocations []*ReportSummary_MachineSeriesAllocation `protobuf:"bytes,3,rep,name=machine_series_allocations,json=machineSeriesAllocations,proto3" json:"machine_series_allocations,omitempty"`
	// Set of disk types allocated to assets.
	AllocatedDiskTypes []PersistentDiskType `protobuf:"varint,4,rep,packed,name=allocated_disk_types,json=allocatedDiskTypes,proto3,enum=google.cloud.migrationcenter.v1.PersistentDiskType" json:"allocated_disk_types,omitempty"`
}

func (x *ReportSummary_ComputeEngineFinding) Reset() {
	*x = ReportSummary_ComputeEngineFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[176]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_ComputeEngineFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_ComputeEngineFinding) ProtoMessage() {}

func (x *ReportSummary_ComputeEngineFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[176]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_ComputeEngineFinding.ProtoReflect.Descriptor instead.
func (*ReportSummary_ComputeEngineFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 5}
}

func (x *ReportSummary_ComputeEngineFinding) GetAllocatedRegions() []string {
	if x != nil {
		return x.AllocatedRegions
	}
	return nil
}

func (x *ReportSummary_ComputeEngineFinding) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

func (x *ReportSummary_ComputeEngineFinding) GetMachineSeriesAllocations() []*ReportSummary_MachineSeriesAllocation {
	if x != nil {
		return x.MachineSeriesAllocations
	}
	return nil
}

func (x *ReportSummary_ComputeEngineFinding) GetAllocatedDiskTypes() []PersistentDiskType {
	if x != nil {
		return x.AllocatedDiskTypes
	}
	return nil
}

// A set of findings that applies to assets destined for VMWare Engine.
type ReportSummary_VmwareEngineFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of regions in which the assets were allocated
	AllocatedRegions []string `protobuf:"bytes,1,rep,name=allocated_regions,json=allocatedRegions,proto3" json:"allocated_regions,omitempty"`
	// Count of assets which are allocated
	AllocatedAssetCount int64 `protobuf:"varint,2,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
	// Set of per-nodetype allocation records
	NodeAllocations []*ReportSummary_VmwareNodeAllocation `protobuf:"bytes,3,rep,name=node_allocations,json=nodeAllocations,proto3" json:"node_allocations,omitempty"`
}

func (x *ReportSummary_VmwareEngineFinding) Reset() {
	*x = ReportSummary_VmwareEngineFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[177]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_VmwareEngineFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_VmwareEngineFinding) ProtoMessage() {}

func (x *ReportSummary_VmwareEngineFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[177]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_VmwareEngineFinding.ProtoReflect.Descriptor instead.
func (*ReportSummary_VmwareEngineFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 6}
}

func (x *ReportSummary_VmwareEngineFinding) GetAllocatedRegions() []string {
	if x != nil {
		return x.AllocatedRegions
	}
	return nil
}

func (x *ReportSummary_VmwareEngineFinding) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

func (x *ReportSummary_VmwareEngineFinding) GetNodeAllocations() []*ReportSummary_VmwareNodeAllocation {
	if x != nil {
		return x.NodeAllocations
	}
	return nil
}

// Represents assets allocated to a specific VMWare Node type.
type ReportSummary_VmwareNodeAllocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// VMWare node type, e.g. "ve1-standard-72"
	VmwareNode *ReportSummary_VmwareNode `protobuf:"bytes,1,opt,name=vmware_node,json=vmwareNode,proto3" json:"vmware_node,omitempty"`
	// Count of this node type to be provisioned
	NodeCount int64 `protobuf:"varint,2,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Count of assets allocated to these nodes
	AllocatedAssetCount int64 `protobuf:"varint,3,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
}

func (x *ReportSummary_VmwareNodeAllocation) Reset() {
	*x = ReportSummary_VmwareNodeAllocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[178]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_VmwareNodeAllocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_VmwareNodeAllocation) ProtoMessage() {}

func (x *ReportSummary_VmwareNodeAllocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[178]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_VmwareNodeAllocation.ProtoReflect.Descriptor instead.
func (*ReportSummary_VmwareNodeAllocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 7}
}

func (x *ReportSummary_VmwareNodeAllocation) GetVmwareNode() *ReportSummary_VmwareNode {
	if x != nil {
		return x.VmwareNode
	}
	return nil
}

func (x *ReportSummary_VmwareNodeAllocation) GetNodeCount() int64 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *ReportSummary_VmwareNodeAllocation) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

// A VMWare Engine Node
type ReportSummary_VmwareNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
	// on the displayName of
	// cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.nodeTypes
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *ReportSummary_VmwareNode) Reset() {
	*x = ReportSummary_VmwareNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[179]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_VmwareNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_VmwareNode) ProtoMessage() {}

func (x *ReportSummary_VmwareNode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[179]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_VmwareNode.ProtoReflect.Descriptor instead.
func (*ReportSummary_VmwareNode) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 8}
}

func (x *ReportSummary_VmwareNode) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// A set of findings that applies to assets destined for Sole-Tenant nodes.
type ReportSummary_SoleTenantFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of regions in which the assets are allocated
	AllocatedRegions []string `protobuf:"bytes,1,rep,name=allocated_regions,json=allocatedRegions,proto3" json:"allocated_regions,omitempty"`
	// Count of assets which are allocated
	AllocatedAssetCount int64 `protobuf:"varint,2,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
	// Set of per-nodetype allocation records
	NodeAllocations []*ReportSummary_SoleTenantNodeAllocation `protobuf:"bytes,3,rep,name=node_allocations,json=nodeAllocations,proto3" json:"node_allocations,omitempty"`
}

func (x *ReportSummary_SoleTenantFinding) Reset() {
	*x = ReportSummary_SoleTenantFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[180]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_SoleTenantFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_SoleTenantFinding) ProtoMessage() {}

func (x *ReportSummary_SoleTenantFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[180]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_SoleTenantFinding.ProtoReflect.Descriptor instead.
func (*ReportSummary_SoleTenantFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 9}
}

func (x *ReportSummary_SoleTenantFinding) GetAllocatedRegions() []string {
	if x != nil {
		return x.AllocatedRegions
	}
	return nil
}

func (x *ReportSummary_SoleTenantFinding) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

func (x *ReportSummary_SoleTenantFinding) GetNodeAllocations() []*ReportSummary_SoleTenantNodeAllocation {
	if x != nil {
		return x.NodeAllocations
	}
	return nil
}

// Represents the assets allocated to a specific Sole-Tenant node type.
type ReportSummary_SoleTenantNodeAllocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sole Tenant node type, e.g. "m3-node-128-3904"
	Node *SoleTenantNodeType `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// Count of this node type to be provisioned
	NodeCount int64 `protobuf:"varint,2,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Count of assets allocated to these nodes
	AllocatedAssetCount int64 `protobuf:"varint,3,opt,name=allocated_asset_count,json=allocatedAssetCount,proto3" json:"allocated_asset_count,omitempty"`
}

func (x *ReportSummary_SoleTenantNodeAllocation) Reset() {
	*x = ReportSummary_SoleTenantNodeAllocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[181]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_SoleTenantNodeAllocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_SoleTenantNodeAllocation) ProtoMessage() {}

func (x *ReportSummary_SoleTenantNodeAllocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[181]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_SoleTenantNodeAllocation.ProtoReflect.Descriptor instead.
func (*ReportSummary_SoleTenantNodeAllocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 10}
}

func (x *ReportSummary_SoleTenantNodeAllocation) GetNode() *SoleTenantNodeType {
	if x != nil {
		return x.Node
	}
	return nil
}

func (x *ReportSummary_SoleTenantNodeAllocation) GetNodeCount() int64 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *ReportSummary_SoleTenantNodeAllocation) GetAllocatedAssetCount() int64 {
	if x != nil {
		return x.AllocatedAssetCount
	}
	return 0
}

// Summary Findings for a specific Group/PreferenceSet combination.
type ReportSummary_GroupPreferenceSetFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display Name of the Preference Set
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description for the Preference Set.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A set of preferences that applies to all machines in the context.
	MachinePreferences *VirtualMachinePreferences `protobuf:"bytes,3,opt,name=machine_preferences,json=machinePreferences,proto3" json:"machine_preferences,omitempty"`
	// Total monthly cost for this preference set.
	MonthlyCostTotal *money.Money `protobuf:"bytes,4,opt,name=monthly_cost_total,json=monthlyCostTotal,proto3" json:"monthly_cost_total,omitempty"`
	// Compute monthly cost for this preference set.
	MonthlyCostCompute *money.Money `protobuf:"bytes,5,opt,name=monthly_cost_compute,json=monthlyCostCompute,proto3" json:"monthly_cost_compute,omitempty"`
	// Licensing monthly cost for this preference set.
	MonthlyCostOsLicense *money.Money `protobuf:"bytes,6,opt,name=monthly_cost_os_license,json=monthlyCostOsLicense,proto3" json:"monthly_cost_os_license,omitempty"`
	// Network Egress monthly cost for this preference set.
	MonthlyCostNetworkEgress *money.Money `protobuf:"bytes,7,opt,name=monthly_cost_network_egress,json=monthlyCostNetworkEgress,proto3" json:"monthly_cost_network_egress,omitempty"`
	// Storage monthly cost for this preference set.
	MonthlyCostStorage *money.Money `protobuf:"bytes,8,opt,name=monthly_cost_storage,json=monthlyCostStorage,proto3" json:"monthly_cost_storage,omitempty"`
	// Miscellaneous monthly cost for this preference set.
	MonthlyCostOther *money.Money `protobuf:"bytes,9,opt,name=monthly_cost_other,json=monthlyCostOther,proto3" json:"monthly_cost_other,omitempty"`
	// A set of findings that applies to Compute Engine machines in the input.
	ComputeEngineFinding *ReportSummary_ComputeEngineFinding `protobuf:"bytes,10,opt,name=compute_engine_finding,json=computeEngineFinding,proto3" json:"compute_engine_finding,omitempty"`
	// A set of findings that applies to VMWare machines in the input.
	VmwareEngineFinding *ReportSummary_VmwareEngineFinding `protobuf:"bytes,11,opt,name=vmware_engine_finding,json=vmwareEngineFinding,proto3" json:"vmware_engine_finding,omitempty"`
	// A set of findings that applies to Sole-Tenant machines in the input.
	SoleTenantFinding *ReportSummary_SoleTenantFinding `protobuf:"bytes,12,opt,name=sole_tenant_finding,json=soleTenantFinding,proto3" json:"sole_tenant_finding,omitempty"`
}

func (x *ReportSummary_GroupPreferenceSetFinding) Reset() {
	*x = ReportSummary_GroupPreferenceSetFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[182]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_GroupPreferenceSetFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_GroupPreferenceSetFinding) ProtoMessage() {}

func (x *ReportSummary_GroupPreferenceSetFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[182]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_GroupPreferenceSetFinding.ProtoReflect.Descriptor instead.
func (*ReportSummary_GroupPreferenceSetFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 11}
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMachinePreferences() *VirtualMachinePreferences {
	if x != nil {
		return x.MachinePreferences
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostTotal() *money.Money {
	if x != nil {
		return x.MonthlyCostTotal
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostCompute() *money.Money {
	if x != nil {
		return x.MonthlyCostCompute
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostOsLicense() *money.Money {
	if x != nil {
		return x.MonthlyCostOsLicense
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostNetworkEgress() *money.Money {
	if x != nil {
		return x.MonthlyCostNetworkEgress
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostStorage() *money.Money {
	if x != nil {
		return x.MonthlyCostStorage
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetMonthlyCostOther() *money.Money {
	if x != nil {
		return x.MonthlyCostOther
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetComputeEngineFinding() *ReportSummary_ComputeEngineFinding {
	if x != nil {
		return x.ComputeEngineFinding
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetVmwareEngineFinding() *ReportSummary_VmwareEngineFinding {
	if x != nil {
		return x.VmwareEngineFinding
	}
	return nil
}

func (x *ReportSummary_GroupPreferenceSetFinding) GetSoleTenantFinding() *ReportSummary_SoleTenantFinding {
	if x != nil {
		return x.SoleTenantFinding
	}
	return nil
}

// Summary Findings for a specific Group.
type ReportSummary_GroupFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display Name for the Group.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description for the Group.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Summary statistics for all the assets in this group.
	AssetAggregateStats *ReportSummary_AssetAggregateStats `protobuf:"bytes,3,opt,name=asset_aggregate_stats,json=assetAggregateStats,proto3" json:"asset_aggregate_stats,omitempty"`
	// This field is deprecated, do not rely on it having a value.
	//
	// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
	OverlappingAssetCount int64 `protobuf:"varint,4,opt,name=overlapping_asset_count,json=overlappingAssetCount,proto3" json:"overlapping_asset_count,omitempty"`
	// Findings for each of the PreferenceSets for this group.
	PreferenceSetFindings []*ReportSummary_GroupPreferenceSetFinding `protobuf:"bytes,5,rep,name=preference_set_findings,json=preferenceSetFindings,proto3" json:"preference_set_findings,omitempty"`
}

func (x *ReportSummary_GroupFinding) Reset() {
	*x = ReportSummary_GroupFinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[183]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_GroupFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_GroupFinding) ProtoMessage() {}

func (x *ReportSummary_GroupFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[183]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_GroupFinding.ProtoReflect.Descriptor instead.
func (*ReportSummary_GroupFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 12}
}

func (x *ReportSummary_GroupFinding) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ReportSummary_GroupFinding) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReportSummary_GroupFinding) GetAssetAggregateStats() *ReportSummary_AssetAggregateStats {
	if x != nil {
		return x.AssetAggregateStats
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/migrationcenter/v1/migrationcenter.proto.
func (x *ReportSummary_GroupFinding) GetOverlappingAssetCount() int64 {
	if x != nil {
		return x.OverlappingAssetCount
	}
	return 0
}

func (x *ReportSummary_GroupFinding) GetPreferenceSetFindings() []*ReportSummary_GroupPreferenceSetFinding {
	if x != nil {
		return x.PreferenceSetFindings
	}
	return nil
}

// Describes a single data point in the Chart.
type ReportSummary_ChartData_DataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The X-axis label for this data point.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// The Y-axis value for this data point.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ReportSummary_ChartData_DataPoint) Reset() {
	*x = ReportSummary_ChartData_DataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[184]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_ChartData_DataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_ChartData_DataPoint) ProtoMessage() {}

func (x *ReportSummary_ChartData_DataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[184]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_ChartData_DataPoint.ProtoReflect.Descriptor instead.
func (*ReportSummary_ChartData_DataPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 0, 0}
}

func (x *ReportSummary_ChartData_DataPoint) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *ReportSummary_ChartData_DataPoint) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// A histogram bucket with a lower and upper bound, and a count of items
// with a field value between those bounds.
// The lower bound is inclusive and the upper bound is exclusive.
// Lower bound may be -infinity and upper bound may be infinity.
type ReportSummary_HistogramChartData_Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound - inclusive.
	LowerBound int64 `protobuf:"varint,1,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Upper bound - exclusive.
	UpperBound int64 `protobuf:"varint,2,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
	// Count of items in the bucket.
	Count int64 `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *ReportSummary_HistogramChartData_Bucket) Reset() {
	*x = ReportSummary_HistogramChartData_Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[185]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportSummary_HistogramChartData_Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportSummary_HistogramChartData_Bucket) ProtoMessage() {}

func (x *ReportSummary_HistogramChartData_Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[185]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportSummary_HistogramChartData_Bucket.ProtoReflect.Descriptor instead.
func (*ReportSummary_HistogramChartData_Bucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP(), []int{146, 2, 0}
}

func (x *ReportSummary_HistogramChartData_Bucket) GetLowerBound() int64 {
	if x != nil {
		return x.LowerBound
	}
	return 0
}

func (x *ReportSummary_HistogramChartData_Bucket) GetUpperBound() int64 {
	if x != nil {
		return x.UpperBound
	}
	return 0
}

func (x *ReportSummary_HistogramChartData_Bucket) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

var File_google_cloud_migrationcenter_v1_migrationcenter_proto protoreflect.FileDescriptor

var file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xf3, 0x07, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x0f,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0e, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x54, 0x0a,
	0x0c, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x07, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x0f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12,
	0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x42, 0x0e, 0x0a, 0x0c, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xe9, 0x03, 0x0a, 0x0d, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x1b, 0x76,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x19, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a, 0x2c, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x7d, 0x22, 0x9c, 0x09, 0x0a, 0x09, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a,
	0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x65, 0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x90, 0x02, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4d,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54,
	0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54,
	0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f,
	0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a,
	0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16,
	0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x07, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x28, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x22, 0xed, 0x04, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x22, 0x38, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x3a, 0x97, 0x01, 0xea, 0x41,
	0x93, 0x01, 0x0a, 0x2d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x62, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x22, 0xd3, 0x03, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x61, 0xea, 0x41, 0x5e, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x22, 0xa6, 0x03, 0x0a, 0x0a, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x59, 0x0a, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x56, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x57, 0x0a, 0x0e, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x69,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x82, 0x01, 0xea,
	0x41, 0x7f, 0x0a, 0x29, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x7d, 0x22, 0xdc, 0x06, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x12, 0x33, 0x0a, 0x13,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x2f, 0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x94, 0x01, 0x0a,
	0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x50, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x55, 0x45, 0x53,
	0x54, 0x5f, 0x4f, 0x53, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x56, 0x45, 0x4e,
	0x54, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x43, 0x41, 0x4e, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x10, 0x04, 0x22, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x03, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a,
	0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d,
	0x22, 0xc5, 0x05, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x97, 0x01, 0x0a, 0x1f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xbf, 0x01,
	0x0a, 0x1c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x65, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x5b, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x0a, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x3a,
	0x77, 0xea, 0x41, 0x74, 0x0a, 0x2b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xc8, 0x05, 0x0a, 0x06, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x07,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x39, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x4f, 0x54,
	0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x53, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x52,
	0x53, 0x48, 0x49, 0x50, 0x10, 0x01, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x82,
	0x01, 0xea, 0x41, 0x7f, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x56, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x7d, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x02, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x3e, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x9e, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a,
	0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xbd, 0x01,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x41, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb6, 0x01,
	0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x12, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x54, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x5b, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x22, 0x7a, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xce, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x42, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x22, 0xbf, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xa5, 0x01, 0x0a, 0x1c, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a,
	0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x6d, 0x0a, 0x1d, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a,
	0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x99, 0x02, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x47, 0x0a, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x76, 0x69, 0x65, 0x77, 0x22, 0xaf, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4b, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x56, 0x69,
	0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x9d, 0x01,
	0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xce, 0x01,
	0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4e, 0x0a, 0x0a, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x84,
	0x01, 0x0a, 0x18, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7f, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x65, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc4, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0xa4, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x32, 0x0a, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x65, 0x49, 0x64, 0x12, 0x5e, 0x0a, 0x10, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8c, 0x01, 0x0a, 0x1b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x9e, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe1, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xbd, 0x01, 0x0a,
	0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x41, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x12,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xf6, 0x01, 0x0a, 0x17, 0x41, 0x64, 0x64,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x06,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x65,
	0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x22, 0xf9, 0x01, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x06, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xe9, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b,
	0x12, 0x29, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xb3, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0xa7, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x48, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xca, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41,
	0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x55, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x12, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc1, 0x01,
	0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x44, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x7c, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xc0, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x57, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x63, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9b, 0x02, 0x0a, 0x1a, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e,
	0x12, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x5a, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xde, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x65, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x59, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x29, 0x0a, 0x27, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xc9, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4a, 0x0a, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x94, 0x02, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x12, 0x2b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xa3, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x19,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x3f, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x22, 0x8b, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x12, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x3f, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x22, 0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x07, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x7c, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0x61, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xbb, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a,
	0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xe8, 0x01,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x44,
	0x0a, 0x06, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x56, 0x0a, 0x06, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x52, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x22, 0xe5, 0x04, 0x0a, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12,
	0x5a, 0x0a, 0x0f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5b, 0x0a, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x63, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x12, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22, 0xb3, 0x06, 0x0a, 0x0e, 0x4d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x5b, 0x0a, 0x0b, 0x70,
	0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x2e, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x70, 0x6f,
	0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x67, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x6f, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75,
	0x65, 0x73, 0x74, 0x4f, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x67, 0x75,
	0x65, 0x73, 0x74, 0x4f, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x49, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x05, 0x64, 0x69, 0x73,
	0x6b, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x22, 0x7c, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x22, 0x8d,
	0x05, 0x0a, 0x1a, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x63, 0x70, 0x75, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x70, 0x75, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x70, 0x75, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x70, 0x75, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x63,
	0x70, 0x75, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x63, 0x70, 0x75, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x63, 0x70, 0x75, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x62, 0x69, 0x6f, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x04, 0x62, 0x69, 0x6f,
	0x73, 0x12, 0x6d, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0c, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x75, 0x0a, 0x0e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x70, 0x75, 0x48, 0x79, 0x70, 0x65, 0x72, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x68, 0x79, 0x70, 0x65, 0x72, 0x74, 0x68,
	0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x40, 0x0a, 0x0c, 0x46, 0x69, 0x72, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x52, 0x4d, 0x57,
	0x41, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x02, 0x22, 0x53, 0x0a, 0x11, 0x43, 0x70, 0x75,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x23,
	0x0a, 0x1f, 0x43, 0x50, 0x55, 0x5f, 0x48, 0x59, 0x50, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x52, 0x45,
	0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xd3,
	0x01, 0x0a, 0x0b, 0x42, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1f,
	0x0a, 0x09, 0x62, 0x69, 0x6f, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x62, 0x69, 0x6f, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x22, 0x0a, 0x0c, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74, 0x75, 0x72, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a,
	0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x44,
	0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6d, 0x62, 0x69, 0x6f, 0x73, 0x5f, 0x75, 0x75,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6d, 0x62, 0x69, 0x6f, 0x73,
	0x55, 0x75, 0x69, 0x64, 0x22, 0xf2, 0x01, 0x0a, 0x15, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2a, 0x0a, 0x11,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4d, 0x61,
	0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x08, 0x61, 0x64, 0x61, 0x70,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x08, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x73, 0x22, 0x66, 0x0a, 0x12, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x65,
	0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x22, 0xae, 0x01, 0x0a, 0x15, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x65, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x51, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x22, 0x5f, 0x0a, 0x12, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x22, 0xd2, 0x02, 0x0a, 0x0e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x63, 0x61, 0x73, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x62, 0x63, 0x61, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x66, 0x71, 0x64, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e,
	0x12, 0x61, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x73, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x44, 0x44, 0x52,
	0x45, 0x53, 0x53, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19,
	0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x41,
	0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x44, 0x48, 0x43, 0x50, 0x10, 0x02, 0x22, 0xb6, 0x01, 0x0a, 0x12, 0x4d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x30, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x66, 0x72, 0x65, 0x65, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x46, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x05, 0x64,
	0x69, 0x73, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b,
	0x73, 0x22, 0x55, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xc2, 0x04, 0x0a, 0x09, 0x44, 0x69, 0x73,
	0x6b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x66, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x26, 0x0a, 0x0f, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x6b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x52, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x77, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x77,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x22, 0x72, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x44, 0x45, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x53, 0x41, 0x54, 0x41, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x41, 0x53, 0x10,
	0x03, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x43, 0x53, 0x49, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x56, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x06, 0x0a, 0x02, 0x46, 0x43, 0x10, 0x06, 0x12, 0x09, 0x0a,
	0x05, 0x49, 0x53, 0x43, 0x53, 0x49, 0x10, 0x07, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x22, 0x5d, 0x0a,
	0x11, 0x44, 0x69, 0x73, 0x6b, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x9a, 0x02, 0x0a,
	0x0d, 0x44, 0x69, 0x73, 0x6b, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x61,
	0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x66,
	0x72, 0x65, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x09, 0x66, 0x72, 0x65, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x75,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x59,
	0x0a, 0x0e, 0x73, 0x75, 0x62, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb7, 0x06, 0x0a, 0x10, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60,
	0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x09, 0x76, 0x6d, 0x64, 0x6b,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56,
	0x6d, 0x64, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x76, 0x6d, 0x64, 0x6b, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x6f, 0x0a, 0x11, 0x72, 0x64, 0x6d, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x64, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x10, 0x72, 0x64, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x22, 0xff, 0x01, 0x0a, 0x0b, 0x42, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x46, 0x4c, 0x41, 0x54, 0x5f, 0x56, 0x31, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x41,
	0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x4c, 0x41, 0x54, 0x5f,
	0x56, 0x32, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x4d, 0x45, 0x4d, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x42,
	0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x44, 0x4d, 0x5f,
	0x56, 0x31, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x44, 0x4d, 0x5f, 0x56, 0x32, 0x10, 0x05, 0x12, 0x19, 0x0a,
	0x15, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45,
	0x53, 0x50, 0x41, 0x52, 0x53, 0x45, 0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x41, 0x43, 0x4b,
	0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x50, 0x41, 0x52, 0x53,
	0x45, 0x5f, 0x56, 0x31, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x41, 0x43, 0x4b, 0x49, 0x4e,
	0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x50, 0x41, 0x52, 0x53, 0x45, 0x5f,
	0x56, 0x32, 0x10, 0x08, 0x22, 0x6f, 0x0a, 0x08, 0x56, 0x6d, 0x64, 0x6b, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x19, 0x0a, 0x15, 0x56, 0x4d, 0x44, 0x4b, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44,
	0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e,
	0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53,
	0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x44, 0x45, 0x50, 0x45,
	0x4e, 0x44, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x4e, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54,
	0x45, 0x4e, 0x54, 0x10, 0x03, 0x22, 0x6c, 0x0a, 0x10, 0x52, 0x64, 0x6d, 0x43, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x44, 0x4d,
	0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x48, 0x59, 0x53, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49,
	0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x49, 0x52, 0x54,
	0x55, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x10, 0x02, 0x22, 0xb0, 0x02, 0x0a, 0x0e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x4f, 0x73, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x73, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x52, 0x06, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xf3, 0x03, 0x0a, 0x12, 0x47, 0x75, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x05, 0x66, 0x73, 0x74, 0x61, 0x62, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x73, 0x74, 0x61, 0x62, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x05, 0x66, 0x73, 0x74, 0x61, 0x62, 0x12, 0x45, 0x0a, 0x05, 0x68, 0x6f,
	0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x68, 0x6f, 0x73, 0x74,
	0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x6e, 0x66, 0x73, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0a, 0x6e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x12, 0x62, 0x0a, 0x0c, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65,
	0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x73, 0x65, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x4c, 0x69, 0x6e,
	0x75, 0x78, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e,
	0x55, 0x58, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x55,
	0x58, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x55, 0x58, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x1b, 0x0a, 0x17, 0x53, 0x45, 0x5f, 0x4c, 0x49, 0x4e, 0x55, 0x58, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22, 0x57, 0x0a, 0x0e,
	0x46, 0x73, 0x74, 0x61, 0x62, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x73, 0x74, 0x61, 0x62, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x92, 0x01, 0x0a, 0x0a, 0x46, 0x73, 0x74, 0x61, 0x62, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x66, 0x73, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x66, 0x73, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6e, 0x74, 0x6f, 0x70, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x6e, 0x74, 0x6f, 0x70, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x66, 0x72, 0x65, 0x71, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x66, 0x72,
	0x65, 0x71, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x73, 0x73, 0x6e, 0x6f, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x6e, 0x6f, 0x22, 0x57, 0x0a, 0x0e, 0x48, 0x6f,
	0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x6f, 0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x22, 0x3b, 0x0a, 0x0a, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x22, 0x55, 0x0a, 0x0d, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x4c, 0x0a, 0x09, 0x4e, 0x66, 0x73, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x22, 0xc1, 0x04, 0x0a, 0x13, 0x47, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4f, 0x0a,
	0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x51,
	0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x12, 0x4d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x40, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x6f, 0x6f, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a,
	0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64,
	0x41, 0x70, 0x70, 0x73, 0x12, 0x53, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0c, 0x6f, 0x70, 0x65,
	0x6e, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x22, 0x5f, 0x0a, 0x12, 0x52, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xc9, 0x03, 0x0a, 0x0e, 0x52,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x58, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x78, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6d, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6d, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x70, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x70, 0x69, 0x64, 0x22, 0x43,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41,
	0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45,
	0x44, 0x10, 0x03, 0x22, 0x61, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x42, 0x4f, 0x4f, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0x5f, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x07,
	0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x8b, 0x02, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x70, 0x69, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x65, 0x78, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x65, 0x78, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6d, 0x64, 0x6c, 0x69,
	0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6d, 0x64, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa7, 0x01, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x37, 0x0a, 0x09,
	0x73, 0x63, 0x61, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x73, 0x63, 0x61,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x65, 0x0a, 0x15, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xa6, 0x03, 0x0a, 0x11, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x28, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x72,
	0x74, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x4e,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x70, 0x69, 0x64,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x45, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x4f, 0x50, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49,
	0x53, 0x54, 0x45, 0x4e, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4c, 0x4f, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x05, 0x22,
	0x75, 0x0a, 0x1d, 0x47, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65,
	0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0xcb, 0x01, 0x0a, 0x19, 0x47, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x0a, 0x0c, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x22, 0x79, 0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x22, 0x96, 0x04, 0x0a, 0x0f,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x5f, 0x0a, 0x0e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x0d, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x60, 0x0a, 0x0f, 0x61, 0x77, 0x73, 0x5f, 0x65, 0x63, 0x32, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x45,
	0x63, 0x32, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x77, 0x73, 0x45, 0x63, 0x32, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x63, 0x0a, 0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x62, 0x0a, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x65, 0x0a, 0x10, 0x70,
	0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x0f, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x22, 0xe1, 0x01, 0x0a, 0x15, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x73, 0x78, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x73,
	0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6f, 0x73, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6f, 0x73, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e,
	0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x76, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x56, 0x6d, 0x49, 0x64, 0x22, 0x61, 0x0a, 0x15, 0x41, 0x77, 0x73, 0x45,
	0x63, 0x32, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0x0a, 0x16,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x34, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x35, 0x0a, 0x17, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61,
	0x6c, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x11,
	0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x12, 0x2f, 0x0a, 0x13, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x12,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x22, 0x41, 0x0a, 0x0e, 0x43, 0x70, 0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x22, 0x72, 0x0a, 0x12, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x70, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x70,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x70, 0x73, 0x22, 0x34, 0x0a, 0x0f, 0x44, 0x69, 0x73,
	0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6f, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6f, 0x70, 0x73, 0x22,
	0xf4, 0x02, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x41,
	0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x70,
	0x75, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x03, 0x63, 0x70,
	0x75, 0x12, 0x4d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x44, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x22, 0xa2, 0x01, 0x0a, 0x14, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x89, 0x01, 0x0a, 0x21, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1e, 0x64, 0x61, 0x69,
	0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x85, 0x09, 0x0a, 0x1d,
	0x44, 0x61, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x50, 0x55, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x5d, 0x0a, 0x06, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69,
	0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x60, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69,
	0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x57, 0x0a, 0x04, 0x64,
	0x69, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c,
	0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x04,
	0x64, 0x69, 0x73, 0x6b, 0x1a, 0x85, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e,
	0x12, 0x36, 0x0a, 0x17, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x79, 0x5f, 0x66, 0x69, 0x66, 0x74, 0x68,
	0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x15, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x79, 0x46, 0x69, 0x66, 0x74, 0x68, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x65, 0x61, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x70, 0x65, 0x61, 0x6b, 0x1a, 0x82, 0x01, 0x0a,
	0x03, 0x43, 0x50, 0x55, 0x12, 0x7b, 0x0a, 0x16, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x15, 0x75, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x1a, 0x85, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x7b, 0x0a, 0x16,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x15, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x1a, 0xd5, 0x01, 0x0a, 0x07, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x65, 0x0a, 0x0b, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69,
	0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x0a, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x70, 0x73, 0x12, 0x63, 0x0a, 0x0a,
	0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x70,
	0x73, 0x1a, 0x60, 0x0a, 0x04, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x58, 0x0a, 0x04, 0x69, 0x6f, 0x70,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x04, 0x69,
	0x6f, 0x70, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0xdc, 0x01, 0x0a, 0x07, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x12, 0x65, 0x0a, 0x11,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x10, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x12, 0x5f, 0x0a, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x22,
	0x9e, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xe7, 0x01, 0x0a, 0x10, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x12, 0x45, 0x0a, 0x03, 0x66, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x66, 0x69, 0x74, 0x12, 0x78, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x12, 0x0a, 0x10, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x73, 0x0a, 0x1c, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x05, 0x73, 0x68,
	0x61, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x68, 0x61, 0x70, 0x65, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x22,
	0xa9, 0x02, 0x0a, 0x1c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x53, 0x68, 0x61, 0x70, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x2e, 0x0a,
	0x13, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x70, 0x68, 0x79, 0x73,
	0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a,
	0x12, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6c, 0x6f, 0x67, 0x69, 0x63,
	0x61, 0x6c, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x22, 0x7c, 0x0a, 0x18, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x22, 0xb6, 0x01, 0x0a, 0x0d, 0x46, 0x69,
	0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x54, 0x0a, 0x09, 0x66,
	0x69, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x46,
	0x69, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x08, 0x66, 0x69, 0x74, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x22, 0x4f, 0x0a, 0x08, 0x46, 0x69, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x19, 0x0a,
	0x15, 0x46, 0x49, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x49, 0x54, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x5f, 0x46, 0x49, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x53, 0x5f, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54,
	0x10, 0x03, 0x22, 0xca, 0x03, 0x0a, 0x0b, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x4a, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x56, 0x0a, 0x09, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x12, 0x56, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x48, 0x00, 0x52,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x07, 0x0a, 0x05, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0x05, 0x0a, 0x03, 0x53, 0x75, 0x6d, 0x1a, 0x2e, 0x0a, 0x09, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0b, 0x6c,
	0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x1a, 0x0b, 0x0a, 0x09, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x61, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc3, 0x06, 0x0a, 0x11, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x50, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x03, 0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53,
	0x75, 0x6d, 0x48, 0x00, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x5c, 0x0a, 0x09, 0x68, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x5c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x48, 0x00, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x1d, 0x0a, 0x05, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x1a, 0x1b, 0x0a, 0x03, 0x53, 0x75, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0xcc, 0x01, 0x0a, 0x09, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12,
	0x5d, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x60,
	0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x77, 0x65,
	0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x6c,
	0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x70, 0x70,
	0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0xa8, 0x01, 0x0a, 0x09, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x60,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xf9, 0x01, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x72,
	0x6f, 0x77, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x09, 0x72, 0x6f, 0x77, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x22, 0xc1, 0x01, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x60, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x09, 0x6a, 0x6f, 0x62, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0xc7, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x12, 0x5c, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x12, 0x2d, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0xcd, 0x01, 0x0a, 0x0b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22, 0x46, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x03, 0x22,
	0xab, 0x01, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x76, 0x6d, 0x55, 0x75, 0x69, 0x64, 0x12, 0x44, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x9e, 0x02,
	0x0a, 0x0e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x55, 0x72, 0x69, 0x12, 0x5b, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x69,
	0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x4f, 0x0a, 0x13, 0x75, 0x72, 0x69, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x75, 0x72, 0x69, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x56,
	0x0a, 0x09, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x08, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x73, 0x22, 0x49, 0x0a, 0x13, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x56,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa0, 0x06, 0x0a, 0x19, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x65, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x61, 0x0a, 0x12, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x11, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x6c, 0x61, 0x6e, 0x12, 0x7d, 0x0a, 0x1c, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x7a, 0x69,
	0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x1a, 0x73, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x4f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x12, 0x77, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x19, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x17, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x71, 0x0a, 0x18, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x79, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x16, 0x73, 0x6f,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x22, 0xd1, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x64, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x52, 0x12, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x7a, 0x0a, 0x12, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x64,
	0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x14,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x22, 0x23, 0x0a, 0x0d, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53,
	0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xad, 0x04, 0x0a, 0x17, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x70, 0x75, 0x5f, 0x6f, 0x76, 0x65,
	0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x12, 0x63, 0x70, 0x75, 0x4f, 0x76, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x36, 0x0a, 0x17, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x4f, 0x76, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12,
	0x55, 0x0a, 0x27, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x64, 0x75, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x24, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x70, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x43,
	0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x43,
	0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x31, 0x5f, 0x59, 0x45, 0x41, 0x52,
	0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x5f, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54,
	0x53, 0x10, 0x02, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x33, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59,
	0x5f, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x03, 0x12, 0x25, 0x0a, 0x21, 0x43,
	0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x31, 0x5f, 0x59, 0x45, 0x41, 0x52,
	0x5f, 0x55, 0x50, 0x46, 0x52, 0x4f, 0x4e, 0x54, 0x5f, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x04, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x33, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x5f, 0x55, 0x50, 0x46, 0x52, 0x4f, 0x4e, 0x54, 0x5f,
	0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x22, 0xd4, 0x05, 0x0a, 0x16, 0x53, 0x6f,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x70, 0x75, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x12, 0x63, 0x70, 0x75, 0x4f, 0x76, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x85, 0x01, 0x0a, 0x17, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x15, 0x68, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6f,
	0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12,
	0x52, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x22, 0xca, 0x01, 0x0a, 0x15, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x27, 0x0a,
	0x23, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x4d,
	0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x2c, 0x0a, 0x28, 0x48,
	0x4f, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x49,
	0x4e, 0x5f, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x35, 0x0a, 0x31, 0x48, 0x4f, 0x53,
	0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x49, 0x4e, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x03,
	0x22, 0x6e, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44,
	0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x31, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4d,
	0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x33, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x10, 0x03,
	0x22, 0x31, 0x0a, 0x12, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x4e, 0x6f,
	0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x40, 0x0a, 0x11, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xdd, 0x01, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x74, 0x3a, 0x5e, 0xea, 0x41, 0x5b, 0x0a, 0x27, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x30, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xa8, 0x22, 0x0a, 0x0d, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x6c, 0x0a, 0x10, 0x61, 0x6c, 0x6c, 0x5f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x62, 0x0a, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xa9, 0x01, 0x0a, 0x09, 0x43, 0x68,
	0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x63, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x68, 0x61,
	0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x37, 0x0a, 0x09,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x3e, 0x0a, 0x14, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x73, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x72, 0x65, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x04, 0x66, 0x72, 0x65, 0x65, 0x1a, 0xda, 0x01, 0x0a, 0x12, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x62, 0x0a, 0x07,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x1a, 0x60, 0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f,
	0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x75,
	0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x85, 0x07, 0x0a, 0x13, 0x41, 0x73, 0x73, 0x65, 0x74, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x7d, 0x0a, 0x18,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x16, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x12, 0x7f, 0x0a, 0x19, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x17, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x12, 0x63, 0x0a, 0x10,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x12, 0x73, 0x0a, 0x14, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x12, 0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x77, 0x0a, 0x16, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x43, 0x68, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x14, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12,
	0x79, 0x0a, 0x17, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x43, 0x68, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x15, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x1a, 0xa4, 0x01, 0x0a, 0x17, 0x4d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0e, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x0d,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x32, 0x0a,
	0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0xe5, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x1a,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x18, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x65, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0xe6, 0x01, 0x0a, 0x13, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x6e, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xc5, 0x01, 0x0a, 0x14, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0b, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x20, 0x0a, 0x0a, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x1a, 0xe8, 0x01, 0x0a,
	0x11, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x61,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x72, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53, 0x6f,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xb6, 0x01, 0x0a, 0x18, 0x53, 0x6f, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61, 0x6c, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0xe0, 0x07, 0x0a, 0x19, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x12, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x40, 0x0a, 0x12, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79,
	0x52, 0x10, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x54, 0x6f, 0x74,
	0x61, 0x6c, 0x12, 0x44, 0x0a, 0x14, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x63, 0x6f,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d,
	0x6f, 0x6e, 0x65, 0x79, 0x52, 0x12, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x43, 0x6f, 0x73,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x17, 0x6d, 0x6f, 0x6e, 0x74,
	0x68, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x73, 0x5f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x14, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x4f, 0x73, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x1b, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x63,
	0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x65, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x18, 0x6d, 0x6f,
	0x6e, 0x74, 0x68, 0x6c, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x44, 0x0a, 0x14, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c,
	0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x12, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c,
	0x79, 0x43, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x12,
	0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x74, 0x68,
	0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x10, 0x6d, 0x6f,
	0x6e, 0x74, 0x68, 0x6c, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x12, 0x79,
	0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x14, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x76, 0x0a, 0x15, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x70, 0x0a, 0x13, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x53,
	0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x11, 0x73, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x46, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x1a, 0x8a, 0x03, 0x0a, 0x0c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76, 0x0a, 0x15, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x13, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x3a, 0x0a, 0x17, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x41, 0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x80, 0x01,
	0x0a, 0x17, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53,
	0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x15, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x2a, 0x52, 0x0a, 0x09, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1a, 0x0a,
	0x16, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x53, 0x53,
	0x45, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12,
	0x13, 0x0a, 0x0f, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x6e, 0x0a, 0x15, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x15, 0x0a,
	0x11, 0x4f, 0x53, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x53, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c,
	0x59, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4f,
	0x53, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c, 0x59, 0x5f, 0x4c, 0x49, 0x4e, 0x55, 0x58, 0x10, 0x02,
	0x12, 0x12, 0x0a, 0x0e, 0x4f, 0x53, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c, 0x59, 0x5f, 0x55, 0x4e,
	0x49, 0x58, 0x10, 0x03, 0x2a, 0xf3, 0x01, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54,
	0x5f, 0x52, 0x56, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x5f, 0x58, 0x4c, 0x53, 0x58, 0x10, 0x01, 0x12,
	0x21, 0x0a, 0x1d, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x46, 0x4f,
	0x52, 0x4d, 0x41, 0x54, 0x5f, 0x52, 0x56, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x5f, 0x43, 0x53, 0x56,
	0x10, 0x02, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42,
	0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44,
	0x5f, 0x41, 0x57, 0x53, 0x5f, 0x43, 0x53, 0x56, 0x10, 0x04, 0x12, 0x28, 0x0a, 0x24, 0x49, 0x4d,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f,
	0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x5a, 0x55, 0x52, 0x45, 0x5f, 0x43,
	0x53, 0x56, 0x10, 0x05, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a,
	0x4f, 0x42, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x4f,
	0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x43, 0x53, 0x56, 0x10, 0x06, 0x2a, 0x65, 0x0a, 0x0d, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1f, 0x0a, 0x1b, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15,
	0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4d, 0x50, 0x4f, 0x52,
	0x54, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10,
	0x02, 0x2a, 0x69, 0x0a, 0x0e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x46, 0x52, 0x41,
	0x4d, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x46,
	0x52, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x19, 0x0a, 0x15, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x9e, 0x01, 0x0a,
	0x12, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e,
	0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x45, 0x52,
	0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d,
	0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x1c, 0x0a, 0x18, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x44, 0x49,
	0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x03, 0x2a, 0x6e, 0x0a,
	0x0b, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x49,
	0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55,
	0x4c, 0x54, 0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x59, 0x4f, 0x55, 0x52, 0x5f,
	0x4f, 0x57, 0x4e, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x2a, 0xd3, 0x01,
	0x0a, 0x1a, 0x53, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x2c, 0x0a, 0x28,
	0x53, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2f, 0x0a, 0x2b, 0x53, 0x49,
	0x5a, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f,
	0x41, 0x53, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x01, 0x12, 0x29, 0x0a, 0x25, 0x53,
	0x49, 0x5a, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x52, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x2b, 0x0a, 0x27, 0x53, 0x49, 0x5a, 0x49, 0x4e, 0x47,
	0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54,
	0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x41, 0x47, 0x47, 0x52, 0x45, 0x53, 0x53, 0x49, 0x56,
	0x45, 0x10, 0x03, 0x2a, 0x8a, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4f, 0x4d, 0x4d, 0x49,
	0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x4f, 0x4e, 0x45, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x10, 0x02, 0x12,
	0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4c,
	0x41, 0x4e, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x45, 0x5f, 0x59, 0x45, 0x41, 0x52, 0x53, 0x10, 0x03,
	0x2a, 0xed, 0x01, 0x0a, 0x1d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x12, 0x30, 0x0a, 0x2c, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x4d, 0x49,
	0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x50,
	0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x33, 0x0a, 0x2f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f,
	0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54,
	0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45,
	0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x32, 0x0a, 0x2e, 0x43, 0x4f, 0x4d,
	0x50, 0x55, 0x54, 0x45, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f, 0x56, 0x4d,
	0x57, 0x41, 0x52, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x31, 0x0a,
	0x2d, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43,
	0x54, 0x5f, 0x53, 0x4f, 0x4c, 0x45, 0x5f, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x59, 0x10, 0x03,
	0x2a, 0x70, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b,
	0x0a, 0x17, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x52,
	0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x56, 0x49, 0x45,
	0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x10, 0x03, 0x32, 0xac, 0x50, 0x0a, 0x0f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0xb2, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12,
	0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbf, 0x01,
	0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x22, 0x53, 0xda, 0x41, 0x11, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x32, 0x30, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xdf, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41,
	0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x95, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x39,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x11, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x50, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x12, 0xd8, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12,
	0xdd, 0x01, 0x0a, 0x15, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f,
	0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0xf1, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4a, 0x6f, 0x62, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41,
	0x1e, 0x0a, 0x09, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x6a, 0x6f, 0x62, 0x2c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x6a, 0x6f, 0x62, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x22, 0x3d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x0f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf3, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87,
	0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x16, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x47, 0x3a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x32, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x11, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x52, 0x75, 0x6e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x12, 0xd0, 0x01, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x22, 0x4f, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x51, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0xa4, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0xca, 0x41, 0x23, 0x0a, 0x0e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x10, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0xf1, 0x01, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7c, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x01,
	0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd1, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x2a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41,
	0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x32, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc9,
	0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x66, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x10, 0x41,
	0x64, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x64, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x54, 0x6f, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12,
	0xdf, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x46, 0x72, 0x6f, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x12, 0xd0, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb6, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d,
	0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xa3, 0x01,
	0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd8, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x1b, 0x0a, 0x06,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xda,
	0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x0c,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x67, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12,
	0xbf, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x65, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x22, 0x41,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x8d, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x2c, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x22, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x73, 0x12, 0x8f, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x3a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41,
	0x1d, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x14, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x08, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0xca,
	0x41, 0x21, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x3a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xce, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0xde, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x1b, 0x0a,
	0x06, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x06, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12,
	0xb3, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xdc,
	0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca,
	0x41, 0x1e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xf5, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescOnce sync.Once
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescData = file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDesc
)

func file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescGZIP() []byte {
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescOnce.Do(func() {
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescData)
	})
	return file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDescData
}

var file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes = make([]protoimpl.EnumInfo, 34)
var file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes = make([]protoimpl.MessageInfo, 186)
var file_google_cloud_migrationcenter_v1_migrationcenter_proto_goTypes = []interface{}{
	(AssetView)(0),                                    // 0: google.cloud.migrationcenter.v1.AssetView
	(OperatingSystemFamily)(0),                        // 1: google.cloud.migrationcenter.v1.OperatingSystemFamily
	(ImportJobFormat)(0),                              // 2: google.cloud.migrationcenter.v1.ImportJobFormat
	(ImportJobView)(0),                                // 3: google.cloud.migrationcenter.v1.ImportJobView
	(ErrorFrameView)(0),                               // 4: google.cloud.migrationcenter.v1.ErrorFrameView
	(PersistentDiskType)(0),                           // 5: google.cloud.migrationcenter.v1.PersistentDiskType
	(LicenseType)(0),                                  // 6: google.cloud.migrationcenter.v1.LicenseType
	(SizingOptimizationStrategy)(0),                   // 7: google.cloud.migrationcenter.v1.SizingOptimizationStrategy
	(CommitmentPlan)(0),                               // 8: google.cloud.migrationcenter.v1.CommitmentPlan
	(ComputeMigrationTargetProduct)(0),                // 9: google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct
	(ReportView)(0),                                   // 10: google.cloud.migrationcenter.v1.ReportView
	(ImportJob_ImportJobState)(0),                     // 11: google.cloud.migrationcenter.v1.ImportJob.ImportJobState
	(ImportDataFile_State)(0),                         // 12: google.cloud.migrationcenter.v1.ImportDataFile.State
	(Source_SourceType)(0),                            // 13: google.cloud.migrationcenter.v1.Source.SourceType
	(Source_State)(0),                                 // 14: google.cloud.migrationcenter.v1.Source.State
	(Report_Type)(0),                                  // 15: google.cloud.migrationcenter.v1.Report.Type
	(Report_State)(0),                                 // 16: google.cloud.migrationcenter.v1.Report.State
	(MachineDetails_PowerState)(0),                    // 17: google.cloud.migrationcenter.v1.MachineDetails.PowerState
	(MachineArchitectureDetails_FirmwareType)(0),      // 18: google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
	(MachineArchitectureDetails_CpuHyperThreading)(0), // 19: google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
	(NetworkAddress_AddressAssignment)(0),             // 20: google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment
	(DiskEntry_InterfaceType)(0),                      // 21: google.cloud.migrationcenter.v1.DiskEntry.InterfaceType
	(VmwareDiskConfig_BackingType)(0),                 // 22: google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType
	(VmwareDiskConfig_VmdkMode)(0),                    // 23: google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode
	(VmwareDiskConfig_RdmCompatibility)(0),            // 24: google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
	(GuestConfigDetails_SeLinuxMode)(0),               // 25: google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode
	(RunningService_State)(0),                         // 26: google.cloud.migrationcenter.v1.RunningService.State
	(RunningService_StartMode)(0),                     // 27: google.cloud.migrationcenter.v1.RunningService.StartMode
	(NetworkConnection_State)(0),                      // 28: google.cloud.migrationcenter.v1.NetworkConnection.State
	(FitDescriptor_FitLevel)(0),                       // 29: google.cloud.migrationcenter.v1.FitDescriptor.FitLevel
	(ImportError_Severity)(0),                         // 30: google.cloud.migrationcenter.v1.ImportError.Severity
	(VmwareEnginePreferences_CommitmentPlan)(0),       // 31: google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
	(SoleTenancyPreferences_HostMaintenancePolicy)(0), // 32: google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
	(SoleTenancyPreferences_CommitmentPlan)(0),        // 33: google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
	(*Asset)(nil),                                     // 34: google.cloud.migrationcenter.v1.Asset
	(*PreferenceSet)(nil),                             // 35: google.cloud.migrationcenter.v1.PreferenceSet
	(*ImportJob)(nil),                                 // 36: google.cloud.migrationcenter.v1.ImportJob
	(*ImportDataFile)(nil),                            // 37: google.cloud.migrationcenter.v1.ImportDataFile
	(*Group)(nil),                                     // 38: google.cloud.migrationcenter.v1.Group
	(*ErrorFrame)(nil),                                // 39: google.cloud.migrationcenter.v1.ErrorFrame
	(*Source)(nil),                                    // 40: google.cloud.migrationcenter.v1.Source
	(*ReportConfig)(nil),                              // 41: google.cloud.migrationcenter.v1.ReportConfig
	(*Report)(nil),                                    // 42: google.cloud.migrationcenter.v1.Report
	(*OperationMetadata)(nil),                         // 43: google.cloud.migrationcenter.v1.OperationMetadata
	(*ListAssetsRequest)(nil),                         // 44: google.cloud.migrationcenter.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                        // 45: google.cloud.migrationcenter.v1.ListAssetsResponse
	(*GetAssetRequest)(nil),                           // 46: google.cloud.migrationcenter.v1.GetAssetRequest
	(*UpdateAssetRequest)(nil),                        // 47: google.cloud.migrationcenter.v1.UpdateAssetRequest
	(*BatchUpdateAssetsRequest)(nil),                  // 48: google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest
	(*BatchUpdateAssetsResponse)(nil),                 // 49: google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse
	(*DeleteAssetRequest)(nil),                        // 50: google.cloud.migrationcenter.v1.DeleteAssetRequest
	(*BatchDeleteAssetsRequest)(nil),                  // 51: google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest
	(*ReportAssetFramesRequest)(nil),                  // 52: google.cloud.migrationcenter.v1.ReportAssetFramesRequest
	(*ReportAssetFramesResponse)(nil),                 // 53: google.cloud.migrationcenter.v1.ReportAssetFramesResponse
	(*AggregateAssetsValuesRequest)(nil),              // 54: google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
	(*AggregateAssetsValuesResponse)(nil),             // 55: google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse
	(*CreateImportJobRequest)(nil),                    // 56: google.cloud.migrationcenter.v1.CreateImportJobRequest
	(*ListImportJobsRequest)(nil),                     // 57: google.cloud.migrationcenter.v1.ListImportJobsRequest
	(*ListImportJobsResponse)(nil),                    // 58: google.cloud.migrationcenter.v1.ListImportJobsResponse
	(*GetImportJobRequest)(nil),                       // 59: google.cloud.migrationcenter.v1.GetImportJobRequest
	(*DeleteImportJobRequest)(nil),                    // 60: google.cloud.migrationcenter.v1.DeleteImportJobRequest
	(*UpdateImportJobRequest)(nil),                    // 61: google.cloud.migrationcenter.v1.UpdateImportJobRequest
	(*ValidateImportJobRequest)(nil),                  // 62: google.cloud.migrationcenter.v1.ValidateImportJobRequest
	(*RunImportJobRequest)(nil),                       // 63: google.cloud.migrationcenter.v1.RunImportJobRequest
	(*GetImportDataFileRequest)(nil),                  // 64: google.cloud.migrationcenter.v1.GetImportDataFileRequest
	(*ListImportDataFilesRequest)(nil),                // 65: google.cloud.migrationcenter.v1.ListImportDataFilesRequest
	(*ListImportDataFilesResponse)(nil),               // 66: google.cloud.migrationcenter.v1.ListImportDataFilesResponse
	(*CreateImportDataFileRequest)(nil),               // 67: google.cloud.migrationcenter.v1.CreateImportDataFileRequest
	(*DeleteImportDataFileRequest)(nil),               // 68: google.cloud.migrationcenter.v1.DeleteImportDataFileRequest
	(*ListGroupsRequest)(nil),                         // 69: google.cloud.migrationcenter.v1.ListGroupsRequest
	(*ListGroupsResponse)(nil),                        // 70: google.cloud.migrationcenter.v1.ListGroupsResponse
	(*GetGroupRequest)(nil),                           // 71: google.cloud.migrationcenter.v1.GetGroupRequest
	(*CreateGroupRequest)(nil),                        // 72: google.cloud.migrationcenter.v1.CreateGroupRequest
	(*UpdateGroupRequest)(nil),                        // 73: google.cloud.migrationcenter.v1.UpdateGroupRequest
	(*DeleteGroupRequest)(nil),                        // 74: google.cloud.migrationcenter.v1.DeleteGroupRequest
	(*AddAssetsToGroupRequest)(nil),                   // 75: google.cloud.migrationcenter.v1.AddAssetsToGroupRequest
	(*RemoveAssetsFromGroupRequest)(nil),              // 76: google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest
	(*ListErrorFramesRequest)(nil),                    // 77: google.cloud.migrationcenter.v1.ListErrorFramesRequest
	(*ListErrorFramesResponse)(nil),                   // 78: google.cloud.migrationcenter.v1.ListErrorFramesResponse
	(*GetErrorFrameRequest)(nil),                      // 79: google.cloud.migrationcenter.v1.GetErrorFrameRequest
	(*ListSourcesRequest)(nil),                        // 80: google.cloud.migrationcenter.v1.ListSourcesRequest
	(*ListSourcesResponse)(nil),                       // 81: google.cloud.migrationcenter.v1.ListSourcesResponse
	(*GetSourceRequest)(nil),                          // 82: google.cloud.migrationcenter.v1.GetSourceRequest
	(*CreateSourceRequest)(nil),                       // 83: google.cloud.migrationcenter.v1.CreateSourceRequest
	(*UpdateSourceRequest)(nil),                       // 84: google.cloud.migrationcenter.v1.UpdateSourceRequest
	(*DeleteSourceRequest)(nil),                       // 85: google.cloud.migrationcenter.v1.DeleteSourceRequest
	(*ListPreferenceSetsRequest)(nil),                 // 86: google.cloud.migrationcenter.v1.ListPreferenceSetsRequest
	(*ListPreferenceSetsResponse)(nil),                // 87: google.cloud.migrationcenter.v1.ListPreferenceSetsResponse
	(*GetPreferenceSetRequest)(nil),                   // 88: google.cloud.migrationcenter.v1.GetPreferenceSetRequest
	(*CreatePreferenceSetRequest)(nil),                // 89: google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
	(*UpdatePreferenceSetRequest)(nil),                // 90: google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest
	(*DeletePreferenceSetRequest)(nil),                // 91: google.cloud.migrationcenter.v1.DeletePreferenceSetRequest
	(*GetSettingsRequest)(nil),                        // 92: google.cloud.migrationcenter.v1.GetSettingsRequest
	(*UpdateSettingsRequest)(nil),                     // 93: google.cloud.migrationcenter.v1.UpdateSettingsRequest
	(*CreateReportConfigRequest)(nil),                 // 94: google.cloud.migrationcenter.v1.CreateReportConfigRequest
	(*DeleteReportConfigRequest)(nil),                 // 95: google.cloud.migrationcenter.v1.DeleteReportConfigRequest
	(*GetReportRequest)(nil),                          // 96: google.cloud.migrationcenter.v1.GetReportRequest
	(*ListReportsRequest)(nil),                        // 97: google.cloud.migrationcenter.v1.ListReportsRequest
	(*ListReportsResponse)(nil),                       // 98: google.cloud.migrationcenter.v1.ListReportsResponse
	(*DeleteReportRequest)(nil),                       // 99: google.cloud.migrationcenter.v1.DeleteReportRequest
	(*GetReportConfigRequest)(nil),                    // 100: google.cloud.migrationcenter.v1.GetReportConfigRequest
	(*ListReportConfigsRequest)(nil),                  // 101: google.cloud.migrationcenter.v1.ListReportConfigsRequest
	(*ListReportConfigsResponse)(nil),                 // 102: google.cloud.migrationcenter.v1.ListReportConfigsResponse
	(*CreateReportRequest)(nil),                       // 103: google.cloud.migrationcenter.v1.CreateReportRequest
	(*Frames)(nil),                                    // 104: google.cloud.migrationcenter.v1.Frames
	(*AssetFrame)(nil),                                // 105: google.cloud.migrationcenter.v1.AssetFrame
	(*MachineDetails)(nil),                            // 106: google.cloud.migrationcenter.v1.MachineDetails
	(*MachineArchitectureDetails)(nil),                // 107: google.cloud.migrationcenter.v1.MachineArchitectureDetails
	(*BiosDetails)(nil),                               // 108: google.cloud.migrationcenter.v1.BiosDetails
	(*MachineNetworkDetails)(nil),                     // 109: google.cloud.migrationcenter.v1.MachineNetworkDetails
	(*NetworkAdapterList)(nil),                        // 110: google.cloud.migrationcenter.v1.NetworkAdapterList
	(*NetworkAdapterDetails)(nil),                     // 111: google.cloud.migrationcenter.v1.NetworkAdapterDetails
	(*NetworkAddressList)(nil),                        // 112: google.cloud.migrationcenter.v1.NetworkAddressList
	(*NetworkAddress)(nil),                            // 113: google.cloud.migrationcenter.v1.NetworkAddress
	(*MachineDiskDetails)(nil),                        // 114: google.cloud.migrationcenter.v1.MachineDiskDetails
	(*DiskEntryList)(nil),                             // 115: google.cloud.migrationcenter.v1.DiskEntryList
	(*DiskEntry)(nil),                                 // 116: google.cloud.migrationcenter.v1.DiskEntry
	(*DiskPartitionList)(nil),                         // 117: google.cloud.migrationcenter.v1.DiskPartitionList
	(*DiskPartition)(nil),                             // 118: google.cloud.migrationcenter.v1.DiskPartition
	(*VmwareDiskConfig)(nil),                          // 119: google.cloud.migrationcenter.v1.VmwareDiskConfig
	(*GuestOsDetails)(nil),                            // 120: google.cloud.migrationcenter.v1.GuestOsDetails
	(*GuestConfigDetails)(nil),                        // 121: google.cloud.migrationcenter.v1.GuestConfigDetails
	(*FstabEntryList)(nil),                            // 122: google.cloud.migrationcenter.v1.FstabEntryList
	(*FstabEntry)(nil),                                // 123: google.cloud.migrationcenter.v1.FstabEntry
	(*HostsEntryList)(nil),                            // 124: google.cloud.migrationcenter.v1.HostsEntryList
	(*HostsEntry)(nil),                                // 125: google.cloud.migrationcenter.v1.HostsEntry
	(*NfsExportList)(nil),                             // 126: google.cloud.migrationcenter.v1.NfsExportList
	(*NfsExport)(nil),                                 // 127: google.cloud.migrationcenter.v1.NfsExport
	(*GuestRuntimeDetails)(nil),                       // 128: google.cloud.migrationcenter.v1.GuestRuntimeDetails
	(*RunningServiceList)(nil),                        // 129: google.cloud.migrationcenter.v1.RunningServiceList
	(*RunningService)(nil),                            // 130: google.cloud.migrationcenter.v1.RunningService
	(*RunningProcessList)(nil),                        // 131: google.cloud.migrationcenter.v1.RunningProcessList
	(*RunningProcess)(nil),                            // 132: google.cloud.migrationcenter.v1.RunningProcess
	(*RuntimeNetworkInfo)(nil),                        // 133: google.cloud.migrationcenter.v1.RuntimeNetworkInfo
	(*NetworkConnectionList)(nil),                     // 134: google.cloud.migrationcenter.v1.NetworkConnectionList
	(*NetworkConnection)(nil),                         // 135: google.cloud.migrationcenter.v1.NetworkConnection
	(*GuestInstalledApplicationList)(nil),             // 136: google.cloud.migrationcenter.v1.GuestInstalledApplicationList
	(*GuestInstalledApplication)(nil),                 // 137: google.cloud.migrationcenter.v1.GuestInstalledApplication
	(*OpenFileList)(nil),                              // 138: google.cloud.migrationcenter.v1.OpenFileList
	(*OpenFileDetails)(nil),                           // 139: google.cloud.migrationcenter.v1.OpenFileDetails
	(*PlatformDetails)(nil),                           // 140: google.cloud.migrationcenter.v1.PlatformDetails
	(*VmwarePlatformDetails)(nil),                     // 141: google.cloud.migrationcenter.v1.VmwarePlatformDetails
	(*AwsEc2PlatformDetails)(nil),                     // 142: google.cloud.migrationcenter.v1.AwsEc2PlatformDetails
	(*AzureVmPlatformDetails)(nil),                    // 143: google.cloud.migrationcenter.v1.AzureVmPlatformDetails
	(*GenericPlatformDetails)(nil),                    // 144: google.cloud.migrationcenter.v1.GenericPlatformDetails
	(*PhysicalPlatformDetails)(nil),                   // 145: google.cloud.migrationcenter.v1.PhysicalPlatformDetails
	(*MemoryUsageSample)(nil),                         // 146: google.cloud.migrationcenter.v1.MemoryUsageSample
	(*CpuUsageSample)(nil),                            // 147: google.cloud.migrationcenter.v1.CpuUsageSample
	(*NetworkUsageSample)(nil),                        // 148: google.cloud.migrationcenter.v1.NetworkUsageSample
	(*DiskUsageSample)(nil),                           // 149: google.cloud.migrationcenter.v1.DiskUsageSample
	(*PerformanceSample)(nil),                         // 150: google.cloud.migrationcenter.v1.PerformanceSample
	(*AssetPerformanceData)(nil),                      // 151: google.cloud.migrationcenter.v1.AssetPerformanceData
	(*DailyResourceUsageAggregation)(nil),             // 152: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
	(*InsightList)(nil),                               // 153: google.cloud.migrationcenter.v1.InsightList
	(*Insight)(nil),                                   // 154: google.cloud.migrationcenter.v1.Insight
	(*GenericInsight)(nil),                            // 155: google.cloud.migrationcenter.v1.GenericInsight
	(*MigrationInsight)(nil),                          // 156: google.cloud.migrationcenter.v1.MigrationInsight
	(*ComputeEngineMigrationTarget)(nil),              // 157: google.cloud.migrationcenter.v1.ComputeEngineMigrationTarget
	(*ComputeEngineShapeDescriptor)(nil),              // 158: google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
	(*ComputeStorageDescriptor)(nil),                  // 159: google.cloud.migrationcenter.v1.ComputeStorageDescriptor
	(*FitDescriptor)(nil),                             // 160: google.cloud.migrationcenter.v1.FitDescriptor
	(*Aggregation)(nil),                               // 161: google.cloud.migrationcenter.v1.Aggregation
	(*AggregationResult)(nil),                         // 162: google.cloud.migrationcenter.v1.AggregationResult
	(*FileValidationReport)(nil),                      // 163: google.cloud.migrationcenter.v1.FileValidationReport
	(*ValidationReport)(nil),                          // 164: google.cloud.migrationcenter.v1.ValidationReport
	(*ExecutionReport)(nil),                           // 165: google.cloud.migrationcenter.v1.ExecutionReport
	(*ImportError)(nil),                               // 166: google.cloud.migrationcenter.v1.ImportError
	(*ImportRowError)(nil),                            // 167: google.cloud.migrationcenter.v1.ImportRowError
	(*UploadFileInfo)(nil),                            // 168: google.cloud.migrationcenter.v1.UploadFileInfo
	(*AssetList)(nil),                                 // 169: google.cloud.migrationcenter.v1.AssetList
	(*FrameViolationEntry)(nil),                       // 170: google.cloud.migrationcenter.v1.FrameViolationEntry
	(*VirtualMachinePreferences)(nil),                 // 171: google.cloud.migrationcenter.v1.VirtualMachinePreferences
	(*ComputeEnginePreferences)(nil),                  // 172: google.cloud.migrationcenter.v1.ComputeEnginePreferences
	(*MachinePreferences)(nil),                        // 173: google.cloud.migrationcenter.v1.MachinePreferences
	(*MachineSeries)(nil),                             // 174: google.cloud.migrationcenter.v1.MachineSeries
	(*VmwareEnginePreferences)(nil),                   // 175: google.cloud.migrationcenter.v1.VmwareEnginePreferences
	(*SoleTenancyPreferences)(nil),                    // 176: google.cloud.migrationcenter.v1.SoleTenancyPreferences
	(*SoleTenantNodeType)(nil),                        // 177: google.cloud.migrationcenter.v1.SoleTenantNodeType
	(*RegionPreferences)(nil),                         // 178: google.cloud.migrationcenter.v1.RegionPreferences
	(*Settings)(nil),                                  // 179: google.cloud.migrationcenter.v1.Settings
	(*ReportSummary)(nil),                             // 180: google.cloud.migrationcenter.v1.ReportSummary
	nil,                                               // 181: google.cloud.migrationcenter.v1.Asset.LabelsEntry
	nil,                                               // 182: google.cloud.migrationcenter.v1.Asset.AttributesEntry
	nil,                                               // 183: google.cloud.migrationcenter.v1.ImportJob.LabelsEntry
	nil,                                               // 184: google.cloud.migrationcenter.v1.Group.LabelsEntry
	(*ReportConfig_GroupPreferenceSetAssignment)(nil), // 185: google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
	nil, // 186: google.cloud.migrationcenter.v1.AssetFrame.LabelsEntry
	nil, // 187: google.cloud.migrationcenter.v1.AssetFrame.AttributesEntry
	nil, // 188: google.cloud.migrationcenter.v1.RunningProcess.AttributesEntry
	(*DailyResourceUsageAggregation_Stats)(nil),   // 189: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	(*DailyResourceUsageAggregation_CPU)(nil),     // 190: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
	(*DailyResourceUsageAggregation_Memory)(nil),  // 191: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
	(*DailyResourceUsageAggregation_Network)(nil), // 192: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
	(*DailyResourceUsageAggregation_Disk)(nil),    // 193: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
	(*Aggregation_Count)(nil),                     // 194: google.cloud.migrationcenter.v1.Aggregation.Count
	(*Aggregation_Sum)(nil),                       // 195: google.cloud.migrationcenter.v1.Aggregation.Sum
	(*Aggregation_Histogram)(nil),                 // 196: google.cloud.migrationcenter.v1.Aggregation.Histogram
	(*Aggregation_Frequency)(nil),                 // 197: google.cloud.migrationcenter.v1.Aggregation.Frequency
	(*AggregationResult_Count)(nil),               // 198: google.cloud.migrationcenter.v1.AggregationResult.Count
	(*AggregationResult_Sum)(nil),                 // 199: google.cloud.migrationcenter.v1.AggregationResult.Sum
	(*AggregationResult_Histogram)(nil),           // 200: google.cloud.migrationcenter.v1.AggregationResult.Histogram
	(*AggregationResult_Frequency)(nil),           // 201: google.cloud.migrationcenter.v1.AggregationResult.Frequency
	(*AggregationResult_Histogram_Bucket)(nil),    // 202: google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
	nil,                             // 203: google.cloud.migrationcenter.v1.AggregationResult.Frequency.ValuesEntry
	nil,                             // 204: google.cloud.migrationcenter.v1.UploadFileInfo.HeadersEntry
	(*ReportSummary_ChartData)(nil), // 205: google.cloud.migrationcenter.v1.ReportSummary.ChartData
	(*ReportSummary_UtilizationChartData)(nil),      // 206: google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
	(*ReportSummary_HistogramChartData)(nil),        // 207: google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
	(*ReportSummary_AssetAggregateStats)(nil),       // 208: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
	(*ReportSummary_MachineSeriesAllocation)(nil),   // 209: google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
	(*ReportSummary_ComputeEngineFinding)(nil),      // 210: google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
	(*ReportSummary_VmwareEngineFinding)(nil),       // 211: google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
	(*ReportSummary_VmwareNodeAllocation)(nil),      // 212: google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
	(*ReportSummary_VmwareNode)(nil),                // 213: google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
	(*ReportSummary_SoleTenantFinding)(nil),         // 214: google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
	(*ReportSummary_SoleTenantNodeAllocation)(nil),  // 215: google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
	(*ReportSummary_GroupPreferenceSetFinding)(nil), // 216: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
	(*ReportSummary_GroupFinding)(nil),              // 217: google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
	(*ReportSummary_ChartData_DataPoint)(nil),       // 218: google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
	(*ReportSummary_HistogramChartData_Bucket)(nil), // 219: google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
	(*timestamppb.Timestamp)(nil),                   // 220: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                   // 221: google.protobuf.FieldMask
	(*date.Date)(nil),                               // 222: google.type.Date
	(*money.Money)(nil),                             // 223: google.type.Money
	(*emptypb.Empty)(nil),                           // 224: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                 // 225: google.longrunning.Operation
}
var file_google_cloud_migrationcenter_v1_migrationcenter_proto_depIdxs = []int32{
	220, // 0: google.cloud.migrationcenter.v1.Asset.create_time:type_name -> google.protobuf.Timestamp
	220, // 1: google.cloud.migrationcenter.v1.Asset.update_time:type_name -> google.protobuf.Timestamp
	181, // 2: google.cloud.migrationcenter.v1.Asset.labels:type_name -> google.cloud.migrationcenter.v1.Asset.LabelsEntry
	182, // 3: google.cloud.migrationcenter.v1.Asset.attributes:type_name -> google.cloud.migrationcenter.v1.Asset.AttributesEntry
	106, // 4: google.cloud.migrationcenter.v1.Asset.machine_details:type_name -> google.cloud.migrationcenter.v1.MachineDetails
	153, // 5: google.cloud.migrationcenter.v1.Asset.insight_list:type_name -> google.cloud.migrationcenter.v1.InsightList
	151, // 6: google.cloud.migrationcenter.v1.Asset.performance_data:type_name -> google.cloud.migrationcenter.v1.AssetPerformanceData
	220, // 7: google.cloud.migrationcenter.v1.PreferenceSet.create_time:type_name -> google.protobuf.Timestamp
	220, // 8: google.cloud.migrationcenter.v1.PreferenceSet.update_time:type_name -> google.protobuf.Timestamp
	171, // 9: google.cloud.migrationcenter.v1.PreferenceSet.virtual_machine_preferences:type_name -> google.cloud.migrationcenter.v1.VirtualMachinePreferences
	220, // 10: google.cloud.migrationcenter.v1.ImportJob.create_time:type_name -> google.protobuf.Timestamp
	220, // 11: google.cloud.migrationcenter.v1.ImportJob.update_time:type_name -> google.protobuf.Timestamp
	220, // 12: google.cloud.migrationcenter.v1.ImportJob.complete_time:type_name -> google.protobuf.Timestamp
	11,  // 13: google.cloud.migrationcenter.v1.ImportJob.state:type_name -> google.cloud.migrationcenter.v1.ImportJob.ImportJobState
	183, // 14: google.cloud.migrationcenter.v1.ImportJob.labels:type_name -> google.cloud.migrationcenter.v1.ImportJob.LabelsEntry
	164, // 15: google.cloud.migrationcenter.v1.ImportJob.validation_report:type_name -> google.cloud.migrationcenter.v1.ValidationReport
	165, // 16: google.cloud.migrationcenter.v1.ImportJob.execution_report:type_name -> google.cloud.migrationcenter.v1.ExecutionReport
	2,   // 17: google.cloud.migrationcenter.v1.ImportDataFile.format:type_name -> google.cloud.migrationcenter.v1.ImportJobFormat
	220, // 18: google.cloud.migrationcenter.v1.ImportDataFile.create_time:type_name -> google.protobuf.Timestamp
	12,  // 19: google.cloud.migrationcenter.v1.ImportDataFile.state:type_name -> google.cloud.migrationcenter.v1.ImportDataFile.State
	168, // 20: google.cloud.migrationcenter.v1.ImportDataFile.upload_file_info:type_name -> google.cloud.migrationcenter.v1.UploadFileInfo
	220, // 21: google.cloud.migrationcenter.v1.Group.create_time:type_name -> google.protobuf.Timestamp
	220, // 22: google.cloud.migrationcenter.v1.Group.update_time:type_name -> google.protobuf.Timestamp
	184, // 23: google.cloud.migrationcenter.v1.Group.labels:type_name -> google.cloud.migrationcenter.v1.Group.LabelsEntry
	170, // 24: google.cloud.migrationcenter.v1.ErrorFrame.violations:type_name -> google.cloud.migrationcenter.v1.FrameViolationEntry
	105, // 25: google.cloud.migrationcenter.v1.ErrorFrame.original_frame:type_name -> google.cloud.migrationcenter.v1.AssetFrame
	220, // 26: google.cloud.migrationcenter.v1.ErrorFrame.ingestion_time:type_name -> google.protobuf.Timestamp
	220, // 27: google.cloud.migrationcenter.v1.Source.create_time:type_name -> google.protobuf.Timestamp
	220, // 28: google.cloud.migrationcenter.v1.Source.update_time:type_name -> google.protobuf.Timestamp
	13,  // 29: google.cloud.migrationcenter.v1.Source.type:type_name -> google.cloud.migrationcenter.v1.Source.SourceType
	14,  // 30: google.cloud.migrationcenter.v1.Source.state:type_name -> google.cloud.migrationcenter.v1.Source.State
	220, // 31: google.cloud.migrationcenter.v1.ReportConfig.create_time:type_name -> google.protobuf.Timestamp
	220, // 32: google.cloud.migrationcenter.v1.ReportConfig.update_time:type_name -> google.protobuf.Timestamp
	185, // 33: google.cloud.migrationcenter.v1.ReportConfig.group_preferenceset_assignments:type_name -> google.cloud.migrationcenter.v1.ReportConfig.GroupPreferenceSetAssignment
	220, // 34: google.cloud.migrationcenter.v1.Report.create_time:type_name -> google.protobuf.Timestamp
	220, // 35: google.cloud.migrationcenter.v1.Report.update_time:type_name -> google.protobuf.Timestamp
	15,  // 36: google.cloud.migrationcenter.v1.Report.type:type_name -> google.cloud.migrationcenter.v1.Report.Type
	16,  // 37: google.cloud.migrationcenter.v1.Report.state:type_name -> google.cloud.migrationcenter.v1.Report.State
	180, // 38: google.cloud.migrationcenter.v1.Report.summary:type_name -> google.cloud.migrationcenter.v1.ReportSummary
	220, // 39: google.cloud.migrationcenter.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	220, // 40: google.cloud.migrationcenter.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,   // 41: google.cloud.migrationcenter.v1.ListAssetsRequest.view:type_name -> google.cloud.migrationcenter.v1.AssetView
	34,  // 42: google.cloud.migrationcenter.v1.ListAssetsResponse.assets:type_name -> google.cloud.migrationcenter.v1.Asset
	0,   // 43: google.cloud.migrationcenter.v1.GetAssetRequest.view:type_name -> google.cloud.migrationcenter.v1.AssetView
	221, // 44: google.cloud.migrationcenter.v1.UpdateAssetRequest.update_mask:type_name -> google.protobuf.FieldMask
	34,  // 45: google.cloud.migrationcenter.v1.UpdateAssetRequest.asset:type_name -> google.cloud.migrationcenter.v1.Asset
	47,  // 46: google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest.requests:type_name -> google.cloud.migrationcenter.v1.UpdateAssetRequest
	34,  // 47: google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse.assets:type_name -> google.cloud.migrationcenter.v1.Asset
	104, // 48: google.cloud.migrationcenter.v1.ReportAssetFramesRequest.frames:type_name -> google.cloud.migrationcenter.v1.Frames
	161, // 49: google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.aggregations:type_name -> google.cloud.migrationcenter.v1.Aggregation
	162, // 50: google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse.results:type_name -> google.cloud.migrationcenter.v1.AggregationResult
	36,  // 51: google.cloud.migrationcenter.v1.CreateImportJobRequest.import_job:type_name -> google.cloud.migrationcenter.v1.ImportJob
	3,   // 52: google.cloud.migrationcenter.v1.ListImportJobsRequest.view:type_name -> google.cloud.migrationcenter.v1.ImportJobView
	36,  // 53: google.cloud.migrationcenter.v1.ListImportJobsResponse.import_jobs:type_name -> google.cloud.migrationcenter.v1.ImportJob
	3,   // 54: google.cloud.migrationcenter.v1.GetImportJobRequest.view:type_name -> google.cloud.migrationcenter.v1.ImportJobView
	221, // 55: google.cloud.migrationcenter.v1.UpdateImportJobRequest.update_mask:type_name -> google.protobuf.FieldMask
	36,  // 56: google.cloud.migrationcenter.v1.UpdateImportJobRequest.import_job:type_name -> google.cloud.migrationcenter.v1.ImportJob
	37,  // 57: google.cloud.migrationcenter.v1.ListImportDataFilesResponse.import_data_files:type_name -> google.cloud.migrationcenter.v1.ImportDataFile
	37,  // 58: google.cloud.migrationcenter.v1.CreateImportDataFileRequest.import_data_file:type_name -> google.cloud.migrationcenter.v1.ImportDataFile
	38,  // 59: google.cloud.migrationcenter.v1.ListGroupsResponse.groups:type_name -> google.cloud.migrationcenter.v1.Group
	38,  // 60: google.cloud.migrationcenter.v1.CreateGroupRequest.group:type_name -> google.cloud.migrationcenter.v1.Group
	221, // 61: google.cloud.migrationcenter.v1.UpdateGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	38,  // 62: google.cloud.migrationcenter.v1.UpdateGroupRequest.group:type_name -> google.cloud.migrationcenter.v1.Group
	169, // 63: google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.assets:type_name -> google.cloud.migrationcenter.v1.AssetList
	169, // 64: google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest.assets:type_name -> google.cloud.migrationcenter.v1.AssetList
	4,   // 65: google.cloud.migrationcenter.v1.ListErrorFramesRequest.view:type_name -> google.cloud.migrationcenter.v1.ErrorFrameView
	39,  // 66: google.cloud.migrationcenter.v1.ListErrorFramesResponse.error_frames:type_name -> google.cloud.migrationcenter.v1.ErrorFrame
	4,   // 67: google.cloud.migrationcenter.v1.GetErrorFrameRequest.view:type_name -> google.cloud.migrationcenter.v1.ErrorFrameView
	40,  // 68: google.cloud.migrationcenter.v1.ListSourcesResponse.sources:type_name -> google.cloud.migrationcenter.v1.Source
	40,  // 69: google.cloud.migrationcenter.v1.CreateSourceRequest.source:type_name -> google.cloud.migrationcenter.v1.Source
	221, // 70: google.cloud.migrationcenter.v1.UpdateSourceRequest.update_mask:type_name -> google.protobuf.FieldMask
	40,  // 71: google.cloud.migrationcenter.v1.UpdateSourceRequest.source:type_name -> google.cloud.migrationcenter.v1.Source
	35,  // 72: google.cloud.migrationcenter.v1.ListPreferenceSetsResponse.preference_sets:type_name -> google.cloud.migrationcenter.v1.PreferenceSet
	35,  // 73: google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.preference_set:type_name -> google.cloud.migrationcenter.v1.PreferenceSet
	221, // 74: google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	35,  // 75: google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest.preference_set:type_name -> google.cloud.migrationcenter.v1.PreferenceSet
	221, // 76: google.cloud.migrationcenter.v1.UpdateSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	179, // 77: google.cloud.migrationcenter.v1.UpdateSettingsRequest.settings:type_name -> google.cloud.migrationcenter.v1.Settings
	41,  // 78: google.cloud.migrationcenter.v1.CreateReportConfigRequest.report_config:type_name -> google.cloud.migrationcenter.v1.ReportConfig
	10,  // 79: google.cloud.migrationcenter.v1.GetReportRequest.view:type_name -> google.cloud.migrationcenter.v1.ReportView
	10,  // 80: google.cloud.migrationcenter.v1.ListReportsRequest.view:type_name -> google.cloud.migrationcenter.v1.ReportView
	42,  // 81: google.cloud.migrationcenter.v1.ListReportsResponse.reports:type_name -> google.cloud.migrationcenter.v1.Report
	41,  // 82: google.cloud.migrationcenter.v1.ListReportConfigsResponse.report_configs:type_name -> google.cloud.migrationcenter.v1.ReportConfig
	42,  // 83: google.cloud.migrationcenter.v1.CreateReportRequest.report:type_name -> google.cloud.migrationcenter.v1.Report
	105, // 84: google.cloud.migrationcenter.v1.Frames.frames_data:type_name -> google.cloud.migrationcenter.v1.AssetFrame
	106, // 85: google.cloud.migrationcenter.v1.AssetFrame.machine_details:type_name -> google.cloud.migrationcenter.v1.MachineDetails
	220, // 86: google.cloud.migrationcenter.v1.AssetFrame.report_time:type_name -> google.protobuf.Timestamp
	186, // 87: google.cloud.migrationcenter.v1.AssetFrame.labels:type_name -> google.cloud.migrationcenter.v1.AssetFrame.LabelsEntry
	187, // 88: google.cloud.migrationcenter.v1.AssetFrame.attributes:type_name -> google.cloud.migrationcenter.v1.AssetFrame.AttributesEntry
	150, // 89: google.cloud.migrationcenter.v1.AssetFrame.performance_samples:type_name -> google.cloud.migrationcenter.v1.PerformanceSample
	220, // 90: google.cloud.migrationcenter.v1.MachineDetails.create_time:type_name -> google.protobuf.Timestamp
	17,  // 91: google.cloud.migrationcenter.v1.MachineDetails.power_state:type_name -> google.cloud.migrationcenter.v1.MachineDetails.PowerState
	107, // 92: google.cloud.migrationcenter.v1.MachineDetails.architecture:type_name -> google.cloud.migrationcenter.v1.MachineArchitectureDetails
	120, // 93: google.cloud.migrationcenter.v1.MachineDetails.guest_os:type_name -> google.cloud.migrationcenter.v1.GuestOsDetails
	109, // 94: google.cloud.migrationcenter.v1.MachineDetails.network:type_name -> google.cloud.migrationcenter.v1.MachineNetworkDetails
	114, // 95: google.cloud.migrationcenter.v1.MachineDetails.disks:type_name -> google.cloud.migrationcenter.v1.MachineDiskDetails
	140, // 96: google.cloud.migrationcenter.v1.MachineDetails.platform:type_name -> google.cloud.migrationcenter.v1.PlatformDetails
	108, // 97: google.cloud.migrationcenter.v1.MachineArchitectureDetails.bios:type_name -> google.cloud.migrationcenter.v1.BiosDetails
	18,  // 98: google.cloud.migrationcenter.v1.MachineArchitectureDetails.firmware_type:type_name -> google.cloud.migrationcenter.v1.MachineArchitectureDetails.FirmwareType
	19,  // 99: google.cloud.migrationcenter.v1.MachineArchitectureDetails.hyperthreading:type_name -> google.cloud.migrationcenter.v1.MachineArchitectureDetails.CpuHyperThreading
	222, // 100: google.cloud.migrationcenter.v1.BiosDetails.release_date:type_name -> google.type.Date
	110, // 101: google.cloud.migrationcenter.v1.MachineNetworkDetails.adapters:type_name -> google.cloud.migrationcenter.v1.NetworkAdapterList
	111, // 102: google.cloud.migrationcenter.v1.NetworkAdapterList.entries:type_name -> google.cloud.migrationcenter.v1.NetworkAdapterDetails
	112, // 103: google.cloud.migrationcenter.v1.NetworkAdapterDetails.addresses:type_name -> google.cloud.migrationcenter.v1.NetworkAddressList
	113, // 104: google.cloud.migrationcenter.v1.NetworkAddressList.entries:type_name -> google.cloud.migrationcenter.v1.NetworkAddress
	20,  // 105: google.cloud.migrationcenter.v1.NetworkAddress.assignment:type_name -> google.cloud.migrationcenter.v1.NetworkAddress.AddressAssignment
	115, // 106: google.cloud.migrationcenter.v1.MachineDiskDetails.disks:type_name -> google.cloud.migrationcenter.v1.DiskEntryList
	116, // 107: google.cloud.migrationcenter.v1.DiskEntryList.entries:type_name -> google.cloud.migrationcenter.v1.DiskEntry
	21,  // 108: google.cloud.migrationcenter.v1.DiskEntry.interface_type:type_name -> google.cloud.migrationcenter.v1.DiskEntry.InterfaceType
	117, // 109: google.cloud.migrationcenter.v1.DiskEntry.partitions:type_name -> google.cloud.migrationcenter.v1.DiskPartitionList
	119, // 110: google.cloud.migrationcenter.v1.DiskEntry.vmware:type_name -> google.cloud.migrationcenter.v1.VmwareDiskConfig
	118, // 111: google.cloud.migrationcenter.v1.DiskPartitionList.entries:type_name -> google.cloud.migrationcenter.v1.DiskPartition
	117, // 112: google.cloud.migrationcenter.v1.DiskPartition.sub_partitions:type_name -> google.cloud.migrationcenter.v1.DiskPartitionList
	22,  // 113: google.cloud.migrationcenter.v1.VmwareDiskConfig.backing_type:type_name -> google.cloud.migrationcenter.v1.VmwareDiskConfig.BackingType
	23,  // 114: google.cloud.migrationcenter.v1.VmwareDiskConfig.vmdk_mode:type_name -> google.cloud.migrationcenter.v1.VmwareDiskConfig.VmdkMode
	24,  // 115: google.cloud.migrationcenter.v1.VmwareDiskConfig.rdm_compatibility:type_name -> google.cloud.migrationcenter.v1.VmwareDiskConfig.RdmCompatibility
	1,   // 116: google.cloud.migrationcenter.v1.GuestOsDetails.family:type_name -> google.cloud.migrationcenter.v1.OperatingSystemFamily
	121, // 117: google.cloud.migrationcenter.v1.GuestOsDetails.config:type_name -> google.cloud.migrationcenter.v1.GuestConfigDetails
	128, // 118: google.cloud.migrationcenter.v1.GuestOsDetails.runtime:type_name -> google.cloud.migrationcenter.v1.GuestRuntimeDetails
	122, // 119: google.cloud.migrationcenter.v1.GuestConfigDetails.fstab:type_name -> google.cloud.migrationcenter.v1.FstabEntryList
	124, // 120: google.cloud.migrationcenter.v1.GuestConfigDetails.hosts:type_name -> google.cloud.migrationcenter.v1.HostsEntryList
	126, // 121: google.cloud.migrationcenter.v1.GuestConfigDetails.nfs_exports:type_name -> google.cloud.migrationcenter.v1.NfsExportList
	25,  // 122: google.cloud.migrationcenter.v1.GuestConfigDetails.selinux_mode:type_name -> google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode
	123, // 123: google.cloud.migrationcenter.v1.FstabEntryList.entries:type_name -> google.cloud.migrationcenter.v1.FstabEntry
	125, // 124: google.cloud.migrationcenter.v1.HostsEntryList.entries:type_name -> google.cloud.migrationcenter.v1.HostsEntry
	127, // 125: google.cloud.migrationcenter.v1.NfsExportList.entries:type_name -> google.cloud.migrationcenter.v1.NfsExport
	129, // 126: google.cloud.migrationcenter.v1.GuestRuntimeDetails.services:type_name -> google.cloud.migrationcenter.v1.RunningServiceList
	131, // 127: google.cloud.migrationcenter.v1.GuestRuntimeDetails.processes:type_name -> google.cloud.migrationcenter.v1.RunningProcessList
	133, // 128: google.cloud.migrationcenter.v1.GuestRuntimeDetails.network:type_name -> google.cloud.migrationcenter.v1.RuntimeNetworkInfo
	220, // 129: google.cloud.migrationcenter.v1.GuestRuntimeDetails.last_boot_time:type_name -> google.protobuf.Timestamp
	136, // 130: google.cloud.migrationcenter.v1.GuestRuntimeDetails.installed_apps:type_name -> google.cloud.migrationcenter.v1.GuestInstalledApplicationList
	138, // 131: google.cloud.migrationcenter.v1.GuestRuntimeDetails.open_file_list:type_name -> google.cloud.migrationcenter.v1.OpenFileList
	130, // 132: google.cloud.migrationcenter.v1.RunningServiceList.entries:type_name -> google.cloud.migrationcenter.v1.RunningService
	26,  // 133: google.cloud.migrationcenter.v1.RunningService.state:type_name -> google.cloud.migrationcenter.v1.RunningService.State
	27,  // 134: google.cloud.migrationcenter.v1.RunningService.start_mode:type_name -> google.cloud.migrationcenter.v1.RunningService.StartMode
	132, // 135: google.cloud.migrationcenter.v1.RunningProcessList.entries:type_name -> google.cloud.migrationcenter.v1.RunningProcess
	188, // 136: google.cloud.migrationcenter.v1.RunningProcess.attributes:type_name -> google.cloud.migrationcenter.v1.RunningProcess.AttributesEntry
	220, // 137: google.cloud.migrationcenter.v1.RuntimeNetworkInfo.scan_time:type_name -> google.protobuf.Timestamp
	134, // 138: google.cloud.migrationcenter.v1.RuntimeNetworkInfo.connections:type_name -> google.cloud.migrationcenter.v1.NetworkConnectionList
	135, // 139: google.cloud.migrationcenter.v1.NetworkConnectionList.entries:type_name -> google.cloud.migrationcenter.v1.NetworkConnection
	28,  // 140: google.cloud.migrationcenter.v1.NetworkConnection.state:type_name -> google.cloud.migrationcenter.v1.NetworkConnection.State
	137, // 141: google.cloud.migrationcenter.v1.GuestInstalledApplicationList.entries:type_name -> google.cloud.migrationcenter.v1.GuestInstalledApplication
	220, // 142: google.cloud.migrationcenter.v1.GuestInstalledApplication.install_time:type_name -> google.protobuf.Timestamp
	139, // 143: google.cloud.migrationcenter.v1.OpenFileList.entries:type_name -> google.cloud.migrationcenter.v1.OpenFileDetails
	141, // 144: google.cloud.migrationcenter.v1.PlatformDetails.vmware_details:type_name -> google.cloud.migrationcenter.v1.VmwarePlatformDetails
	142, // 145: google.cloud.migrationcenter.v1.PlatformDetails.aws_ec2_details:type_name -> google.cloud.migrationcenter.v1.AwsEc2PlatformDetails
	143, // 146: google.cloud.migrationcenter.v1.PlatformDetails.azure_vm_details:type_name -> google.cloud.migrationcenter.v1.AzureVmPlatformDetails
	144, // 147: google.cloud.migrationcenter.v1.PlatformDetails.generic_details:type_name -> google.cloud.migrationcenter.v1.GenericPlatformDetails
	145, // 148: google.cloud.migrationcenter.v1.PlatformDetails.physical_details:type_name -> google.cloud.migrationcenter.v1.PhysicalPlatformDetails
	220, // 149: google.cloud.migrationcenter.v1.PerformanceSample.sample_time:type_name -> google.protobuf.Timestamp
	146, // 150: google.cloud.migrationcenter.v1.PerformanceSample.memory:type_name -> google.cloud.migrationcenter.v1.MemoryUsageSample
	147, // 151: google.cloud.migrationcenter.v1.PerformanceSample.cpu:type_name -> google.cloud.migrationcenter.v1.CpuUsageSample
	148, // 152: google.cloud.migrationcenter.v1.PerformanceSample.network:type_name -> google.cloud.migrationcenter.v1.NetworkUsageSample
	149, // 153: google.cloud.migrationcenter.v1.PerformanceSample.disk:type_name -> google.cloud.migrationcenter.v1.DiskUsageSample
	152, // 154: google.cloud.migrationcenter.v1.AssetPerformanceData.daily_resource_usage_aggregations:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
	222, // 155: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.date:type_name -> google.type.Date
	190, // 156: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.cpu:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
	191, // 157: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.memory:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
	192, // 158: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.network:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
	193, // 159: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.disk:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
	154, // 160: google.cloud.migrationcenter.v1.InsightList.insights:type_name -> google.cloud.migrationcenter.v1.Insight
	220, // 161: google.cloud.migrationcenter.v1.InsightList.update_time:type_name -> google.protobuf.Timestamp
	156, // 162: google.cloud.migrationcenter.v1.Insight.migration_insight:type_name -> google.cloud.migrationcenter.v1.MigrationInsight
	155, // 163: google.cloud.migrationcenter.v1.Insight.generic_insight:type_name -> google.cloud.migrationcenter.v1.GenericInsight
	160, // 164: google.cloud.migrationcenter.v1.MigrationInsight.fit:type_name -> google.cloud.migrationcenter.v1.FitDescriptor
	157, // 165: google.cloud.migrationcenter.v1.MigrationInsight.compute_engine_target:type_name -> google.cloud.migrationcenter.v1.ComputeEngineMigrationTarget
	158, // 166: google.cloud.migrationcenter.v1.ComputeEngineMigrationTarget.shape:type_name -> google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
	159, // 167: google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.storage:type_name -> google.cloud.migrationcenter.v1.ComputeStorageDescriptor
	5,   // 168: google.cloud.migrationcenter.v1.ComputeStorageDescriptor.type:type_name -> google.cloud.migrationcenter.v1.PersistentDiskType
	29,  // 169: google.cloud.migrationcenter.v1.FitDescriptor.fit_level:type_name -> google.cloud.migrationcenter.v1.FitDescriptor.FitLevel
	194, // 170: google.cloud.migrationcenter.v1.Aggregation.count:type_name -> google.cloud.migrationcenter.v1.Aggregation.Count
	195, // 171: google.cloud.migrationcenter.v1.Aggregation.sum:type_name -> google.cloud.migrationcenter.v1.Aggregation.Sum
	196, // 172: google.cloud.migrationcenter.v1.Aggregation.histogram:type_name -> google.cloud.migrationcenter.v1.Aggregation.Histogram
	197, // 173: google.cloud.migrationcenter.v1.Aggregation.frequency:type_name -> google.cloud.migrationcenter.v1.Aggregation.Frequency
	198, // 174: google.cloud.migrationcenter.v1.AggregationResult.count:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Count
	199, // 175: google.cloud.migrationcenter.v1.AggregationResult.sum:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Sum
	200, // 176: google.cloud.migrationcenter.v1.AggregationResult.histogram:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Histogram
	201, // 177: google.cloud.migrationcenter.v1.AggregationResult.frequency:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Frequency
	167, // 178: google.cloud.migrationcenter.v1.FileValidationReport.row_errors:type_name -> google.cloud.migrationcenter.v1.ImportRowError
	166, // 179: google.cloud.migrationcenter.v1.FileValidationReport.file_errors:type_name -> google.cloud.migrationcenter.v1.ImportError
	163, // 180: google.cloud.migrationcenter.v1.ValidationReport.file_validations:type_name -> google.cloud.migrationcenter.v1.FileValidationReport
	166, // 181: google.cloud.migrationcenter.v1.ValidationReport.job_errors:type_name -> google.cloud.migrationcenter.v1.ImportError
	164, // 182: google.cloud.migrationcenter.v1.ExecutionReport.execution_errors:type_name -> google.cloud.migrationcenter.v1.ValidationReport
	30,  // 183: google.cloud.migrationcenter.v1.ImportError.severity:type_name -> google.cloud.migrationcenter.v1.ImportError.Severity
	166, // 184: google.cloud.migrationcenter.v1.ImportRowError.errors:type_name -> google.cloud.migrationcenter.v1.ImportError
	204, // 185: google.cloud.migrationcenter.v1.UploadFileInfo.headers:type_name -> google.cloud.migrationcenter.v1.UploadFileInfo.HeadersEntry
	220, // 186: google.cloud.migrationcenter.v1.UploadFileInfo.uri_expiration_time:type_name -> google.protobuf.Timestamp
	9,   // 187: google.cloud.migrationcenter.v1.VirtualMachinePreferences.target_product:type_name -> google.cloud.migrationcenter.v1.ComputeMigrationTargetProduct
	178, // 188: google.cloud.migrationcenter.v1.VirtualMachinePreferences.region_preferences:type_name -> google.cloud.migrationcenter.v1.RegionPreferences
	8,   // 189: google.cloud.migrationcenter.v1.VirtualMachinePreferences.commitment_plan:type_name -> google.cloud.migrationcenter.v1.CommitmentPlan
	7,   // 190: google.cloud.migrationcenter.v1.VirtualMachinePreferences.sizing_optimization_strategy:type_name -> google.cloud.migrationcenter.v1.SizingOptimizationStrategy
	172, // 191: google.cloud.migrationcenter.v1.VirtualMachinePreferences.compute_engine_preferences:type_name -> google.cloud.migrationcenter.v1.ComputeEnginePreferences
	175, // 192: google.cloud.migrationcenter.v1.VirtualMachinePreferences.vmware_engine_preferences:type_name -> google.cloud.migrationcenter.v1.VmwareEnginePreferences
	176, // 193: google.cloud.migrationcenter.v1.VirtualMachinePreferences.sole_tenancy_preferences:type_name -> google.cloud.migrationcenter.v1.SoleTenancyPreferences
	173, // 194: google.cloud.migrationcenter.v1.ComputeEnginePreferences.machine_preferences:type_name -> google.cloud.migrationcenter.v1.MachinePreferences
	6,   // 195: google.cloud.migrationcenter.v1.ComputeEnginePreferences.license_type:type_name -> google.cloud.migrationcenter.v1.LicenseType
	174, // 196: google.cloud.migrationcenter.v1.MachinePreferences.allowed_machine_series:type_name -> google.cloud.migrationcenter.v1.MachineSeries
	31,  // 197: google.cloud.migrationcenter.v1.VmwareEnginePreferences.commitment_plan:type_name -> google.cloud.migrationcenter.v1.VmwareEnginePreferences.CommitmentPlan
	32,  // 198: google.cloud.migrationcenter.v1.SoleTenancyPreferences.host_maintenance_policy:type_name -> google.cloud.migrationcenter.v1.SoleTenancyPreferences.HostMaintenancePolicy
	33,  // 199: google.cloud.migrationcenter.v1.SoleTenancyPreferences.commitment_plan:type_name -> google.cloud.migrationcenter.v1.SoleTenancyPreferences.CommitmentPlan
	177, // 200: google.cloud.migrationcenter.v1.SoleTenancyPreferences.node_types:type_name -> google.cloud.migrationcenter.v1.SoleTenantNodeType
	208, // 201: google.cloud.migrationcenter.v1.ReportSummary.all_assets_stats:type_name -> google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
	217, // 202: google.cloud.migrationcenter.v1.ReportSummary.group_findings:type_name -> google.cloud.migrationcenter.v1.ReportSummary.GroupFinding
	189, // 203: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.utilization_percentage:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	189, // 204: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.utilization_percentage:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	189, // 205: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.ingress_bps:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	189, // 206: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.egress_bps:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	189, // 207: google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.iops:type_name -> google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
	202, // 208: google.cloud.migrationcenter.v1.AggregationResult.Histogram.buckets:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
	203, // 209: google.cloud.migrationcenter.v1.AggregationResult.Frequency.values:type_name -> google.cloud.migrationcenter.v1.AggregationResult.Frequency.ValuesEntry
	218, // 210: google.cloud.migrationcenter.v1.ReportSummary.ChartData.data_points:type_name -> google.cloud.migrationcenter.v1.ReportSummary.ChartData.DataPoint
	219, // 211: google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.buckets:type_name -> google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData.Bucket
	206, // 212: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.memory_utilization_chart:type_name -> google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
	206, // 213: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.storage_utilization_chart:type_name -> google.cloud.migrationcenter.v1.ReportSummary.UtilizationChartData
	205, // 214: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.operating_system:type_name -> google.cloud.migrationcenter.v1.ReportSummary.ChartData
	207, // 215: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.core_count_histogram:type_name -> google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
	207, // 216: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.memory_bytes_histogram:type_name -> google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
	207, // 217: google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats.storage_bytes_histogram:type_name -> google.cloud.migrationcenter.v1.ReportSummary.HistogramChartData
	174, // 218: google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation.machine_series:type_name -> google.cloud.migrationcenter.v1.MachineSeries
	209, // 219: google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.machine_series_allocations:type_name -> google.cloud.migrationcenter.v1.ReportSummary.MachineSeriesAllocation
	5,   // 220: google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding.allocated_disk_types:type_name -> google.cloud.migrationcenter.v1.PersistentDiskType
	212, // 221: google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding.node_allocations:type_name -> google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation
	213, // 222: google.cloud.migrationcenter.v1.ReportSummary.VmwareNodeAllocation.vmware_node:type_name -> google.cloud.migrationcenter.v1.ReportSummary.VmwareNode
	215, // 223: google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding.node_allocations:type_name -> google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation
	177, // 224: google.cloud.migrationcenter.v1.ReportSummary.SoleTenantNodeAllocation.node:type_name -> google.cloud.migrationcenter.v1.SoleTenantNodeType
	171, // 225: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.machine_preferences:type_name -> google.cloud.migrationcenter.v1.VirtualMachinePreferences
	223, // 226: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_total:type_name -> google.type.Money
	223, // 227: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_compute:type_name -> google.type.Money
	223, // 228: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_os_license:type_name -> google.type.Money
	223, // 229: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_network_egress:type_name -> google.type.Money
	223, // 230: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_storage:type_name -> google.type.Money
	223, // 231: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.monthly_cost_other:type_name -> google.type.Money
	210, // 232: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.compute_engine_finding:type_name -> google.cloud.migrationcenter.v1.ReportSummary.ComputeEngineFinding
	211, // 233: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.vmware_engine_finding:type_name -> google.cloud.migrationcenter.v1.ReportSummary.VmwareEngineFinding
	214, // 234: google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding.sole_tenant_finding:type_name -> google.cloud.migrationcenter.v1.ReportSummary.SoleTenantFinding
	208, // 235: google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.asset_aggregate_stats:type_name -> google.cloud.migrationcenter.v1.ReportSummary.AssetAggregateStats
	216, // 236: google.cloud.migrationcenter.v1.ReportSummary.GroupFinding.preference_set_findings:type_name -> google.cloud.migrationcenter.v1.ReportSummary.GroupPreferenceSetFinding
	44,  // 237: google.cloud.migrationcenter.v1.MigrationCenter.ListAssets:input_type -> google.cloud.migrationcenter.v1.ListAssetsRequest
	46,  // 238: google.cloud.migrationcenter.v1.MigrationCenter.GetAsset:input_type -> google.cloud.migrationcenter.v1.GetAssetRequest
	47,  // 239: google.cloud.migrationcenter.v1.MigrationCenter.UpdateAsset:input_type -> google.cloud.migrationcenter.v1.UpdateAssetRequest
	48,  // 240: google.cloud.migrationcenter.v1.MigrationCenter.BatchUpdateAssets:input_type -> google.cloud.migrationcenter.v1.BatchUpdateAssetsRequest
	50,  // 241: google.cloud.migrationcenter.v1.MigrationCenter.DeleteAsset:input_type -> google.cloud.migrationcenter.v1.DeleteAssetRequest
	51,  // 242: google.cloud.migrationcenter.v1.MigrationCenter.BatchDeleteAssets:input_type -> google.cloud.migrationcenter.v1.BatchDeleteAssetsRequest
	52,  // 243: google.cloud.migrationcenter.v1.MigrationCenter.ReportAssetFrames:input_type -> google.cloud.migrationcenter.v1.ReportAssetFramesRequest
	54,  // 244: google.cloud.migrationcenter.v1.MigrationCenter.AggregateAssetsValues:input_type -> google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
	56,  // 245: google.cloud.migrationcenter.v1.MigrationCenter.CreateImportJob:input_type -> google.cloud.migrationcenter.v1.CreateImportJobRequest
	57,  // 246: google.cloud.migrationcenter.v1.MigrationCenter.ListImportJobs:input_type -> google.cloud.migrationcenter.v1.ListImportJobsRequest
	59,  // 247: google.cloud.migrationcenter.v1.MigrationCenter.GetImportJob:input_type -> google.cloud.migrationcenter.v1.GetImportJobRequest
	60,  // 248: google.cloud.migrationcenter.v1.MigrationCenter.DeleteImportJob:input_type -> google.cloud.migrationcenter.v1.DeleteImportJobRequest
	61,  // 249: google.cloud.migrationcenter.v1.MigrationCenter.UpdateImportJob:input_type -> google.cloud.migrationcenter.v1.UpdateImportJobRequest
	62,  // 250: google.cloud.migrationcenter.v1.MigrationCenter.ValidateImportJob:input_type -> google.cloud.migrationcenter.v1.ValidateImportJobRequest
	63,  // 251: google.cloud.migrationcenter.v1.MigrationCenter.RunImportJob:input_type -> google.cloud.migrationcenter.v1.RunImportJobRequest
	64,  // 252: google.cloud.migrationcenter.v1.MigrationCenter.GetImportDataFile:input_type -> google.cloud.migrationcenter.v1.GetImportDataFileRequest
	65,  // 253: google.cloud.migrationcenter.v1.MigrationCenter.ListImportDataFiles:input_type -> google.cloud.migrationcenter.v1.ListImportDataFilesRequest
	67,  // 254: google.cloud.migrationcenter.v1.MigrationCenter.CreateImportDataFile:input_type -> google.cloud.migrationcenter.v1.CreateImportDataFileRequest
	68,  // 255: google.cloud.migrationcenter.v1.MigrationCenter.DeleteImportDataFile:input_type -> google.cloud.migrationcenter.v1.DeleteImportDataFileRequest
	69,  // 256: google.cloud.migrationcenter.v1.MigrationCenter.ListGroups:input_type -> google.cloud.migrationcenter.v1.ListGroupsRequest
	71,  // 257: google.cloud.migrationcenter.v1.MigrationCenter.GetGroup:input_type -> google.cloud.migrationcenter.v1.GetGroupRequest
	72,  // 258: google.cloud.migrationcenter.v1.MigrationCenter.CreateGroup:input_type -> google.cloud.migrationcenter.v1.CreateGroupRequest
	73,  // 259: google.cloud.migrationcenter.v1.MigrationCenter.UpdateGroup:input_type -> google.cloud.migrationcenter.v1.UpdateGroupRequest
	74,  // 260: google.cloud.migrationcenter.v1.MigrationCenter.DeleteGroup:input_type -> google.cloud.migrationcenter.v1.DeleteGroupRequest
	75,  // 261: google.cloud.migrationcenter.v1.MigrationCenter.AddAssetsToGroup:input_type -> google.cloud.migrationcenter.v1.AddAssetsToGroupRequest
	76,  // 262: google.cloud.migrationcenter.v1.MigrationCenter.RemoveAssetsFromGroup:input_type -> google.cloud.migrationcenter.v1.RemoveAssetsFromGroupRequest
	77,  // 263: google.cloud.migrationcenter.v1.MigrationCenter.ListErrorFrames:input_type -> google.cloud.migrationcenter.v1.ListErrorFramesRequest
	79,  // 264: google.cloud.migrationcenter.v1.MigrationCenter.GetErrorFrame:input_type -> google.cloud.migrationcenter.v1.GetErrorFrameRequest
	80,  // 265: google.cloud.migrationcenter.v1.MigrationCenter.ListSources:input_type -> google.cloud.migrationcenter.v1.ListSourcesRequest
	82,  // 266: google.cloud.migrationcenter.v1.MigrationCenter.GetSource:input_type -> google.cloud.migrationcenter.v1.GetSourceRequest
	83,  // 267: google.cloud.migrationcenter.v1.MigrationCenter.CreateSource:input_type -> google.cloud.migrationcenter.v1.CreateSourceRequest
	84,  // 268: google.cloud.migrationcenter.v1.MigrationCenter.UpdateSource:input_type -> google.cloud.migrationcenter.v1.UpdateSourceRequest
	85,  // 269: google.cloud.migrationcenter.v1.MigrationCenter.DeleteSource:input_type -> google.cloud.migrationcenter.v1.DeleteSourceRequest
	86,  // 270: google.cloud.migrationcenter.v1.MigrationCenter.ListPreferenceSets:input_type -> google.cloud.migrationcenter.v1.ListPreferenceSetsRequest
	88,  // 271: google.cloud.migrationcenter.v1.MigrationCenter.GetPreferenceSet:input_type -> google.cloud.migrationcenter.v1.GetPreferenceSetRequest
	89,  // 272: google.cloud.migrationcenter.v1.MigrationCenter.CreatePreferenceSet:input_type -> google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
	90,  // 273: google.cloud.migrationcenter.v1.MigrationCenter.UpdatePreferenceSet:input_type -> google.cloud.migrationcenter.v1.UpdatePreferenceSetRequest
	91,  // 274: google.cloud.migrationcenter.v1.MigrationCenter.DeletePreferenceSet:input_type -> google.cloud.migrationcenter.v1.DeletePreferenceSetRequest
	92,  // 275: google.cloud.migrationcenter.v1.MigrationCenter.GetSettings:input_type -> google.cloud.migrationcenter.v1.GetSettingsRequest
	93,  // 276: google.cloud.migrationcenter.v1.MigrationCenter.UpdateSettings:input_type -> google.cloud.migrationcenter.v1.UpdateSettingsRequest
	94,  // 277: google.cloud.migrationcenter.v1.MigrationCenter.CreateReportConfig:input_type -> google.cloud.migrationcenter.v1.CreateReportConfigRequest
	100, // 278: google.cloud.migrationcenter.v1.MigrationCenter.GetReportConfig:input_type -> google.cloud.migrationcenter.v1.GetReportConfigRequest
	101, // 279: google.cloud.migrationcenter.v1.MigrationCenter.ListReportConfigs:input_type -> google.cloud.migrationcenter.v1.ListReportConfigsRequest
	95,  // 280: google.cloud.migrationcenter.v1.MigrationCenter.DeleteReportConfig:input_type -> google.cloud.migrationcenter.v1.DeleteReportConfigRequest
	103, // 281: google.cloud.migrationcenter.v1.MigrationCenter.CreateReport:input_type -> google.cloud.migrationcenter.v1.CreateReportRequest
	96,  // 282: google.cloud.migrationcenter.v1.MigrationCenter.GetReport:input_type -> google.cloud.migrationcenter.v1.GetReportRequest
	97,  // 283: google.cloud.migrationcenter.v1.MigrationCenter.ListReports:input_type -> google.cloud.migrationcenter.v1.ListReportsRequest
	99,  // 284: google.cloud.migrationcenter.v1.MigrationCenter.DeleteReport:input_type -> google.cloud.migrationcenter.v1.DeleteReportRequest
	45,  // 285: google.cloud.migrationcenter.v1.MigrationCenter.ListAssets:output_type -> google.cloud.migrationcenter.v1.ListAssetsResponse
	34,  // 286: google.cloud.migrationcenter.v1.MigrationCenter.GetAsset:output_type -> google.cloud.migrationcenter.v1.Asset
	34,  // 287: google.cloud.migrationcenter.v1.MigrationCenter.UpdateAsset:output_type -> google.cloud.migrationcenter.v1.Asset
	49,  // 288: google.cloud.migrationcenter.v1.MigrationCenter.BatchUpdateAssets:output_type -> google.cloud.migrationcenter.v1.BatchUpdateAssetsResponse
	224, // 289: google.cloud.migrationcenter.v1.MigrationCenter.DeleteAsset:output_type -> google.protobuf.Empty
	224, // 290: google.cloud.migrationcenter.v1.MigrationCenter.BatchDeleteAssets:output_type -> google.protobuf.Empty
	53,  // 291: google.cloud.migrationcenter.v1.MigrationCenter.ReportAssetFrames:output_type -> google.cloud.migrationcenter.v1.ReportAssetFramesResponse
	55,  // 292: google.cloud.migrationcenter.v1.MigrationCenter.AggregateAssetsValues:output_type -> google.cloud.migrationcenter.v1.AggregateAssetsValuesResponse
	225, // 293: google.cloud.migrationcenter.v1.MigrationCenter.CreateImportJob:output_type -> google.longrunning.Operation
	58,  // 294: google.cloud.migrationcenter.v1.MigrationCenter.ListImportJobs:output_type -> google.cloud.migrationcenter.v1.ListImportJobsResponse
	36,  // 295: google.cloud.migrationcenter.v1.MigrationCenter.GetImportJob:output_type -> google.cloud.migrationcenter.v1.ImportJob
	225, // 296: google.cloud.migrationcenter.v1.MigrationCenter.DeleteImportJob:output_type -> google.longrunning.Operation
	225, // 297: google.cloud.migrationcenter.v1.MigrationCenter.UpdateImportJob:output_type -> google.longrunning.Operation
	225, // 298: google.cloud.migrationcenter.v1.MigrationCenter.ValidateImportJob:output_type -> google.longrunning.Operation
	225, // 299: google.cloud.migrationcenter.v1.MigrationCenter.RunImportJob:output_type -> google.longrunning.Operation
	37,  // 300: google.cloud.migrationcenter.v1.MigrationCenter.GetImportDataFile:output_type -> google.cloud.migrationcenter.v1.ImportDataFile
	66,  // 301: google.cloud.migrationcenter.v1.MigrationCenter.ListImportDataFiles:output_type -> google.cloud.migrationcenter.v1.ListImportDataFilesResponse
	225, // 302: google.cloud.migrationcenter.v1.MigrationCenter.CreateImportDataFile:output_type -> google.longrunning.Operation
	225, // 303: google.cloud.migrationcenter.v1.MigrationCenter.DeleteImportDataFile:output_type -> google.longrunning.Operation
	70,  // 304: google.cloud.migrationcenter.v1.MigrationCenter.ListGroups:output_type -> google.cloud.migrationcenter.v1.ListGroupsResponse
	38,  // 305: google.cloud.migrationcenter.v1.MigrationCenter.GetGroup:output_type -> google.cloud.migrationcenter.v1.Group
	225, // 306: google.cloud.migrationcenter.v1.MigrationCenter.CreateGroup:output_type -> google.longrunning.Operation
	225, // 307: google.cloud.migrationcenter.v1.MigrationCenter.UpdateGroup:output_type -> google.longrunning.Operation
	225, // 308: google.cloud.migrationcenter.v1.MigrationCenter.DeleteGroup:output_type -> google.longrunning.Operation
	225, // 309: google.cloud.migrationcenter.v1.MigrationCenter.AddAssetsToGroup:output_type -> google.longrunning.Operation
	225, // 310: google.cloud.migrationcenter.v1.MigrationCenter.RemoveAssetsFromGroup:output_type -> google.longrunning.Operation
	78,  // 311: google.cloud.migrationcenter.v1.MigrationCenter.ListErrorFrames:output_type -> google.cloud.migrationcenter.v1.ListErrorFramesResponse
	39,  // 312: google.cloud.migrationcenter.v1.MigrationCenter.GetErrorFrame:output_type -> google.cloud.migrationcenter.v1.ErrorFrame
	81,  // 313: google.cloud.migrationcenter.v1.MigrationCenter.ListSources:output_type -> google.cloud.migrationcenter.v1.ListSourcesResponse
	40,  // 314: google.cloud.migrationcenter.v1.MigrationCenter.GetSource:output_type -> google.cloud.migrationcenter.v1.Source
	225, // 315: google.cloud.migrationcenter.v1.MigrationCenter.CreateSource:output_type -> google.longrunning.Operation
	225, // 316: google.cloud.migrationcenter.v1.MigrationCenter.UpdateSource:output_type -> google.longrunning.Operation
	225, // 317: google.cloud.migrationcenter.v1.MigrationCenter.DeleteSource:output_type -> google.longrunning.Operation
	87,  // 318: google.cloud.migrationcenter.v1.MigrationCenter.ListPreferenceSets:output_type -> google.cloud.migrationcenter.v1.ListPreferenceSetsResponse
	35,  // 319: google.cloud.migrationcenter.v1.MigrationCenter.GetPreferenceSet:output_type -> google.cloud.migrationcenter.v1.PreferenceSet
	225, // 320: google.cloud.migrationcenter.v1.MigrationCenter.CreatePreferenceSet:output_type -> google.longrunning.Operation
	225, // 321: google.cloud.migrationcenter.v1.MigrationCenter.UpdatePreferenceSet:output_type -> google.longrunning.Operation
	225, // 322: google.cloud.migrationcenter.v1.MigrationCenter.DeletePreferenceSet:output_type -> google.longrunning.Operation
	179, // 323: google.cloud.migrationcenter.v1.MigrationCenter.GetSettings:output_type -> google.cloud.migrationcenter.v1.Settings
	225, // 324: google.cloud.migrationcenter.v1.MigrationCenter.UpdateSettings:output_type -> google.longrunning.Operation
	225, // 325: google.cloud.migrationcenter.v1.MigrationCenter.CreateReportConfig:output_type -> google.longrunning.Operation
	41,  // 326: google.cloud.migrationcenter.v1.MigrationCenter.GetReportConfig:output_type -> google.cloud.migrationcenter.v1.ReportConfig
	102, // 327: google.cloud.migrationcenter.v1.MigrationCenter.ListReportConfigs:output_type -> google.cloud.migrationcenter.v1.ListReportConfigsResponse
	225, // 328: google.cloud.migrationcenter.v1.MigrationCenter.DeleteReportConfig:output_type -> google.longrunning.Operation
	225, // 329: google.cloud.migrationcenter.v1.MigrationCenter.CreateReport:output_type -> google.longrunning.Operation
	42,  // 330: google.cloud.migrationcenter.v1.MigrationCenter.GetReport:output_type -> google.cloud.migrationcenter.v1.Report
	98,  // 331: google.cloud.migrationcenter.v1.MigrationCenter.ListReports:output_type -> google.cloud.migrationcenter.v1.ListReportsResponse
	225, // 332: google.cloud.migrationcenter.v1.MigrationCenter.DeleteReport:output_type -> google.longrunning.Operation
	285, // [285:333] is the sub-list for method output_type
	237, // [237:285] is the sub-list for method input_type
	237, // [237:237] is the sub-list for extension type_name
	237, // [237:237] is the sub-list for extension extendee
	0,   // [0:237] is the sub-list for field type_name
}

func init() { file_google_cloud_migrationcenter_v1_migrationcenter_proto_init() }
func file_google_cloud_migrationcenter_v1_migrationcenter_proto_init() {
	if File_google_cloud_migrationcenter_v1_migrationcenter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreferenceSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDataFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Group); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Report); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportAssetFramesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportAssetFramesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateAssetsValuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregateAssetsValuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImportJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImportJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidateImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunImportJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetImportDataFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImportDataFilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListImportDataFilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateImportDataFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteImportDataFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddAssetsToGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveAssetsFromGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListErrorFramesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListErrorFramesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetErrorFrameRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPreferenceSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPreferenceSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPreferenceSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePreferenceSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePreferenceSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePreferenceSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReportConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReportConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReportConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReportConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Frames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineArchitectureDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BiosDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineNetworkDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkAdapterList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkAdapterDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkAddressList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineDiskDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEntryList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskPartitionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareDiskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuestOsDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuestConfigDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FstabEntryList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FstabEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HostsEntryList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HostsEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NfsExportList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NfsExport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuestRuntimeDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunningServiceList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunningService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunningProcessList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunningProcess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeNetworkInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConnectionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuestInstalledApplicationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuestInstalledApplication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenFileList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OpenFileDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwarePlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsEc2PlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AzureVmPlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenericPlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhysicalPlatformDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MemoryUsageSample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CpuUsageSample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkUsageSample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskUsageSample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PerformanceSample); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetPerformanceData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsightList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Insight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenericInsight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationInsight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEngineMigrationTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEngineShapeDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeStorageDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FitDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[127].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileValidationReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportRowError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadFileInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FrameViolationEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VirtualMachinePreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEnginePreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachinePreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[140].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MachineSeries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[141].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareEnginePreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[142].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoleTenancyPreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[143].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SoleTenantNodeType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegionPreferences); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[151].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportConfig_GroupPreferenceSetAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation_Stats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation_CPU); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation_Memory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation_Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[159].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DailyResourceUsageAggregation_Disk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[160].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation_Count); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[161].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation_Sum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[162].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation_Histogram); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[163].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation_Frequency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult_Count); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[165].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult_Sum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[166].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult_Histogram); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[167].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult_Frequency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[168].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregationResult_Histogram_Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[171].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_ChartData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[172].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_UtilizationChartData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[173].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_HistogramChartData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[174].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_AssetAggregateStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[175].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_MachineSeriesAllocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[176].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_ComputeEngineFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[177].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_VmwareEngineFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[178].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_VmwareNodeAllocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[179].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_VmwareNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[180].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_SoleTenantFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[181].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_SoleTenantNodeAllocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[182].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_GroupPreferenceSetFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[183].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_GroupFinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[184].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_ChartData_DataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[185].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportSummary_HistogramChartData_Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Asset_MachineDetails)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ImportJob_ValidationReport)(nil),
		(*ImportJob_ExecutionReport)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ImportDataFile_UploadFileInfo)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[71].OneofWrappers = []interface{}{
		(*AssetFrame_MachineDetails)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[82].OneofWrappers = []interface{}{
		(*DiskEntry_Vmware)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[106].OneofWrappers = []interface{}{
		(*PlatformDetails_VmwareDetails)(nil),
		(*PlatformDetails_AwsEc2Details)(nil),
		(*PlatformDetails_AzureVmDetails)(nil),
		(*PlatformDetails_GenericDetails)(nil),
		(*PlatformDetails_PhysicalDetails)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[120].OneofWrappers = []interface{}{
		(*Insight_MigrationInsight)(nil),
		(*Insight_GenericInsight)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[122].OneofWrappers = []interface{}{
		(*MigrationInsight_ComputeEngineTarget)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[127].OneofWrappers = []interface{}{
		(*Aggregation_Count_)(nil),
		(*Aggregation_Sum_)(nil),
		(*Aggregation_Histogram_)(nil),
		(*Aggregation_Frequency_)(nil),
	}
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes[128].OneofWrappers = []interface{}{
		(*AggregationResult_Count_)(nil),
		(*AggregationResult_Sum_)(nil),
		(*AggregationResult_Histogram_)(nil),
		(*AggregationResult_Frequency_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDesc,
			NumEnums:      34,
			NumMessages:   186,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_migrationcenter_v1_migrationcenter_proto_goTypes,
		DependencyIndexes: file_google_cloud_migrationcenter_v1_migrationcenter_proto_depIdxs,
		EnumInfos:         file_google_cloud_migrationcenter_v1_migrationcenter_proto_enumTypes,
		MessageInfos:      file_google_cloud_migrationcenter_v1_migrationcenter_proto_msgTypes,
	}.Build()
	File_google_cloud_migrationcenter_v1_migrationcenter_proto = out.File
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_rawDesc = nil
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_goTypes = nil
	file_google_cloud_migrationcenter_v1_migrationcenter_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MigrationCenterClient is the client API for MigrationCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MigrationCenterClient interface {
	// Lists all the assets in a given project and location.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Gets the details of an asset.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Updates the parameters of an asset.
	UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Updates the parameters of a list of assets.
	BatchUpdateAssets(ctx context.Context, in *BatchUpdateAssetsRequest, opts ...grpc.CallOption) (*BatchUpdateAssetsResponse, error)
	// Deletes an asset.
	DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes list of Assets.
	BatchDeleteAssets(ctx context.Context, in *BatchDeleteAssetsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Reports a set of frames.
	ReportAssetFrames(ctx context.Context, in *ReportAssetFramesRequest, opts ...grpc.CallOption) (*ReportAssetFramesResponse, error)
	// Aggregates the requested fields based on provided function.
	AggregateAssetsValues(ctx context.Context, in *AggregateAssetsValuesRequest, opts ...grpc.CallOption) (*AggregateAssetsValuesResponse, error)
	// Creates an import job.
	CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all import jobs.
	ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error)
	// Gets the details of an import job.
	GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error)
	// Deletes an import job.
	DeleteImportJob(ctx context.Context, in *DeleteImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an import job.
	UpdateImportJob(ctx context.Context, in *UpdateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Validates an import job.
	ValidateImportJob(ctx context.Context, in *ValidateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Runs an import job.
	RunImportJob(ctx context.Context, in *RunImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an import data file.
	GetImportDataFile(ctx context.Context, in *GetImportDataFileRequest, opts ...grpc.CallOption) (*ImportDataFile, error)
	// List import data files.
	ListImportDataFiles(ctx context.Context, in *ListImportDataFilesRequest, opts ...grpc.CallOption) (*ListImportDataFilesResponse, error)
	// Creates an import data file.
	CreateImportDataFile(ctx context.Context, in *CreateImportDataFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an import data file.
	DeleteImportDataFile(ctx context.Context, in *DeleteImportDataFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all groups in a given project and location.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Gets the details of a group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error)
	// Creates a new group in a given project and location.
	CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a group.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a group.
	DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds assets to a group.
	AddAssetsToGroup(ctx context.Context, in *AddAssetsToGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes assets from a group.
	RemoveAssetsFromGroup(ctx context.Context, in *RemoveAssetsFromGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all error frames in a given source and location.
	ListErrorFrames(ctx context.Context, in *ListErrorFramesRequest, opts ...grpc.CallOption) (*ListErrorFramesResponse, error)
	// Gets the details of an error frame.
	GetErrorFrame(ctx context.Context, in *GetErrorFrameRequest, opts ...grpc.CallOption) (*ErrorFrame, error)
	// Lists all the sources in a given project and location.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Gets the details of a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a new source in a given project and location.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a source.
	DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all the preference sets in a given project and location.
	ListPreferenceSets(ctx context.Context, in *ListPreferenceSetsRequest, opts ...grpc.CallOption) (*ListPreferenceSetsResponse, error)
	// Gets the details of a preference set.
	GetPreferenceSet(ctx context.Context, in *GetPreferenceSetRequest, opts ...grpc.CallOption) (*PreferenceSet, error)
	// Creates a new preference set in a given project and location.
	CreatePreferenceSet(ctx context.Context, in *CreatePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a preference set.
	UpdatePreferenceSet(ctx context.Context, in *UpdatePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a preference set.
	DeletePreferenceSet(ctx context.Context, in *DeletePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of regional settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates the regional-level project settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a report configuration.
	CreateReportConfig(ctx context.Context, in *CreateReportConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single ReportConfig.
	GetReportConfig(ctx context.Context, in *GetReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error)
	// Lists ReportConfigs in a given project and location.
	ListReportConfigs(ctx context.Context, in *ListReportConfigsRequest, opts ...grpc.CallOption) (*ListReportConfigsResponse, error)
	// Deletes a ReportConfig.
	DeleteReportConfig(ctx context.Context, in *DeleteReportConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a report.
	CreateReport(ctx context.Context, in *CreateReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Report.
	GetReport(ctx context.Context, in *GetReportRequest, opts ...grpc.CallOption) (*Report, error)
	// Lists Reports in a given ReportConfig.
	ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error)
	// Deletes a Report.
	DeleteReport(ctx context.Context, in *DeleteReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type migrationCenterClient struct {
	cc grpc.ClientConnInterface
}

func NewMigrationCenterClient(cc grpc.ClientConnInterface) MigrationCenterClient {
	return &migrationCenterClient{cc}
}

func (c *migrationCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) BatchUpdateAssets(ctx context.Context, in *BatchUpdateAssetsRequest, opts ...grpc.CallOption) (*BatchUpdateAssetsResponse, error) {
	out := new(BatchUpdateAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/BatchUpdateAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) BatchDeleteAssets(ctx context.Context, in *BatchDeleteAssetsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/BatchDeleteAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ReportAssetFrames(ctx context.Context, in *ReportAssetFramesRequest, opts ...grpc.CallOption) (*ReportAssetFramesResponse, error) {
	out := new(ReportAssetFramesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ReportAssetFrames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) AggregateAssetsValues(ctx context.Context, in *AggregateAssetsValuesRequest, opts ...grpc.CallOption) (*AggregateAssetsValuesResponse, error) {
	out := new(AggregateAssetsValuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/AggregateAssetsValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateImportJob(ctx context.Context, in *CreateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListImportJobs(ctx context.Context, in *ListImportJobsRequest, opts ...grpc.CallOption) (*ListImportJobsResponse, error) {
	out := new(ListImportJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListImportJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetImportJob(ctx context.Context, in *GetImportJobRequest, opts ...grpc.CallOption) (*ImportJob, error) {
	out := new(ImportJob)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteImportJob(ctx context.Context, in *DeleteImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdateImportJob(ctx context.Context, in *UpdateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ValidateImportJob(ctx context.Context, in *ValidateImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ValidateImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) RunImportJob(ctx context.Context, in *RunImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/RunImportJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetImportDataFile(ctx context.Context, in *GetImportDataFileRequest, opts ...grpc.CallOption) (*ImportDataFile, error) {
	out := new(ImportDataFile)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetImportDataFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListImportDataFiles(ctx context.Context, in *ListImportDataFilesRequest, opts ...grpc.CallOption) (*ListImportDataFilesResponse, error) {
	out := new(ListImportDataFilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListImportDataFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateImportDataFile(ctx context.Context, in *CreateImportDataFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateImportDataFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteImportDataFile(ctx context.Context, in *DeleteImportDataFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteImportDataFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) AddAssetsToGroup(ctx context.Context, in *AddAssetsToGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/AddAssetsToGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) RemoveAssetsFromGroup(ctx context.Context, in *RemoveAssetsFromGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/RemoveAssetsFromGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListErrorFrames(ctx context.Context, in *ListErrorFramesRequest, opts ...grpc.CallOption) (*ListErrorFramesResponse, error) {
	out := new(ListErrorFramesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListErrorFrames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetErrorFrame(ctx context.Context, in *GetErrorFrameRequest, opts ...grpc.CallOption) (*ErrorFrame, error) {
	out := new(ErrorFrame)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetErrorFrame", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListPreferenceSets(ctx context.Context, in *ListPreferenceSetsRequest, opts ...grpc.CallOption) (*ListPreferenceSetsResponse, error) {
	out := new(ListPreferenceSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListPreferenceSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetPreferenceSet(ctx context.Context, in *GetPreferenceSetRequest, opts ...grpc.CallOption) (*PreferenceSet, error) {
	out := new(PreferenceSet)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetPreferenceSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreatePreferenceSet(ctx context.Context, in *CreatePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreatePreferenceSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdatePreferenceSet(ctx context.Context, in *UpdatePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdatePreferenceSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeletePreferenceSet(ctx context.Context, in *DeletePreferenceSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeletePreferenceSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateReportConfig(ctx context.Context, in *CreateReportConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetReportConfig(ctx context.Context, in *GetReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error) {
	out := new(ReportConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListReportConfigs(ctx context.Context, in *ListReportConfigsRequest, opts ...grpc.CallOption) (*ListReportConfigsResponse, error) {
	out := new(ListReportConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListReportConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteReportConfig(ctx context.Context, in *DeleteReportConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) CreateReport(ctx context.Context, in *CreateReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/CreateReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) GetReport(ctx context.Context, in *GetReportRequest, opts ...grpc.CallOption) (*Report, error) {
	out := new(Report)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/GetReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) ListReports(ctx context.Context, in *ListReportsRequest, opts ...grpc.CallOption) (*ListReportsResponse, error) {
	out := new(ListReportsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/ListReports", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationCenterClient) DeleteReport(ctx context.Context, in *DeleteReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MigrationCenterServer is the server API for MigrationCenter service.
type MigrationCenterServer interface {
	// Lists all the assets in a given project and location.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Gets the details of an asset.
	GetAsset(context.Context, *GetAssetRequest) (*Asset, error)
	// Updates the parameters of an asset.
	UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error)
	// Updates the parameters of a list of assets.
	BatchUpdateAssets(context.Context, *BatchUpdateAssetsRequest) (*BatchUpdateAssetsResponse, error)
	// Deletes an asset.
	DeleteAsset(context.Context, *DeleteAssetRequest) (*emptypb.Empty, error)
	// Deletes list of Assets.
	BatchDeleteAssets(context.Context, *BatchDeleteAssetsRequest) (*emptypb.Empty, error)
	// Reports a set of frames.
	ReportAssetFrames(context.Context, *ReportAssetFramesRequest) (*ReportAssetFramesResponse, error)
	// Aggregates the requested fields based on provided function.
	AggregateAssetsValues(context.Context, *AggregateAssetsValuesRequest) (*AggregateAssetsValuesResponse, error)
	// Creates an import job.
	CreateImportJob(context.Context, *CreateImportJobRequest) (*longrunningpb.Operation, error)
	// Lists all import jobs.
	ListImportJobs(context.Context, *ListImportJobsRequest) (*ListImportJobsResponse, error)
	// Gets the details of an import job.
	GetImportJob(context.Context, *GetImportJobRequest) (*ImportJob, error)
	// Deletes an import job.
	DeleteImportJob(context.Context, *DeleteImportJobRequest) (*longrunningpb.Operation, error)
	// Updates an import job.
	UpdateImportJob(context.Context, *UpdateImportJobRequest) (*longrunningpb.Operation, error)
	// Validates an import job.
	ValidateImportJob(context.Context, *ValidateImportJobRequest) (*longrunningpb.Operation, error)
	// Runs an import job.
	RunImportJob(context.Context, *RunImportJobRequest) (*longrunningpb.Operation, error)
	// Gets an import data file.
	GetImportDataFile(context.Context, *GetImportDataFileRequest) (*ImportDataFile, error)
	// List import data files.
	ListImportDataFiles(context.Context, *ListImportDataFilesRequest) (*ListImportDataFilesResponse, error)
	// Creates an import data file.
	CreateImportDataFile(context.Context, *CreateImportDataFileRequest) (*longrunningpb.Operation, error)
	// Delete an import data file.
	DeleteImportDataFile(context.Context, *DeleteImportDataFileRequest) (*longrunningpb.Operation, error)
	// Lists all groups in a given project and location.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Gets the details of a group.
	GetGroup(context.Context, *GetGroupRequest) (*Group, error)
	// Creates a new group in a given project and location.
	CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a group.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error)
	// Deletes a group.
	DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error)
	// Adds assets to a group.
	AddAssetsToGroup(context.Context, *AddAssetsToGroupRequest) (*longrunningpb.Operation, error)
	// Removes assets from a group.
	RemoveAssetsFromGroup(context.Context, *RemoveAssetsFromGroupRequest) (*longrunningpb.Operation, error)
	// Lists all error frames in a given source and location.
	ListErrorFrames(context.Context, *ListErrorFramesRequest) (*ListErrorFramesResponse, error)
	// Gets the details of an error frame.
	GetErrorFrame(context.Context, *GetErrorFrameRequest) (*ErrorFrame, error)
	// Lists all the sources in a given project and location.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Gets the details of a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Creates a new source in a given project and location.
	CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error)
	// Deletes a source.
	DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error)
	// Lists all the preference sets in a given project and location.
	ListPreferenceSets(context.Context, *ListPreferenceSetsRequest) (*ListPreferenceSetsResponse, error)
	// Gets the details of a preference set.
	GetPreferenceSet(context.Context, *GetPreferenceSetRequest) (*PreferenceSet, error)
	// Creates a new preference set in a given project and location.
	CreatePreferenceSet(context.Context, *CreatePreferenceSetRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a preference set.
	UpdatePreferenceSet(context.Context, *UpdatePreferenceSetRequest) (*longrunningpb.Operation, error)
	// Deletes a preference set.
	DeletePreferenceSet(context.Context, *DeletePreferenceSetRequest) (*longrunningpb.Operation, error)
	// Gets the details of regional settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates the regional-level project settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*longrunningpb.Operation, error)
	// Creates a report configuration.
	CreateReportConfig(context.Context, *CreateReportConfigRequest) (*longrunningpb.Operation, error)
	// Gets details of a single ReportConfig.
	GetReportConfig(context.Context, *GetReportConfigRequest) (*ReportConfig, error)
	// Lists ReportConfigs in a given project and location.
	ListReportConfigs(context.Context, *ListReportConfigsRequest) (*ListReportConfigsResponse, error)
	// Deletes a ReportConfig.
	DeleteReportConfig(context.Context, *DeleteReportConfigRequest) (*longrunningpb.Operation, error)
	// Creates a report.
	CreateReport(context.Context, *CreateReportRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Report.
	GetReport(context.Context, *GetReportRequest) (*Report, error)
	// Lists Reports in a given ReportConfig.
	ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error)
	// Deletes a Report.
	DeleteReport(context.Context, *DeleteReportRequest) (*longrunningpb.Operation, error)
}

// UnimplementedMigrationCenterServer can be embedded to have forward compatible implementations.
type UnimplementedMigrationCenterServer struct {
}

func (*UnimplementedMigrationCenterServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedMigrationCenterServer) GetAsset(context.Context, *GetAssetRequest) (*Asset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAsset not implemented")
}
func (*UnimplementedMigrationCenterServer) BatchUpdateAssets(context.Context, *BatchUpdateAssetsRequest) (*BatchUpdateAssetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateAssets not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteAsset(context.Context, *DeleteAssetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAsset not implemented")
}
func (*UnimplementedMigrationCenterServer) BatchDeleteAssets(context.Context, *BatchDeleteAssetsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteAssets not implemented")
}
func (*UnimplementedMigrationCenterServer) ReportAssetFrames(context.Context, *ReportAssetFramesRequest) (*ReportAssetFramesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportAssetFrames not implemented")
}
func (*UnimplementedMigrationCenterServer) AggregateAssetsValues(context.Context, *AggregateAssetsValuesRequest) (*AggregateAssetsValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregateAssetsValues not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateImportJob(context.Context, *CreateImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) ListImportJobs(context.Context, *ListImportJobsRequest) (*ListImportJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImportJobs not implemented")
}
func (*UnimplementedMigrationCenterServer) GetImportJob(context.Context, *GetImportJobRequest) (*ImportJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteImportJob(context.Context, *DeleteImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdateImportJob(context.Context, *UpdateImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) ValidateImportJob(context.Context, *ValidateImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) RunImportJob(context.Context, *RunImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunImportJob not implemented")
}
func (*UnimplementedMigrationCenterServer) GetImportDataFile(context.Context, *GetImportDataFileRequest) (*ImportDataFile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImportDataFile not implemented")
}
func (*UnimplementedMigrationCenterServer) ListImportDataFiles(context.Context, *ListImportDataFilesRequest) (*ListImportDataFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImportDataFiles not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateImportDataFile(context.Context, *CreateImportDataFileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateImportDataFile not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteImportDataFile(context.Context, *DeleteImportDataFileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteImportDataFile not implemented")
}
func (*UnimplementedMigrationCenterServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (*UnimplementedMigrationCenterServer) GetGroup(context.Context, *GetGroupRequest) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) AddAssetsToGroup(context.Context, *AddAssetsToGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddAssetsToGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) RemoveAssetsFromGroup(context.Context, *RemoveAssetsFromGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveAssetsFromGroup not implemented")
}
func (*UnimplementedMigrationCenterServer) ListErrorFrames(context.Context, *ListErrorFramesRequest) (*ListErrorFramesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListErrorFrames not implemented")
}
func (*UnimplementedMigrationCenterServer) GetErrorFrame(context.Context, *GetErrorFrameRequest) (*ErrorFrame, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetErrorFrame not implemented")
}
func (*UnimplementedMigrationCenterServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (*UnimplementedMigrationCenterServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSource not implemented")
}
func (*UnimplementedMigrationCenterServer) ListPreferenceSets(context.Context, *ListPreferenceSetsRequest) (*ListPreferenceSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPreferenceSets not implemented")
}
func (*UnimplementedMigrationCenterServer) GetPreferenceSet(context.Context, *GetPreferenceSetRequest) (*PreferenceSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPreferenceSet not implemented")
}
func (*UnimplementedMigrationCenterServer) CreatePreferenceSet(context.Context, *CreatePreferenceSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePreferenceSet not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdatePreferenceSet(context.Context, *UpdatePreferenceSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePreferenceSet not implemented")
}
func (*UnimplementedMigrationCenterServer) DeletePreferenceSet(context.Context, *DeletePreferenceSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePreferenceSet not implemented")
}
func (*UnimplementedMigrationCenterServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (*UnimplementedMigrationCenterServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateReportConfig(context.Context, *CreateReportConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReportConfig not implemented")
}
func (*UnimplementedMigrationCenterServer) GetReportConfig(context.Context, *GetReportConfigRequest) (*ReportConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReportConfig not implemented")
}
func (*UnimplementedMigrationCenterServer) ListReportConfigs(context.Context, *ListReportConfigsRequest) (*ListReportConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReportConfigs not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteReportConfig(context.Context, *DeleteReportConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReportConfig not implemented")
}
func (*UnimplementedMigrationCenterServer) CreateReport(context.Context, *CreateReportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReport not implemented")
}
func (*UnimplementedMigrationCenterServer) GetReport(context.Context, *GetReportRequest) (*Report, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReport not implemented")
}
func (*UnimplementedMigrationCenterServer) ListReports(context.Context, *ListReportsRequest) (*ListReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReports not implemented")
}
func (*UnimplementedMigrationCenterServer) DeleteReport(context.Context, *DeleteReportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReport not implemented")
}

func RegisterMigrationCenterServer(s *grpc.Server, srv MigrationCenterServer) {
	s.RegisterService(&_MigrationCenter_serviceDesc, srv)
}

func _MigrationCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/GetAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_UpdateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).UpdateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).UpdateAsset(ctx, req.(*UpdateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_BatchUpdateAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).BatchUpdateAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/BatchUpdateAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).BatchUpdateAssets(ctx, req.(*BatchUpdateAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_DeleteAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).DeleteAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).DeleteAsset(ctx, req.(*DeleteAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_BatchDeleteAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).BatchDeleteAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/BatchDeleteAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).BatchDeleteAssets(ctx, req.(*BatchDeleteAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ReportAssetFrames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportAssetFramesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ReportAssetFrames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ReportAssetFrames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ReportAssetFrames(ctx, req.(*ReportAssetFramesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_AggregateAssetsValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregateAssetsValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).AggregateAssetsValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/AggregateAssetsValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).AggregateAssetsValues(ctx, req.(*AggregateAssetsValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_CreateImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).CreateImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/CreateImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).CreateImportJob(ctx, req.(*CreateImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ListImportJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImportJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ListImportJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ListImportJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ListImportJobs(ctx, req.(*ListImportJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_GetImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).GetImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/GetImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).GetImportJob(ctx, req.(*GetImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_DeleteImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).DeleteImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).DeleteImportJob(ctx, req.(*DeleteImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_UpdateImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).UpdateImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).UpdateImportJob(ctx, req.(*UpdateImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ValidateImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ValidateImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ValidateImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ValidateImportJob(ctx, req.(*ValidateImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_RunImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).RunImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/RunImportJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).RunImportJob(ctx, req.(*RunImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_GetImportDataFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImportDataFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).GetImportDataFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/GetImportDataFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).GetImportDataFile(ctx, req.(*GetImportDataFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ListImportDataFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImportDataFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ListImportDataFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ListImportDataFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ListImportDataFiles(ctx, req.(*ListImportDataFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_CreateImportDataFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImportDataFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).CreateImportDataFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/CreateImportDataFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).CreateImportDataFile(ctx, req.(*CreateImportDataFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_DeleteImportDataFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImportDataFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).DeleteImportDataFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteImportDataFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).DeleteImportDataFile(ctx, req.(*DeleteImportDataFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).CreateGroup(ctx, req.(*CreateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).DeleteGroup(ctx, req.(*DeleteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_AddAssetsToGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddAssetsToGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).AddAssetsToGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/AddAssetsToGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).AddAssetsToGroup(ctx, req.(*AddAssetsToGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_RemoveAssetsFromGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveAssetsFromGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).RemoveAssetsFromGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/RemoveAssetsFromGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).RemoveAssetsFromGroup(ctx, req.(*RemoveAssetsFromGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_ListErrorFrames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListErrorFramesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).ListErrorFrames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.migrationcenter.v1.MigrationCenter/ListErrorFrames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationCenterServer).ListErrorFrames(ctx, req.(*ListErrorFramesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationCenter_GetErrorFrame_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetErrorFrameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationCenterServer).GetErrorFram