// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accounts

import (
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	accountspb "cloud.google.com/go/shopping/merchant/accounts/apiv1beta/accountspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newOnlineReturnPolicyClientHook clientHook

// OnlineReturnPolicyCallOptions contains the retry settings for each method of OnlineReturnPolicyClient.
type OnlineReturnPolicyCallOptions struct {
	GetOnlineReturnPolicy    []gax.CallOption
	ListOnlineReturnPolicies []gax.CallOption
}

func defaultOnlineReturnPolicyGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultOnlineReturnPolicyCallOptions() *OnlineReturnPolicyCallOptions {
	return &OnlineReturnPolicyCallOptions{
		GetOnlineReturnPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListOnlineReturnPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultOnlineReturnPolicyRESTCallOptions() *OnlineReturnPolicyCallOptions {
	return &OnlineReturnPolicyCallOptions{
		GetOnlineReturnPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListOnlineReturnPolicies: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalOnlineReturnPolicyClient is an interface that defines the methods available from Merchant API.
type internalOnlineReturnPolicyClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetOnlineReturnPolicy(context.Context, *accountspb.GetOnlineReturnPolicyRequest, ...gax.CallOption) (*accountspb.OnlineReturnPolicy, error)
	ListOnlineReturnPolicies(context.Context, *accountspb.ListOnlineReturnPoliciesRequest, ...gax.CallOption) *OnlineReturnPolicyIterator
}

// OnlineReturnPolicyClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The service facilitates the management of a merchant’s remorse return policy
// configuration, encompassing return policies for both ads and free listings
//
// programs. This API defines the following resource model:OnlineReturnPolicy
type OnlineReturnPolicyClient struct {
	// The internal transport-dependent client.
	internalClient internalOnlineReturnPolicyClient

	// The call options for this service.
	CallOptions *OnlineReturnPolicyCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *OnlineReturnPolicyClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *OnlineReturnPolicyClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *OnlineReturnPolicyClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetOnlineReturnPolicy gets an existing return policy.
func (c *OnlineReturnPolicyClient) GetOnlineReturnPolicy(ctx context.Context, req *accountspb.GetOnlineReturnPolicyRequest, opts ...gax.CallOption) (*accountspb.OnlineReturnPolicy, error) {
	return c.internalClient.GetOnlineReturnPolicy(ctx, req, opts...)
}

// ListOnlineReturnPolicies lists all existing return policies.
func (c *OnlineReturnPolicyClient) ListOnlineReturnPolicies(ctx context.Context, req *accountspb.ListOnlineReturnPoliciesRequest, opts ...gax.CallOption) *OnlineReturnPolicyIterator {
	return c.internalClient.ListOnlineReturnPolicies(ctx, req, opts...)
}

// onlineReturnPolicyGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type onlineReturnPolicyGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing OnlineReturnPolicyClient
	CallOptions **OnlineReturnPolicyCallOptions

	// The gRPC API client.
	onlineReturnPolicyClient accountspb.OnlineReturnPolicyServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewOnlineReturnPolicyClient creates a new online return policy service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The service facilitates the management of a merchant’s remorse return policy
// configuration, encompassing return policies for both ads and free listings
//
// programs. This API defines the following resource model:OnlineReturnPolicy
func NewOnlineReturnPolicyClient(ctx context.Context, opts ...option.ClientOption) (*OnlineReturnPolicyClient, error) {
	clientOpts := defaultOnlineReturnPolicyGRPCClientOptions()
	if newOnlineReturnPolicyClientHook != nil {
		hookOpts, err := newOnlineReturnPolicyClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := OnlineReturnPolicyClient{CallOptions: defaultOnlineReturnPolicyCallOptions()}

	c := &onlineReturnPolicyGRPCClient{
		connPool:                 connPool,
		onlineReturnPolicyClient: accountspb.NewOnlineReturnPolicyServiceClient(connPool),
		CallOptions:              &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *onlineReturnPolicyGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *onlineReturnPolicyGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *onlineReturnPolicyGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type onlineReturnPolicyRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing OnlineReturnPolicyClient
	CallOptions **OnlineReturnPolicyCallOptions
}

// NewOnlineReturnPolicyRESTClient creates a new online return policy service rest client.
//
// The service facilitates the management of a merchant’s remorse return policy
// configuration, encompassing return policies for both ads and free listings
//
// programs. This API defines the following resource model:OnlineReturnPolicy
func NewOnlineReturnPolicyRESTClient(ctx context.Context, opts ...option.ClientOption) (*OnlineReturnPolicyClient, error) {
	clientOpts := append(defaultOnlineReturnPolicyRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultOnlineReturnPolicyRESTCallOptions()
	c := &onlineReturnPolicyRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &OnlineReturnPolicyClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultOnlineReturnPolicyRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *onlineReturnPolicyRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *onlineReturnPolicyRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *onlineReturnPolicyRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *onlineReturnPolicyGRPCClient) GetOnlineReturnPolicy(ctx context.Context, req *accountspb.GetOnlineReturnPolicyRequest, opts ...gax.CallOption) (*accountspb.OnlineReturnPolicy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOnlineReturnPolicy[0:len((*c.CallOptions).GetOnlineReturnPolicy):len((*c.CallOptions).GetOnlineReturnPolicy)], opts...)
	var resp *accountspb.OnlineReturnPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.onlineReturnPolicyClient.GetOnlineReturnPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *onlineReturnPolicyGRPCClient) ListOnlineReturnPolicies(ctx context.Context, req *accountspb.ListOnlineReturnPoliciesRequest, opts ...gax.CallOption) *OnlineReturnPolicyIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOnlineReturnPolicies[0:len((*c.CallOptions).ListOnlineReturnPolicies):len((*c.CallOptions).ListOnlineReturnPolicies)], opts...)
	it := &OnlineReturnPolicyIterator{}
	req = proto.Clone(req).(*accountspb.ListOnlineReturnPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accountspb.OnlineReturnPolicy, string, error) {
		resp := &accountspb.ListOnlineReturnPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.onlineReturnPolicyClient.ListOnlineReturnPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOnlineReturnPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetOnlineReturnPolicy gets an existing return policy.
func (c *onlineReturnPolicyRESTClient) GetOnlineReturnPolicy(ctx context.Context, req *accountspb.GetOnlineReturnPolicyRequest, opts ...gax.CallOption) (*accountspb.OnlineReturnPolicy, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOnlineReturnPolicy[0:len((*c.CallOptions).GetOnlineReturnPolicy):len((*c.CallOptions).GetOnlineReturnPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.OnlineReturnPolicy{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOnlineReturnPolicies lists all existing return policies.
func (c *onlineReturnPolicyRESTClient) ListOnlineReturnPolicies(ctx context.Context, req *accountspb.ListOnlineReturnPoliciesRequest, opts ...gax.CallOption) *OnlineReturnPolicyIterator {
	it := &OnlineReturnPolicyIterator{}
	req = proto.Clone(req).(*accountspb.ListOnlineReturnPoliciesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accountspb.OnlineReturnPolicy, string, error) {
		resp := &accountspb.ListOnlineReturnPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v/onlineReturnPolicies", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOnlineReturnPolicies(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
