#pragma once
/*
 *  $Id: elliptic.h 28793 2025-11-05 08:18:57Z yeti-dn $
 *  Copyright (C) 2005-2017 David Necas (Yeti), Petr Klapetek, Chris Anderson.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net, sidewinder.asu@gmail.com.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_ELLIPTIC_H__
#define __GWY_ELLIPTIC_H__

#include <libgwyddion/field.h>

G_BEGIN_DECLS

gsize    gwy_field_elliptic_area_fill            (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gint width,
                                                  gint height,
                                                  gdouble value);
gsize    gwy_field_elliptic_area_extract         (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gint width,
                                                  gint height,
                                                  gdouble *data);
void     gwy_field_elliptic_area_unextract       (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gint width,
                                                  gint height,
                                                  const gdouble *data);
gsize    gwy_field_get_elliptic_area_size        (gint width,
                                                  gint height);
gsize    gwy_field_get_elliptic_intersection     (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gint width,
                                                  gint height);
gsize    gwy_field_circular_area_fill            (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gdouble radius,
                                                  gdouble value);
gsize    gwy_field_circular_area_extract         (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gdouble radius,
                                                  gdouble *data);
gsize    gwy_field_circular_area_extract_with_pos(GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gdouble radius,
                                                  gdouble *data,
                                                  gint *xpos,
                                                  gint *ypos);
void     gwy_field_circular_area_unextract       (GwyField *field,
                                                  gint col,
                                                  gint row,
                                                  gdouble radius,
                                                  const gdouble *data);
gsize    gwy_field_get_circular_area_size        (gdouble radius);
gboolean gwy_field_local_maximum                 (GwyField *dfield,
                                                  gdouble *x,
                                                  gdouble *y,
                                                  gint ax,
                                                  gint ay);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
