/*
 * Copyright University of Reims Champagne-Ardenne
 * Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN,
 *                           Emmanuel PLUOT, Gaetan RUBEZ, Hassan KHARTABIL,
 *                           Jean-Charles BOISSON and Eric HENON
 * (24/07/2017)
 * jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr
 *
 * This software is a computer program whose purpose is to
 * detect and quantify interactions from electron density
 * obtained either internally from promolecular density or
 * calculated from an input wave function input file. It also
 * prepares for the visualization of isosurfaces representing
 * several descriptors (dg) coming from the IGM methodology.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 *
 * */

/**
 * @file eig3.h
 * @brief Eigen-decomposition for symmetric 3x3 real matrices.Public domain, copied from the public domain Java library JAMA. */

#ifndef _EIG_H_
#define _EIG_H_

// LOCAL
//#include <toolbox.h>
#include <general.h>

/**
 * @fn  double hypot2(double x, double y);
 * @brief Tool function making hypotenus computation
 * @param x
 * @param y
 * @result the result of sqrt(x*x+y*y) */
double hypot2(double x, double y);

/**
 * @fn void tred2(double V[3][3], double d[3], double e[3]);
 * @brief This is derived from the Algol procedures tred2 by Bowdler, Martin, Reinsch, and Wilkinson, Handbook for  Auto. Comp., Vol.ii-Linear Algebra, and the corresponding Fortran subroutine in EISPACK.
 * @param V eigen vectors
 * @param d eigen values 
 * @param e TO DOCUMENT */
void tred2(double V[3][3], double d[3], double e[3]);

/**
 * @fn void tql2(double V[3][3], double d[3], double e[3]);
 * @brief This is derived from the Algol procedures tql2, by Bowdler, Martin, Reinsch, and Wilkinson, Handbook for Auto. Comp., Vol.ii-Linear Algebra, and the corresponding Fortran subroutine in EISPACK.
 * @param V eigen vectors
 * @param d eigen values 
 * @param e TO DOCUMENT */
void tql2(double V[3][3], double d[3], double e[3]);

/**
 * @fn  void eigen_decomposition(double** A, double V[3][3], double d[3]);
 * @brief Symmetric matrix A => eigenvectors in columns of V, corresponding eigenvalues in d. 
 * @warning first parameter is a double** but is considered as A[3][3]
 * @param A symmetric matrix
 * @param V eigen vectors
 * @param d eigen values */
void eigen_decomposition(double** A, double V[3][3], double d[3]);

#endif
