/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

/* process cmdline args, check verb set */

#include "test.h"
#include <state.h>

static int test_state_verb(char *verb, char *options, char verbnum)
{
	char *argv[] = { "lcagent", verb, options, NULL };
	int argc = sizeof argv / sizeof argv[0] - 1;
	state_t state = {0};
	int rc;

	test_log("%s: %s\n", __func__, verb);

	if (!options) argc--;

	rc = state_parse_args(&state, argc, argv);
	if (!test_assert(rc == 0, "state_parse_args() rc = %i", rc))
		return test_status;
	if (!test_assert(state.verb == verbnum, "state_parse_args(): verb = %d", state.verb))
		return test_status;

	return 0;
}

static int test_state_bad_verb(void)
{
	char verb[] = "badverb";
	char *argv[] = { "lcagent", verb, NULL };
	int argc = sizeof argv / sizeof argv[0] - 1;
	state_t state = {0};
	int rc;

	test_log("%s: %s\n", __func__, verb);

	errno = 0;
	rc = state_parse_args(&state, argc, argv);
	if (!test_assert(errno == EINVAL, "EINVAL set"))
		return test_status;
	if (!test_assert(rc == -1, "state_parse_args() rc = %i", rc))
		return test_status;

	return 0;
}

int main(void)
{
	char name[] = "state_parse_arg() - verb";

	test_name(name);

	/* test verbs with no preceeding options */
#define X(a, b, c, d) if (test_state_verb(b, NULL, c)) return test_status;
	STATE_VERBS
#undef X

	/* test verbs again with preceeding options */
#define X(a, b, c, d) if (test_state_verb(b, "-v", c)) return test_status;
	STATE_VERBS
#undef X

	if (test_state_bad_verb()) return test_status;

	return test_status;
}
