# REQUIRES: aarch64
# RUN: rm -rf %t && mkdir %t && cd %t
# RUN: llvm-mc -filetype=obj -triple=aarch64 %s -o a.o
# RUN: not ld.lld a.o --defsym zero=0 2>&1 | FileCheck %s --implicit-check-not=error:

# CHECK: error: a.o:(.text+0x0): relocation R_AARCH64_MOVW_UABS_G0 out of range: 65536 is not in [0, 65535]
movn x0, #:abs_g0:zero+0x10000
# CHECK: error: a.o:(.text+0x4): relocation R_AARCH64_MOVW_UABS_G1 out of range: 4294967296 is not in [0, 4294967295]
movn x0, #:abs_g1:zero+0x100000000
# CHECK: error: a.o:(.text+0x8): relocation R_AARCH64_MOVW_UABS_G2 out of range: 281474976710656 is not in [0, 281474976710655]
movn x0, #:abs_g2:zero+0x1000000000000
# CHECK: error: a.o:(.text+0xc): relocation R_AARCH64_MOVW_SABS_G0 out of range: 65536 is not in [-65536, 65535]
movn x0, #:abs_g0_s:zero+0x10000
# CHECK: error: a.o:(.text+0x10): relocation R_AARCH64_MOVW_SABS_G1 out of range: 4294967296 is not in [-4294967296, 4294967295]
movn x0, #:abs_g1_s:zero+0x100000000
# CHECK: error: a.o:(.text+0x14): relocation R_AARCH64_MOVW_SABS_G2 out of range: 281474976710656 is not in [-281474976710656, 281474976710655]
movn x0, #:abs_g2_s:zero+0x1000000000000
# CHECK: error: a.o:(.text+0x18): relocation R_AARCH64_MOVW_SABS_G0 out of range: -65537 is not in [-65536, 65535]
movn x0, #:abs_g0_s:zero-0x10001
# CHECK: error: a.o:(.text+0x1c): relocation R_AARCH64_MOVW_SABS_G1 out of range: -4295032832 is not in [-4294967296, 4294967295]
movn x0, #:abs_g1_s:zero-0x100010000
# CHECK: error: a.o:(.text+0x20): relocation R_AARCH64_MOVW_SABS_G2 out of range: -281479271677952 is not in [-281474976710656, 281474976710655]
movn x0, #:abs_g2_s:zero-0x1000100000000

# CHECK: error: a.o:(.text+0x24): relocation R_AARCH64_MOVW_PREL_G0 out of range: 65536 is not in [-65536, 65535]; references section '.text'
movn x0, #:prel_g0:.+0x10000
# CHECK: error: a.o:(.text+0x28): relocation R_AARCH64_MOVW_PREL_G1 out of range: 4294967296 is not in [-4294967296, 4294967295]
movn x0, #:prel_g1:.+0x100000000
# CHECK: error: a.o:(.text+0x2c): relocation R_AARCH64_MOVW_PREL_G2 out of range: 281474976710656 is not in [-281474976710656, 281474976710655]
movn x0, #:prel_g2:.+0x1000000000000
# CHECK: error: a.o:(.text+0x30): relocation R_AARCH64_MOVW_PREL_G0 out of range: -65537 is not in [-65536, 65535]
movn x0, #:prel_g0:.-0x10001
# CHECK: error: a.o:(.text+0x34): relocation R_AARCH64_MOVW_PREL_G1 out of range: -4295032832 is not in [-4294967296, 4294967295]
movn x0, #:prel_g1:.-0x100010000
# CHECK: error: a.o:(.text+0x38): relocation R_AARCH64_MOVW_PREL_G2 out of range: -281479271677952 is not in [-281474976710656, 281474976710655]
movn x0, #:prel_g2:.-0x1000100000000

movz x0, #:tprel_g0: v1
# CHECK: error: a.o:(.text+0x3c): relocation R_AARCH64_TLSLE_MOVW_TPREL_G0 out of range: 65552 is not in [-65536, 65535]; references 'v1'
movz x0, #:tprel_g1: v2
# CHECK: error: a.o:(.text+0x40): relocation R_AARCH64_TLSLE_MOVW_TPREL_G1 out of range: 4295032848 is not in [-4294967296, 4294967295]; references 'v2'
movz x0, #:tprel_g2: v3
# CHECK: error: a.o:(.text+0x44): relocation R_AARCH64_TLSLE_MOVW_TPREL_G2 out of range: 281479271743496 is not in [-281474976710656, 281474976710655]; references 'v3'

.section .tbss,"awT",@nobits
.balign 16
.space 0x10000
v1:
.quad 0
.space 0x100000000 - 8
v2:
.quad 0
.space 0x1000000000000 - 16
v3:
.quad 0
