#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QObject>
#include <QtQml>


/////////////////////// Local includes
#include "jsclassregistrar.h"
#include "pappsomspp/export-import-config.h"
#include "../trace/datapoint.h"

namespace pappso
{

  /*  BEGIN CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: DataPoint
   */

class PMSPP_LIB_DECL DataPointJs : public QObject
{
  Q_OBJECT

  Q_PROPERTY(double x READ getX WRITE setX NOTIFY xChanged)
  Q_PROPERTY(double y READ getY WRITE setY NOTIFY yChanged)
  Q_PROPERTY(bool valid READ isValid NOTIFY validChanged)
  Q_PROPERTY(QString string READ toString NOTIFY stringChanged)
  QML_NAMED_ELEMENT(DataPoint)

  public:
  Q_INVOKABLE explicit DataPointJs(QObject *parent = nullptr);
  Q_INVOKABLE explicit DataPointJs(double x, double y, QObject *parent = nullptr);
  Q_INVOKABLE explicit DataPointJs(const DataPoint &data_ppoint, QObject *parent = nullptr);

  Q_INVOKABLE double getX() const;
  Q_INVOKABLE void setX(double x);

  Q_INVOKABLE double getY() const;
  Q_INVOKABLE void setY(double y);

  Q_INVOKABLE void setData(double x, double y);

  bool isValid() const;

  QString toString() const;
  QString toString(int decimals) const;

  Q_INVOKABLE void reset();
  Q_INVOKABLE void incrementX(double value);
  Q_INVOKABLE void incrementY(double value);
  Q_INVOKABLE void initialize(double x, double y);
  Q_INVOKABLE void initialize(const QString &text);

  const DataPoint &dataPoint() const;
  void setDataPoint(const DataPoint &point);

  static void registerJsConstructor(QJSEngine *engine);

  signals:
  void xChanged();
  void yChanged();
  void validChanged();
  void stringChanged();

  private:
  DataPoint m_dataPoint;
};

PAPPSO_REGISTER_JS_CLASS(pappso, DataPointJs)

  /*  BEGIN CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: DataPoint
   */

} // namespace pappso
