# stub for SortedDict. This is a lightly edited copy of
# https://github.com/grantjenks/python-sortedcontainers/blob/eea42df1f7bad2792e8da77335ff888f04b9e5ae/sortedcontainers/sorteddict.pyi
# (from https://github.com/grantjenks/python-sortedcontainers/pull/107)

from __future__ import annotations

from typing import (
    Any,
    Callable,
    Hashable,
    ItemsView,
    Iterable,
    Iterator,
    KeysView,
    Mapping,
    Sequence,
    TypeVar,
    ValuesView,
    overload,
)

_T = TypeVar("_T")
_S = TypeVar("_S")
_T_h = TypeVar("_T_h", bound=Hashable)
_KT = TypeVar("_KT", bound=Hashable)  # Key type.
_VT = TypeVar("_VT")  # Value type.
_KT_co = TypeVar("_KT_co", covariant=True, bound=Hashable)
_VT_co = TypeVar("_VT_co", covariant=True)
_SD = TypeVar("_SD", bound=SortedDict)
_Key = Callable[[_T], Any]

class SortedDict(dict[_KT, _VT]):
    @overload
    def __init__(self, **kwargs: _VT) -> None: ...
    @overload
    def __init__(self, __map: Mapping[_KT, _VT], **kwargs: _VT) -> None: ...
    @overload
    def __init__(
        self, __iterable: Iterable[tuple[_KT, _VT]], **kwargs: _VT
    ) -> None: ...
    @overload
    def __init__(self, __key: _Key[_KT], **kwargs: _VT) -> None: ...
    @overload
    def __init__(
        self, __key: _Key[_KT], __map: Mapping[_KT, _VT], **kwargs: _VT
    ) -> None: ...
    @overload
    def __init__(
        self, __key: _Key[_KT], __iterable: Iterable[tuple[_KT, _VT]], **kwargs: _VT
    ) -> None: ...
    @property
    def key(self) -> _Key[_KT] | None: ...
    @property
    def iloc(self) -> SortedKeysView[_KT]: ...
    def clear(self) -> None: ...
    def __delitem__(self, key: _KT) -> None: ...
    def __iter__(self) -> Iterator[_KT]: ...
    def __reversed__(self) -> Iterator[_KT]: ...
    def __setitem__(self, key: _KT, value: _VT) -> None: ...
    def _setitem(self, key: _KT, value: _VT) -> None: ...
    def copy(self: _SD) -> _SD: ...
    def __copy__(self: _SD) -> _SD: ...
    @classmethod
    @overload
    def fromkeys(
        cls, seq: Iterable[_T_h], value: None = ...
    ) -> SortedDict[_T_h, None]: ...
    @classmethod
    @overload
    def fromkeys(cls, seq: Iterable[_T_h], value: _S) -> SortedDict[_T_h, _S]: ...
    # As of Python 3.10, `dict_{keys,items,values}` have an extra `mapping` attribute and so
    # `Sorted{Keys,Items,Values}View` are no longer compatible with them.
    # See https://github.com/python/typeshed/issues/6837
    def keys(self) -> SortedKeysView[_KT]: ...  # type: ignore[override]
    def items(self) -> SortedItemsView[_KT, _VT]: ...  # type: ignore[override]
    def values(self) -> SortedValuesView[_VT]: ...  # type: ignore[override]
    @overload
    def pop(self, key: _KT) -> _VT: ...
    @overload
    def pop(self, key: _KT, default: _T = ...) -> _VT | _T: ...
    def popitem(self, index: int = ...) -> tuple[_KT, _VT]: ...
    def peekitem(self, index: int = ...) -> tuple[_KT, _VT]: ...
    def setdefault(self, key: _KT, default: _VT | None = ...) -> _VT: ...
    # Mypy now reports the first overload as an error, because typeshed widened the type
    # of `__map` to its internal `_typeshed.SupportsKeysAndGetItem` type in
    #   https://github.com/python/typeshed/pull/6653
    # Since sorteddicts don't change the signature of `update` from that of `dict`, we
    # let the stubs for `update` inherit from the stubs for `dict`. (I suspect we could
    # do the same for many othe methods.) We leave the stubs commented to better track
    # how this file has evolved from the original stubs.
    # @overload
    # def update(self, __map: Mapping[_KT, _VT], **kwargs: _VT) -> None: ...
    # @overload
    # def update(self, __iterable: Iterable[Tuple[_KT, _VT]], **kwargs: _VT) -> None: ...
    # @overload
    # def update(self, **kwargs: _VT) -> None: ...
    def __reduce__(
        self,
    ) -> tuple[
        type[SortedDict[_KT, _VT]],
        tuple[Callable[[_KT], Any], list[tuple[_KT, _VT]]],
    ]: ...
    def __repr__(self) -> str: ...
    def _check(self) -> None: ...
    def islice(
        self,
        start: int | None = ...,
        stop: int | None = ...,
        reverse: bool = ...,
    ) -> Iterator[_KT]: ...
    def bisect_left(self, value: _KT) -> int: ...
    def bisect_right(self, value: _KT) -> int: ...

class SortedKeysView(KeysView[_KT_co], Sequence[_KT_co]):
    @overload
    def __getitem__(self, index: int) -> _KT_co: ...
    @overload
    def __getitem__(self, index: slice) -> list[_KT_co]: ...
    def __delitem__(self, index: int | slice) -> None: ...

class SortedItemsView(ItemsView[_KT_co, _VT_co], Sequence[tuple[_KT_co, _VT_co]]):
    def __iter__(self) -> Iterator[tuple[_KT_co, _VT_co]]: ...
    @overload
    def __getitem__(self, index: int) -> tuple[_KT_co, _VT_co]: ...
    @overload
    def __getitem__(self, index: slice) -> list[tuple[_KT_co, _VT_co]]: ...
    def __delitem__(self, index: int | slice) -> None: ...

class SortedValuesView(ValuesView[_VT_co], Sequence[_VT_co]):
    @overload
    def __getitem__(self, index: int) -> _VT_co: ...
    @overload
    def __getitem__(self, index: slice) -> list[_VT_co]: ...
    def __delitem__(self, index: int | slice) -> None: ...
