--
-- Copyright 2026 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.

CREATE PERFETTO TABLE _mt6897_2d AS
WITH
  data(device, policy, freq_khz, dep_policy, dep_freq, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("MT6897", 0, 480000, 4, 400000, 11.89, 33.54, 0.25, 0),
      ("MT6897", 0, 480000, 4, 500000, 12.0, 34.52, 0.21, 0),
      ("MT6897", 0, 480000, 4, 600000, 11.97, 35.03, 0.21, 0),
      ("MT6897", 0, 480000, 4, 700000, 11.85, 35.07, 0.39, 0),
      ("MT6897", 0, 480000, 4, 800000, 11.96, 33.92, 0.34, 0),
      ("MT6897", 0, 480000, 4, 900000, 11.79, 38.24, 0.88, 0),
      ("MT6897", 0, 480000, 4, 1000000, 11.76, 41.45, 1.02, 0),
      ("MT6897", 0, 480000, 4, 1100000, 11.63, 44.84, 1.19, 0),
      ("MT6897", 0, 480000, 4, 1200000, 11.51, 45.02, 1.28, 0),
      ("MT6897", 0, 480000, 4, 1300000, 11.49, 56.76, 1.32, 0),
      ("MT6897", 0, 480000, 4, 1400000, 11.48, 63.34, 1.37, 0),
      ("MT6897", 0, 480000, 4, 1500000, 11.55, 71.08, 1.34, 0),
      ("MT6897", 0, 480000, 4, 1600000, 11.58, 75.93, 1.34, 0),
      ("MT6897", 0, 480000, 4, 1700000, 11.68, 83.38, 1.4, 0),
      ("MT6897", 0, 480000, 4, 1800000, 14.19, 88.99, 1.46, 0),
      ("MT6897", 0, 480000, 7, 400000, 11.08, 30.13, 1.1, 0),
      ("MT6897", 0, 480000, 7, 500000, 11.12, 30.02, 1.11, 0),
      ("MT6897", 0, 480000, 7, 600000, 11.17, 29.9, 1.1, 0),
      ("MT6897", 0, 480000, 7, 700000, 11.15, 29.78, 1.11, 0),
      ("MT6897", 0, 480000, 7, 800000, 11.45, 30.09, 1.07, 0),
      ("MT6897", 0, 480000, 7, 900000, 11.41, 29.85, 1.13, 0),
      ("MT6897", 0, 480000, 7, 1000000, 11.43, 29.75, 1.09, 0),
      ("MT6897", 0, 480000, 7, 1100000, 11.46, 29.66, 1.12, 0),
      ("MT6897", 0, 480000, 7, 1200000, 11.86, 30.45, 1.08, 0),
      ("MT6897", 0, 480000, 7, 1300000, 11.89, 29.55, 1.08, 0),
      ("MT6897", 0, 480000, 7, 1400000, 11.91, 32.34, 1.08, 0),
      ("MT6897", 0, 480000, 7, 1500000, 11.85, 33.6, 1.21, 0),
      ("MT6897", 0, 480000, 7, 1600000, 11.86, 33.24, 1.2, 0),
      ("MT6897", 0, 480000, 7, 1700000, 11.84, 34.67, 1.23, 0),
      ("MT6897", 0, 480000, 7, 1800000, 11.87, 36.07, 1.24, 0),
      ("MT6897", 0, 600000, 4, 400000, 12.03, 33.75, 0.56, 0),
      ("MT6897", 0, 600000, 4, 500000, 12.04, 34.73, 0.7, 0),
      ("MT6897", 0, 600000, 4, 600000, 12.02, 35.6, 0.82, 0),
      ("MT6897", 0, 600000, 4, 700000, 12.04, 36.45, 0.82, 0),
      ("MT6897", 0, 600000, 4, 800000, 12.0, 38.25, 0.9, 0),
      ("MT6897", 0, 600000, 4, 900000, 12.27, 40.04, 1.01, 0),
      ("MT6897", 0, 600000, 4, 1000000, 12.47, 41.45, 1.01, 0),
      ("MT6897", 0, 600000, 4, 1100000, 12.45, 44.73, 1.08, 0),
      ("MT6897", 0, 600000, 4, 1200000, 12.79, 48.3, 1.13, 0),
      ("MT6897", 0, 600000, 4, 1300000, 12.84, 56.76, 1.16, 0),
      ("MT6897", 0, 600000, 4, 1400000, 12.95, 63.34, 1.21, 0),
      ("MT6897", 0, 600000, 4, 1500000, 13.13, 71.08, 1.19, 0),
      ("MT6897", 0, 600000, 4, 1600000, 13.22, 75.93, 1.18, 0),
      ("MT6897", 0, 600000, 4, 1700000, 13.31, 83.38, 1.24, 0),
      ("MT6897", 0, 600000, 4, 1800000, 13.82, 88.99, 1.3, 0),
      ("MT6897", 0, 600000, 7, 400000, 11.94, 34.34, 1.11, 0),
      ("MT6897", 0, 600000, 7, 500000, 11.95, 34.04, 1.11, 0),
      ("MT6897", 0, 600000, 7, 600000, 11.96, 33.55, 1.11, 0),
      ("MT6897", 0, 600000, 7, 700000, 11.92, 35.42, 1.21, 0),
      ("MT6897", 0, 600000, 7, 800000, 11.85, 35.06, 1.34, 0),
      ("MT6897", 0, 600000, 7, 900000, 11.9, 35.39, 1.31, 0),
      ("MT6897", 0, 600000, 7, 1000000, 11.91, 36.35, 1.31, 0),
      ("MT6897", 0, 600000, 7, 1100000, 11.92, 34.65, 1.29, 0),
      ("MT6897", 0, 600000, 7, 1200000, 11.94, 38.7, 1.31, 0),
      ("MT6897", 0, 600000, 7, 1300000, 11.91, 39.5, 1.31, 0),
      ("MT6897", 0, 600000, 7, 1400000, 11.91, 44.26, 1.31, 0),
      ("MT6897", 0, 600000, 7, 1500000, 11.91, 44.0, 1.32, 0),
      ("MT6897", 0, 600000, 7, 1600000, 11.89, 47.49, 1.38, 0),
      ("MT6897", 0, 600000, 7, 1700000, 11.93, 51.98, 1.36, 0),
      ("MT6897", 0, 600000, 7, 1800000, 11.87, 56.6, 1.39, 0),
      ("MT6897", 0, 700000, 4, 400000, 13.74, 32.38, 0.41, 0),
      ("MT6897", 0, 700000, 4, 500000, 13.57, 34.0, 0.64, 0),
      ("MT6897", 0, 700000, 4, 600000, 13.43, 35.32, 0.82, 0),
      ("MT6897", 0, 700000, 4, 700000, 13.48, 44.01, 0.81, 0),
      ("MT6897", 0, 700000, 4, 800000, 13.5, 43.69, 0.88, 0),
      ("MT6897", 0, 700000, 4, 900000, 13.2, 45.41, 1.17, 0),
      ("MT6897", 0, 700000, 4, 1000000, 13.14, 45.11, 1.18, 0),
      ("MT6897", 0, 700000, 4, 1100000, 13.21, 44.77, 1.22, 0),
      ("MT6897", 0, 700000, 4, 1200000, 13.21, 47.32, 1.27, 0),
      ("MT6897", 0, 700000, 4, 1300000, 13.19, 64.34, 1.3, 0),
      ("MT6897", 0, 700000, 4, 1400000, 13.21, 67.32, 1.35, 0),
      ("MT6897", 0, 700000, 4, 1500000, 13.24, 70.45, 1.33, 0),
      ("MT6897", 0, 700000, 4, 1600000, 13.33, 74.21, 1.32, 0),
      ("MT6897", 0, 700000, 4, 1700000, 13.89, 79.76, 1.37, 0),
      ("MT6897", 0, 700000, 4, 1800000, 14.71, 84.97, 1.41, 0),
      ("MT6897", 0, 700000, 7, 400000, 13.17, 32.25, 1.13, 0),
      ("MT6897", 0, 700000, 7, 500000, 13.13, 32.01, 1.35, 0),
      ("MT6897", 0, 700000, 7, 600000, 13.31, 31.51, 1.31, 0),
      ("MT6897", 0, 700000, 7, 700000, 13.45, 34.04, 1.34, 0),
      ("MT6897", 0, 700000, 7, 800000, 13.42, 33.72, 1.35, 0),
      ("MT6897", 0, 700000, 7, 900000, 13.48, 34.25, 1.36, 0),
      ("MT6897", 0, 700000, 7, 1000000, 13.64, 35.5, 1.35, 0),
      ("MT6897", 0, 700000, 7, 1100000, 13.78, 33.15, 1.28, 0),
      ("MT6897", 0, 700000, 7, 1200000, 13.64, 49.7, 1.34, 0),
      ("MT6897", 0, 700000, 7, 1300000, 13.63, 48.34, 1.33, 0),
      ("MT6897", 0, 700000, 7, 1400000, 13.6, 49.71, 1.34, 0),
      ("MT6897", 0, 700000, 7, 1500000, 13.59, 52.34, 1.33, 0),
      ("MT6897", 0, 700000, 7, 1600000, 13.53, 56.2, 1.37, 0),
      ("MT6897", 0, 700000, 7, 1700000, 13.5, 56.01, 1.36, 0),
      ("MT6897", 0, 700000, 7, 1800000, 13.63, 72.7, 1.36, 0),
      ("MT6897", 0, 800000, 4, 400000, 15.02, 57.84, 0.47, 0),
      ("MT6897", 0, 800000, 4, 500000, 15.18, 57.2, 0.61, 0),
      ("MT6897", 0, 800000, 4, 600000, 15.13, 56.7, 0.72, 0),
      ("MT6897", 0, 800000, 4, 700000, 15.12, 56.36, 0.72, 0),
      ("MT6897", 0, 800000, 4, 800000, 15.04, 56.14, 0.83, 0),
      ("MT6897", 0, 800000, 4, 900000, 15.04, 56.18, 0.98, 0),
      ("MT6897", 0, 800000, 4, 1000000, 14.98, 56.16, 0.99, 0),
      ("MT6897", 0, 800000, 4, 1100000, 14.95, 55.83, 1.06, 0),
      ("MT6897", 0, 800000, 4, 1200000, 14.84, 60.9, 1.18, 0),
      ("MT6897", 0, 800000, 4, 1300000, 14.84, 63.79, 1.2, 0),
      ("MT6897", 0, 800000, 4, 1400000, 14.84, 66.96, 1.26, 0),
      ("MT6897", 0, 800000, 4, 1500000, 14.83, 70.84, 1.24, 0),
      ("MT6897", 0, 800000, 4, 1600000, 14.78, 77.74, 1.27, 0),
      ("MT6897", 0, 800000, 4, 1700000, 14.84, 85.1, 1.33, 0),
      ("MT6897", 0, 800000, 4, 1800000, 14.77, 93.44, 1.43, 0),
      ("MT6897", 0, 800000, 7, 400000, 13.65, 51.27, 1.16, 0),
      ("MT6897", 0, 800000, 7, 500000, 13.62, 51.16, 1.36, 0),
      ("MT6897", 0, 800000, 7, 600000, 13.69, 51.24, 1.35, 0),
      ("MT6897", 0, 800000, 7, 700000, 13.69, 50.78, 1.34, 0),
      ("MT6897", 0, 800000, 7, 800000, 13.76, 50.96, 1.35, 0),
      ("MT6897", 0, 800000, 7, 900000, 13.77, 50.94, 1.35, 0),
      ("MT6897", 0, 800000, 7, 1000000, 13.73, 50.94, 1.41, 0),
      ("MT6897", 0, 800000, 7, 1100000, 13.77, 50.98, 1.4, 0),
      ("MT6897", 0, 800000, 7, 1200000, 13.73, 50.9, 1.49, 0),
      ("MT6897", 0, 800000, 7, 1300000, 13.79, 52.4, 1.49, 0),
      ("MT6897", 0, 800000, 7, 1400000, 13.73, 52.56, 1.53, 0),
      ("MT6897", 0, 800000, 7, 1500000, 13.73, 52.3, 1.57, 0),
      ("MT6897", 0, 800000, 7, 1600000, 13.97, 55.57, 1.44, 0),
      ("MT6897", 0, 800000, 7, 1700000, 13.83, 55.78, 1.62, 0),
      ("MT6897", 0, 800000, 7, 1800000, 14.14, 68.38, 1.56, 0),
      ("MT6897", 0, 900000, 4, 400000, 16.26, 72.21, 0.55, 0),
      ("MT6897", 0, 900000, 4, 500000, 16.13, 70.73, 0.93, 0),
      ("MT6897", 0, 900000, 4, 600000, 16.27, 69.38, 0.9, 0),
      ("MT6897", 0, 900000, 4, 700000, 16.23, 68.46, 0.99, 0),
      ("MT6897", 0, 900000, 4, 800000, 16.04, 67.57, 1.02, 0),
      ("MT6897", 0, 900000, 4, 900000, 16.02, 68.12, 1.09, 0),
      ("MT6897", 0, 900000, 4, 1000000, 16.48, 67.27, 1.07, 0),
      ("MT6897", 0, 900000, 4, 1100000, 16.69, 67.63, 1.1, 0),
      ("MT6897", 0, 900000, 4, 1200000, 16.43, 68.85, 1.17, 0),
      ("MT6897", 0, 900000, 4, 1300000, 16.41, 75.42, 1.2, 0),
      ("MT6897", 0, 900000, 4, 1400000, 16.31, 71.74, 1.26, 0),
      ("MT6897", 0, 900000, 4, 1500000, 16.4, 78.14, 1.23, 0),
      ("MT6897", 0, 900000, 4, 1600000, 16.41, 84.68, 1.22, 0),
      ("MT6897", 0, 900000, 4, 1700000, 16.37, 103.55, 1.3, 0),
      ("MT6897", 0, 900000, 4, 1800000, 16.37, 114.84, 1.34, 0),
      ("MT6897", 0, 900000, 7, 400000, 15.35, 63.61, 1.17, 0),
      ("MT6897", 0, 900000, 7, 500000, 15.45, 65.14, 1.38, 0),
      ("MT6897", 0, 900000, 7, 600000, 15.72, 64.69, 1.42, 0),
      ("MT6897", 0, 900000, 7, 700000, 15.78, 64.63, 1.4, 0),
      ("MT6897", 0, 900000, 7, 800000, 15.88, 64.81, 1.35, 0),
      ("MT6897", 0, 900000, 7, 900000, 15.76, 64.32, 1.39, 0),
      ("MT6897", 0, 900000, 7, 1000000, 15.78, 64.29, 1.41, 0),
      ("MT6897", 0, 900000, 7, 1100000, 15.69, 64.29, 1.39, 0),
      ("MT6897", 0, 900000, 7, 1200000, 15.7, 64.07, 1.48, 0),
      ("MT6897", 0, 900000, 7, 1300000, 15.69, 64.46, 1.48, 0),
      ("MT6897", 0, 900000, 7, 1400000, 15.56, 65.58, 1.66, 0),
      ("MT6897", 0, 900000, 7, 1500000, 15.58, 66.17, 1.63, 0),
      ("MT6897", 0, 900000, 7, 1600000, 15.39, 67.58, 1.66, 0),
      ("MT6897", 0, 900000, 7, 1700000, 15.62, 70.66, 1.64, 0),
      ("MT6897", 0, 900000, 7, 1800000, 15.36, 72.9, 1.7, 0),
      ("MT6897", 0, 1000000, 4, 400000, 16.96, 84.04, 0.82, 0),
      ("MT6897", 0, 1000000, 4, 500000, 17.23, 81.71, 0.89, 0),
      ("MT6897", 0, 1000000, 4, 600000, 17.29, 79.52, 0.87, 0),
      ("MT6897", 0, 1000000, 4, 700000, 18.01, 78.02, 0.92, 0),
      ("MT6897", 0, 1000000, 4, 800000, 17.98, 76.46, 0.93, 0),
      ("MT6897", 0, 1000000, 4, 900000, 18.2, 77.01, 1.01, 0),
      ("MT6897", 0, 1000000, 4, 1000000, 17.79, 78.74, 1.02, 0),
      ("MT6897", 0, 1000000, 4, 1100000, 18.09, 76.88, 1.04, 0),
      ("MT6897", 0, 1000000, 4, 1200000, 18.17, 76.45, 1.09, 0),
      ("MT6897", 0, 1000000, 4, 1300000, 18.08, 77.27, 1.13, 0),
      ("MT6897", 0, 1000000, 4, 1400000, 17.95, 75.05, 1.23, 0),
      ("MT6897", 0, 1000000, 4, 1500000, 17.96, 85.57, 1.21, 0),
      ("MT6897", 0, 1000000, 4, 1600000, 17.97, 91.63, 1.22, 0),
      ("MT6897", 0, 1000000, 4, 1700000, 17.79, 122.01, 1.4, 0),
      ("MT6897", 0, 1000000, 4, 1800000, 17.74, 136.24, 1.46, 0),
      ("MT6897", 0, 1000000, 7, 400000, 15.56, 65.79, 1.2, 0),
      ("MT6897", 0, 1000000, 7, 500000, 15.42, 77.37, 1.44, 0),
      ("MT6897", 0, 1000000, 7, 600000, 15.93, 78.19, 1.45, 0),
      ("MT6897", 0, 1000000, 7, 700000, 15.79, 79.87, 1.47, 0),
      ("MT6897", 0, 1000000, 7, 800000, 15.88, 77.07, 1.5, 0),
      ("MT6897", 0, 1000000, 7, 900000, 15.81, 79.24, 1.62, 0),
      ("MT6897", 0, 1000000, 7, 1000000, 15.92, 77.55, 1.61, 0),
      ("MT6897", 0, 1000000, 7, 1100000, 15.63, 76.42, 1.73, 0),
      ("MT6897", 0, 1000000, 7, 1200000, 16.67, 77.28, 1.65, 0),
      ("MT6897", 0, 1000000, 7, 1300000, 16.71, 77.02, 1.63, 0),
      ("MT6897", 0, 1000000, 7, 1400000, 16.58, 77.21, 1.66, 0),
      ("MT6897", 0, 1000000, 7, 1500000, 16.66, 77.54, 1.62, 0),
      ("MT6897", 0, 1000000, 7, 1600000, 16.63, 79.27, 1.63, 0),
      ("MT6897", 0, 1000000, 7, 1700000, 16.92, 77.74, 1.63, 0),
      ("MT6897", 0, 1000000, 7, 1800000, 17.14, 79.75, 1.63, 0),
      ("MT6897", 0, 1100000, 4, 400000, 18.66, 93.92, 0.87, 0),
      ("MT6897", 0, 1100000, 4, 500000, 19.41, 90.76, 0.93, 0),
      ("MT6897", 0, 1100000, 4, 600000, 19.36, 87.72, 0.92, 0),
      ("MT6897", 0, 1100000, 4, 700000, 19.65, 86.23, 0.98, 0),
      ("MT6897", 0, 1100000, 4, 800000, 19.58, 82.94, 1.0, 0),
      ("MT6897", 0, 1100000, 4, 900000, 21.84, 82.86, 1.05, 0),
      ("MT6897", 0, 1100000, 4, 1000000, 21.56, 86.58, 1.04, 0),
      ("MT6897", 0, 1100000, 4, 1100000, 21.69, 84.2, 1.07, 0),
      ("MT6897", 0, 1100000, 4, 1200000, 22.41, 82.1, 1.13, 0),
      ("MT6897", 0, 1100000, 4, 1300000, 23.51, 81.15, 1.16, 0),
      ("MT6897", 0, 1100000, 4, 1400000, 22.94, 80.38, 1.2, 0),
      ("MT6897", 0, 1100000, 4, 1500000, 22.93, 93.01, 1.19, 0),
      ("MT6897", 0, 1100000, 4, 1600000, 23.07, 98.57, 1.18, 0),
      ("MT6897", 0, 1100000, 4, 1700000, 22.96, 140.46, 1.25, 0),
      ("MT6897", 0, 1100000, 4, 1800000, 23.08, 157.64, 1.29, 0),
      ("MT6897", 0, 1100000, 7, 400000, 18.15, 61.95, 1.23, 0),
      ("MT6897", 0, 1100000, 7, 500000, 18.18, 78.04, 1.43, 0),
      ("MT6897", 0, 1100000, 7, 600000, 18.42, 78.85, 1.48, 0),
      ("MT6897", 0, 1100000, 7, 700000, 18.42, 83.03, 1.48, 0),
      ("MT6897", 0, 1100000, 7, 800000, 20.04, 84.12, 1.51, 0),
      ("MT6897", 0, 1100000, 7, 900000, 19.76, 85.44, 1.62, 0),
      ("MT6897", 0, 1100000, 7, 1000000, 19.84, 81.51, 1.6, 0),
      ("MT6897", 0, 1100000, 7, 1100000, 19.78, 85.16, 1.71, 0),
      ("MT6897", 0, 1100000, 7, 1200000, 19.75, 86.14, 1.65, 0),
      ("MT6897", 0, 1100000, 7, 1300000, 19.75, 84.02, 1.65, 0),
      ("MT6897", 0, 1100000, 7, 1400000, 21.0, 83.57, 1.65, 0),
      ("MT6897", 0, 1100000, 7, 1500000, 20.52, 83.52, 1.62, 0),
      ("MT6897", 0, 1100000, 7, 1600000, 20.98, 81.97, 1.6, 0),
      ("MT6897", 0, 1100000, 7, 1700000, 20.95, 77.22, 1.61, 0),
      ("MT6897", 0, 1100000, 7, 1800000, 21.46, 78.82, 1.6, 0),
      ("MT6897", 0, 1200000, 4, 400000, 26.9, 102.43, 0.79, 0),
      ("MT6897", 0, 1200000, 4, 500000, 27.02, 98.42, 0.86, 0),
      ("MT6897", 0, 1200000, 4, 600000, 26.73, 94.55, 0.84, 0),
      ("MT6897", 0, 1200000, 4, 700000, 26.57, 93.06, 0.91, 0),
      ("MT6897", 0, 1200000, 4, 800000, 26.3, 88.06, 0.91, 0),
      ("MT6897", 0, 1200000, 4, 900000, 26.35, 87.34, 0.99, 0),
      ("MT6897", 0, 1200000, 4, 1000000, 26.4, 86.49, 0.98, 0),
      ("MT6897", 0, 1200000, 4, 1100000, 26.3, 85.94, 1.03, 0),
      ("MT6897", 0, 1200000, 4, 1200000, 26.65, 86.37, 1.08, 0),
      ("MT6897", 0, 1200000, 4, 1300000, 26.49, 87.53, 1.11, 0),
      ("MT6897", 0, 1200000, 4, 1400000, 26.51, 89.34, 1.16, 0),
      ("MT6897", 0, 1200000, 4, 1500000, 26.67, 100.45, 1.15, 0),
      ("MT6897", 0, 1200000, 4, 1600000, 27.17, 105.52, 1.15, 0),
      ("MT6897", 0, 1200000, 4, 1700000, 28.87, 144.55, 1.21, 0),
      ("MT6897", 0, 1200000, 4, 1800000, 30.35, 163.88, 1.26, 0),
      ("MT6897", 0, 1200000, 7, 400000, 21.62, 61.78, 1.25, 0),
      ("MT6897", 0, 1200000, 7, 500000, 21.46, 75.03, 1.26, 0),
      ("MT6897", 0, 1200000, 7, 600000, 21.43, 77.06, 1.34, 0),
      ("MT6897", 0, 1200000, 7, 700000, 21.42, 81.85, 1.34, 0),
      ("MT6897", 0, 1200000, 7, 800000, 21.34, 84.45, 1.4, 0),
      ("MT6897", 0, 1200000, 7, 900000, 21.23, 89.32, 1.61, 0),
      ("MT6897", 0, 1200000, 7, 1000000, 21.13, 93.13, 1.62, 0),
      ("MT6897", 0, 1200000, 7, 1100000, 21.69, 94.62, 1.77, 0),
      ("MT6897", 0, 1200000, 7, 1200000, 21.06, 94.79, 1.73, 0),
      ("MT6897", 0, 1200000, 7, 1300000, 21.04, 94.88, 1.72, 0),
      ("MT6897", 0, 1200000, 7, 1400000, 21.0, 94.98, 1.73, 0),
      ("MT6897", 0, 1200000, 7, 1500000, 20.99, 94.79, 1.7, 0),
      ("MT6897", 0, 1200000, 7, 1600000, 20.96, 94.25, 1.67, 0),
      ("MT6897", 0, 1200000, 7, 1700000, 20.95, 93.77, 1.71, 0),
      ("MT6897", 0, 1200000, 7, 1800000, 21.34, 93.07, 1.66, 0),
      ("MT6897", 0, 1300000, 4, 400000, 25.99, 133.16, 0.83, 0),
      ("MT6897", 0, 1300000, 4, 500000, 26.2, 131.28, 0.89, 0),
      ("MT6897", 0, 1300000, 4, 600000, 26.06, 130.61, 0.88, 0),
      ("MT6897", 0, 1300000, 4, 700000, 25.97, 126.65, 0.97, 0),
      ("MT6897", 0, 1300000, 4, 800000, 25.82, 125.7, 0.97, 0),
      ("MT6897", 0, 1300000, 4, 900000, 26.03, 124.5, 1.04, 0),
      ("MT6897", 0, 1300000, 4, 1000000, 26.09, 123.6, 1.04, 0),
      ("MT6897", 0, 1300000, 4, 1100000, 25.95, 121.95, 1.1, 0),
      ("MT6897", 0, 1300000, 4, 1200000, 26.3, 119.57, 1.13, 0),
      ("MT6897", 0, 1300000, 4, 1300000, 26.17, 126.22, 1.21, 0),
      ("MT6897", 0, 1300000, 4, 1400000, 26.18, 123.25, 1.28, 0),
      ("MT6897", 0, 1300000, 4, 1500000, 26.42, 124.8, 1.42, 0),
      ("MT6897", 0, 1300000, 4, 1600000, 26.61, 124.35, 1.52, 0),
      ("MT6897", 0, 1300000, 4, 1700000, 27.71, 140.35, 1.57, 0),
      ("MT6897", 0, 1300000, 4, 1800000, 28.66, 158.53, 1.58, 0),
      ("MT6897", 0, 1300000, 7, 400000, 21.73, 101.71, 1.21, 0),
      ("MT6897", 0, 1300000, 7, 500000, 21.67, 103.23, 1.32, 0),
      ("MT6897", 0, 1300000, 7, 600000, 21.9, 101.58, 1.42, 0),
      ("MT6897", 0, 1300000, 7, 700000, 23.08, 98.17, 1.4, 0),
      ("MT6897", 0, 1300000, 7, 800000, 22.98, 100.93, 1.45, 0),
      ("MT6897", 0, 1300000, 7, 900000, 23.1, 101.17, 1.56, 0),
      ("MT6897", 0, 1300000, 7, 1000000, 23.08, 104.65, 1.56, 0),
      ("MT6897", 0, 1300000, 7, 1100000, 23.08, 101.36, 1.66, 0),
      ("MT6897", 0, 1300000, 7, 1200000, 23.99, 99.93, 1.6, 0),
      ("MT6897", 0, 1300000, 7, 1300000, 24.04, 97.21, 1.58, 0),
      ("MT6897", 0, 1300000, 7, 1400000, 24.74, 99.29, 1.58, 0),
      ("MT6897", 0, 1300000, 7, 1500000, 25.24, 100.9, 1.54, 0),
      ("MT6897", 0, 1300000, 7, 1600000, 25.02, 99.17, 1.56, 0),
      ("MT6897", 0, 1300000, 7, 1700000, 25.46, 101.76, 1.54, 0),
      ("MT6897", 0, 1300000, 7, 1800000, 25.63, 95.99, 1.54, 0),
      ("MT6897", 0, 1400000, 4, 400000, 26.12, 132.97, 0.86, 0),
      ("MT6897", 0, 1400000, 4, 500000, 26.33, 131.07, 0.93, 0),
      ("MT6897", 0, 1400000, 4, 600000, 26.28, 130.38, 0.9, 0),
      ("MT6897", 0, 1400000, 4, 700000, 26.24, 126.35, 0.96, 0),
      ("MT6897", 0, 1400000, 4, 800000, 27.23, 127.64, 0.94, 0),
      ("MT6897", 0, 1400000, 4, 900000, 27.27, 127.85, 1.03, 0),
      ("MT6897", 0, 1400000, 4, 1000000, 27.14, 134.32, 1.03, 0),
      ("MT6897", 0, 1400000, 4, 1100000, 27.07, 128.73, 1.08, 0),
      ("MT6897", 0, 1400000, 4, 1200000, 27.1, 129.8, 1.13, 0),
      ("MT6897", 0, 1400000, 4, 1300000, 27.15, 129.34, 1.15, 0),
      ("MT6897", 0, 1400000, 4, 1400000, 27.08, 134.94, 1.21, 0),
      ("MT6897", 0, 1400000, 4, 1500000, 26.93, 126.68, 1.37, 0),
      ("MT6897", 0, 1400000, 4, 1600000, 26.95, 124.92, 1.41, 0),
      ("MT6897", 0, 1400000, 4, 1700000, 27.97, 141.16, 1.54, 0),
      ("MT6897", 0, 1400000, 4, 1800000, 28.96, 173.02, 1.53, 0),
      ("MT6897", 0, 1400000, 7, 400000, 25.18, 108.0, 1.26, 0),
      ("MT6897", 0, 1400000, 7, 500000, 25.18, 115.48, 1.35, 0),
      ("MT6897", 0, 1400000, 7, 600000, 25.16, 115.53, 1.4, 0),
      ("MT6897", 0, 1400000, 7, 700000, 25.12, 114.38, 1.69, 0),
      ("MT6897", 0, 1400000, 7, 800000, 24.98, 116.62, 1.67, 0),
      ("MT6897", 0, 1400000, 7, 900000, 25.08, 116.26, 1.76, 0),
      ("MT6897", 0, 1400000, 7, 1000000, 25.06, 113.58, 1.7, 0),
      ("MT6897", 0, 1400000, 7, 1100000, 25.04, 113.66, 1.74, 0),
      ("MT6897", 0, 1400000, 7, 1200000, 25.47, 112.66, 1.69, 0),
      ("MT6897", 0, 1400000, 7, 1300000, 24.54, 111.08, 1.65, 0),
      ("MT6897", 0, 1400000, 7, 1400000, 24.73, 111.96, 1.65, 0),
      ("MT6897", 0, 1400000, 7, 1500000, 25.54, 107.54, 1.61, 0),
      ("MT6897", 0, 1400000, 7, 1600000, 24.97, 114.68, 1.62, 0),
      ("MT6897", 0, 1400000, 7, 1700000, 25.32, 112.4, 1.61, 0),
      ("MT6897", 0, 1400000, 7, 1800000, 25.43, 109.06, 1.61, 0),
      ("MT6897", 0, 1500000, 4, 400000, 29.51, 167.07, 0.78, 0),
      ("MT6897", 0, 1500000, 4, 500000, 29.7, 165.17, 0.85, 0),
      ("MT6897", 0, 1500000, 4, 600000, 29.67, 163.5, 0.83, 0),
      ("MT6897", 0, 1500000, 4, 700000, 29.81, 161.95, 0.95, 0),
      ("MT6897", 0, 1500000, 4, 800000, 29.65, 159.89, 0.94, 0),
      ("MT6897", 0, 1500000, 4, 900000, 29.5, 159.73, 1.15, 0),
      ("MT6897", 0, 1500000, 4, 1000000, 29.57, 158.59, 1.13, 0),
      ("MT6897", 0, 1500000, 4, 1100000, 29.4, 159.66, 1.3, 0),
      ("MT6897", 0, 1500000, 4, 1200000, 29.39, 157.39, 1.32, 0),
      ("MT6897", 0, 1500000, 4, 1300000, 29.15, 155.53, 1.25, 0),
      ("MT6897", 0, 1500000, 4, 1400000, 29.2, 156.87, 1.64, 0),
      ("MT6897", 0, 1500000, 4, 1500000, 29.33, 156.93, 1.55, 0),
      ("MT6897", 0, 1500000, 4, 1600000, 29.28, 156.04, 1.57, 0),
      ("MT6897", 0, 1500000, 4, 1700000, 29.33, 159.31, 1.62, 0),
      ("MT6897", 0, 1500000, 4, 1800000, 29.43, 169.06, 1.61, 0),
      ("MT6897", 0, 1500000, 7, 400000, 27.03, 117.96, 1.69, 0),
      ("MT6897", 0, 1500000, 7, 500000, 27.0, 137.19, 1.64, 0),
      ("MT6897", 0, 1500000, 7, 600000, 27.53, 138.95, 1.62, 0),
      ("MT6897", 0, 1500000, 7, 700000, 27.51, 140.05, 1.68, 0),
      ("MT6897", 0, 1500000, 7, 800000, 27.61, 141.78, 1.66, 0),
      ("MT6897", 0, 1500000, 7, 900000, 27.46, 140.83, 1.74, 0),
      ("MT6897", 0, 1500000, 7, 1000000, 27.46, 138.24, 1.7, 0),
      ("MT6897", 0, 1500000, 7, 1100000, 28.81, 134.57, 1.69, 0),
      ("MT6897", 0, 1500000, 7, 1200000, 29.84, 134.86, 1.63, 0),
      ("MT6897", 0, 1500000, 7, 1300000, 30.31, 141.12, 1.63, 0),
      ("MT6897", 0, 1500000, 7, 1400000, 30.04, 134.08, 1.64, 0),
      ("MT6897", 0, 1500000, 7, 1500000, 30.38, 133.68, 1.58, 0),
      ("MT6897", 0, 1500000, 7, 1600000, 30.27, 139.65, 1.61, 0),
      ("MT6897", 0, 1500000, 7, 1700000, 30.22, 132.5, 1.61, 0),
      ("MT6897", 0, 1500000, 7, 1800000, 30.38, 131.61, 1.6, 0),
      ("MT6897", 0, 1600000, 4, 400000, 33.86, 171.9, 0.8, 0),
      ("MT6897", 0, 1600000, 4, 500000, 33.74, 172.36, 0.89, 0),
      ("MT6897", 0, 1600000, 4, 600000, 33.84, 173.04, 0.86, 0),
      ("MT6897", 0, 1600000, 4, 700000, 33.95, 173.63, 0.91, 0),
      ("MT6897", 0, 1600000, 4, 800000, 33.84, 174.71, 0.93, 0),
      ("MT6897", 0, 1600000, 4, 900000, 33.81, 173.65, 1.06, 0),
      ("MT6897", 0, 1600000, 4, 1000000, 33.77, 173.1, 1.05, 0),
      ("MT6897", 0, 1600000, 4, 1100000, 33.99, 172.73, 1.13, 0),
      ("MT6897", 0, 1600000, 4, 1200000, 33.78, 172.51, 1.19, 0),
      ("MT6897", 0, 1600000, 4, 1300000, 33.77, 172.47, 1.15, 0),
      ("MT6897", 0, 1600000, 4, 1400000, 33.48, 172.56, 1.48, 0),
      ("MT6897", 0, 1600000, 4, 1500000, 33.74, 172.89, 1.39, 0),
      ("MT6897", 0, 1600000, 4, 1600000, 33.73, 173.31, 1.4, 0),
      ("MT6897", 0, 1600000, 4, 1700000, 33.74, 174.02, 1.45, 0),
      ("MT6897", 0, 1600000, 4, 1800000, 33.77, 177.7, 1.45, 0),
      ("MT6897", 0, 1600000, 7, 400000, 30.01, 127.91, 1.58, 0),
      ("MT6897", 0, 1600000, 7, 500000, 29.88, 147.31, 1.58, 0),
      ("MT6897", 0, 1600000, 7, 600000, 29.52, 170.34, 1.57, 0),
      ("MT6897", 0, 1600000, 7, 700000, 29.68, 177.93, 1.56, 0),
      ("MT6897", 0, 1600000, 7, 800000, 29.64, 179.15, 1.56, 0),
      ("MT6897", 0, 1600000, 7, 900000, 29.64, 177.6, 1.66, 0),
      ("MT6897", 0, 1600000, 7, 1000000, 29.63, 175.1, 1.62, 0),
      ("MT6897", 0, 1600000, 7, 1100000, 29.72, 173.43, 1.68, 0),
      ("MT6897", 0, 1600000, 7, 1200000, 29.79, 178.71, 1.63, 0),
      ("MT6897", 0, 1600000, 7, 1300000, 30.15, 183.37, 1.64, 0),
      ("MT6897", 0, 1600000, 7, 1400000, 29.96, 176.76, 1.74, 0),
      ("MT6897", 0, 1600000, 7, 1500000, 30.35, 172.02, 1.71, 0),
      ("MT6897", 0, 1600000, 7, 1600000, 30.76, 176.82, 1.69, 0),
      ("MT6897", 0, 1600000, 7, 1700000, 31.97, 166.5, 1.72, 0),
      ("MT6897", 0, 1600000, 7, 1800000, 31.66, 166.36, 1.8, 0),
      ("MT6897", 0, 1700000, 4, 400000, 35.18, 169.41, 0.74, 0),
      ("MT6897", 0, 1700000, 4, 500000, 35.94, 170.53, 0.85, 0),
      ("MT6897", 0, 1700000, 4, 600000, 36.64, 171.87, 0.83, 0),
      ("MT6897", 0, 1700000, 4, 700000, 36.44, 173.19, 1.41, 0),
      ("MT6897", 0, 1700000, 4, 800000, 36.5, 174.93, 1.39, 0),
      ("MT6897", 0, 1700000, 4, 900000, 36.34, 179.35, 1.44, 0),
      ("MT6897", 0, 1700000, 4, 1000000, 36.36, 185.17, 1.38, 0),
      ("MT6897", 0, 1700000, 4, 1100000, 36.25, 187.54, 1.22, 0),
      ("MT6897", 0, 1700000, 4, 1200000, 35.99, 190.26, 1.28, 0),
      ("MT6897", 0, 1700000, 4, 1300000, 36.15, 194.67, 1.23, 0),
      ("MT6897", 0, 1700000, 4, 1400000, 36.33, 198.11, 1.53, 0),
      ("MT6897", 0, 1700000, 4, 1500000, 36.44, 206.47, 1.45, 0),
      ("MT6897", 0, 1700000, 4, 1600000, 37.78, 211.48, 1.43, 0),
      ("MT6897", 0, 1700000, 4, 1700000, 38.42, 216.87, 1.48, 0),
      ("MT6897", 0, 1700000, 4, 1800000, 38.39, 222.45, 1.49, 0),
      ("MT6897", 0, 1700000, 7, 400000, 35.07, 157.86, 1.65, 0),
      ("MT6897", 0, 1700000, 7, 500000, 35.07, 156.81, 1.73, 0),
      ("MT6897", 0, 1700000, 7, 600000, 35.07, 187.71, 1.86, 0),
      ("MT6897", 0, 1700000, 7, 700000, 36.39, 213.25, 1.77, 0),
      ("MT6897", 0, 1700000, 7, 800000, 36.75, 219.22, 1.76, 0),
      ("MT6897", 0, 1700000, 7, 900000, 37.31, 219.82, 1.75, 0),
      ("MT6897", 0, 1700000, 7, 1000000, 37.02, 220.7, 1.69, 0),
      ("MT6897", 0, 1700000, 7, 1100000, 36.97, 221.01, 1.68, 0),
      ("MT6897", 0, 1700000, 7, 1200000, 36.96, 219.11, 1.66, 0),
      ("MT6897", 0, 1700000, 7, 1300000, 36.93, 221.86, 1.73, 0),
      ("MT6897", 0, 1700000, 7, 1400000, 37.0, 218.93, 1.73, 0),
      ("MT6897", 0, 1700000, 7, 1500000, 36.89, 213.01, 1.66, 0),
      ("MT6897", 0, 1700000, 7, 1600000, 36.91, 215.03, 1.75, 0),
      ("MT6897", 0, 1700000, 7, 1700000, 36.95, 207.21, 1.66, 0),
      ("MT6897", 0, 1700000, 7, 1800000, 36.78, 207.4, 1.84, 0),
      ("MT6897", 0, 1800000, 4, 400000, 34.65, 188.68, 0.81, 0),
      ("MT6897", 0, 1800000, 4, 500000, 35.69, 201.21, 1.02, 0),
      ("MT6897", 0, 1800000, 4, 600000, 36.63, 199.62, 1.03, 0),
      ("MT6897", 0, 1800000, 4, 700000, 38.05, 196.37, 1.38, 0),
      ("MT6897", 0, 1800000, 4, 800000, 39.3, 194.12, 1.37, 0),
      ("MT6897", 0, 1800000, 4, 900000, 40.11, 192.49, 1.39, 0),
      ("MT6897", 0, 1800000, 4, 1000000, 41.17, 190.99, 1.32, 0),
      ("MT6897", 0, 1800000, 4, 1100000, 42.02, 191.09, 1.19, 0),
      ("MT6897", 0, 1800000, 4, 1200000, 42.07, 191.32, 1.22, 0),
      ("MT6897", 0, 1800000, 4, 1300000, 42.11, 194.02, 1.16, 0),
      ("MT6897", 0, 1800000, 4, 1400000, 42.03, 196.87, 1.47, 0),
      ("MT6897", 0, 1800000, 4, 1500000, 42.11, 208.58, 1.39, 0),
      ("MT6897", 0, 1800000, 4, 1600000, 42.35, 215.02, 1.39, 0),
      ("MT6897", 0, 1800000, 4, 1700000, 42.19, 230.66, 1.47, 0),
      ("MT6897", 0, 1800000, 4, 1800000, 42.1, 263.58, 1.47, 0),
      ("MT6897", 0, 1800000, 7, 400000, 36.11, 183.83, 1.93, 0),
      ("MT6897", 0, 1800000, 7, 500000, 36.93, 184.09, 2.02, 0),
      ("MT6897", 0, 1800000, 7, 600000, 36.66, 186.49, 1.97, 0),
      ("MT6897", 0, 1800000, 7, 700000, 36.64, 207.81, 1.87, 0),
      ("MT6897", 0, 1800000, 7, 800000, 36.85, 211.81, 1.86, 0),
      ("MT6897", 0, 1800000, 7, 900000, 37.36, 212.33, 1.85, 0),
      ("MT6897", 0, 1800000, 7, 1000000, 37.2, 212.95, 1.79, 0),
      ("MT6897", 0, 1800000, 7, 1100000, 37.23, 213.19, 1.78, 0),
      ("MT6897", 0, 1800000, 7, 1200000, 38.29, 211.25, 1.8, 0),
      ("MT6897", 0, 1800000, 7, 1300000, 39.06, 213.9, 1.83, 0),
      ("MT6897", 0, 1800000, 7, 1400000, 38.91, 212.12, 1.84, 0),
      ("MT6897", 0, 1800000, 7, 1500000, 38.82, 207.31, 2.06, 0),
      ("MT6897", 0, 1800000, 7, 1600000, 38.97, 208.76, 1.95, 0),
      ("MT6897", 0, 1800000, 7, 1700000, 38.77, 202.94, 2.14, 0),
      ("MT6897", 0, 1800000, 7, 1800000, 38.77, 202.99, 2.22, 0),
      ("MT6897", 0, 1900000, 4, 400000, 42.4, 181.86, 0.88, 0),
      ("MT6897", 0, 1900000, 4, 500000, 42.22, 203.04, 1.09, 0),
      ("MT6897", 0, 1900000, 4, 600000, 42.05, 238.05, 1.21, 0),
      ("MT6897", 0, 1900000, 4, 700000, 41.78, 267.59, 1.23, 0),
      ("MT6897", 0, 1900000, 4, 800000, 41.97, 290.68, 1.22, 0),
      ("MT6897", 0, 1900000, 4, 900000, 41.82, 298.23, 1.34, 0),
      ("MT6897", 0, 1900000, 4, 1000000, 41.63, 298.95, 1.37, 0),
      ("MT6897", 0, 1900000, 4, 1100000, 41.94, 298.65, 1.39, 0),
      ("MT6897", 0, 1900000, 4, 1200000, 41.98, 298.12, 1.32, 0),
      ("MT6897", 0, 1900000, 4, 1300000, 42.04, 296.32, 1.38, 0),
      ("MT6897", 0, 1900000, 4, 1400000, 41.97, 294.9, 1.42, 0),
      ("MT6897", 0, 1900000, 4, 1500000, 42.05, 291.82, 1.33, 0),
      ("MT6897", 0, 1900000, 4, 1600000, 43.17, 287.64, 1.33, 0),
      ("MT6897", 0, 1900000, 4, 1700000, 43.87, 279.88, 1.41, 0),
      ("MT6897", 0, 1900000, 4, 1800000, 46.26, 274.66, 1.84, 0),
      ("MT6897", 0, 1900000, 7, 400000, 37.08, 305.05, 1.95, 0),
      ("MT6897", 0, 1900000, 7, 500000, 37.75, 304.87, 2.0, 0),
      ("MT6897", 0, 1900000, 7, 600000, 38.33, 306.51, 1.94, 0),
      ("MT6897", 0, 1900000, 7, 700000, 38.99, 299.8, 1.84, 0),
      ("MT6897", 0, 1900000, 7, 800000, 39.07, 302.47, 1.82, 0),
      ("MT6897", 0, 1900000, 7, 900000, 39.01, 301.05, 1.82, 0),
      ("MT6897", 0, 1900000, 7, 1000000, 39.07, 302.09, 1.76, 0),
      ("MT6897", 0, 1900000, 7, 1100000, 39.49, 297.26, 1.73, 0),
      ("MT6897", 0, 1900000, 7, 1200000, 39.59, 294.39, 1.73, 0),
      ("MT6897", 0, 1900000, 7, 1300000, 39.53, 292.56, 1.79, 0),
      ("MT6897", 0, 1900000, 7, 1400000, 39.5, 289.26, 1.79, 0),
      ("MT6897", 0, 1900000, 7, 1500000, 39.46, 284.1, 2.12, 0),
      ("MT6897", 0, 1900000, 7, 1600000, 39.35, 282.36, 2.21, 0),
      ("MT6897", 0, 1900000, 7, 1700000, 39.3, 279.38, 2.24, 0),
      ("MT6897", 0, 1900000, 7, 1800000, 39.28, 274.22, 2.35, 0),
      ("MT6897", 0, 2000000, 4, 400000, 42.54, 279.01, 1.07, 0),
      ("MT6897", 0, 2000000, 4, 500000, 43.54, 288.12, 1.04, 0),
      ("MT6897", 0, 2000000, 4, 600000, 43.9, 290.24, 1.13, 0),
      ("MT6897", 0, 2000000, 4, 700000, 43.83, 289.84, 1.2, 0),
      ("MT6897", 0, 2000000, 4, 800000, 43.92, 290.47, 1.29, 0),
      ("MT6897", 0, 2000000, 4, 900000, 44.18, 295.91, 1.4, 0),
      ("MT6897", 0, 2000000, 4, 1000000, 44.63, 296.19, 1.42, 0),
      ("MT6897", 0, 2000000, 4, 1100000, 44.97, 295.38, 1.43, 0),
      ("MT6897", 0, 2000000, 4, 1200000, 44.9, 294.55, 1.55, 0),
      ("MT6897", 0, 2000000, 4, 1300000, 47.54, 292.27, 1.52, 0),
      ("MT6897", 0, 2000000, 4, 1400000, 47.55, 290.82, 1.51, 0),
      ("MT6897", 0, 2000000, 4, 1500000, 48.57, 287.31, 1.52, 0),
      ("MT6897", 0, 2000000, 4, 1600000, 49.7, 282.78, 1.66, 0),
      ("MT6897", 0, 2000000, 4, 1700000, 50.95, 275.42, 1.66, 0),
      ("MT6897", 0, 2000000, 4, 1800000, 51.05, 269.45, 1.86, 0),
      ("MT6897", 0, 2000000, 7, 400000, 37.03, 314.39, 2.0, 0),
      ("MT6897", 0, 2000000, 7, 500000, 37.52, 314.21, 2.25, 0),
      ("MT6897", 0, 2000000, 7, 600000, 37.93, 315.84, 2.17, 0),
      ("MT6897", 0, 2000000, 7, 700000, 38.54, 311.54, 2.13, 0),
      ("MT6897", 0, 2000000, 7, 800000, 38.61, 310.08, 2.0, 0),
      ("MT6897", 0, 2000000, 7, 900000, 38.54, 310.38, 2.0, 0),
      ("MT6897", 0, 2000000, 7, 1000000, 38.63, 308.56, 1.95, 0),
      ("MT6897", 0, 2000000, 7, 1100000, 39.1, 307.4, 1.9, 0),
      ("MT6897", 0, 2000000, 7, 1200000, 39.33, 305.21, 2.05, 0),
      ("MT6897", 0, 2000000, 7, 1300000, 39.27, 309.57, 2.27, 0),
      ("MT6897", 0, 2000000, 7, 1400000, 39.24, 303.72, 2.26, 0),
      ("MT6897", 0, 2000000, 7, 1500000, 39.24, 302.12, 2.33, 0),
      ("MT6897", 0, 2000000, 7, 1600000, 39.16, 291.7, 2.38, 0),
      ("MT6897", 0, 2000000, 7, 1700000, 39.13, 291.88, 2.46, 0),
      ("MT6897", 0, 2000000, 7, 1800000, 39.09, 283.56, 2.5, 0),
      ("MT6897", 0, 2100000, 4, 400000, 42.4, 276.6, 1.16, 0),
      ("MT6897", 0, 2100000, 4, 500000, 44.04, 307.58, 1.3, 0),
      ("MT6897", 0, 2100000, 4, 600000, 44.7, 314.42, 1.63, 0),
      ("MT6897", 0, 2100000, 4, 700000, 45.21, 326.01, 1.93, 0),
      ("MT6897", 0, 2100000, 4, 800000, 45.38, 314.11, 1.92, 0),
      ("MT6897", 0, 2100000, 4, 900000, 44.99, 325.27, 2.02, 0),
      ("MT6897", 0, 2100000, 4, 1000000, 45.54, 303.41, 2.23, 0),
      ("MT6897", 0, 2100000, 4, 1100000, 45.15, 302.69, 2.13, 0),
      ("MT6897", 0, 2100000, 4, 1200000, 47.81, 328.05, 2.05, 0),
      ("MT6897", 0, 2100000, 4, 1300000, 49.63, 306.38, 2.13, 0),
      ("MT6897", 0, 2100000, 4, 1400000, 49.57, 298.18, 2.11, 0),
      ("MT6897", 0, 2100000, 4, 1500000, 50.65, 291.86, 2.02, 0),
      ("MT6897", 0, 2100000, 4, 1600000, 50.93, 284.64, 1.94, 0),
      ("MT6897", 0, 2100000, 4, 1700000, 51.0, 276.41, 2.06, 0),
      ("MT6897", 0, 2100000, 4, 1800000, 50.61, 269.43, 2.25, 0),
      ("MT6897", 0, 2100000, 7, 400000, 38.08, 325.66, 1.84, 0),
      ("MT6897", 0, 2100000, 7, 500000, 38.13, 325.48, 2.13, 0),
      ("MT6897", 0, 2100000, 7, 600000, 38.39, 327.11, 2.03, 0),
      ("MT6897", 0, 2100000, 7, 700000, 38.98, 322.8, 1.99, 0),
      ("MT6897", 0, 2100000, 7, 800000, 38.94, 321.34, 1.9, 0),
      ("MT6897", 0, 2100000, 7, 900000, 38.89, 321.65, 1.9, 0),
      ("MT6897", 0, 2100000, 7, 1000000, 38.95, 316.96, 1.87, 0),
      ("MT6897", 0, 2100000, 7, 1100000, 39.31, 319.45, 1.83, 0),
      ("MT6897", 0, 2100000, 7, 1200000, 39.43, 317.96, 1.98, 0),
      ("MT6897", 0, 2100000, 7, 1300000, 39.36, 328.52, 2.27, 0),
      ("MT6897", 0, 2100000, 7, 1400000, 39.3, 328.3, 2.32, 0),
      ("MT6897", 0, 2100000, 7, 1500000, 39.32, 319.65, 2.5, 0),
      ("MT6897", 0, 2100000, 7, 1600000, 39.22, 302.97, 2.53, 0),
      ("MT6897", 0, 2100000, 7, 1700000, 39.17, 306.31, 2.67, 0),
      ("MT6897", 0, 2100000, 7, 1800000, 39.1, 294.83, 2.6, 0),
      ("MT6897", 0, 2200000, 4, 400000, 42.27, 377.94, 1.83, 0),
      ("MT6897", 0, 2200000, 4, 500000, 43.63, 364.9, 1.7, 0),
      ("MT6897", 0, 2200000, 4, 600000, 44.61, 355.92, 2.3, 0),
      ("MT6897", 0, 2200000, 4, 700000, 46.95, 354.41, 2.62, 0),
      ("MT6897", 0, 2200000, 4, 800000, 48.33, 343.7, 2.61, 0),
      ("MT6897", 0, 2200000, 4, 900000, 48.13, 350.58, 2.5, 0),
      ("MT6897", 0, 2200000, 4, 1000000, 48.29, 334.12, 2.4, 0),
      ("MT6897", 0, 2200000, 4, 1100000, 48.15, 341.37, 2.3, 0),
      ("MT6897", 0, 2200000, 4, 1200000, 50.93, 327.09, 2.2, 0),
      ("MT6897", 0, 2200000, 4, 1300000, 51.72, 354.32, 2.29, 0),
      ("MT6897", 0, 2200000, 4, 1400000, 51.59, 349.21, 2.28, 0),
      ("MT6897", 0, 2200000, 4, 1500000, 54.64, 345.03, 2.17, 0),
      ("MT6897", 0, 2200000, 4, 1600000, 57.09, 340.92, 2.09, 0),
      ("MT6897", 0, 2200000, 4, 1700000, 57.04, 342.77, 2.22, 0),
      ("MT6897", 0, 2200000, 4, 1800000, 58.13, 336.68, 2.55, 0),
      ("MT6897", 0, 2200000, 7, 400000, 37.58, 340.31, 1.92, 0),
      ("MT6897", 0, 2200000, 7, 500000, 37.77, 340.13, 2.46, 0),
      ("MT6897", 0, 2200000, 7, 600000, 38.02, 341.77, 2.42, 0),
      ("MT6897", 0, 2200000, 7, 700000, 38.79, 337.46, 2.22, 0),
      ("MT6897", 0, 2200000, 7, 800000, 38.73, 336.0, 2.2, 0),
      ("MT6897", 0, 2200000, 7, 900000, 38.66, 336.31, 2.32, 0),
      ("MT6897", 0, 2200000, 7, 1000000, 38.68, 331.62, 2.2, 0),
      ("MT6897", 0, 2200000, 7, 1100000, 39.2, 334.11, 2.21, 0),
      ("MT6897", 0, 2200000, 7, 1200000, 39.35, 354.31, 2.19, 0),
      ("MT6897", 0, 2200000, 7, 1300000, 39.3, 350.85, 2.25, 0),
      ("MT6897", 0, 2200000, 7, 1400000, 39.25, 342.96, 2.52, 0),
      ("MT6897", 0, 2200000, 7, 1500000, 39.67, 340.57, 2.55, 0),
      ("MT6897", 0, 2200000, 7, 1600000, 39.87, 317.62, 2.56, 0),
      ("MT6897", 0, 2200000, 7, 1700000, 39.79, 324.12, 2.64, 0),
      ("MT6897", 0, 2200000, 7, 1800000, 39.82, 309.48, 2.66, 0)) AS _values
  )
SELECT
  *
FROM data;
