// Copyright (C) 2024 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import {LONG, NUM} from '../../trace_processor/query_result';
import {Trace} from '../../public/trace';
import {SourceDataset} from '../../trace_processor/dataset';
import {FlamegraphState} from '../../widgets/flamegraph';
import {createProfilingTrack} from './profiling_track';

export function createCpuProfileTrack(
  trace: Trace,
  uri: string,
  utid: number,
  detailsPanelState: FlamegraphState | undefined,
  onDetailsPanelStateChange: (state: FlamegraphState) => void,
) {
  return createProfilingTrack(
    trace,
    uri,
    {
      dataset: new SourceDataset({
        schema: {
          id: NUM,
          ts: LONG,
          callsiteId: NUM,
        },
        src: `
          SELECT
            id,
            ts,
            callsite_id AS callsiteId,
            utid
          FROM cpu_profile_stack_sample
        `,
        filter: {
          col: 'utid',
          eq: utid,
        },
      }),
      callsiteQuery: (ts) => `
        SELECT callsite_id
        FROM cpu_profile_stack_sample
        WHERE ts = ${ts} AND utid = ${utid}
      `,
      sqlModule: 'callstacks.stack_profile',
      metricName: 'CPU Profile Samples',
      panelTitle: 'CPU Profile Samples',
      sliceName: 'CPU Sample',
    },
    detailsPanelState,
    onDetailsPanelStateChange,
  );
}
