
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <GeomTools_UndefinedTypeHandler.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>

// module includes
#include <GeomTools.hxx>
#include <GeomTools_Curve2dSet.hxx>
#include <GeomTools_CurveSet.hxx>
#include <GeomTools_SurfaceSet.hxx>
#include <GeomTools_UndefinedTypeHandler.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_GeomTools(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("GeomTools"));
py::object klass;

//Python trampoline classes

// classes

    // Class GeomTools from ./opencascade/GeomTools.hxx
    klass = m.attr("GeomTools");

    // default constructor
    register_default_constructor<GeomTools , shared_ptr<GeomTools>>(m,"GeomTools");

    // nested enums

    static_cast<py::class_<GeomTools , shared_ptr<GeomTools>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Dump_s",
                    (void (*)(  const handle<Geom_Surface> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom_Surface> & ,  Standard_OStream &  ) >(&GeomTools::Dump),
                    R"#(A set of Curves from Geom2d. Dumps the surface on the stream.)#"  , py::arg("S"),  py::arg("OS")
          )
        .def_static("Write_s",
                    (void (*)(  const handle<Geom_Surface> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom_Surface> & ,  Standard_OStream &  ) >(&GeomTools::Write),
                    R"#(Writes the surface on the stream.)#"  , py::arg("S"),  py::arg("OS")
          )
        .def_static("Dump_s",
                    (void (*)(  const handle<Geom_Curve> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom_Curve> & ,  Standard_OStream &  ) >(&GeomTools::Dump),
                    R"#(Dumps the Curve on the stream.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("Write_s",
                    (void (*)(  const handle<Geom_Curve> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom_Curve> & ,  Standard_OStream &  ) >(&GeomTools::Write),
                    R"#(Writes the Curve on the stream.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("Dump_s",
                    (void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream &  ) >(&GeomTools::Dump),
                    R"#(Dumps the Curve on the stream.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("Write_s",
                    (void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream &  ) ) static_cast<void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream &  ) >(&GeomTools::Write),
                    R"#(Writes the Curve on the stream.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("SetUndefinedTypeHandler_s",
                    (void (*)(  const handle<GeomTools_UndefinedTypeHandler> &  ) ) static_cast<void (*)(  const handle<GeomTools_UndefinedTypeHandler> &  ) >(&GeomTools::SetUndefinedTypeHandler),
                    R"#()#"  , py::arg("aHandler")
          )
        .def_static("GetUndefinedTypeHandler_s",
                    (handle<GeomTools_UndefinedTypeHandler> (*)() ) static_cast<handle<GeomTools_UndefinedTypeHandler> (*)() >(&GeomTools::GetUndefinedTypeHandler),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
        .def_static("Read_s",
            [](Geom_Surface& S,Standard_IStream & IS ){
                handle<Geom_Surface>  S_ptr; S_ptr = &S;

                GeomTools::Read(S_ptr,IS);
                if ( S_ptr.get() != &S ) copy_if_copy_constructible(S, *S_ptr);

 },
            R"#(Reads the surface from the stream.)#"  , py::arg("S"),  py::arg("IS")
          )
        .def_static("Read_s",
            [](Geom_Curve& C,Standard_IStream & IS ){
                handle<Geom_Curve>  C_ptr; C_ptr = &C;

                GeomTools::Read(C_ptr,IS);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);

 },
            R"#(Reads the Curve from the stream.)#"  , py::arg("C"),  py::arg("IS")
          )
        .def_static("Read_s",
            [](Geom2d_Curve& C,Standard_IStream & IS ){
                handle<Geom2d_Curve>  C_ptr; C_ptr = &C;

                GeomTools::Read(C_ptr,IS);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);

 },
            R"#(Reads the Curve from the stream.)#"  , py::arg("C"),  py::arg("IS")
          )
        .def_static("GetReal_s",
            [](Standard_IStream & IS ){
                Standard_Real  theValue;

                GeomTools::GetReal(IS,theValue);
                
return std::make_tuple(theValue); },
            R"#(Reads the Standard_Real value from the stream. Zero is read in case of error)#"  , py::arg("IS")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomTools_Curve2dSet from ./opencascade/GeomTools_Curve2dSet.hxx
    klass = m.attr("GeomTools_Curve2dSet");


    // nested enums

    static_cast<py::class_<GeomTools_Curve2dSet , shared_ptr<GeomTools_Curve2dSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (GeomTools_Curve2dSet::*)() ) static_cast<void (GeomTools_Curve2dSet::*)() >(&GeomTools_Curve2dSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (GeomTools_Curve2dSet::*)(  const handle<Geom2d_Curve> &  ) ) static_cast<Standard_Integer (GeomTools_Curve2dSet::*)(  const handle<Geom2d_Curve> &  ) >(&GeomTools_Curve2dSet::Add),
             R"#(Incorporate a new Curve in the set and returns its index.)#"  , py::arg("C")
          )
        .def("Curve2d",
             (handle<Geom2d_Curve> (GeomTools_Curve2dSet::*)(  const Standard_Integer  ) const) static_cast<handle<Geom2d_Curve> (GeomTools_Curve2dSet::*)(  const Standard_Integer  ) const>(&GeomTools_Curve2dSet::Curve2d),
             R"#(Returns the Curve of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (GeomTools_Curve2dSet::*)(  const handle<Geom2d_Curve> &  ) const) static_cast<Standard_Integer (GeomTools_Curve2dSet::*)(  const handle<Geom2d_Curve> &  ) const>(&GeomTools_Curve2dSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("C")
          )
        .def("Dump",
             (void (GeomTools_Curve2dSet::*)( Standard_OStream &  ) const) static_cast<void (GeomTools_Curve2dSet::*)( Standard_OStream &  ) const>(&GeomTools_Curve2dSet::Dump),
             R"#(Dumps the content of me on the stream <OS>.)#"  , py::arg("OS")
          )
        .def("Write",
             (void (GeomTools_Curve2dSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const) static_cast<void (GeomTools_Curve2dSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const>(&GeomTools_Curve2dSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (GeomTools_Curve2dSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) ) static_cast<void (GeomTools_Curve2dSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) >(&GeomTools_Curve2dSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PrintCurve2d_s",
                    (void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) ) static_cast<void (*)(  const handle<Geom2d_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) >(&GeomTools_Curve2dSet::PrintCurve2d),
                    R"#(Dumps the curve on the stream, if compact is True use the compact format that can be read back.)#"  , py::arg("C"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("ReadCurve2d_s",
                    (handle<Geom2d_Curve> (*)( Standard_IStream &  ) ) static_cast<handle<Geom2d_Curve> (*)( Standard_IStream &  ) >(&GeomTools_Curve2dSet::ReadCurve2d),
                    R"#(Reads the curve from the stream. The curve is assumed to have been written with the Print method (compact = True).)#"  , py::arg("IS")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomTools_CurveSet from ./opencascade/GeomTools_CurveSet.hxx
    klass = m.attr("GeomTools_CurveSet");


    // nested enums

    static_cast<py::class_<GeomTools_CurveSet , shared_ptr<GeomTools_CurveSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (GeomTools_CurveSet::*)() ) static_cast<void (GeomTools_CurveSet::*)() >(&GeomTools_CurveSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (GeomTools_CurveSet::*)(  const handle<Geom_Curve> &  ) ) static_cast<Standard_Integer (GeomTools_CurveSet::*)(  const handle<Geom_Curve> &  ) >(&GeomTools_CurveSet::Add),
             R"#(Incorporate a new Curve in the set and returns its index.)#"  , py::arg("C")
          )
        .def("Curve",
             (handle<Geom_Curve> (GeomTools_CurveSet::*)(  const Standard_Integer  ) const) static_cast<handle<Geom_Curve> (GeomTools_CurveSet::*)(  const Standard_Integer  ) const>(&GeomTools_CurveSet::Curve),
             R"#(Returns the Curve of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (GeomTools_CurveSet::*)(  const handle<Geom_Curve> &  ) const) static_cast<Standard_Integer (GeomTools_CurveSet::*)(  const handle<Geom_Curve> &  ) const>(&GeomTools_CurveSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("C")
          )
        .def("Dump",
             (void (GeomTools_CurveSet::*)( Standard_OStream &  ) const) static_cast<void (GeomTools_CurveSet::*)( Standard_OStream &  ) const>(&GeomTools_CurveSet::Dump),
             R"#(Dumps the content of me on the stream <OS>.)#"  , py::arg("OS")
          )
        .def("Write",
             (void (GeomTools_CurveSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const) static_cast<void (GeomTools_CurveSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const>(&GeomTools_CurveSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (GeomTools_CurveSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) ) static_cast<void (GeomTools_CurveSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) >(&GeomTools_CurveSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PrintCurve_s",
                    (void (*)(  const handle<Geom_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) ) static_cast<void (*)(  const handle<Geom_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) >(&GeomTools_CurveSet::PrintCurve),
                    R"#(Dumps the curve on the stream, if compact is True use the compact format that can be read back.)#"  , py::arg("C"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("ReadCurve_s",
                    (handle<Geom_Curve> (*)( Standard_IStream &  ) ) static_cast<handle<Geom_Curve> (*)( Standard_IStream &  ) >(&GeomTools_CurveSet::ReadCurve),
                    R"#(Reads the curve from the stream. The curve is assumed to have been written with the Print method (compact = True).)#"  , py::arg("IS")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomTools_SurfaceSet from ./opencascade/GeomTools_SurfaceSet.hxx
    klass = m.attr("GeomTools_SurfaceSet");


    // nested enums

    static_cast<py::class_<GeomTools_SurfaceSet , shared_ptr<GeomTools_SurfaceSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (GeomTools_SurfaceSet::*)() ) static_cast<void (GeomTools_SurfaceSet::*)() >(&GeomTools_SurfaceSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (GeomTools_SurfaceSet::*)(  const handle<Geom_Surface> &  ) ) static_cast<Standard_Integer (GeomTools_SurfaceSet::*)(  const handle<Geom_Surface> &  ) >(&GeomTools_SurfaceSet::Add),
             R"#(Incorporate a new Surface in the set and returns its index.)#"  , py::arg("S")
          )
        .def("Surface",
             (handle<Geom_Surface> (GeomTools_SurfaceSet::*)(  const Standard_Integer  ) const) static_cast<handle<Geom_Surface> (GeomTools_SurfaceSet::*)(  const Standard_Integer  ) const>(&GeomTools_SurfaceSet::Surface),
             R"#(Returns the Surface of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (GeomTools_SurfaceSet::*)(  const handle<Geom_Surface> &  ) const) static_cast<Standard_Integer (GeomTools_SurfaceSet::*)(  const handle<Geom_Surface> &  ) const>(&GeomTools_SurfaceSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("S")
          )
        .def("Dump",
             (void (GeomTools_SurfaceSet::*)( Standard_OStream &  ) const) static_cast<void (GeomTools_SurfaceSet::*)( Standard_OStream &  ) const>(&GeomTools_SurfaceSet::Dump),
             R"#(Dumps the content of me on the stream <OS>.)#"  , py::arg("OS")
          )
        .def("Write",
             (void (GeomTools_SurfaceSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const) static_cast<void (GeomTools_SurfaceSet::*)( Standard_OStream & ,   const Message_ProgressRange &  ) const>(&GeomTools_SurfaceSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (GeomTools_SurfaceSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) ) static_cast<void (GeomTools_SurfaceSet::*)( Standard_IStream & ,   const Message_ProgressRange &  ) >(&GeomTools_SurfaceSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PrintSurface_s",
                    (void (*)(  const handle<Geom_Surface> & ,  Standard_OStream & ,   const Standard_Boolean  ) ) static_cast<void (*)(  const handle<Geom_Surface> & ,  Standard_OStream & ,   const Standard_Boolean  ) >(&GeomTools_SurfaceSet::PrintSurface),
                    R"#(Dumps the surface on the stream, if compact is True use the compact format that can be read back.)#"  , py::arg("S"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def_static("ReadSurface_s",
                    (handle<Geom_Surface> (*)( Standard_IStream &  ) ) static_cast<handle<Geom_Surface> (*)( Standard_IStream &  ) >(&GeomTools_SurfaceSet::ReadSurface),
                    R"#(Reads the surface from the stream. The surface is assumed to have been written with the Print method (compact = True).)#"  , py::arg("IS")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class GeomTools_UndefinedTypeHandler from ./opencascade/GeomTools_UndefinedTypeHandler.hxx
    klass = m.attr("GeomTools_UndefinedTypeHandler");


    // nested enums

    static_cast<py::class_<GeomTools_UndefinedTypeHandler ,opencascade::handle<GeomTools_UndefinedTypeHandler>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("PrintCurve",
             (void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) const) static_cast<void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) const>(&GeomTools_UndefinedTypeHandler::PrintCurve),
             R"#()#"  , py::arg("C"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("ReadCurve",
             (Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom_Curve> &  ) const) static_cast<Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom_Curve> &  ) const>(&GeomTools_UndefinedTypeHandler::ReadCurve),
             R"#()#"  , py::arg("ctype"),  py::arg("IS"),  py::arg("C")
          )
        .def("PrintCurve2d",
             (void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom2d_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) const) static_cast<void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom2d_Curve> & ,  Standard_OStream & ,   const Standard_Boolean  ) const>(&GeomTools_UndefinedTypeHandler::PrintCurve2d),
             R"#()#"  , py::arg("C"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("ReadCurve2d",
             (Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom2d_Curve> &  ) const) static_cast<Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom2d_Curve> &  ) const>(&GeomTools_UndefinedTypeHandler::ReadCurve2d),
             R"#()#"  , py::arg("ctype"),  py::arg("IS"),  py::arg("C")
          )
        .def("PrintSurface",
             (void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom_Surface> & ,  Standard_OStream & ,   const Standard_Boolean  ) const) static_cast<void (GeomTools_UndefinedTypeHandler::*)(  const handle<Geom_Surface> & ,  Standard_OStream & ,   const Standard_Boolean  ) const>(&GeomTools_UndefinedTypeHandler::PrintSurface),
             R"#()#"  , py::arg("S"),  py::arg("OS"),  py::arg("compact")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("ReadSurface",
             (Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom_Surface> &  ) const) static_cast<Standard_IStream & (GeomTools_UndefinedTypeHandler::*)(  const Standard_Integer ,  Standard_IStream & ,  handle<Geom_Surface> &  ) const>(&GeomTools_UndefinedTypeHandler::ReadSurface),
             R"#()#"  , py::arg("ctype"),  py::arg("IS"),  py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&GeomTools_UndefinedTypeHandler::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&GeomTools_UndefinedTypeHandler::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (GeomTools_UndefinedTypeHandler::*)() const) static_cast< const handle<Standard_Type> & (GeomTools_UndefinedTypeHandler::*)() const>(&GeomTools_UndefinedTypeHandler::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/GeomTools.hxx
// ./opencascade/GeomTools_Curve2dSet.hxx
// ./opencascade/GeomTools_CurveSet.hxx
// ./opencascade/GeomTools_SurfaceSet.hxx
// ./opencascade/GeomTools_UndefinedTypeHandler.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
