
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshData_Model.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshTools_Parameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>

// module includes
#include <IMeshTools_Context.hxx>
#include <IMeshTools_CurveTessellator.hxx>
#include <IMeshTools_MeshAlgo.hxx>
#include <IMeshTools_MeshAlgoFactory.hxx>
#include <IMeshTools_MeshAlgoType.hxx>
#include <IMeshTools_MeshBuilder.hxx>
#include <IMeshTools_ModelAlgo.hxx>
#include <IMeshTools_ModelBuilder.hxx>
#include <IMeshTools_Parameters.hxx>
#include <IMeshTools_ShapeExplorer.hxx>
#include <IMeshTools_ShapeVisitor.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <IMeshData_Face.hxx>

// Module definiiton
void register_IMeshTools_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IMeshTools", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<IMeshTools_MeshAlgoType>(m, "IMeshTools_MeshAlgoType",R"#(Enumerates built-in meshing algorithms factories implementing IMeshTools_MeshAlgoFactory interface.)#")
        .value("IMeshTools_MeshAlgoType_DEFAULT",IMeshTools_MeshAlgoType::IMeshTools_MeshAlgoType_DEFAULT)
        .value("IMeshTools_MeshAlgoType_Watson",IMeshTools_MeshAlgoType::IMeshTools_MeshAlgoType_Watson)
        .value("IMeshTools_MeshAlgoType_Delabella",IMeshTools_MeshAlgoType::IMeshTools_MeshAlgoType_Delabella).export_values();

//Python trampoline classes
    class Py_IMeshTools_CurveTessellator : public IMeshTools_CurveTessellator{
    public:
        using IMeshTools_CurveTessellator::IMeshTools_CurveTessellator;


        // public pure virtual
        Standard_Integer PointsNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_CurveTessellator,PointsNb,) };
        Standard_Boolean Value( const Standard_Integer theIndex,gp_Pnt & thePoint,Standard_Real & theParameter) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_CurveTessellator,Value,theIndex,thePoint,theParameter) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_MeshAlgo : public IMeshTools_MeshAlgo{
    public:
        using IMeshTools_MeshAlgo::IMeshTools_MeshAlgo;


        // public pure virtual
        void Perform( const typename IMeshData::IFaceHandle & theDFace, const IMeshTools_Parameters & theParameters, const Message_ProgressRange & theRange) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_MeshAlgo,Perform,theDFace,theParameters,theRange) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_MeshAlgoFactory : public IMeshTools_MeshAlgoFactory{
    public:
        using IMeshTools_MeshAlgoFactory::IMeshTools_MeshAlgoFactory;


        // public pure virtual
        handle<IMeshTools_MeshAlgo> GetAlgo( const GeomAbs_SurfaceType theSurfaceType, const IMeshTools_Parameters & theParameters) const  override { using return_type = handle<IMeshTools_MeshAlgo>;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_MeshAlgoFactory,GetAlgo,theSurfaceType,theParameters) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshTools_ModelAlgo : public IMeshTools_ModelAlgo{
    public:
        using IMeshTools_ModelAlgo::IMeshTools_ModelAlgo;


        // public pure virtual


        // protected pure virtual
        Standard_Boolean performInternal( const handle<IMeshData_Model> & theModel, const IMeshTools_Parameters & theParameters, const Message_ProgressRange & theRange) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ModelAlgo,performInternal,theModel,theParameters,theRange) };


        // private pure virtual

    };
    class Py_IMeshTools_ModelBuilder : public IMeshTools_ModelBuilder{
    public:
        using IMeshTools_ModelBuilder::IMeshTools_ModelBuilder;


        // public pure virtual


        // protected pure virtual
        handle<IMeshData_Model> performInternal( const TopoDS_Shape & theShape, const IMeshTools_Parameters & theParameters) override { using return_type = handle<IMeshData_Model>;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ModelBuilder,performInternal,theShape,theParameters) };


        // private pure virtual

    };
    class Py_IMeshTools_ShapeVisitor : public IMeshTools_ShapeVisitor{
    public:
        using IMeshTools_ShapeVisitor::IMeshTools_ShapeVisitor;


        // public pure virtual
        void Visit( const TopoDS_Face & theFace) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ShapeVisitor,Visit,theFace) };
        void Visit( const TopoDS_Edge & theEdge) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshTools_ShapeVisitor,Visit,theEdge) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<IMeshTools_Parameters , shared_ptr<IMeshTools_Parameters>  >(m,"IMeshTools_Parameters",R"#(Structure storing meshing parameters)#");
    py::class_<IMeshTools_Context ,opencascade::handle<IMeshTools_Context>  , IMeshData_Shape >(m,"IMeshTools_Context",R"#(Interface class representing context of BRepMesh algorithm. Intended to cache discrete model and instances of tools for its processing.)#");
    py::class_<IMeshTools_CurveTessellator ,opencascade::handle<IMeshTools_CurveTessellator> ,Py_IMeshTools_CurveTessellator , Standard_Transient >(m,"IMeshTools_CurveTessellator",R"#(Interface class providing API for edge tessellation tools.)#");
    py::class_<IMeshTools_MeshAlgo ,opencascade::handle<IMeshTools_MeshAlgo> ,Py_IMeshTools_MeshAlgo , Standard_Transient >(m,"IMeshTools_MeshAlgo",R"#(Interface class providing API for algorithms intended to create mesh for discrete face.)#");
    py::class_<IMeshTools_MeshAlgoFactory ,opencascade::handle<IMeshTools_MeshAlgoFactory> ,Py_IMeshTools_MeshAlgoFactory , Standard_Transient >(m,"IMeshTools_MeshAlgoFactory",R"#(Base interface for factories producing instances of triangulation algorithms taking into account type of surface of target face.)#");
    py::class_<IMeshTools_MeshBuilder ,opencascade::handle<IMeshTools_MeshBuilder>  , Message_Algorithm >(m,"IMeshTools_MeshBuilder",R"#(Builds mesh for each face of shape without triangulation. In case if some faces of shape have already been triangulated checks deflection of existing polygonal model and re-uses it if deflection satisfies the specified parameter. Otherwise nullifies existing triangulation and build triangulation anew.)#");
    py::class_<IMeshTools_ModelAlgo ,opencascade::handle<IMeshTools_ModelAlgo> ,Py_IMeshTools_ModelAlgo , Standard_Transient >(m,"IMeshTools_ModelAlgo",R"#(Interface class providing API for algorithms intended to update or modify discrete model.)#");
    py::class_<IMeshTools_ModelBuilder ,opencascade::handle<IMeshTools_ModelBuilder> ,Py_IMeshTools_ModelBuilder , Message_Algorithm >(m,"IMeshTools_ModelBuilder",R"#(Interface class represents API for tool building discrete model.)#");
    py::class_<IMeshTools_ShapeExplorer ,opencascade::handle<IMeshTools_ShapeExplorer>  , IMeshData_Shape >(m,"IMeshTools_ShapeExplorer",R"#(Explores TopoDS_Shape for parts to be meshed - faces and free edges.)#");
    py::class_<IMeshTools_ShapeVisitor ,opencascade::handle<IMeshTools_ShapeVisitor> ,Py_IMeshTools_ShapeVisitor , Standard_Transient >(m,"IMeshTools_ShapeVisitor",R"#(Interface class for shape visitor.)#");

};

// user-defined post-inclusion per module

// user-defined post
