% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quincunx.R, R/quincunx2.R
\name{quincunx}
\alias{quincunx}
\alias{quincunx2}
\title{Demonstration of the Quincunx (Bean Machine/Galton Box)}
\usage{
quincunx(
  balls = 200,
  layers = 15,
  pch.layers = 2,
  pch.balls = 19,
  col.balls = sample(colors(), balls, TRUE),
  cex.balls = 2
)

quincunx2(
  balls = 200,
  layers = 15,
  pch.layers = 2,
  pch.balls = 19,
  col.balls = sample(colors(), balls, TRUE),
  cex.balls = 2
)
}
\arguments{
\item{balls}{number of balls}

\item{layers}{number of layers}

\item{pch.layers}{point character of layers; triangles (\code{pch = 2}) are
recommended}

\item{pch.balls, col.balls, cex.balls}{point character, colors and
magnification of balls}
}
\value{
A named vector: the frequency table for the locations of the balls.
  Note the names of the vector are the locations: 1.5, 2.5, ..., layers -
  0.5.
}
\description{
Simulates the quincunx with ``balls'' (beans) falling through several layers
(denoted by triangles) and the distribution of the final locations at which
the balls hit is denoted by a histogram; \code{quincunx()} is shows single
layer, and \code{quincunx2()} is a two-stage version of the quincunx.
}
\details{
The bean machine, also known as the quincunx or Galton box, is a device
invented by Sir Francis Galton to demonstrate the law of error and the normal
distribution.

When a ball falls through a layer, it can either go to the right or left side
with the probability 0.5. At last the location of all the balls will show us
the bell-shaped distribution.
}
\note{
The maximum number of animation frames is controlled by
  \code{ani.options('nmax')} as usual, but it is strongly recommended that
  \code{ani.options(nmax = balls + layers -2)}, in which case all the balls
  will just fall through all the layers and there will be no redundant
  animation frames.
}
\references{
Examples at \url{https://yihui.org/animation/example/quincunx/}
}
\seealso{
\code{\link{rbinom}}
}
\author{
Yihui Xie, Lijia Yu, and Keith ORourke
}
