% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.glmmTMB}
\alias{vcov.glmmTMB}
\title{Calculate Variance-Covariance Matrix for a Fitted glmmTMB model}
\usage{
\method{vcov}{glmmTMB}(
  object,
  full = FALSE,
  include_nonest = TRUE,
  sandwich = FALSE,
  cluster = getGroups(object),
  ...
)
}
\arguments{
\item{object}{a \dQuote{glmmTMB} fit}

\item{full}{return a full variance-covariance matrix?}

\item{include_nonest}{include variables that are mapped \emph{or} dropped due to rank-deficiency? (these will be given variances and covariances of NA)}

\item{sandwich}{use the sandwich estimator for the variance-covariance matrix? (this only works for ML fits, but not for REML fits)}

\item{cluster}{grouping factor for the sandwich estimator, only used if \code{sandwich==TRUE}.}

\item{\dots}{ignored, for method compatibility}
}
\value{
By default (\code{full==FALSE}), a list of separate variance-covariance matrices for each model component (conditional, zero-inflation, dispersion).  If \code{full==TRUE}, a single square variance-covariance matrix for \emph{all} top-level model parameters (conditional, dispersion, and variance-covariance parameters)
}
\description{
Calculate Variance-Covariance Matrix for a Fitted glmmTMB model
}
