% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{is_separator}
\alias{is_separator}
\title{Check whether removing this set of vertices would disconnect the graph.}
\usage{
is_separator(graph, candidate)
}
\arguments{
\item{graph}{The input graph. It may be directed, but edge directions are
ignored.}

\item{candidate}{A numeric vector giving the vertex ids of the candidate
separator.}
}
\value{
A logical scalar, whether the supplied vertex set is a (minimal)
vertex separator or not.
lists all vertex separator of minimum size.
}
\description{
\code{is_separator()} determines whether the supplied vertex set is a vertex
separator:
A vertex set \eqn{S} is a separator if there are vertices \eqn{u} and \eqn{v}
in the graph such that all paths between \eqn{u} and \eqn{v} pass
through some vertices in \eqn{S}.
}
\examples{
ring <- make_ring(4)
min_st_separators(ring)
is_separator(ring, 1)
is_separator(ring, c(1, 3))
is_separator(ring, c(2, 4))
is_separator(ring, c(2, 3))

}
\seealso{
Other flow: 
\code{\link{dominator_tree}()},
\code{\link{edge_connectivity}()},
\code{\link{is_min_separator}()},
\code{\link{max_flow}()},
\code{\link{min_cut}()},
\code{\link{min_separators}()},
\code{\link{min_st_separators}()},
\code{\link{st_cuts}()},
\code{\link{st_min_cuts}()},
\code{\link{vertex_connectivity}()}
}
\concept{flow}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Separators.html#igraph_is_separator}{\code{is_separator()}}.}

