% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_OSLAgeSummary.R
\name{plot_OSLAgeSummary}
\alias{plot_OSLAgeSummary}
\title{Plot Posterior OSL-Age Summary}
\usage{
plot_OSLAgeSummary(object, level = 0.95, digits = 1L, verbose = TRUE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Results}, \link{numeric} (\strong{required}):
an object produced by \link{combine_De_Dr}. Alternatively, a \link{numeric} vector of
a parameter from an MCMC process.}

\item{level}{\link{numeric} (\emph{with default}):
probability of shown credible interval.}

\item{digits}{\link{integer} (\emph{with default}):
number of digits considered for the calculation.}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}

\item{...}{further arguments to modify the plot, supported: \code{xlim}, \code{ylim},
\code{xlab}, \code{ylab}, \code{main}, \code{lwd}, \code{lty}, \code{col}, \code{rug}, \code{polygon_col},
\code{polygon_density}.}
}
\value{
A posterior distribution plot and an \linkS4class{RLum.Results}
object with the credible interval.
}
\description{
The function produces a graphical summary of the statistical inference of
an OSL age.
}
\details{
The function is called automatically by \link{combine_De_Dr}.
}
\section{Function version}{
 0.1.0
}

\examples{
##generate random data
set.seed(1234)
object <- rnorm(1000, 100, 10)
plot_OSLAgeSummary(object)

}
\seealso{
\link{combine_De_Dr}, \link{plot.default}, \link[rjags:rjags-package]{rjags::rjags}
}
\author{
Anne Philippe, Université de Nantes (France),
Jean-Michel Galharret, Université de Nantes (France),
Norbert Mercier, IRAMAT-CRP2A, Université Bordeaux Montaigne (France),
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Philippe, A., Galharret, J., Mercier, N., Kreutzer, S., 2025. plot_OSLAgeSummary(): Plot Posterior OSL-Age Summary. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{dplot}
\keyword{hplot}
