// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain
// SPDX-FileCopyrightText: 2025 Antmicro
// SPDX-License-Identifier: CC0-1.0

// verilog_format: off
`define stop  // TODO
`define checkh(gotv,expv) do if ((gotv) !== (expv)) begin $write("%%Error: %s:%0d:  got='h%x exp='h%x\n", `__FILE__,`__LINE__, (gotv), (expv)); `stop; end while(0)
// verilog_format: on

// Example from IEEE 1800-2023 10.6.2

  module t;
  logic a, b, c, d;
  wire e;
  and and1 (e, a, b, c);

  initial begin
    $monitor("%d d=%b,e=%b", $stime, d, e);
    assign d = a & b & c;
    a = 1;
    b = 0;
    c = 1;
    #10;
    force d = (a | b | c);
    force e = (a | b | c);
    `checkh(d, 1);
    `checkh(e, 1);
    #10;
    release d;
    release e;
    // TODO support procedural continuous assignments.
    //
    // As per IEEE 1800-2023 10.6.2, value of `d` should be updated
    // after release. However, Verilator treats `assign` inside an initial block
    // as procedural assign thus value update is not properly restored.
    #10;
    `checkh(d, 0);
    `checkh(e, 0);

    $finish;
  end
endmodule
